C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE FDSTAT (ibuf, data, ithdr, ihead1, csa, ihdwrd,
     *                   iheadr, ishift, iupdat, iblock, itimng, iap,
     *                   first, iprntr, nsamp, intrvl, isi, ifmt,
     *                   micro, phase, ITRWRD, SZSMPD, SZLNHD, quarter,
     * ifmt_TrcNum,l_TrcNum, ln_TrcNum,ifmt_RecNum,l_RecNum, ln_RecNum,
     * ifmt_DphInd,l_DphInd, ln_DphInd,ifmt_RecInd,l_RecInd, ln_RecInd,
     * ifmt_PrRcNm,l_PrRcNm, ln_PrRcNm,ifmt_StaCor,l_StaCor, ln_StaCor,
     * ifmt_DstSgn,l_DstSgn, ln_DstSgn,ifmt_LinInd,l_LinInd, ln_LinInd,
     * ifmt_DatShf,l_DatShf, ln_DatShf,ifmt_ToStUn,l_ToStUn, ln_ToStUn,
     * ifmt_ToTmAU,l_ToTmAU, ln_ToTmAU,ifmt_ihdwrd,l_ihdwrd, ln_ihdwrd,
     * ifmt_InStUn,l_InStUn, ln_InStUn,ifmt_RcStUn,l_RcStUn, ln_RcStUn,
     * ifmt_InStAp,l_InStAp, ln_InStAp,ifmt_RcStAp,l_RcStAp, ln_RcStAp,
     * ifmt_ToStAp,l_ToStAp, ln_ToStAp,ifmt_ToTmAA,l_ToTmAA, ln_ToTmAA)

C
C**********************************************************************
C                                                                     *
C   VARIABLE LIST:                                                    *
C   --------------                                                    *
C                                                                     *
C   IHEAD  - INTEGER * 2 ARRAY CONTAINING THE LINE HEADER.            *
C                                                                     *
C         NOTE: THESE TWO ARRAYS SHOULD BE EQUIVALENCED               *
C               IN THE CALLING PROGRAM.                               *
C                                                                     *
C   ISHIFT - INDICATES IF STATICS ARE TO BE APPLIED.                  *
C             0 = APPLY THE STATIC.                                   *
C             1 = DON'T APPLY THE STATIC.                             *
C                                                                     *
C   IUPDAT - INDICATES IF WORD 125 IS TO BE UPDATED.                  *
C             0 = UPDATE 125.                                         *
C             1 = DON'T UPDATE 125.                                   *
C                                                                     *
C   IBLOCK - INDICATES THE TYPE OF SHIFT TO BE PERFORMED.             *
C             0 = FINE GRAIN SHIFT.                                   *
C             1 = NEAREST SAMPLE ONLY.                                *
C                                                                     *
C   IPRNTR - UNIT NUMBER FOR THE PRINTER.                             *
C                                                                     *
C   IHEADR - INDICATES WHETHER TO USE HEADER STATICS.                 *
C             0 = YES.  ( USE HEADER PLUS ICSA )                      *
C             1 = NO.   ( USE ICSA ONLY )                             *
C                                                                     *
C   ITIMNG - INDICATES WHETHER TO APPLY TIMING ADJUSTMENT ONLY        *
C             0 = DO NOT APPLY ONLY.                                  *
C             1 = APPLY ONLY.                                         *
C                                                                     *
C   NREG   - COMPUTED REGION SIZE FOR STATIC APPLICATION IN THE       *
C            FREQUENCY DOMAIN.  APPLIES TO FINE GRAIN STATICS ONLY.   *
C                                                                     *
C   IAP    - UNIT NUMBER FOR A.P.                                     *
C                                                                     *
C   NOUPDT - INDICATES WHETHER TO UPDATE NEW TRACE HEADER WORDS.      *
C             0 = UPDATE NEW TRACE HEADER WORDS.                      *
C             1 = DO NOT UPDATE.                                      *
C                                                                     *
C   IDUM2  - DUMMY ARGUMENT.                                          *
C                                                                     *
C   IDUM3  - DUMMY ARGUMENT.                                          *
C                                                                     *
C   IDUM4  - DUMMY ARGUMENT.                                          *
C                                                                     *
C   ICSA   - INTEGER * 4 ARRAY CONTAINING STATICS THAT WERE           *
C            SUPPLIED BY THE CALLING PROGRAM.                         *
C            NOTE:  VALUES SUPPLIED ARE MULTIPLIED BY 4               *
C                                                                     *
C   IBUF   - ADDRESS OF THE DATA.                                     *
C   ITHDR  - ADDRESS OF THE TRACE HEADER.                             *
C                                                                     *
C**********************************************************************

c#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>

      REAL        DATA(*), CSA(*)
      INTEGER     IBUF(*), ITHDR(*)
C
      INTEGER     IHEAD1(*),
     *            IREG(9), ZERO, ITRWRD, SZSMPD, SZLNHD
      LOGICAL     first, micro, phase
C
      DATA ONE /1.0/, TWO /2.0/, ZERO /0/, IMS /4/
      SAVE           
C

      KSHIFT=ISHIFT  ! Cray
      KUPDAT=IUPDAT  ! Cray
      KBLOCK=IBLOCK  ! Cray
      KHEADR=IHEADR  ! Cray
      KTIMNG=ITIMNG  ! Cray
      KOUPDT=IOUPDT  ! Cray
C


      IF (first) THEN
      IF ( NSAMP  .LE. 8192
     *            .OR. KBLOCK .NE. 0 ) GO TO 1000
C
      WRITE(IPRNTR,500)
  500 FORMAT(/,13X, '** M0500 ** WARNING FROM SUBROUTINE FDSTAT:',
     *       /,25X, 'THE NUMBER OF SAMPLES AS FILED IN THE INPUT',
     *       /,25X, 'DATA SET LINE HEADER HAS EXCEEDED THE',
     *       /,25X, 'SUBROUTINE''S LIMIT TO PERFORM FREQUENCY',
     *       /,25X, 'DOMAIN STATICS.  THE TRACE LENGTH EXCEEDS',
     *       /,25X, 'THE MAXIMUM OF 8192 SAMPLES ALLOWED FOR THE',
     *       /,25X, 'FAST FOURIER TRANSFORM.  INSTEAD OF APPLYING',
     *       /,25X, 'STATICS TO THE NEAREST 1/4 MS, STATICS WILL BE',
     *       /,25X, 'APPLIED TO THE NEAREST INTEGER MULTIPLE OF THE',
     *       /,25X, 'SAMPLE INTERVAL.  VERIFY THE INPUT DATA SET LINE',
     *       /,25X, 'HEADER ENTRY FOR THE NUMBER OR SAMPLES OR WINDOW',
     *       /,25X, 'THE TRACES SUCH THAT THE NUMBER OF SAMPLES',
     *       /,25X, 'CONFORMS TO THE SUBROUTINE''S RESTRICTIONS.',/)
C
c     IBLOCK = 1
c     KBLOCK = 1

C--
C---- IS NUMBER OF SAMPLES
C---- EVEN OR ODD ??
C--
 1000 continue
C
C
      call saver( IBUF,'StWdFl', istwd , LINHED)

      IF ( istwd .ne. 2) go to 2000
C
      NEWRDS = 1
C
      WRITE(IPRNTR,1500)
 1500 FORMAT(/,13X, '** M1500 ** MESSAGE FROM SUBROUTINE FDSTAT(F):',
     *       /,25X, 'NEW STATICS WORDS ARE AVAILABLE.',/)
C
      GO TO 3000
C
 2000 WRITE(IPRNTR,2500)
 2500 FORMAT(/,13X, '** M2500 ** MESSAGE FROM SUBROUTINE FDSTAT(F):',
     *       /,25X, 'NEW STATICS WORDS ARE NOT AVAILABLE.',/)
C--
C--
 3000 continue

      first = .false.
C--
      ENDIF
C***********************************************************************
C
C                   ENTRY FOR STATICS APPLICATION
C                  AND/OR TRACE HEADER WORD UPDATE
C
C***********************************************************************
C
              call saver2(IBUF ,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                    itrct , 1)
              call saver2(IBUF ,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                    irect , 1)
              call saver2(IBUF ,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                    idi   , 1)
              call saver2(IBUF ,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                    ili   , 1)
              call saver2(IBUF ,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                    igi   , 1)
              call saver2(IBUF ,ifmt_PrRcNm,l_PrRcNm, ln_PrRcNm,
     1                    iprn  , 1)
              call saver2(IBUF ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                    istati, 1)
              call saver2(IBUF ,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                    idist , 1)
              call saver2(IBUF ,ifmt_DatShf,l_DatShf, ln_DatShf,
     1                    itr126, 1)
              call saver2(IBUF ,ifmt_ToStUn,l_ToStUn, ln_ToStUn,
     1                    itr15 , 1)
              call saver2(IBUF ,ifmt_ToTmAU,l_ToTmAU, ln_ToTmAU,
     1                    itr16 , 1)
              call saver2(IBUF ,ifmt_InStUn,l_InStUn, ln_InStUn,
     1                    itr8  , 1)
              call saver2(IBUF ,ifmt_InStAp,l_InStAp, ln_InStAp,
     1                    itr9  , 1)
              call saver2(IBUF ,ifmt_RcStUn,l_RcStUn, ln_RcStUn,
     1                    itr11 , 1)
              call saver2(IBUF ,ifmt_RcStAp,l_RcStAp, ln_RcStAp,
     1                    itr12 , 1)
              call saver2(IBUF ,ifmt_ToStAp,l_ToStAp, ln_ToStAp,
     1                    itr13 , 1)
              call saver2(IBUF ,ifmt_ToTmAA,l_ToTmAA, ln_ToTmAA,
     1                    itr14 , 1)
              call saver2(IBUF ,ifmt_ihdwrd,l_ihdwrd, ln_ihdwrd,
     1                    ihdwrd, 1)

       if (phase) then
          rstat = CSA(9) + CSA(10)
          go to 12000
       endif
C
C***********************************************************************
C
CCray               START CALCULATING STATICS
C
C***********************************************************************
C
c7000 CONTINUE
      ISTAT  = 0
      KSTAT  = 0
      RSTAT  = 0.0
      STAT   = 0.0
      ROUND  = 0.0
c     KBLOCK = KBLOCK
C--
C---- IS THE TRACE DEAD ??
C--
      IF ( istati .GE. 30000 ) RETURN
C--
C---- ARE WE GOING TO APPLY
C---- HEADER STATICS ?? 1=yes
C--
      IF ( KHEADR .EQ. 1 ) GO TO 7500
C--
C---- ARE WE GOING TO USE NEW
C---- TRACE HEADER STATIC WORDS ?? 1=yes
C--
      IF ( NEWRDS .EQ. 1 )  GO TO 8000
C--
C---- SUM THE HEADER STATICS (OLD TYPE)
C--
      if (phase) then
         istati = 0
         itr126 = 0
      endif
      ISTAT = ( istati + itr126 ) * IMS
C--
C---- DO WE NEED TO APPLY A
C---- TIMING ADJUSTMENT ONLY ?? 1=yes
C--
      IF ( KTIMNG .EQ. 1 )
     *         ISTAT = itr126 * IMS
               call savew2(IBUF ,ifmt_DatShf,l_DatShf, ln_DatShf,
     1                     0, 1)
C--
C---- ADD IN STATIC SUPPLIED
C---- BY CALLING PROGRAM
C--
 7500 CONTINUE
      ISTAT  = ISTAT + CSA(9) + CSA(10)
C
      GO TO 8500
C--
C---- SUM THE TRACE HEADER
C---- STATICS (NEW TYPE)
C--
 8000 CONTINUE
      ISTAT  = itr15 + CSA(9) +
     *         itr16 + CSA(10)
C--
C---- TIMING ADJUSTMENT ONLY ??
C--
      IF ( KTIMNG .EQ. 1 )
     *            ISTAT = itr16 + CSA(10)
C--
C---- IS THERE ANY TOTAL STATIC TO APPLY ??
C--
 8500 CONTINUE
      IF ( ISTAT .EQ. 0 )  GO TO 12500
C--
C---- DEFAULT TO POSITIVE STATIC
C--
      ONEM = -1.0
C--
C---- IS STATIC NEGATIVE ??
C--
      IF ( ISTAT .LT. 0 )  ONEM = 1.0
C--
C---- CALCULATE HOW MANY WHOLE
C---- SAMPLES TO SHIFT (BLOCK SHIFT)
C--
      KFAC   = ISI * IMS
      RFAC   = KFAC
      KSTAT  = ISTAT / KFAC
      RSTAT  = FLOAT( ISTAT ) / RFAC
C--
C---- COMPUTE FRACTIONAL SHIFT
C--
      ABSTAT = ABS (RSTAT)
      JSTAT  = ABSTAT
      STAT   = ABSTAT - JSTAT
      IF ( KBLOCK .EQ. 0 ) GO TO 9000
C--
C---- ROUND BLOCK SHIFT
C---- TO NEAREST SAMPLE
C--
      KSTAT = RSTAT + SIGN ( 0.5, RSTAT )
C--
C---- IS STATIC POSITIVE ??
C--
 9000 IF ( ISTAT .GT. 0 )  GO TO 9500
C
      IREG(1) = 0 
C--
C---- SET REGISTER 8 TO NEGATIVE
C---- ISTAT FOR NEGATIVE SHIFT
C--
      IREG(8) = -KSTAT
C--
C---- SET REGISTER 9 FOR NEGATIVE
C---- SHIFT TO REAPPLY ZEROES
C--
      IREG(9) = NSAMP + KSTAT - 1
C
      GO TO 10000
C--
C---- SET REGISTER 8 TO ZERO
C---- FOR POSITIVE SHIFT
C--
 9500 IREG(8) = 0
C--
C---- SET REGISTER 1 TO
C---- KSTAT FOR POSITIVE SHIFT
C--
      IREG(1) = KSTAT
C
10000 IREG(2) = NSAMP - IABS(KSTAT)
      IF ( IREG(2) .LE. 0 ) 
     1   call savew2(IBUF ,ifmt_StaCor,l_StaCor, ln_StaCor,
     2               30000 , 1)
C
      IREG(3) = ISTAT
      IREG(4) = IABS(KSTAT)
      IREG(5) = 0
      IREG(6) = NSAMP
C
      IF ( KSHIFT .EQ. 1 ) GO TO 12500
C--
C---- IF NO FRACTIONAL SHIFT IS
C---- NEEDED, SET TO BLOCK SHIFT
C--
c     IF ( STAT .EQ. 0.0 )  KBLOCK = 1
C--
C---- FINE GRAIN SHIFT
C--
C
C***********************************************************************
C
C                   APPLY THE STATIC TO TRACE
C               AND UPDATE HEADER WORDS IF NEEDED
C               For phase option apply phase, update trace header
C               and return
C
C***********************************************************************
C
c     CALL SHIFTS(IBUF,NSAMP,RSTAT) ! Cray 
12000 continue

      call vmov (ibuf(ITRWRD+1), 1, data, 1, nsamp)

      if (phase) then
         call rotate (data, nsamp, -rstat)
      else
         CALL SHIFTS(data,NSAMP,RSTAT) ! Cray 
      endif

      call vmov (data, 1, ibuf(ITRWRD+1), 1, nsamp)

      if (phase) then
         istati = rstat
         call savew2(IBUF ,ifmt_StaCor,l_StaCor, ln_StaCor,
     1               istati, 1)
         return
      endif
C--
C---- IS WORD 125 (ihdwrd) TO BE UPDATED ??
C--
12500 continue

      IF (micro) THEN
         RSTAT = RSTAT * 1000.
         KSTAT = RSTAT
      ENDIF


      IF ( KUPDAT .EQ. 1 ) GO TO 13500
C
C***********************************************************************
C
C                  UPDATE OLD TRACE HEADER WORD
C
C***********************************************************************
C
C---- BLOCK SHIFT OR FINE GRAIN ??
C--
      IF ( KBLOCK .EQ. 1 ) GO TO 13000
C--
C---- FINE GRAIN UPDATE
C--
      ROUND = SIGN ( 0.5, RSTAT )
      IF ( RSTAT .EQ. 0.0 ) ROUND = 0.0
      if (micro) then
         ihdwrd =
     *         ihdwrd + ( ( RSTAT * ISI ) + ROUND )
         IF ( KHEADR .EQ. 0 )
     *            ihdwrd  =  ( RSTAT * ISI ) + ROUND
      else
         ihdwrd = ihdwrd + ( ( RSTAT * ISI ) + ROUND )
c        ITHDR(ihdwrd) =
c    *         ITHDR(ihdwrd) + ( ( RSTAT * ISI ) + ROUND )
         IF ( KHEADR .EQ. 0 )
     *            ihdwrd  =  ( RSTAT * ISI ) + ROUND
      endif
              call savew2(IBUF ,ifmt_ihdwrd,l_ihdwrd, ln_ihdwrd,
     1                    ihdwrd, 1)

      RETURN
C--
C---- BLOCK SHIFT UPDATE
C--
13000 continue

      if (micro) then
         ihdwrd = ihdwrd + KSTAT * ISI
         IF ( KHEADR .EQ. 0 )
     *            ihdwrd = KSTAT * ISI
      else
         ihdwrd = ihdwrd + KSTAT * ISI
         IF ( KHEADR .EQ. 0 )
     *            ihdwrd = KSTAT * ISI
      endif
              call savew2(IBUF ,ifmt_ihdwrd,l_ihdwrd, ln_ihdwrd,
     1                    ihdwrd, 1)
C
C--
C---- END OF OLD HEADER
C---- STATICS WORD UPDATE
C--
      RETURN
C--
C---- DO WE UPDATE NEW STATICS WORDS ??
C--
13500 CONTINUE
      IF ( NEWRDS .EQ. 0
     *            .OR. NOUPDT .EQ. 1 ) RETURN
C
C***********************************************************************
C
C                  UPDATE NEW TRACE HEADER WORDS
C
C***********************************************************************
C
      IF ( KTIMNG .EQ. 1 ) GO TO 16500
C
C---- *** FINE GRAIN OR BLOCK SHIFT ***
C---- IF STATIC WAS NOT APPLIED, WE WANT
C---- TO ADD COMPUTED STATIC TO UNAPPLIED
C---- WORDS ONLY; APPLIED WORDS ARE TABOO
C---- IN THIS CASE.  HEADER STATICS WON'T BE
C---- ADDED IN AGAIN BECAUSE THEY'RE ALREADY
C---- IN THE UNAPPLIED WORDS.
C--
      IF ( KSHIFT .EQ. 0 ) GO TO 14000
C
c     ITHDR( 8) = ITHDR( 8) + ICSA( 2)
c     ITHDR(11) = ITHDR(11) + ICSA( 5)
c     ITHDR(15) = ITHDR(15) + ICSA( 9)
c     ITHDR(16) = ITHDR(16) + ICSA(10)
      itr8  = itr8  + CSA( 2)
      itr11 = itr11 + CSA( 5)
      itr15 = itr15 + CSA( 9)
      itr16 = itr16 + CSA(10)
              call savew2(IBUF ,ifmt_InStUn,l_InStUn, ln_InStUn,
     1                    itr8  , 1)
              call savew2(IBUF ,ifmt_InStAp,l_InStAp, ln_InStAp,
     1                    itr9  , 1)
              call savew2(IBUF ,ifmt_ToStUn,l_ToStUn, ln_ToStUn,
     1                    itr15 , 1)
              call savew2(IBUF ,ifmt_ToTmAU,l_ToTmAU, ln_ToTmAU,
     1                    itr16 , 1)
      RETURN
C--
C---- IF HEADER STATICS WERE NOT APPLIED,
C---- WE JUST WANT TO ADD EXTERNAL STATICS
C---- TO THE APPLIED WORDS ONLY!!  FDSTAT
C---- WAS SET UP TO ASSUME HEADER STATICS WERE
C---- ALWAYS GOING TO BE APPLIED FOR NEW STATIC
C---- WORDS, SO APPLIED AND UNAPPLIED WORDS
C---- WERE UPDATED.  THIS IS WRONG IF NOT USING
C---- HEADER STATICS!!!!
C---- IF BLOCK SHIFT, TOTAL STATIC MUST BE ON A
C---- SAMPLE BOUNDARY...
C--
14000 IF ( KHEADR .EQ. 0 ) GO TO 14500
         IF ( ( KSTAT * KFAC ) .NE. ISTAT.AND.KBLOCK.EQ.1) GO TO 15500
C
c     ITHDR( 9) = ITHDR( 9) + ICSA( 2)
c     ITHDR(12) = ITHDR(12) + ICSA( 5)
c     ITHDR(13) = ITHDR(13) + ICSA( 9)
c     ITHDR(14) = ITHDR(14) + ICSA(10)
      itr9  = itr9  + CSA( 2)
      itr12 = itr12 + CSA( 5)
      itr13 = itr13 + CSA( 9)
      itr14 = itr14 + CSA(10)
              call savew2(IBUF ,ifmt_InStAp,l_InStAp, ln_InStAp,
     1                    itr9  , 1)
              call savew2(IBUF ,ifmt_RcStAp,l_RcStAp, ln_RcStAp,
     1                    itr12 , 1)
              call savew2(IBUF ,ifmt_ToStAp,l_ToStAp, ln_ToStAp,
     1                    itr13 , 1)
              call savew2(IBUF ,ifmt_ToTmAA,l_ToTmAA, ln_ToTmAA,
     1                    itr14 , 1)
      RETURN
C--
C---- IF FINE GRAIN SHIFT, ALL UNAPPLIED
C---- STATICS WILL BE USED UP. IF TOTAL
C---- STATIC IS ZERO, EVERYTHING CANCELED OUT.
C---- WE CAN NOW BUG OUT IF FINE GRAIN.
C---- IF BLOCK SHIFT, WE'VE GOT LOT'S OF
C---- STUFF LEFT TO GO...
C--
14500 IF ( KBLOCK .EQ. 1
     *            .AND. ISTAT .NE. 0
     *                  .AND. ( KSTAT * KFAC ) .NE. ISTAT ) GO TO 15000
C
c     ITHDR(14)   =   ITHDR(14)  +  ITHDR(16) + ICSA(10)
c     ITHDR(13)   =   ITHDR(13)  +  ITHDR(15) + ICSA( 9)
c     ITHDR( 9)   =   ITHDR( 8)  +  ITHDR( 9) + ICSA( 2)
c     ITHDR(12)   =   ITHDR(11)  +  ITHDR(12) + ICSA( 5)
c     ITHDR(16)   =   0
c     ITHDR(15)   =   0
c     ITHDR( 8)   =   0
c     ITHDR(11)   =   0
      itr14   =   itr14  +  itr16 + CSA(10)
      itr13   =   itr13  +  itr15 + CSA( 9)
      itr9    =   itr9   +  itr8  + CSA( 2)
      itr12   =   itr12  +  itr11 + CSA( 5)
      itr16   =   0
      itr15   =   0
      itr8    =   0
      itr11   =   0
              call savew2(IBUF ,ifmt_InStAp,l_InStAp, ln_InStAp,
     1                    itr8  , 1)
              call savew2(IBUF ,ifmt_InStAp,l_InStAp, ln_InStAp,
     1                    itr9  , 1)
              call savew2(IBUF ,ifmt_RcStAp,l_RcStAp, ln_RcStAp,
     1                    itr12 , 1)
              call savew2(IBUF ,ifmt_ToStAp,l_ToStAp, ln_ToStAp,
     1                    itr13 , 1)
              call savew2(IBUF ,ifmt_ToTmAA,l_ToTmAA, ln_ToTmAA,
     1                    itr14 , 1)
              call savew2(IBUF ,ifmt_ToStUn,l_ToStUn, ln_ToStUn,
     1                    itr15 , 1)
              call savew2(IBUF ,ifmt_ToTmAU,l_ToTmAU, ln_ToTmAU,
     1                    itr16 , 1)
      RETURN
C--
C---- BLOCK SHIFT MODE NOW...
C--
15000 continue
      SSTAT = ( CSA( 2) + itr8  ) / RFAC
      RSTAT = ( CSA( 5) + itr11 ) / RFAC
      TSTAT = ( CSA( 9) + itr15 ) / RFAC
      ASTAT = ( CSA(10) + itr16 ) / RFAC
      GO TO 16000
C--
C---- THIS SECTION FOR BLOCK SHIFT,
C---- NO HEADER STATICS APPLIED.
C--
15500 continue
      SSTAT = ( CSA( 2) ) / RFAC
      RSTAT = ( CSA( 5) ) / RFAC
      TSTAT = ( CSA( 9) ) / RFAC
      ASTAT = ( CSA(10) ) / RFAC
C
16000 continue
      CSA2   = SSTAT  + SIGN ( 0.5, SSTAT )
      CSA2   = CSA2  * KFAC
      CSA5   = RSTAT  + SIGN ( 0.5, RSTAT )
      CSA5   = CSA5  * KFAC
      CSA9   = TSTAT  + SIGN ( 0.5, TSTAT )
      CSA9   = CSA9  * KFAC
      CSA10  = ASTAT  + SIGN ( 0.5, ASTAT )
      CSA10  = CSA10 * KFAC
      RLEFT  = (CSA9 - CSA2 ) / RFAC
      ILEFT  = RLEFT + SIGN ( 0.5, RLEFT )
      ILEFT  = ILEFT * KFAC
C
c     ITHDR( 9) = ITHDR( 9) + ICSA2
c     ITHDR(12) = ITHDR(12) + ILEFT
c     ITHDR(13) = ITHDR(13) + ICSA9
c     ITHDR(14) = ITHDR(14) + ICSA10
c     ITHDR( 8) = ITHDR( 8) + ICSA( 2) - ICSA2
c     ITHDR(11) = ITHDR(11) + ICSA( 5) - ILEFT
c     ITHDR(15) = ITHDR(15) + ICSA( 9) - ICSA9
c     ITHDR(16) = ITHDR(16) + ICSA(10) - ICSA10
      itr9  = itr9  + CSA2
      itr12 = itr12 + ILEFT
      itr13 = itr13 + CSA9
      itr14 = itr14 + CSA10
      itr8  = itr8  + CSA( 2) - CSA2
      itr11 = itr11 + CSA( 5) - ILEFT
      itr15 = itr15 + CSA( 9) - CSA9
      itr16 = itr16 + CSA(10) - CSA10
              call savew2(IBUF ,ifmt_InStAp,l_InStAp, ln_InStAp,
     1                    itr9  , 1)
              call savew2(IBUF ,ifmt_RcStAp,l_RcStAp, ln_RcStAp,
     1                    itr12 , 1)
              call savew2(IBUF ,ifmt_ToStAp,l_ToStAp, ln_ToStAp,
     1                    itr13 , 1)
              call savew2(IBUF ,ifmt_ToTmAA,l_ToTmAA, ln_ToTmAA,
     1                    itr14 , 1)
              call savew2(IBUF ,ifmt_InStUn,l_InStUn, ln_InStUn,
     1                    itr8  , 1)
              call savew2(IBUF ,ifmt_RcStUn,l_RcStUn, ln_RcStUn,
     1                    itr11 , 1)
              call savew2(IBUF ,ifmt_ToStUn,l_ToStUn, ln_ToStUn,
     1                    itr15 , 1)
              call savew2(IBUF ,ifmt_ToTmAU,l_ToTmAU, ln_ToTmAU,
     1                    itr16 , 1)
      RETURN
C--
C---- FOR TIMING ADJUSTMENT ONLY...
C--
16500 IF ( KBLOCK .EQ. 1 ) GO TO 17500
         IF ( KSHIFT .EQ. 1 ) GO TO 17000
            itr14 = itr14 + itr16 + CSA(10)
            itr16 = 0
              call savew2(IBUF ,ifmt_ToTmAA,l_ToTmAA, ln_ToTmAA,
     1                    itr14 , 1)
              call savew2(IBUF ,ifmt_ToTmAU,l_ToTmAU, ln_ToTmAU,
     1                    itr16 , 1)
            RETURN
C
17000 itr16 = itr16 + CSA(10)
              call savew2(IBUF ,ifmt_ToTmAU,l_ToTmAU, ln_ToTmAU,
     1                    itr16 , 1)
      RETURN
C
17500 ASTAT     = ( CSA(10) + itr16 ) / RFAC
      CSA10    = ASTAT  + SIGN ( 0.5, ASTAT )
      CSA10    = CSA10 * KFAC
      itr14 = itr14 + CSA10
      itr16 = itr16 + CSA(10) - CSA10
              call savew2(IBUF ,ifmt_ToTmAA,l_ToTmAA, ln_ToTmAA,
     1                    itr14 , 1)
              call savew2(IBUF ,ifmt_ToTmAU,l_ToTmAU, ln_ToTmAU,
     1                    itr16 , 1)
C
      RETURN
      END
