C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE DGMPRD (A,B,R,N,M,L)
C
C     MULTIPLY 2 GENERAL DOUBLE PRECISION MATRICES TO FORM A RESULTANT
C         GENERAL DOUBLE PRECISION MATRIX
C
C     (D.P. VERSION OF SSP SUBR. GMPRD)
C         A=FIRST INPUT MATRIX
C         B=SECOND INPUT MATRIX
C         R=OUTPUT MATRIX
C         N=NO. OF ROWS IN A
C         M=NO. COLUMNS IN A AND NO. ROWS IN B
C         L=NO. COLUMNS IN B
C
      REAL*8 A(1),B(1),R(1)
      SAVE ! Cray
      IR=0
      IK=-M
      DO 10 K=1,L
      IK=IK+M
      DO 10 J=1,N
      IR=IR+1
      JI=J-N
      IB=IK
      R(IR)=0
      DO 10 I=1,M
      JI=JI+N
      IB=IB+1
   10 R(IR)=R(IR)+A(JI)*B(IB)
      RETURN
      END
      SUBROUTINE DMINV (A,N,D,L,M)
C
C     INVERT A GENERAL DOUBLE PRECISION MATRIX (A D.P. VERSION OF
C     SSP SUBR. MINV)
C         A = INPUT MATRIX (REPLACED BY RESULTANT INVERSE MATRIX)
C         N = ORDER OF MATRIX A
C         D = RESULTANT DETERMINANT
C         L = WORK VECTOR OF LENGTH N
C         M = WORK VECTOR OF LENGTH N
C
      REAL*8 A(1),D,BIGA,HOLD
      DIMENSION L(1),M(1)
      SAVE ! Cray 
C     SEARCH FOR LARGEST ELEMENT
      D=1.0
      NK=-N
      DO 80 K=1,N
      NK=NK+N
      L(K)=K
      M(K)=K
      KK=NK+K
      BIGA=A(KK)
      DO 20 J=K,N
      IZ=N*(J-1)
      DO 20 I=K,N
      IJ=IZ+I
#ifndef CRAYSYSTEM
   10 IF(DABS(BIGA)-DABS(A(IJ))) 15,20,20
#else
   10 IF(ABS(BIGA)-ABS(A(IJ))) 15,20,20
#endif
   15 BIGA=A(IJ)
      L(K)=I
      M(K)=J
   20 CONTINUE
C     INTERCHANGE ROWS
      J=L(K)
      IF(J-K) 35,35,25
   25 KI=K-N
      DO 30 I=1,N
      KI=KI+N
      HOLD=-A(KI)
      JI=KI-K+J
      A(KI)=A(JI)
   30 A(JI)=HOLD
C     INTERCHANGE COLUMNS
   35 I=M(K)
      IF(I-K) 45,45,38
   38 JP=N*(I-1)
      DO 40 J=1,N
      JK=NK+J
      JI=JP+J
      HOLD=-A(JK)
      A(JK)=A(JI)
   40 A(JI)=HOLD
C     DIVIDE COLUMN BY MINUS PIVOT (VALUE OF PIVOT ELEMENT IS IN BIGA)
   45 IF(BIGA) 48,46,48
   46 D=0.0
      RETURN
   48 DO 55 I=1,N
      IF(I-K) 50,55,50
   50 IK=NK+I
      A(IK)=A(IK)/(-BIGA)
   55 CONTINUE
C     REDUCE MATRIX
      DO 65 I=1,N
      IK=NK+I
      HOLD=A(IK)
      IJ=I-N
      DO 65 J=1,N
      IJ=IJ+N
      IF(I-K) 60,65,60
   60 IF(J-K) 62,65,62
   62 KJ=IJ-I+K
      A(IJ)=HOLD*A(KJ)+A(IJ)
   65 CONTINUE
C     DIVIDE ROW BY PIVOT
      KJ=K-N
      DO 75 J=1,N
      KJ=KJ+N
      IF(J-K) 70,75,70
   70 A(KJ)=A(KJ)/BIGA
   75 CONTINUE
C     PRODUCT OF PIVOTS
      D=D*BIGA
C     REPLACE PIVOT BY RECIPROCAL
      A(KK)=1.0/BIGA
   80 CONTINUE
C     FINAL ROW AND COLUMN INTERCHANGE
      K=N
  100 K=K-1
      IF(K) 150,150,105
  105 I=L(K)
      IF(I-K) 120,120,108
  108 JQ=N*(K-1)
      JR=N*(I-1)
      DO 110 J=1,N
      JK=JQ+J
      HOLD=A(JK)
      JI=JR+J
      A(JK)=-A(JI)
  110 A(JI)=HOLD
  120 J=M(K)
      IF(J-K) 100,100,125
  125 KI=K-N
      DO 130 I=1,N
      KI=KI+N
      HOLD=A(KI)
      JI=KI-K+J
      A(KI)=-A(JI)
  130 A(JI)=HOLD
      GO TO 100
  150 RETURN
      END
