C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
C
C     PROGRAM NAME: SCOR (STATIC CORRECTIONS USING EVENT TAPE)
C
C     LANGUAGE: FORTRAN
C
C     AUTHOR: UNKNOWN
C
C     DATE WRITTEN: UNKNOWN
C
C     AMOCO PRODUCTION CO. PROPRIETARY -
C                              TO BE MAINTAINED IN CONFIDENCE
C
C     ABSTRACT: PROGRAM SCOR WILL CALCULATE A SET OF SURFACE
C               CONSISTENT STATIC CORRECTIONS GIVEN AN EVENT
C               TAPE GENERATED BY EITHER PROGRAM TIME(TIDO),
C               OR PICK.  INITIALLY, THE MEAN TIME IS REMOVED
C               FROM THE TIMES WITHIN EACH CDP.  THEN THE STATIC
C               CORRECTIONS ARE DETERMINED USING THE GAUSS-
C               SEIDEL METHOD.  THE COMPUTED STATICS ARE THEN
C               DISPLAYED IN 8STAT/9CORR CARD FORMATS AND CAN
C               OPTIONALLY BE PUNCHED TO A VM MACHINE FOR
C               USER INSPECTION OR WHATEVER.  THE CORRECTIONS
C               CAN BE MADE TO A FORMAT 1 OR 3 DATA TAPE WITH
C               THE OUTPUT BEING THE SAME FORMAT AS THE INPUT.
C
C     MODIFICATION HISTORY: ??/??/??   ?.?.
C                           ??/??/??   M.MARTIN
C                                      G.RUCKGABER
C                           3-D MODIFICATIONS ("SC3D")
C                           08/25/82   G.SHIBA
C                           ACCEPT 56 OR 256 BYTE EVENT TAPE
C                           TRACE HEADERS ON INPUT.
C                           02/01/83   G.SHIBA
C                           IMPLEMENT TWO-DIMENSIONAL CDP NUMBERING
C                           SCHEME.  INCREASE NUMBER OF DISK UNITS
C                           AVAILABLE TO 10.
C                           03/16/83   G.SHIBA
C                           IF LAST RECORD TO PROCESS IS DEFAULTED,
C                           SET TO LAST RECORD ON TAPE.  PREVIOUSLY,
C                           THE PROGRAM ASSUMED FIRST RECORD ON TAPE
C                           WAS 1.
C                           05/04/83   G.SHIBA
C                           ADD "LBCLOS" ON EVENT TAPE TO ALLOW THE
C                           DATA TAPE TO SHARE TAPE DRIVE THE EVENT
C                           TAPE USED.
C                           02/28/85   E.ANDES
C                           CLEAN UP CODE.  ADD OPTION TO PUNCH
C                           8STAT/9CORR CARDS TO VM MACHINE.
C                           ADD ABILITY TO CALL APOPEN FROM MAIN
C                           INSTEAD OF IN FDSTAT.  REMOVE
C                           "SYSOUT=CPO" INFORMATION.
C                           08/27/86   E.ANDES
C                           MAKE SCOR CAPABLE OF ACCEPTING NEW
C                           STATIC WORDS IF PREVIOUSLY SET.
C                           DELETE JOB NUMBER.  FIX ERRORS IN
C                           8STAT/9CORR CARD GENERATION ROUTINE.
C
C     INTERNAL SUBROUTINES:
C       PRNTEM    STSCAL    BLDSTS    ERRTAB    EVPIKR    EVTIME
C       ERRCAL    ITERAT    FREQER    EDITPK    APLYCR    ELDISK
C
C     EXTERNAL SUBROUTINES:
C       RTAPE     NACCT     DAOPEN    STINIT    MOVE      WRCARD
C       NACCT2    DAWRTE    STAPLY    GAMOCO    LBOPEN    WRTAPE
C       DAREAD    CCEXIT    DACLOS    HLH       LBCLOS    BOX
C       PARM      DGMPRD    APOPEN
C
C***********************************************************************
C
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      integer     argis
C
      REAL        DATA(SZLNHD)

      CHARACTER*8 TJOBID
C
      REAL        I(12001), R(12001), C(30001), M(30001), ARRAY(8190),
     *            CDPMN(30001), SUMI(30001), SUMR(30001), IDUM(30001),
     *            IERR2(30001), RERR2(30001), DIERR2(30001), RDUM(30001)
C
      INTEGER     SUMK(30001), IEVENT(10), FREC, SMOOTH, BASE, GIDIM,
     *            ISTAT(12001), ICORR(12001), DIDIM, GI,     TPRI,
     *            PRI, CFOLD, WEIGHT, IHEAD1(SZLNHD), REC1, REC2,
     *            REPORT(13), ITER(4), OUTPUT, IHDWRD, pipe, inevnt

c     INTEGER     npart(100), mstart(100), lstart(100), inevnt(100)
C
      CHARACTER*80 KARD ! Cray
      character    hdwrd*6
C
      INTEGER     IBUF(12128), IKNT(30001), RKNT(30001), DI2D(30001),
     *            DIKNT(30001), IPRID(30001), IGID(30001), LI2D(30001)
C
      LOGICAL     cmdln, micro, phase, verbos

      CHARACTER*1 PARR(66), LJOBNO(8)
      CHARACTER*4 NAME
      INTEGER     LHEAD(12128)
      REAL        quarter
#include <f77/pid.h>
 
      CHARACTER*256 EVNFIL, INPFIL, CRDFIL, OUTFIL ! Cray
C
      EQUIVALENCE (SUMI(1),SUMK(1),ISTAT(1),IERR2(1)),
     *            (C(1),CDPMN(1)),
     *            (SUMR(1),ICORR(1),RERR2(1)),
     *            (IBUF(1),IHEAD1(1),IPRID(101),LHEAD(1)),
c    *            (IBUF(129), DATA(1)),
c    *            (IHEAD1(1),LHEAD(1)),
     *            (LJOBNO(1),TJOBID)
C
      COMMON /LUNITS/ INEVNT, INPUT, OUTPUT, IPRNTR
C
      CHARACTER*4 SCOR, CARDID ! Cray
C
      DATA SCOR/'SCOR'/, BGROUP/0.0/, N4/4/, ICOUNT/0/,
     *     N16/16/, N52/52/, NUMREC/0/, LJOBNO/8*' '/,
     *     ISEND/0/, NTRS/1/, NAME/'SCOR'/, IHDWRD/125/
     *     IEVENT/10*0/, pipe/3/,hdwrd/'StaCor'/
     *     quarter/4.0/
C
      DATA PARR/15*' ','S','T','A','T','I','C',' ','C','O',
     *             'R','R','E','C','T','I','O','N','S',' ',
     *             'U','S','I','N','G',' ','E','V','E','N',
     *             'T',' ','T','A','P','E',16*' '/,
     *     REPORT/'  AL','TERN','ATE ','PICK',' SUB',
     *            'STIT','UTIO','N AN','D IT','ERAT',
     *            'ION ','REPO','RT  '/,
     *     ITER/'ITER','ATIO','N RE','PORT'/
C
C     COMMON /LUNITS/ INEVNT, INPUT, OUTPUT, IPRNTR
C
      IF (ARGIS('-H') .GT. 0 .OR. ARGIS('-?') .GT. 0) CALL HELP

      itrpnt = 0
      jpnt   = 1

C 
C---- SET LOGICAL UNIT VALUES....
      INPUT  = 3
      OUTPUT = 4
C     IREADR = 5
      IREADR = LUN ! Cray
c     IPRNTR = 6
      IPRNTR = LERR
C
C---- SET VALUES FOR TRAPPING....
      IGMIN  = 99999
      IGMAX  = -9999
      IPMIN  = 99999
      IPMAX  = -9999
      DIDIM  = 30001
      GIDIM  = 12001
      NITEMS = 13

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('PrRcNm',ifmt_PrRcNm,l_PrRcNm,ln_PrRcNm,TRACEHEADER)
      call savelu('PrTrNm',ifmt_PrTrNm,l_PrTrNm,ln_PrTrNm,TRACEHEADER)
 
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('SrPtEl',ifmt_SrPtEl,l_SrPtEl,ln_SrPtEl,TRACEHEADER)
      call savelu('ShtDep',ifmt_ShtDep,l_ShtDep,ln_ShtDep,TRACEHEADER)
      call savelu('UphlTm',ifmt_UphlTm,l_UphlTm,ln_UphlTm,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)
      call savelu('GrpElv',ifmt_GrpElv,l_GrpElv,ln_GrpElv,TRACEHEADER)
      call savelu('DatShf',ifmt_DatShf,l_DatShf,ln_DatShf,TRACEHEADER)
      call savelu('ToTmAU',ifmt_ToTmAU,l_ToTmAU,ln_ToTmAU,TRACEHEADER)
      call savelu('InStUn',ifmt_InStUn,l_InStUn,ln_InStUn,TRACEHEADER)
      call savelu('InStAp',ifmt_InStAp,l_InStAp,ln_InStAp,TRACEHEADER)
      call savelu('ToStAp',ifmt_ToStAp,l_ToStAp,ln_ToStAp,TRACEHEADER)
      call savelu('ToStUn',ifmt_ToStUn,l_ToStUn,ln_ToStUn,TRACEHEADER)
      call savelu('RcStUn',ifmt_RcStUn,l_RcStUn,ln_RcStUn,TRACEHEADER)
      call savelu('RcStAp',ifmt_RcStAp,l_RcStAp,ln_RcStAp,TRACEHEADER)
      call savelu('ToTmAA',ifmt_ToTmAA,l_ToTmAA,ln_ToTmAA,TRACEHEADER)
      call savelu(hdwrd,ifmt_ihdwrd,l_ihdwrd,ln_ihdwrd,TRACEHEADER)
C
C---- PRINT FUNKY STUFF...
C
#include <f77/open.h>
 
      CALL GAMOCO ( PARR, 1, IPRNTR )

      IRETCD = 0
      ikp = in_ikp()
      write(LER,*)'scorusp: ikp= ',ikp

      if (ikp .eq. 0) then
          call argstr ('-E', evnfil, ' ', ' ')
          call getln (inevnt, evnfil, 'r', -1)
      elseif (ikp .eq. 1) then
          call sisfdfit (inevnt, pipe)
      endif
      if (inevnt .lt. 0) IRETCD = 1

      IF (IRETCD .NE. 0) THEN           
          WRITE (LER,'(A)') 'SCOR ERROR: CAN''T OPEN EVENT FILE'
          CALL CCEXIT(9999)
      ENDIF
      write(LERR,*)'Opened event file= ',evnfil,' on unit= ',inevnt

      IRETCD = 0
      call argstr ('-N', inpfil, ' ', ' ')
      call getln (input, inpfil, 'r', 0)
      if (input .lt. 0) IRETCD = 1
c     CALL OPNIN(1,'-N',INPFIL,INPUT,IPRNTR,IRETCD)
 
      IF (IRETCD .NE. 0) THEN
          WRITE (LER,'(A)') 'SCOR ERROR: CAN''T OPEN SEISMIC INPUT FILE
     1'
          CALL CCEXIT(9999)
      ENDIF
      write(LERR,*)'Opened input file= ',inpfil,' on unit= ',input
   
      CALL OPNPRM('-C',CRDFIL,IREADR,IPRNTR,IRETCD,cmdln)

      IF (IRETCD .NE. 0) THEN
          WRITE (LER,'(A)') 'Error Opening Card File -- FATAL'
          CALL CCEXIT(9999)
      ENDIF
      if (cmdln) then
         write(LERR,*)'Will extract cmd line arguments'
      else
         write(LERR,*)'Opened card file '
      endif

      IRETCD = 0
      call argstr ('-O', outfil, ' ', ' ')
      call getln (output, outfil, 'w', 1)
      if (output .lt. 0) IRETCD = 1
c     CALL OPNOUT(0,'-O',OUTFIL,OUTPUT,IPRNTR,IRETCD)

      IF (IRETCD .NE. 0) THEN
          WRITE (LER,'(A)') 'SCOR ERROR: CAN''T OPEN SEISMIC OUTPUT FIL
     1E'
          CALL CCEXIT(9999)
      ENDIF
      write(LERR,*)'Opened output file= ',outfil,' on unit= ',output

      micro  = (argis('-M') .gt. 0)
      phase  = (argis('-P') .gt. 0)
      verbos = (argis('-V') .gt. 0)
      write(IPRNTR,*)'micro= ',micro,'  phase= ',phase

C
C---- READ EVENT TAPE LINE HEADER...
      LENGTH = 0

          CALL RTAPE ( INEVNT, IHEAD1, LENGTH )
          call saver(IHEAD1, 'NumSmp', nsamp, LINHED)
          call saver(IHEAD1, 'SmpInt', nsi  , LINHED)
          call saver(IHEAD1, 'NumTrc', ntrc , LINHED)
          call saver(IHEAD1, 'NumRec', nrec , LINHED)
          call saver(IHEAD1, 'Format', iform, LINHED)
          call saver(IHEAD1, 'ReSpFm', iunit, LINHED)
      call saver(IHEAD1, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(IHEAD1, 'UnitSc', unitsc, LINHED)
      endif
          if (phase) then
             iunit = 1
             quarter = 1.0
          endif
          nwds = nsamp

          write(IPRNTR,*)'Event tape # samples   = ',nsamp
          write(IPRNTR,*)'Event tape # traces/rec= ',ntrc
          write(IPRNTR,*)'Event tape # recs      = ',nrec
          write(IPRNTR,*)'Event static scaler    = ',iunit

          IF ( LENGTH .GT. 0 ) GO TO 200

C
      WRITE (IPRNTR,100)
  100 FORMAT(/,12X, ' ** M0100 ** ERROR DETECTED IN PROGRAM SCOR:',
     *       /,25X, 'END-OF-FILE ENCOUNTERED ATTEMPTING TO READ ',
     *       /,25X, 'THE LINE HEADER OF THE EVENT TAPE.  VERIFY',
     *       /,25X, 'VERIFY THE DATA SET NAME AND IN THE CASE OF ',
     *       /,25X, 'MULTI-VOLUME DATA SETS, VERIFY THE ORDER IN',
     *       /,25X, 'WHICH VOLUMES WERE CATALOGED.',/)
      GO TO 2750
C
C---- SEE IF VALID EVENT TAPE...
  200 CALL MOVE ( 1, TJOBID, IHEAD1(10), SZSMPD )
      
      call saver (ihead1,'TmMsSl', itype , LINHED)
      write(IPRNTR,*)'ITYPE= ',itype
      
      IF ( ITYPE .EQ. 0
     *           .OR. ITYPE .EQ. 1 ) GO TO 400
C
      WRITE (IPRNTR,300)
  300 FORMAT(/,12X, ' ** M0300 ** ERROR DETECTED BY PROGRAM SCOR:',
     *       /,25X, 'THE INPUT DATA SET ON NEVT SHOULD BE AN EVENT',
     *       /,25X, 'TAPE GENERATED FROM EITHER PROGRAMS TIME OR',
     *       /,25X, 'PICK.  THE ORIGINATION CODE (BYTES 155-156)',
     *       /,25X, 'FILED IN THE EVENT TAPE LINE HEADER SHOULD',
     *       /,25X, 'BE A 0 IF GENERATED BY TIME, AND A 1 IF',
     *       /,25X, 'GENERATED BY PICK.',/)
      GO TO 2750
C
C---- DISPLAY LINE HEADER
  400 IF ( ITYPE .EQ. 1 ) WRITE (IPRNTR,500)
  500 FORMAT(//, 47X, '*** MESSAGE FROM PROGRAM SCOR ***',
     *        /, 42X, 'THE FOLLOWING IS THE INPUT EVENT TAPE (NEVT)',
     *        /, 42X, 'LINE HEADER TO PROGRAM SCOR.  IT WAS GENERATED',
     *        /, 42X, 'BY PROGRAM PICK.',/)
C
      IF ( ITYPE .EQ. 0 ) WRITE (IPRNTR,550)
  550 FORMAT(//, 47X, '*** MESSAGE FROM PROGRAM SCOR ***',
     *        /, 42X, 'THE FOLLOWING IS THE INPUT EVENT TAPE (NEVT)',
     *        /, 42X, 'LINE HEADER TO PROGRAM SCOR.  IT WAS GENERATED',
     *        /, 42X, 'BY PROGRAM TIME OR TIDO.',/)
C
      CALL HLHPRT(IHEAD1, LENGTH, SCOR, N4, IPRNTR) ! Cray
      
C
      IF (cmdln) THEN           ! *** Command Line Input *****************

         call argi4 ('-bd'  ,  BASE ,  5000, 5000)
         call argi4 ('-fld' , CFOLD ,     0,    0)
         call argi4 ('-spl' ,  IGRP ,     0,    0)
         call argi4 ('-ni'  ,NITERS ,     0,    0)
         call argi4 ('-sm'  ,SMOOTH ,   999,  999)
         call argi4 ('-rs'  ,  FREC ,     0,    0)
         call argi4 ('-re'  ,  LREC ,     0,    0)
         call argi4 ('-ir'  ,IEQWLR ,     0,    0)
         call argi4 ('-wt'  ,WEIGHT ,     0,    0)
         call argi4 ('-apl' ,ISHIFT ,     0,    0)
         call argi4 ('-hed' ,IHEADR ,     0,    0)
         call argi4 ('-mod' ,IBLOCK ,     0,    0)
         call argi4 ('-trd' , KUBIC ,     0,    0)
         call argi4 ('-hw'  ,ihdwrd ,   125,  125)
         call argstr('-Hw'  ,hdwrd ,   'StaCor',  'StaCor')
      call savelu(hdwrd,ifmt_ihdwrd,l_ihdwrd,ln_ihdwrd,TRACEHEADER)

      ELSE                      ! *** Card Input *************************

C---- READ DATA CARD....
      READ (IREADR,'(A)',END=2600) KARD ! Cray
      READ (KARD,600) NUMBER, CARDID, BASE, CFOLD, IGRP, ! Cray
     *               NITERS, SMOOTH, FREC, LREC, (IEVENT(J),J=1,10),
     *               IEQWLR,   ISHIFT, WEIGHT, IHEADR, IBLOCK, IHDWRD,
     *               KUBIC,    KARD
  600 FORMAT(          I1,     A4,    I5,   T13,I3, T20,I1, T24,I2,
     *               T27,I4, T31,I5,  T36,I5,         10I1,
     *               T55,I1,   T59, I1, I1,   I1,      I1,I3,
     *               T80,I1,   T1,20A4             )
C
      write(IPRNTR,*)'ishift= ',ishift
C---- WRITE IT OUT...
      CALL WRCARD ( KARD, 1, IPRNTR )
C
C---- IS IT A 1SCOR CARD ???
      IF ( NUMBER .EQ. 1
     *            .AND. CARDID .EQ. SCOR ) GO TO 800
      WRITE (IPRNTR,700)
  700 FORMAT(/,12X, ' ** M0700 ** ERROR DETECTED BY PROGRAM SCOR:',
     *       /,25X, 'CARD MNEMONIC (CC 1-5) OF THE PARAMETER CARD',
     *       /,25X, 'IS NOT SPECIFIED AS 1SCOR.  VERIFY CARD INPUT',
     *       /,25X, 'AND RESUBMIT.',/)
      GO TO 2750

      ENDIF                     ! ****************************************
C
C---- SET DEFAULTS IF NEEDED....
  800 IF ( FREC   .EQ. 0 ) FREC      = 1
      IF ( LREC   .EQ. 0 ) LREC      = 99999
      IF ( IGRP   .EQ. 1 ) BGROUP    = 0.5
      IF ( IGRP   .EQ. 3
     *            .AND. NITERS .EQ. 0 ) NITERS = 1
      IF ( IGRP   .EQ. 3 ) KUBIC     = 1
      IF ( BASE   .EQ. 0 ) BASE      = 5000

      IF ( CFOLD  .EQ. 0 ) call saver (ihead1,'CDPFld', CFOLD, LINHED)
      IF ( IHEADR .NE. 1 ) IHEADR    = 0
      IF ( IBLOCK .NE. 1 ) IBLOCK    = 0
      IF ( NITERS .EQ. 0 ) NITERS    = 20
      IF ( SMOOTH .EQ. 0 ) SMOOTH    = 1000
      if (phase) then
          IF ( IHDWRD .eq. 0 ) IHDWRD    = 1
          hdwrd = 'SGRDat'
      else
          IF ( IHDWRD .eq. 0 ) IHDWRD    = 125
          hdwrd = 'StaCor'
      endif
      call savelu(hdwrd,ifmt_ihdwrd,l_ihdwrd,ln_ihdwrd,TRACEHEADER)
      IBLOCK = 0
      BASESQ = BASE * BASE

      if (micro) then
         write(IPRNTR,*)' '
         write(IPRNTR,*)'**********************************************'
         write(IPRNTR,*)'WARNING: time units selected is micro seconds'
         write(IPRNTR,*)'therefore I will have to use trace header word'
         write(IPRNTR,*)'3-4 (mnemonic SGRDat) which is a full integer'
         write(IPRNTR,*)'So please be aware of this - thanks'
         write(IPRNTR,*)'**********************************************'
         IHDWRD = 2
         write(IPRNTR,*)' '
      endif
C
      IF ( SMOOTH .GE. 0 ) GO TO 1200
      WRITE (IPRNTR,1100)
 1100 FORMAT(/,12X, ' ** M1100 ** ERROR DETECTED BY PROGRAM SCOR:',
     *       /,25X, 'THE ENTRY FOR THE NUMBER OF POINTS TO SMOOTH',
     *       /,25X, 'THE RNMO (CC 27-30) IS LESS THAN ZERO.  THIS',
     *       /,25X, 'ENTRY SHOULD BE AN ODD NUMBER OF CDPS LESS THAN',
     *       /,25X, 'OR EQUAL TO THE NUMBER OF CDPS ON THE LINE.',/)
      GO TO 2750
C
C---- SEE WHAT PARMS ARE ON
C---- EXEC CARD, IF ANY.....
 1200 CALL STSCAL ( ISEND, LJOBNO )
C
C---- PRINT PARAMETER DISPLAY...
      WRITE (IPRNTR,1300) BASE, WEIGHT, CFOLD, IGRP,
     *                   IHEADR, IBLOCK, NITERS
 1300 FORMAT(///,T28,'***** CARD PARAMETERS FOR 1SCOR CARD AFTER ',
     *               'ANY NEEDED DEFAULTS *****',
     *       //,18X,'BASE DISTANCE .................',I5,
     *          15X,'WEIGHTED SOLUTION .............',I5,
     *        /,69X,'  0 = USE WEIGHTED SOLUTION    ',
     *        /,18X,'FOLD ..........................',I5,
     *          15X,'  1 = NO  WEIGHTED SOLUTION    ',
     *       //,18X,'TYPE OF SHOOTING ..............',I5,
     *          15X,'HEADER STATICS APPLICATION ....',I5,
     *        /,18X,'  0 = ON  GROUP                ',
     *          20X,'  0 = DO NOT APPLY HEADER STATICS',
     *        /,18X,'  1 = OFF GROUP                ',
     *          20X,'  1 = APPLY HEADER STATICS     ',
     *        /,18X,'  3 = 3-D                      ',
     *        /,69X,'STATICS APPLICATION MODE ......',I5,
     *        /,18X,'NUMBER OF ITERATIONS ..........',I5,
     *          15X,'  0 = NEAREST SAMPLE           ',
     *        /,69X,'  1 = FINE GRAIN (NEAREST 1/4 MS)'  )

       WRITE (IPRNTR,*)
     *        'STATICS APPLICATION ...........',ISHIFT,
     *        '  (0 = APPLY;  1 = DO NOT APPLY)'

      WRITE (IPRNTR,1400) SMOOTH, ISEND, FREC, LREC, KUBIC,
     *                    (IEVENT(J),J=1,10), ihdwrd, IEQWLR
 1400 FORMAT (  18X,'NO. OF POINTS IN RNMO SMOOTH ..',I5,
     *        /,69X,'PUNCH STATICS CARDS TO CMS ID .',I5,
     *        /,18X,'FIRST RECORD TO PROCESS .......',I5,
     *          15X,'  0 = NO                       ',
     *        /,69X,'  1 = YES                      ',
     *        /,18X,'LAST RECORD TO PROCESS ........',I5,
     *        /,69X,'REMOVE CUBIC TREND ............',I5,
     *        /,18X,'EVENT FLAGS FOR TIME TAPE .....',10I1,
     *          10X,'  0 = REMOVE THE CUBIC TREND   ',
     *        /,69X,'  1 = NO REMOVAL               ',
     *        /,18x,'STATIC HEADER WORD TO WRITE TO=',I5,
     *        /,18X,'INITIATION EQUALS RECEPTION ...',I5,
     *        /,18X,'  0 = I NOT EQUAL TO R         ',
     *        /,18X,'  1 = I     EQUAL TO R         ', // )
C
C---- CALCULATE AMOUNT OF DISK SPACE REQUIRED
C
C---- DETERMINE NUMBER OF TRACES TO BE PROCESSED
      call saver (ihead1,'NumTrc', ntrc , LINHED)
      call saver (ihead1,'NumRec', nrec , LINHED)
      write(IPRNTR,*)'Number Records= ',nrec,'  Number traces/rec=  ',
     1                ntrc
      NTRACE = ( LREC - FREC + 1 ) * ntrc
      IF ( FREC .EQ. 1
     *          .OR. LREC .EQ. 99999 )
     *                 NTRACE = nrec       * ntrc
C
C---- NUMBER OF BYTES PER "TRACE"
      NBYTR  =  SZSMPD * NITEMS
C
C---- NUMBER OF TRACES PER BLOCK
      NTRBLK = 8190*SZSMPD  / NBYTR
C
C---- NUMBER OF BLOCKS
      NTRAKS = NTRACE / NTRBLK + 1
C
C---- NUMBER OF BYTES PER BLOCK
      IBYTES = NBYTR  * NTRBLK
C
C---- GO GET THE SPACE....
      write(IPRNTR,*)'nrec,ntrc,NITEMS,NTRBLK,NTRAKS= ',
     1                nrec,ntrc,NITEMS,NTRBLK,NTRAKS
      CALL ELOPEN ( NTRS, NTRAKS, IBYTES)
C
C---- SEE WHICH TYPE OF EVENT TAPE...
      IF ( ITYPE .EQ. 1 ) GO TO 1700
C
C---- PRINT THE HEADING AND
C---- PROCESS THE TIME TAPE...
      CALL BOX ( IPRNTR, ITER, N16 )
      WEIGHT = 1
      N1     = 0
      N2     = NITERS
      NNN    = 1
C
C---- READ EVENT TIMES AND
C---- PLAY WITH THEM...

      CALL EVTIME ( FREC, LREC, REC1, REC2, BASESQ, IBUF, IEVENT,
     *              CFOLD, IGRP, ARRAY, NBLK, LBLK, NTRBLK, NITEMS,
     *              GIDIM, DIDIM, ITRWRD, SZSMPD, SZLNHD,
     * ifmt_TrcNum,l_TrcNum, ln_TrcNum,ifmt_RecNum,l_RecNum, ln_RecNum,
     * ifmt_DphInd,l_DphInd, ln_DphInd,ifmt_RecInd,l_RecInd, ln_RecInd,
     * ifmt_PrRcNm,l_PrRcNm, ln_PrRcNm,ifmt_StaCor,l_StaCor, ln_StaCor,
     * ifmt_DstSgn,l_DstSgn, ln_DstSgn,ifmt_LinInd,l_LinInd, ln_LinInd,
     * verbos)

      CALL LBCLOS ( INEVNT )
C
C---- CHECK RECORD BOUNDARIES...
      IF ( REC1 .GT. FREC ) WRITE (IPRNTR,1500) FREC, REC1
 1500 FORMAT(/,12X, ' ** M1500 ** WARNING FROM PROGRAM SCOR:',
     *       /,25X, 'THE USER SPECIFIED ',I5,' TO BE THE',
     *       /,25X, 'FIRST RECORD TO BE PROCESSED ON THE EVENT',
     *       /,25X, 'TAPE (CC 31-35), BUT THE FIRST RECORD ON',
     *       /,25X, 'THE EVENT TAPE IS ',I5,'.  THEREFORE, THIS',
     *       /,25X, 'RECORD WILL BE THE FIRST RECORD PROCESSED.',
     *       /,25X, 'IF THIS IS UNSATISFACTORY, CHECK FOR MISSING',
     *       /,25X, 'RECORDS AND/OR TRACES DUE TO ERRORS ON',
     *       /,25X, 'PREVIOUS PROCESSING STEPS AND CHECK FOR',
     *       /,25X, 'ERRONEOUS VALUES FILED IN THE LINE HEADER.',/)
C
      IF ( REC2 .LT. LREC ) WRITE (IPRNTR,1600) LREC, REC2
 1600 FORMAT(/,12X, ' ** M1600 ** WARNING FROM PROGRAM SCOR:',
     *       /,25X, 'EXPECTED RECORD ',I5,' TO BE THE LAST RECORD',
     *       /,25X, 'TO BE PROCESSED ON THE EVENT TAPE, BUT THE END',
     *       /,25X, 'OF THE EVENT TAPE WAS ENCOUNTERED AFTER ',
     *       /,25X, 'RECORD ',I5,'.  CHECK LAST EVENT TAPE RECORD',
     *       /,25X, 'TO PROCESS ENTRY (CC 36-40).  CHECK FOR PREVIOUS',
     *       /,25X, 'PROCESSING STEP ERRORS AND CHECK FOR ERRONEOUS',
     *       /,25X, 'VALUES FILED IN THE LINE HEADER.',/)
C
C---- CLEAR INITIATION, RECEPTION,
C---- STRUCTURE, & RNMO BUFFERS
      CALL MOVE ( 0, I, 0, GIDIM * SZSMPD ) ! Cray
      CALL MOVE ( 0, R, 0, GIDIM * SZSMPD ) ! Cray
      CALL MOVE ( 0, C, 0, DIDIM * SZSMPD ) ! Cray
      CALL MOVE ( 0, M, 0, DIDIM * SZSMPD ) ! Cray
C
      GO TO 2200
C
C---- SET SOME DEFAULTS FOR 3-D PROCESSING
 1700 N1ORN5 = 5
      IF ( IGRP .EQ. 3 ) N1ORN5 = 1
      IF ( IGRP .EQ. 3
     *          .AND. NITERS .EQ. 0) NITERS = 1
      IF ( NITERS .EQ. 0 ) NITERS = 20
      N1 = N1ORN5
      N2 = NITERS - N1ORN5
C
      CALL MOVE ( 0, ARRAY, 0., 8190*SZSMPD ) ! Cray
C
C---- PROCESS THE PICK TAPE

      CALL EVPIKR ( FREC, LREC, REC1, REC2, BASESQ, CFOLD, IBUF, WEIGHT,
     *              CDPMN, IGRP, ARRAY, NBLK, LBLK, NTRBLK, NITEMS,
     *              GIDIM, DIDIM , ITRWRD, SZSMPD, SZLNHD, nwds, iunit,
     * ifmt_TrcNum,l_TrcNum, ln_TrcNum,ifmt_RecNum,l_RecNum, ln_RecNum,
     * ifmt_DphInd,l_DphInd, ln_DphInd,ifmt_RecInd,l_RecInd, ln_RecInd,
     * ifmt_PrRcNm,l_PrRcNm, ln_PrRcNm,ifmt_StaCor,l_StaCor, ln_StaCor,
     * ifmt_DstSgn,l_DstSgn, ln_DstSgn,ifmt_LinInd,l_LinInd, ln_LinInd,
     * verbos)

      CALL LBCLOS ( INEVNT )
C
      IF ( REC1 .GT. FREC )
     *          WRITE (IPRNTR,1500) FREC, REC1
      IF ( REC2 .LT. LREC )
     *          WRITE (IPRNTR,1600) LREC, REC2
C
C---- CALCULATE ERROR BEFORE ANY CALCULATIONS (I=R=C=M=0)
      CALL BOX ( IPRNTR, REPORT, N52 )
 1800 IF ( ICOUNT .GE. 20 ) GO TO 2000
C
      CALL MOVE ( 0, I, 0, GIDIM * SZSMPD ) ! Cray
      CALL MOVE ( 0, R, 0, GIDIM * SZSMPD ) ! Cray
      CALL MOVE ( 0, C, 0, DIDIM * SZSMPD ) ! Cray 
      CALL MOVE ( 0, M, 0, DIDIM * SZSMPD ) ! Cray
C
      CALL ERRCAL ( RMS, I, R, C, M, ARRAY, NBLK, LBLK, NTRBLK, NITEMS )
C
      WRITE (IPRNTR,1900) ICOUNT, RMS
 1900 FORMAT(/,29X,'===> RMS ERROR OF PICK SET NUMBER ',I2,
     *             ' BEFORE ITERATING IS ',F10.3,' <===',/)
C
      NNN = 1
      CALL ITERAT ( N1, SUMI, SUMR, BGROUP, SMOOTH, SUMK, NNN, IEQWLR,
     *              KUBIC, IGRP, I, R, C, M, ARRAY, NBLK, LBLK,
     *              NTRBLK, NITEMS, GIDIM, DIDIM ,
     *              ITRWRD, SZSMPD, SZLNHD)
C
      ICOUNT = ICOUNT + 1
C
C---- DO SOME EDITTING...
C---- INTERCHANGE BEST PICKS WITH ALTERNATES
      CALL EDITPK ( NUMCHG, I, R, C, M, ARRAY, NBLK, LBLK, NTRBLK,
     *              NITEMS )
C
      IF ( NUMCHG .EQ. 0 ) GO TO 2000
      WRITE(IPRNTR,1950) NUMCHG
 1950 FORMAT(///,T39,'***** ',I4,' ALTERNATE PICKS HAVE BEEN ',
     *          'SUBSTITUTED *****',//)
      GO TO 1800
C
C---- MINIMUM ERROR PRODUCED BY EXCHANGING PICKS,
C---- SO BEGIN FINAL ITERATIONS
 2000 ICOUNT = ICOUNT - 1
      WRITE (IPRNTR,2100) ICOUNT
 2100 FORMAT(/,28X,'===> PICK SET NUMBER ',I2,' IS THE FINAL ',
     *             'SET OF PICKS.  BEGIN ITERATING <===',/)
C
 2200 continue

      CALL ITERAT ( N2, SUMI, SUMR, BGROUP, SMOOTH, SUMK, NNN, IEQWLR,
     *              KUBIC, IGRP, I, R, C, M, ARRAY, NBLK, LBLK,
     *              NTRBLK, NITEMS, GIDIM, DIDIM ,
     *              ITRWRD, SZSMPD, SZLNHD)
C
C---- CONSTRUCT A HISTOGRAM FOR
C---- THE DISTRIBUTION OF ERRORS...

      CALL FREQER ( I, R, C, M, ARRAY, NBLK, LBLK, NTRBLK, NITEMS )
C
C---- SET SCOR DEFAULTS TO BE
C---- COMPATIBLE WITH FDSTAT DEFAULTS....
      JHEADR = 0
      JBLOCK = 0
      IF( IHEADR .EQ. 0 ) JHEADR = 1
      IF( IBLOCK .EQ. 0 ) JBLOCK = 1
C
C---- GO APPLY THE STATIC...
      write(IPRNTR,*)'Using header word= ',ihdwrd

      CALL APLYCR ( IBUF, IHEAD1, LHEAD, JBLOCK, JHEADR, IGRP, IGMIN,
     *              IGMAX, IPMIN, IPMAX, I, R, GIDIM, iunit, DATA,
     *              ISHIFT, micro, phase, ITRWRD, SZSMPD, SZLNHD,
     *              quarter,
     * ifmt_TrcNum,l_TrcNum, ln_TrcNum,ifmt_RecNum,l_RecNum, ln_RecNum,
     * ifmt_DphInd,l_DphInd, ln_DphInd,ifmt_RecInd,l_RecInd, ln_RecInd,
     * ifmt_PrRcNm,l_PrRcNm, ln_PrRcNm,ifmt_StaCor,l_StaCor, ln_StaCor,
     * ifmt_DstSgn,l_DstSgn, ln_DstSgn,ifmt_LinInd,l_LinInd, ln_LinInd,
     * ifmt_DatShf,l_DatShf, ln_DatShf,ifmt_ToStUn,l_ToStUn, ln_ToStUn,
     * ifmt_ToTmAU,l_ToTmAU, ln_ToTmAU,ifmt_ihdwrd,l_ihdwrd, ln_ihdwrd,
     * ifmt_InStUn,l_InStUn, ln_InStUn,ifmt_RcStUn,l_RcStUn, ln_RcStUn,
     * ifmt_InStAp,l_InStAp, ln_InStAp,ifmt_RcStAp,l_RcStAp, ln_RcStAp,
     * ifmt_ToStAp,l_ToStAp, ln_ToStAp,ifmt_ToTmAA,l_ToTmAA, ln_ToTmAA)

C
C---- ZERO OUT STATIC BUFFERS....
      CALL MOVE ( 0, ISTAT, 0, GIDIM * SZSMPD ) ! Cray
      CALL MOVE ( 0, ICORR, 0, GIDIM * SZSMPD ) ! Cray
C
C---- GET STATIC INFORMATION
C---- FOR CARD IMAGES....
      DO 2500 J = 1,NBLK
         N = NTRBLK
         IF ( J .EQ. NBLK ) N = LBLK
         CALL ELREAD ( J, ARRAY )
C
C---- SET INDICES..
         DO 2400 K = 1,N
            INDEX  = ( K - 1 ) * NITEMS + 1
            GI     = ARRAY( INDEX +  7 )
            TPRI   = ARRAY( INDEX +  8 )
            IF ( IGRP .EQ. 3 ) TPRI = ARRAY( INDEX + 10 )
            PRI    = ARRAY( INDEX + 10 )
C
C---- STUFF STATIC BUFFER..
C---- MAKE INTEGER NUMBER LOOK REAL.....
            ISTAT(GI)  = R(GI)   * 100.0
            ICORR(PRI) = I(TPRI) * 100.0
 2400    CONTINUE
 2500 CONTINUE
C
C---- GO PRINT THE CARD IMAGES....
      CALL PRNTEM ( IGMIN, IGMAX, IPMIN, IPMAX, ISEND, ISTAT, ICORR )
C
C---- PRINT SUMMARY OF I, R, C, M, STATICS & ERRORS
      CALL ERRTAB ( IERR2, RERR2, DIERR2, IDUM, RDUM, IPRID, IGID, IKNT,
     *              RKNT, DIKNT, IEQWLR, LI2D, DI2D, IGRP, I, R, C, M,
     *              ARRAY, NBLK, LBLK, NTRBLK, NITEMS, GIDIM, DIDIM ,
     *              ITRWRD, SZSMPD, SZLNHD)
      GO TO 2800
C
C---- COME HERE IF NO INPUT CARD.....
 2600 WRITE(IPRNTR,2700)
 2700 FORMAT (/12X, ' ** M2700 ** ERROR DETECTED BY PROGRAM SCOR:',
     *        /25X, 'A 1SCOR CARD IS REQUIRED BUT WAS NOT INPUT.',
     *        /25X, 'VERIFY CARD INPUT AND RESUBMIT.',/)
 2750 CALL LBCLOS ( INEVNT )
CIBM  CALL CCEXIT ( 100 )
      STOP 1010 ! Cray
C
C---- WE'RE THROUGH ....
 2800 IRECB  = FREC
      IF ( REC1 .GT. FREC ) IRECB = REC1
      IRECE  = LREC
      IF ( REC2 .LT. LREC ) IRECE = REC2
      NUMREC = IRECE - IRECB + 1
      CALL CCEXIT(0) ! Cray  
      END
