C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE SHIFTS(TRACE,LENTR,SV)
      PARAMETER (MAXN=8192,MAXW=5*MAXN/2,PI=3.141592654)
      COMPLEX T(0:MAXN-1), F(0:MAXN-1)
      REAL TRACE(0:*), SV, P, W
      LOGICAL FRAC
      DATA LASTR /0/
      SAVE ! DATA STATIC AFTER 1ST CALL

C     IF TRACE LENGTH CHANGES, REBUILD SIN/COS TABLE
      IF (LENTR .NE. LASTR) THEN
          N=2**INT(LOG(FLOAT(LENTR-1))/LOG(2.0)+1.0)
          IF (N .GT. MAXN) STOP
          LASTR=LENTR
      ENDIF

C     DETERMINE FRONT END MUTE
      MUTE=0
      DO 1 K = 0, LENTR-1
         IF (TRACE(K) .NE. 0.0) GOTO 2
         MUTE=MUTE+1
1     CONTINUE
2     CONTINUE
C     COPY INPUT TRACE IN AS COMPLEX
      DO 3 K = 0, LENTR-1
         T(K) = TRACE(K)
3     CONTINUE
C     ZERO TO END OF BUFFER
      DO 4 K = LENTR, N-1
         T(K) = (0.,0.)
4     CONTINUE

C     DO FORWARD FFT
      call cfftb (T, F, n, +1)

C     CALCULATE REQUIRED PHASE SHIFT
      P = -(2.0*PI*SV)/N
C     APPLY PHASE SHIFT AT EACH FREQ
      DO 5 K = 1, N-1
         W = K
         IF (K .GT. N/2) W = W-N
         F(K) = F(K) * CMPLX(COS(P*W),SIN(P*W))
5     CONTINUE

C     BACK TO TIME DOMAIN
      call cfftb (F, T, n, -1)
      DO 6 K = 0, LENTR-1
         TRACE(K) = T(K)/FLOAT(N)
6     CONTINUE

C     RE-APPLY FRONT END MUTE
      FRAC=(SV-REAL(INT(SV)) .NE. 0.0)
      M=SV
      IF (FRAC .AND. SV .GT. 0.0) M=M+1  
      J=0
      DO 7 K = 1, MUTE+M
         TRACE(J)=0.0
         J=J+1
7     CONTINUE

C     WE'RE DONE IF POSITIVE SHIFT 
      IF (SV .GE. 0.0) RETURN
C     KILL WRAPPED AROUND SAMPLES
      J=LENTR-1
      M=ABS(M)
      IF (FRAC) M=M+1
      DO 8 K = 1, M       
         TRACE(J)=0.0
         J=J-1
8     CONTINUE
      RETURN
      END
