C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE foldf (A,ZA,LA,B,ZB,LB,X,LX,npow,first,amp)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

C---  CROSS CORRELATE THE TIME SERIES IN A WITH THAT IN B
C---  WITH CORRELATION COEFFICIENTS RETURNED IN X.

      PARAMETER (MXPOW=SZLNHD,MXWRK=(5*SZLNHD)/2)
      REAL      A(MXPOW), B(LB), X(LX)
      COMPLEX   ZA(MXPOW), ZB(MXPOW)
      integer   ordfft
      logical   first

      DATA LPOW /0/
      SAVE LPOW ! KEEP STATIC

      IF ( first ) THEN

C---  DETERMINE CORRECT POWER OF 2 FOR FFT'S
         LX = LA + LB - 1
         nu = ordfft ( LX )
         npow =  2 ** nu

c     write(LER,*)'LG= ',LA,npow,amp
c     write(LER,*)(a(ii),ii=1,la)

C---  FFT of A
         call rfftf  (A, ZA, npow)
         call rfftsc (ZA, npow, 3, 1)

         first = .false.

      ENDIF

C---  CONVERT TIME REVERSAL OF B TO COMPLEX

c     write(LER,*)'LB= ',LB,npow
c     write(LER,*)(b(ii),ii=1,lb)

      do  i = 1, MXPOW
          ZB (i) = cmplx (0.,0.)
      enddo

C---  FFT of B
      call rfftf  (B, ZB, npow)
      call rfftsc (ZB, npow, 3, 1)

C---  MULTIPLY IN FREQ DOMAIN AND DO INVERSE TRANSFORM
      DO 6 N = 1, NPOW/2 + 1
         ZB(N) = ZA(N) * ZB(N)
6     CONTINUE
      call rfftsc (ZB, npow, -3, 0)
      call rffti  (ZB, B, npow)

C---  RETURN SCALED COEFFICIENTS IN X
      DO I = 1, LB
         X(i) = amp * B(i)
      ENDDO

      RETURN
      END
