C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C                                                                       00000100
C     ..................................................................00000200
C                                                                       00000300
C        SUBROUTINE SICI                                                00000400
C                                                                       00000500
C        PURPOSE                                                        00000600
C           COMPUTES THE SINE AND COSINE INTEGRAL                       00000700
C                                                                       00000800
C        USAGE                                                          00000900
C           CALL SICI(SI,CI,X)                                          00001000
C                                                                       00001100
C        DESCRIPTION OF PARAMETERS                                      00001200
C           SI    - THE RESULTANT VALUE SI(X)                           00001300
C           CI    - THE RESULTANT VALUE CI(X)                           00001400
C           X     - THE ARGUMENT OF SI(X) AND CI(X)                     00001500
C                                                                       00001600
C        REMARKS                                                        00001700
C           THE ARGUMENT VALUE REMAINS UNCHANGED                        00001800
C                                                                       00001900
C        SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED                  00002000
C           NONE                                                        00002100
C                                                                       00002200
C        METHOD                                                         00002300
C           DEFINITION                                                  00002400
C           SI(X)=INTEGRAL(SIN(T)/T)                                    00002500
C           CI(X)=INTEGRAL(COS(T)/T)                                    00002600
C           EVALUATION                                                  00002700
C           REDUCTION OF RANGE USING SYMMETRY.                          00002800
C           DIFFERENT APPROXIMATIONS ARE USED FOR ABS(X) GREATER        00002900
C           THAN 4 AND FOR ABS(X) LESS THAN 4.                          00003000
C           REFERENCE                                                   00003100
C           LUKE AND WIMP, 'POLYNOMIAL APPROXIMATIONS TO INTEGRAL       00003200
C           TRANSFORMS',  MATHEMATICAL TABLES AND OTHER AIDS TO         00003300
C           COMPUTATION, VOL. 15, 1961, ISSUE 74, PP. 174-178.          00003400
C                                                                       00003500
C     ..................................................................00003600
C                                                                       00003700
      SUBROUTINE SICI(SI,CI,X)                                          00003800
      Z=ABS(X)                                                          00003900
      IF(Z-4.)1,1,4                                                     00004000
    1 Y=(4.-Z)*(4.+Z)                                                   00004100
      SI=-1.570797E0                                                    00004200
      IF(Z)3,2,3                                                        00004300
c - this number wasn't representable on some machines
c   2 CI=-1.E75                                                         00004400
    2 CI=-1.E36                                                         00004400
      RETURN                                                            00004500
    3 SI=X*(((((1.753141E-9*Y+1.568988E-7)*Y+1.374168E-5)*Y+6.939889E-4)00004600
     1*Y+1.964882E-2)*Y+4.395509E-1+SI/X)                               00004700
      CI=((5.772156E-1+ALOG(Z))/Z-Z*(((((1.386985E-10*Y+1.584996E-8)*Y  00004800
     1+1.725752E-6)*Y+1.185999E-4)*Y+4.990920E-3)*Y+1.315308E-1))*Z     00004900
      RETURN                                                            00005000
    4 SI=SIN(Z)                                                         00005100
      Y=COS(Z)                                                          00005200
      Z=4./Z                                                            00005300
      U=((((((((4.048069E-3*Z-2.279143E-2)*Z+5.515070E-2)*Z-7.261642E-2)00005400
     1*Z+4.987716E-2)*Z-3.332519E-3)*Z-2.314617E-2)*Z-1.134958E-5)*Z    00005500
     2+6.250011E-2)*Z+2.583989E-10                                      00005600
      V=(((((((((-5.108699E-3*Z+2.819179E-2)*Z-6.537283E-2)*Z           00005700
     1+7.902034E-2)*Z-4.400416E-2)*Z-7.945556E-3)*Z+2.601293E-2)*Z      00005800
     2-3.764000E-4)*Z-3.122418E-2)*Z-6.646441E-7)*Z+2.500000E-1         00005900
      CI=Z*(SI*V-Y*U)                                                   00006000
      SI=-Z*(SI*U+Y*V)                                                  00006100
      IF(X)5,6,6                                                        00006200
    5 SI=3.141593E0-SI                                                  00006300
    6 RETURN                                                            00006400
      END                                                               00006500
