C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine picker (ntrc,nsamp,nh,nvel,jrec,si,velsem,JJ,
     1                   vello,velhi,data,velg,nord,devu,igate,
     2                   next,linear,verbos,vmn,vmx,vout,lupik,
     3                   unit1,unit2,unit3,nreci,ntrci,nsampi,
     4                   off1,off2,off3,devl,xsd,flat,stack)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      real    data(nsamp,ntrc)
      real    velsem(nsamp), vello(nsamp), velhi(nsamp)
      real    velg(nsamp), vout(nsamp)
      real    stack(nsamp)

      real    semstk(SZLNHD), sig(SZLNHD)
      integer jhor(SZLNHD)
      real    vp(SZLNHD), velf(SZLNHD), vtr(SZLNHD), tf(SZLNHD)
      integer ip(SZLNHD), ipp(SZLNHD)
      integer next, pass, xsd, flat

      integer nord
      logical linear
      logical verbos

      write(LERR,*)' '
      write(LERR,*)'*******************'
      write(LERR,*)'Record (seql & stack)= ',jrec
      write(LERR,*)'*******************'

c++++++
c     determine the upper & lower bounds of the vel fairway
c     mute the semblance matrix outside these bounds
c++++++
      nsi = si

      do  i = 1, nsamp

          vl = (1.-devl) * velg (i)
          vh = (1.+devu) * velg (i)
          vello (i) = vl
          velhi (i) = vh

          jhor (i) = 0
          do  j = 1, ntrc

              vv = velsem (j)
              if (vv .ge. vl .AND. vv .le. vh) then
                 jhor (i) = jhor (i) + 1
              else
                 data (i,j) = 0.
              endif
          enddo
      enddo
c++++++
c     stack the muted semblance matrix
c++++++
      call vclr (semstk, 1, nsamp)
      call vclr (stack , 1, nsamp)

      do  i = 1, nsamp

          do  j = 1, ntrc
              semstk (i) = semstk (i) + data (i,j)
          enddo
          xn = jhor (i)
          if (xn .gt. 1.e-30) then
              semstk (i) = semstk (i) / xn
          endif
      enddo
      call vmov (semstk, 1, stack, 1, nsamp)
c++++++
c     find all peaks on stacked sembl
c++++++
      call pkval (semstk, nsamp, 0, vp, ip, np)
      nh = np

      if (nh .eq. 0) then
         write(LERR,*)'No horizons found for rec= ',jrec
         return
      endif

      nord2 = 2*nord

      LH = 0
      DO  J = 1, nh

          itj    = ip (j) 

c-------------------------------------------------------------------------
c     write(0,*)'j= ',j,itj

          itj1  = itj - igate
          if (itj1 .lt.     1) itj1 = 1
          itj2  = itj + igate
          if (itj2 .gt. nsamp) itj2 = nsamp

          vl    = vello(itj)
          vh    = velhi(itj)
          ic    = 0
          pass  = 0

          do  k = 1, ntrc

              vv = velsem(k)
              if (vv .ge. vl .AND. vv .le. vh) then
                 ic = ic + 1
                 semstk (k) = 0.
                 do  ii = itj1, itj2
                     semstk (k) = semstk (k) + data(ii,k)
                 enddo
              else
                 semstk (k) = 0.0
              endif
              if (ic .eq. 0) ivs = k

              kn = (J-1)*ntrc + k
              vtr (kn) = 0.
              do  ii = itj1, itj2
                  vtr (kn) = vtr (kn) + data(ii,k)
              enddo
          enddo

          vtr ( (J-1)*ntrc+1)    = -1
          vtr ( (J-1)*ntrc+ntrc) = -1


          nc  = ic
          ivs = ivs + 1
          ive = ivs + nc - 1
          if (nc .gt. nord) then
             live = 0
             do  i = ivs, ive
                 if (semstk(i) .gt. thr) live = live + 1
             enddo
             if (live .gt. 3*nord) then
                 call nave (nc, nord, semstk(ivs))
             endif
          endif

          IF (.not. linear) THEN
             call lfit (velsem(ivs),semstk(ivs),nc,sig,0,
     1                  b1,a1,sa,sb,chi,q)
             do  i = ivs, ive
                 semstk (i) = semstk (i) - (b1 + velsem(i)*a1)
             enddo
             do  i = 1, ivs-1
                 semstk (i) = 0.0
             enddo
             do  i = ive+1, ntrc
                 semstk (i) = 0.0
             enddo
          ENDIF


          call pkval   (semstk, ntrc, 0, vp, ipp, npp)

          if (np .eq. 0) then
              write(LERR,*)'WARNING: semblances were all zero for'
              write(LERR,*)'stack rec ',jrec,' semb rec ',jrec
              write(LERR,*)'horizon ',J,'  Horizon skipped.'
              go to 200
          endif

100       continue

          call maxmgv (vp, 1, vmax, lc, npp)
          locv = ipp (lc)
          velcur = velsem(locv)

c***********
          if (locv .le. ivs .OR. locv .ge. ive) then

             write(LERR,*)'WARNING: picker hit edge of fairway at'
             write(LERR,*)'rec= ',jrec,' horz= ',J,' lo vel= ',vl,
     1                    ' vel= ',velcur,' hi vel= ',vh
             if (verbos) then
                write(LERR,*)(vp (ii),ii=1,npp)
                write(LERR,*)(ipp(ii),ii=1,npp)
             endif

             if (next .gt. 1) then
                 pass = pass + 1
                 if (pass .gt. next .or. pass+1 .gt. npp) then
                    write(LERR,*)'Could not find alternate peak: horizon
     1 skipped'
                    go to 200
                 endif
                 write(LERR,*)'...trying alternate peak ',pass+1
                 vp (lc) = 0.
                 go to 100
              endif

          endif
c***********

            LH = LH + 1
            jhor(LH) = J
            velf(LH) = velcur
            tf  (LH) = itj * si

200       continue

c-------------------------------------------------------------------------

      ENDDO

      if (lupik .gt. 0) then
         call pikgen (nreci,nsampi,ntrci,nh,lupik,jrec,
     1                tf,velf,unit1,unit2,unit3,off1,off2,
     2                off3,nsamp,JJ,LH,xsd,flat)
      endif

c     write(0,*)'time'
c     write(0,*)(tf(i),i=1,lh)
c     write(0,*)'vel'
c     write(0,*)(velf(i),i=1,lh)

        call vel (tf, velf, nsamp, si, LH, vout)

c     write(0,*)'vel',nsamp
c     write(0,*)(vout(i),i=1,nsamp)


      return
      end
