C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
c performs some arcane geophysical process
c writes the results to an output file
 
c It is assumed that the development location has afp - Amoco Fortran
c Preprocessor
c
c
c**********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters
c    these includes are picked up and expanded into the code by afp
c    and are found in ~usp/include/f77
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
c-----
 
c-----
c    SZLNHD is a value obtained from lhdrsz.h
c    The 3 vectors below are equivalenced and are
c    to access the trace header entries (whatever
c    they may be)
c-----
      integer     lhed ( SZLNHD )
      integer * 2 itr  ( SZLNHD )
      real        head ( SZLNHD )

      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     luqc, lupikin, lupikout
 
c------
c  static memory allocation
c     real        bigar1(SZSPRD*SZSMPM)
c     real        bigar2(SZSPRD*SZSMPM)
c------
c  dynamic memory allocation for big arrays, eg whole records
      integer     itrhdr
      pointer     (wkhdr , itrhdr (1))
      real        semb, vels, times
      pointer     (wkrec , vels  (1))
      pointer     (wktim , times (1))
      pointer     (wksem , semb  (1))
c------
 
c------
c    this is necessary for buliding printout files
#include <f77/pid.h>
c------
      integer     reccur, reclst, trcnum, recnxt
      integer     dstsgn, stacor, lstrec, fstrec, pass
c-----
c    SZSMPM is a value obtained from lhdrsz.h
c-----
      integer     mseg (SZLNHD), nrecs (SZLNHD)
      real        tri (SZLNHD), velnxt (SZLNHD)
      real        velsem (SZLNHD), semstk (SZLNHD)
      real        vello (SZLNHD), velhi (SZLNHD), velf (SZLNHD)
      real        vellst (SZLNHD), vlst (SZLNHD)
      real        velguide (SZLNHD), vout (SZLNHD)
      character   ntap * 100, otap * 100, name*6
      character   gtap * 100, ptap * 100, qtap * 100
      logical     verbos, query, heap, linear, first, interp
      logical     flat, xsd
      integer     argis
 
c-----
c    we access the header values which can be shot or long integers
c    or real values.  The actual trace values start at position
c    ITRWRD1  (position 65 in the old SIS format).  This value is
c    set in lhdrsz.h but eventually could come in thru the line header
c    making the trace header format variable
c-----
      equivalence ( itr( 1), lhed (1), head(1) )

      data lbytes / 0 /, nbytes / 0 /, name/'SEMPIK'/
      data first /.true./
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 .or. argis ( '-h' ) .gt. 0)
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,gtap,ptap,lupikin,lupikout,igate,
     1             pass,linear,nord,vmin,vmax,verbos,interp,
     2             devu,devl,flat,xsd,qtap,thr)
 
c-----
c     get logical unit numbers for input and output of seismic data
 
c     input values are strings ntap & otap (i.e. names of files), and the
c     read 'r' or write 'w' designations of these files, and the default
c     logical unit numbers if ntap & otap are blank strings, i.e. ntap = " "
c     in which case:
c     0 = default stdin
c     1 = default stdout
c     Note: default values other that 0 & 1 may be used
 
c     output values are the logical unit numbers accessing these disk files. if
c     these values are less than 0 it means there was a fatal error in trying to
c     open these files
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
      if (qtap(1:1) .ne. ' ')
     1   call getln(luqc , qtap,'w',-1)
 
c-----
c     read line header of inputa DSN (rtape reads data into vector "itr"
c     lbytes is the number of bytes actually read
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'SEMPIK: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
 
c------
c     save certain pace header rameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that 
c     refers to the trace header (LINEHEADER = 0; TRACEHEADER = 1)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c-----------
c format values are:

c     integer    = 1
c     float      = 2
c     character  = 3
c     2-byte int = 4

c the mnemonic definitions are found in the man pages for program scan
c-----------

c------
c  here we mark out slots to be used for 4-byte floating point
c  storeage in the trace header.  we choose to use the time-velocity
c  area of the trace header but starting from the tail-end to minimize
c  clobbering those folks who do use this area for its intended purpose.

c  devlopers are wise to allow some freedom of the user to stake out
c  these slots so he can avoid trashing something he needs. 
c  in the 2 cases below we grab the last 2 T-V pairs (for 2 reals)


      write(LERR,*)'MutVel,ifmt,l_MutVel,length= ',
     1             ifmt_MutVel,l_MutVel,ln_MutVel
      write(LERR,*)'WatVel,ifmt,l_WatVel,length= ',
     1             ifmt_WatVel,l_WatVel,ln_WatVel
      write(LERR,*)'TrcNum,ifmt,l_TrcNum,length= ',
     1             ifmt_TrcNum,l_TrcNum,ln_TrcNum
      write(LERR,*)'RecNum,ifmt,l_RecNum,length= ',
     1             ifmt_RecNum,l_RecNum,ln_RecNum
      write(LERR,*)'SrcLoc,ifmt,l_SrcLoc,length= ',
     1             ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc
      write(LERR,*)'RecInd,ifmt,l_RecInd,length= ',
     1             ifmt_RecInd,l_RecInd,ln_RecInd
      write(LERR,*)'DphInd,ifmt,l_DphInd,length= ',
     1             ifmt_DphInd,l_DphInd,ln_DphInd
      write(LERR,*)'DstSgn,ifmt,l_DstSgn,length= ',
     1             ifmt_DstSgn,l_DstSgn,ln_DstSgn
      write(LERR,*)'StaCor,ifmt,l_StaCor,length= ',
     1             ifmt_StaCor,l_StaCor,ln_StaCor
 
c     To get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c     LINHED is a value in the include file <f77/sisdef.h> that refers to the
c     lineheader
c
c     see saver/w manual pages
c     (LINHED = 0  - just like LINEHEADER)
c------
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
 
c------
c     hlhprt prints out the historical line header of length lbytes AND
 
c     hlhprt takes "name", in this case 4 characters long and stuffs this
c     into the modified historical line header and returns the NEW length
c     of the line header in lbytes
c------
      call hlhprt (itr, lbytes, name, 6, LERR)
 
c------
c     read pick file header & extract # segs & max # picks/seg
c------
      itemp = SZSMPD
      call galloc (wkrec , itemp, errcd1, abort1)
      call galloc (wktim , itemp, errcd2, abort2)

c     write(0,*)'nsamp,nsi,ntrc,nrec= ',nsamp,nsi,ntrc,nrec
c     write(0,*)'lupikin= ',lupikin

      call getpik (lupikin, Nseg, maxpik, first,
     1             mseg, nrecs, vels, times,
     2             u1,u2,u3,nreci,ntrci,nsampi,
     3             off1,off2,off3)

      call gfree (wkrec)
      call gfree (wktrc)
c---------------------------------------------------
c  malloc only space we're going to use
      heap  = .true.
 
c--------------------------
c  note: these don't
c  have to be the same size
 
      itemi = ntrc * ITRWRD * SZSMPD
      items = ntrc * nsamp  * SZSMPD
      itemp = Nseg * maxpik * SZSMPD
 
c  note also SZSMPD is the native
c  size of a float or int in bytes
c--------------------------
 
c--------
c  galloc - general allocation (machine independent since it uses C
c  malloc internally
c  inputs to galloc are pointer, number of bytes to allocate
c  outputs are error codes:
c     errcod = 0  (allocation succeeded)
c     errcod = 1  (allocation failed)
c--------
 
      call galloc (wkhdr , itemi, errcdi, aborti)
      call galloc (wkrec , itemp, errcd1, abort1)
      call galloc (wktim , itemp, errcd2, abort2)
      call galloc (wksem , items, errcd3, abort3)
 
      if (errcdi .ne. 0.) heap = .false.
      if (errcd1 .ne. 0.) heap = .false.
      if (errcd2 .ne. 0.) heap = .false.
      if (errcd3 .ne. 0.) heap = .false.
 
      if (.not. heap) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*) itemp,'  bytes'
         write(LERR,*) itemp,'  bytes'
         write(LERR,*) items,'  bytes'
         write(LERR,*)' '
         write(LER ,*)' '
         write(LER ,*)'Unable to allocate workspace:'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*) itemp,'  bytes'
         write(LERR,*) itemp,'  bytes'
         write(LERR,*) items,'  bytes'
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*) itemp,'  bytes'
         write(LERR,*) itemp,'  bytes'
         write(LERR,*) items,'  bytes'
         write(LERR,*)' '
      endif
c---------------------------------------------------
      nval = Nseg * maxpik

c     write(0,*)'Nseg,maxpik,nval= ',Nseg,maxpik,nval

      call vclr (vels , 1, nval)
      call vclr (times, 1, nval)
 
c-----
c     read all pick segments & stuff velocities & times into
c     2 1D arrays: each segment will occupy maxpik elements
c     sequentially
c-----
      call getpik (lupikin, Nseg, maxpik, first,
     1             mseg, nrecs, vels, times,
     2             u1,u2,u3,nreci,ntrci,nsampi,
     3             off1,off2,off3)
 
c-----
c     modify line header to reflect actual number of traces output
c-----
      nrecc = nrec

      if (.not. interp) then
         call savew(itr, 'NumRec', nrecc, LINHED)
         call savew(itr, 'NumTrc',  1   , LINHED)
      else
         mrecs = max0 ( nrecs (Nseg) , nrecs (1) )
         call savew(itr, 'NumRec', mrecs, LINHED)
         call savew(itr, 'NumTrc',  1   , LINHED)
      endif
 
c----------------------
c  number output bytes
      obytes = SZTRHD + nsamp * SZSMPD
 
c----------------------
c  inject command line into
c  historical LH:
c  inputs are current line header in vector "itr" and length lbytes (bytes)
c  outputs are line header modified by insertion of the command line into
c  the historical LH and the modified length of the new LH (lbyout)
 
      call savhlh(itr,lbytes,lbyout)
c----------------------
 
c------
c     write to unit number luout lbyout bytes contained in vector itr
c------
      call wrtape ( luout, itr, lbyout  )

      if (qtap(1:1) .ne. ' ') then
         call savew(itr, 'NumRec', nrecc, LINHED)
         call savew(itr, 'NumTrc',  1   , LINHED)
         call wrtape ( luqc , itr, lbyout  )
      endif        

c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
c     if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  qtap,gtap,ptap,ntap,otap,interp,
     2                  igate,devu,devl,pass,xsd,flat)
c     end if
 
      devu = devu / 100.
      devl = devl / 100.
      if (thr .eq. 0.0) thr = .000001
c--------------------------------------------------
c  compute sample interval in secs
c  take care of micro secs if necessary
 
      si = nsi
      if (nsi .le. 32) then
         dt = real (nsi) /1000.
      else
         dt = real (nsi) /1000000.
      endif
 
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read trace, do terrible things to data, write to output file
c-----
 
c-----
c     get first guide function
c-----
      call getvel (1, nval, Nseg, maxpik, nsamp, si,
     1             mseg, nrecs, vels, times, vellst)
      reclst = nrecs (1)
      jseg = 1
      if ( jseg .lt. Nseg) then
           recnxt = nrecs (jseg+1)
           call getvel (2, nval, Nseg, maxpik, nsamp, si,
     1                  mseg, nrecs, vels, times, velnxt)
      else
           recnxt = 0
      endif
      fstrec = nrecs (1)
      lstrec = nrecs (Nseg)

c     write(0,*)'jseg,recnxt,fstrec,lstrec= ',
c    1 jseg,recnxt,fstrec,lstrec

c     write(0,*)'mseg'
c     write(0,*)(mseg(i),i=1,nseg)
c     write(0,*)'nrecs'
c     write(0,*)(nrecs(i),i=1,nseg)
c     write(0,*)'vels'
c     write(0,*)(vels((i-1)*maxpik+1),i=1,Nseg)
c     write(0,*)'times'
c     write(0,*)(times((i-1)*maxpik+1),i=1,Nseg)

      first = .true.
      
      DO  JJ = 1, nrec
 
            ic = 0
            do  kk = 1, ntrc
 
                  nbytes = 0
                  call rtape( luin, itr, nbytes)
c------
c     if end of data encountered (nbytes=0) then bail out
c     Note:  if you're processing records you might really want
c     to branch to the processing part rather than bailing out
c------
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                  call vmov (lhed(ITHWP1), 1, tri, 1, nsamp)

 
c------
c     use previously derived pointers to trace header values

                  call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        stacor , TRACEHEADER)

                  if (stacor .eq. 30000) then
                     call vclr (tri,1,nsamp)
                  else
                     call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                           reccur , TRACEHEADER)
                     call saver2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                           trcnum , TRACEHEADER)
                     call saver2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                           dstsgn , TRACEHEADER)
                     velsem (kk) = dstsgn
                  endif
 
c----------------------
c  pack data into array
                  ic = ic + 1
                  istrc = (ic-1) * nsamp
                  ishdr = (ic-1) * ITRWRD
                  call vmov (tri,1, semb(istrc+1),1, nsamp)
                  call vmov (lhed,1, itrhdr(ishdr+1),1,ITRWRD)
 
            enddo

c     write(0,*)'reclst,reccur,recnxt= ',reclst,reccur,recnxt
 
            IF ( reccur .le. fstrec) THEN

               call vmov (vellst, 1, velguide, 1, nsamp)

            ELSEIF ( reccur .gt. fstrec .AND.
     1               reccur .le. lstrec       ) THEN

                 if (reccur.gt.reclst .AND. reccur.lt.recnxt) then

                     call veltrp (reclst,reccur,recnxt,nsamp,
     1                            vellst,velguide,velnxt)

                 elseif (reccur .ge. recnxt) then

                     reclst = recnxt
                     jseg = jseg + 1
                     call vmov (velnxt, 1, vellst, 1, nsamp)
                     if (jseg .le. Nseg) then
                        call getvel (jseg,nval,Nseg,maxpik,nsamp,si,
     1                               mseg,nrecs,vels,times,velnxt)

c     write(0,*)'getting ',jseg,' seg',vellst(1),velnxt(1),recnxt,
c    1 reclst,nrecs(jseg)

                        recnxt = nrecs (jseg)
                     else
                        recnxt = reclst
                     endif
                     call veltrp (reclst,reccur,recnxt,nsamp,
     1                            vellst,velguide,velnxt)

                 endif

            ELSEIF ( reccur .gt. lstrec ) THEN

               if (jseg .lt. Nseg) then
                   jseg = jseg + 1
                   reclst = recnxt
                   call vmov (velnxt, 1, vellst, 1, nsamp)
                   call getvel (jseg,nval,Nseg,maxpik,nsamp,si,
     1                          mseg,nrecs,vels,times,velnxt)

c     write(0,*)'getting2 ',jseg,' seg',vellst(1),velnxt(1),recnxt,
c    1 reclst,nrecs(jseg)

                   recnxt = nrecs (jseg)
                   call veltrp (reclst,reccur,recnxt,nsamp,
     1                          vellst,velguide,velnxt)
               else
                   call vmov (vellst, 1, velguide, 1, nsamp)
               endif

            ENDIF

c     write(0,*)'velg= ',velguide(1)
 
c-----------------------
c  here's the meat...
c  pick the semblances
 
            call picker (ntrc,nsamp,nhor,nvel,reccur,si,velsem,JJ,
     1                   vello,velhi,semb,velguide,nord,devu,igate,
     2                   pass,linear,verbos,vmin,vmax,velf,lupikout,
     3                   u1,u2,u3,nreci,ntrci,nsampi,off1,off2,off3,
     4                   devl,xsd,flat,semstk,thr)
            if (nhor .eq. 0) go to 100
c-----------------------
 
c-----------
c  output velocities
c  without interpolation
c-----------

            IF (.not. interp) THEN
 
               call vmov (velf, 1, lhed(ITHWP1), 1, nsamp)
               call wrtape (luout, itr, obytes)

c-----------
c  output velocities
c  with interpolation
c-----------
            ELSE

            if (first) then
 
               call vmov (velf, 1, lhed(ITHWP1), 1, nsamp)
               do  jv = 1, reccur
 
                   ir = ir + 1
                   call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                         ir     , TRACEHEADER)
                   call wrtape (luout, itr, obytes)
 
               enddo
               call vmov (velf, 1, vlst, 1, nsamp)
               first = .false.
               ireclst = reccur
 
            else

               ireccur = reccur
               nrr = ireccur - ireclst + 1
               drr = nrr
               do  j = 2, nrr
                   scl = float(j) / drr
                   do  ii = 1, nsamp
                       vout (ii) = vlst(ii) + (velf(ii) - vlst(ii))*scl
                   enddo
                   ir = ir + 1
                   call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                         ir     , TRACEHEADER)
                   call vmov (vout, 1, lhed(ITHWP1), 1, nsamp)
                   call wrtape (luout, itr, obytes)
 
               enddo
               call vmov (velf, 1, vlst, 1, nsamp)
               ireclst = ireccur
 
            endif

            ENDIF

100         continue

            if (qtap(1:1) .ne. ' ') then
                call vmov (semstk, 1, lhed(ITHWP1), 1, nsamp)
                call wrtape (luqc , itr, obytes)
            endif

 
      ENDDO

      if (ir .lt. nrecc) then
         do  j = ir+1, ntrstk
             call savew2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                   j      , TRACEHEADER)
             call vmov (vlst, 1, lhed(ITHWP1), 1, nsamp)
             call wrtape (luout, itr, obytes)
         enddo
      endif

 
  999 continue
 
c-----
c     close data files
c     flush data left
c     in output buffer
c     NOTE: if the output buffer is not closed you can sometimes end up
c     with missing data
c-----
      call lbclos ( luin )
      call lbclos ( luout )
      if (qtap(1:1) .ne. ' ')
     1   call lbclos ( luqc )
      close (lupikin )
      if (lupikout .gt. 0)
     1    close (lupikout)
 
      write(LERR,*)'end of sempik, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      write(LER,*)'end of sempik, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      stop      
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'sempik automatically picks semblance records sensing all peaks'
        write(LER,*)
     :'       in time (dense horizon based picking)'
        write(LER,*)
     :'see manual pages for details ( online by typing uman prg )'
        write(LER,*)' '
        write(LER,*)
     :'execute sempik by typing sempik and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)   : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)   : output velocity tape file name'
        write(LER,*)
     :' -G [gtap]    (no default)   : input velocity guide pik file'
        write(LER,*)
     :' -P [ptap]    (no pik file)  : output velocity pik file'
        write(LER,*)
     :' -Q [qtap]    (no output)    : QC semblance stack output'
        write(LER,*) ' '
        write(LER,*)
     :' -g[igate]       (8)         :  # points in semblance gate'
        write(LER,*)
     :' -du[devu]       (10)        :  upper fairway bndary % deviation'
        write(LER,*)
     :'                                above velocity guide function'
        write(LER,*)
     :' -dl[devu]       (10)        :  lower fairway bndary % deviation'
        write(LER,*)
     :'                                below velocity guide function'
        write(LER,*)
     :' -p [next]        (3)        : number of semblance peaks to test'
        write(LER,*)
     :' -s[nord]   (no smoothing )  :  smoothing order'
        write(LER,*)
     :' -vs [vmin]  (ignore)  : peg 0-time velocity'
        write(LER,*)
     :' -ve [vmax]  (ignore)  : peg trace end time velocity'
        write(LER,*) ' '
        write(LER,*)
     :' -X  include on command line if pick output file is xsd format,'
        write(LER,*)
     :'     else format is flat, i.e. time-velocity-rec'
        write(LER,*)
     :' -L  include on command line to remove linear semb trend'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*)
     :'usage:   sempik -N[] -O[] -Q[] -G[] -P[] [-L -X -V]'
        write(LER,*)
     :'                 -g[] -du[] -dl[] -p[] -s[] -vs[] -ve[]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,gtap,ptap,lupikin,lupikout,igate,
     1                  pass,linear,nord,vmin,vmax,verbos,interp,
     2                  devu,devl,flat,xsd,qtap,thr)
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     vel   - R*4      design velocity
c     ns    - I*4      starting trace index
c     ne    - I*4      ending trace index
c     irs   - I*4      starting record index
c     ire   - I*4      ending record index
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*), gtap*(*), ptap*(*), qtap*(*)
      integer     lupikin,lupikout,nord,igate,pass
      real        vmin, vmax, devu, devl
      logical     verbos, linear, interp, flat, xsd
      integer     argis
 
      lupikin  = 29
      lupikout = 31
      flat = .true.
      xsd  = .false.
c-------
c     import values from the command line using keys, e.g. -N
c     to which are immediately attached the users values.
 
c     For example program sempik might be invoked in the following way:
 
c     sempik  -Nxyz -Oabc
 
c     in which case xyz is a string (the name of the input data set)
c     which will be imported into sempik and associated with the variable
c     "ntap"
 
c     see manual pages on the argument handler routines
c     for the meanings of these functions.  Briefly though
c     we can import from the command line strings, integers, reals,
c     double precision reals, and check the existence of command line
c     keys.  The last 2 fields are the value to be assigned the variable
c     (1) if ONLY the key is present (no value attached to it), or
c     (2) if NO key & no value are present
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argstr( '-G', gtap, ' ', ' ' )
            call argstr( '-P', ptap, ' ', ' ' )
            call argstr( '-Q', qtap, ' ', ' ' )
            call argi4 ( '-s', nord, 0, 0)
            call argi4 ( '-g', igate, 8, 8)
            call argr4 ( '-du', devu, 10., 10.)
            call argr4 ( '-dl', devl, 10., 10.)
            call argr4 ( '-t', thr, 0., 0.)
            call argi4 ( '-p', pass, 3, 3)
            call argr4 ( '-vs', vmin, 0.0, 0.0)
            call argr4 ( '-ve', vmax, 0.0, 0.0)

            xsd    =   (argis('-X') .gt. 0)
            interp =   (argis('-I') .gt. 0)
            linear =   (argis('-L') .gt. 0)
            verbos =   (argis('-V') .gt. 0)
 
            if (xsd) flat = .false.
c-------
c     Note:  argis() = 1 if the key is present
c            argis() = 0 if it isn't

            if (gtap(1:1) .eq. ' ') then
               write(LERR,*)'velpik error:'
               write(LERR,*)'Must input guide function pick file'
               write(LERR,*)'using -G[]'
               write(LER ,*)'velpik error:'
               write(LER ,*)'Must input guide function pick file'
               write(LER ,*)'using -G[]'
               stop
            endif

            open (unit=lupikin,file=gtap,status='old',iostat=ierr)
 
            if (ierr .ne. 0) then
               write(LERR,*)'velpik error:'
               write(LERR,*)'Could not open guide function file ',gtap
               write(LERR,*)'Check existence'
               write(LER ,*)'velpik error:'
               write(LER ,*)'Could not open guide function file ',gtap
               write(LER ,*)'Check existence'
               stop
            endif

            if (ptap(1:1) .ne. ' ') then
               open (unit=lupikout,file=ptap,status='unknown',
     1               iostat=ierr)
               if (ierr .ne. 0) then
                  write(LERR,*)'velpik error:'
                  write(LERR,*)'Problems opening pick file= ',ptap
                  write(LERR,*)'Check permissions...'
                  write(LER ,*)'velpik error:'
                  write(LER ,*)'Problems opening pick file= ',ptap
                  write(LER ,*)'Check permissions...'
                  stop
               endif
            else
               write(LERR,*)'velpik error:'
               write(LERR,*)'Must supply output pick file name'
               write(LERR,*)'using -P[]'
               write(LER ,*)'velpik error:'
               write(LER ,*)'Must supply output pick file name'
               write(LER ,*)'using -P[]'
               stop
            endif
 

 
      return
      end
 
C***********************************************************************
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  qtap,gtap,ptap,ntap,otap,interp,
     2                  igate,devu,devl,pass,xsd,flat)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     vel   - R*4     design velocity
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>
 
      integer     nsamp, nsi, ntrc, nrec
      character   ntap*(*), otap*(*), gtap*(*), ptap*(*), qtap*(*)
      logical     interp, xsd, flat
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' input data set name       =  ', ntap
            write(LERR,*) ' output data set name      =  ', otap
            write(LERR,*) ' input guide fctn file     =  ', gtap
            write(LERR,*) ' output velocity pick file =  ', ptap
            if (qtap(1:1) .ne. ' ')
     1      write(LERR,*) ' output semb stack file    =  ', qtap
            write(LERR,*) ' pick file output is xsd format?  ', xsd
            write(LERR,*) ' pick file output is flat format? ', flat
            write(LERR,*) ' interpolate dense velocity tape? ', interp
            write(LERR,*) ' semblance pick time gate   = ', igate
            write(LERR,*) ' upper fairway deviation (%)= ', devu
            write(LERR,*) ' lower fairway deviation (%)= ', devl
            write(LERR,*)' '
            write(LERR,*)' '

      return
      end
 
