C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine model (recarr, trid, ithdr, nsamp, ntrc,
     1                  mrec, mtrc, msamp, mst,mend,mwin,
     2                  job, stk, ktrc, jj, dbg, first,pipei,
     3                  lumod, mhed, mtr, nrecrd,
     4                  l_StaCor, l_RecNum, l_TrcNum, who_cares)

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c  build model trace to shaping filter

c    modes:

c         job - one model trace selected from a record of input data
c               else model trace selected from each record

c         stk - select a trace from current gather as model trace of input data
c               else the gather is stacked to build a model

      real        recarr(nsamp,ntrc), trid(SZLNHD)
      integer*2   mtr(2*SZLNHD)
      integer     ithdr(*), mhed(*)
      integer     nsamp, ntrc, ktrc, jj
      logical     job, stk, dbg, first, pipei, who_cares

      ic = 0
      ishdr = (ktrc-1) * (ITHWP1-1)

c********************
c  for "job" get a model
c  trace one time only

c  else

c  for "trc" get a specific
c  trc from the current model
c  rec
c  or
c  use a stack of the gather
c  as the model trc
c********************

      IF (first) THEN

         if (.not. stk) then

c----------------------
c  skip to model trace
c----------------------
            call unitts(nrecrd,1,ktrc-1,lumod,mtrc,mtr,pipei)
            call rtape (lumod, mtr, mbytes)

                  if(mbytes .eq. 0) then
                    write(LERR,*)'End of file on model data set:'
                    write(LERR,*)'  trc: rec= ',nrecrd,'  trace= ',ktrc
                    call ccexit(666)
                  endif
                  if (mtr(l_StaCor) .eq. 30000 .and. .not. who_cares ) 
     :                 then
                    write(LERR,*)'BAD LUCK: you chose a dead model trc:'
                    write(LERR,*)'  rec= ',nrecrd,'  trace= ',ktrc
                    write(LERR,*)'Choose Another one & try again'
                    call ccexit(111)
                  endif

            call vmov  (mhed(ITRWRD+mst), 1, trid, 1, mwin)
            if (dbg) then
               write(LERR,*)'trc: model trace= ',mtr(l_TrcNum)
               write(LERR,*)'trc:       rec  = ',mtr(l_RecNum)
            endif
            call unitts(nrecrd,ktrc+1,mtrc,lumod,mtrc,mtr,pipei)

         else

            live = 0
            do  L = 1, mtrc

                call rtape (lumod, mtr, mbytes)
                  if(mbytes .eq. 0) then
                     write(LERR,*)'End of file on model data set:'
                     write(LERR,*)'  stk: rec= ',nrecrd,'  trace= ',L
                     call ccexit(911)
                  endif
                  if (mtr(l_StaCor) .ne. 30000) then
                     live = live + 1
                     call vadd (mhed(ITRWRD+mst),1,trid,1,trid,1,mwin)
                  endif
                  if (dbg) then
                     write(LERR,*)'stk: model trace= ',mtr(l_TrcNum)
                     write(LERR,*)'stk:       rec  = ',mtr(l_RecNum)
                  endif

            enddo

            if (live .eq. 0) then
               write(LERR,*)'BAD LUCK: you chose a dead model gather:'
               write(LERR,*)'  rec= ',nrecrd
               write(LERR,*)'Choose Another one & try again'
               call ccexit(777)
            endif
            xlive = float(live)
            call vsdiv (trid, 1, xlive, trid, 1, mwin)

         endif

                  

      ENDIF

      first = .false.

      return
      end
