C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine shaper (ntrc, nsamp, itimes, iwin, prew,mwin, 
     1                   LA, taper,D, rec, filt, verbos, JJ)

#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      real     a(SZLNHD), b(SZLNHD), c(2*SZLNHD), space(3*SZLNHD)
      real     taper(*), D(*), rec(nsamp,ntrc)
      real     prew
      integer  iwin,nsamp,ntrc,la,lb,ld, itimes(*)
      logical  filt, verbos

      LB = iwin
      LD = mwin

      if (verbos) then
         write(LERR,*)'Record= ',JJ
      endif
      do  100  j = 1, ntrc

          ist = itimes(j)

          call vmov (rec(ist,j), 1, b, 1, LB)
          call vmul (taper, 1, b, 1, b, 1, LB)
          call dotpr (b, 1, b, 1, bdot, LB)

          IF (bdot .gt. 1.e-30) then
              call cross (LD,D,LB,B,-LA/2,c)
              call maxv (c, 1, cmax, indx, LA)
              call shapes(LB,B,LD,D,LA,A,ASE,PREW,space,ierr)
              if (ierr .ne. 0) then
                 write(LERR,*)'Shaping filter error at trace ',j
              endif
              call maxmgv (a, 1, amax, indxa, LA)
              if (verbos) then
                 write(LERR,*)'Trc= ',j,' filter max at index= ',indxa
              endif
              if (filt) then
                  call vclr (rec(1,j), 1, nsamp)
                  call vmov (a, 1, rec(1,j), 1, LA)
              else
                  call fold (LA, a, nsamp, rec(1,j), nfld, c)
                  call vmov (c(indxa), 1, rec(1,j), 1, nsamp)
              endif
          ENDIF

100   continue
      
      return
      end
