C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine AutoDetect ( Record_WorkSpace, ntrc, nsamp, ist, iend,
     :     ShtWrd, threshold, present, lags, nkicks, min_threshold, 
     :     max_threshold, nrec, thresholds, detected, nopower )

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c declare variables passed from the calling routine

      integer ntrc, nsamp, nrec, ist, iend, ShtWrd, nkicks
      integer detected(nrec)

      real threshold, Record_WorkSpace(nsamp,3*ntrc)
      real min_threshold, max_threshold, thresholds(nrec)

      logical present, nopower

c declare local variables

      integer asamp, lags

      real auto_buffer(SZLNHD)
      real auto1(SZLNHD), auto2(SZLNHD), auto3(SZLNHD)
      real cross12(SZLNHD), cross13(SZLNHD), cross23(SZLNHD)
      real count1, count2, count3, dot, test

c initialize variables

      call vclr ( auto_buffer, 1, SZLNHD)
      call vclr ( auto1, 1, SZLNHD)
      call vclr ( auto2, 1, SZLNHD )
      call vclr ( auto3, 1, SZLNHD )
      call vclr ( cross12, 1, SZLNHD )
      call vclr ( cross13, 1, SZLNHD )
      call vclr ( cross23, 1, SZLNHD )
      present = .false.
      asamp = iend - ist + 1
      count1 = 0.
      count2 = 0.
      count3 = 0.

c build auto correlations for selected traces and normalize
c by number of live traces used

      do i = 1, ntrc, 10

         call conv ( Record_WorkSpace(ist,i), 1, 
     :        Record_WorkSpace(ist,i), 1, auto_buffer, 1, lags, asamp,
     :        1 ) 
         call dotpr(auto_buffer, 1, auto_buffer, 1, dot, lags)
         if ( dot .gt. 1.e-32 ) then
            do j = 1, lags
               auto1(j) = auto1(j) + auto_buffer(j)
            enddo
            count1 = count1 + 1
         endif

         call conv ( Record_WorkSpace(ist,ntrc+i), 1, 
     :        Record_WorkSpace(ist,ntrc+i), 1, auto_buffer, 1, lags, 
     :        asamp, 1 ) 
         call dotpr(auto_buffer, 1, auto_buffer, 1, dot, lags)
         if ( dot .gt. 1.e-32 ) then
            do j = 1, lags
               auto2(j) = auto2(j) + auto_buffer(j)
            enddo
            count2 = count2 + 1
         endif

         call conv ( Record_WorkSpace(ist,2*ntrc+i), 1, 
     :        Record_WorkSpace(ist,2*ntrc+i), 1, auto_buffer, 1, lags, 
     :        asamp, 1 ) 
         call dotpr(auto_buffer, 1, auto_buffer, 1, dot, lags)
         if ( dot .gt. 1.e-32 ) then
            do j = 1, lags
               auto3(j) = auto3(j) + auto_buffer(j)
            enddo
            count3 = count3 + 1
         endif
      enddo 

c normalize by number of traces used

      if ( count1 .gt. 1.e-32 .and. 
     :     count2 .gt. 1.e-32 .and. 
     :     count3 .gt. 1.e-32 ) then

         do i = 1, lags
            auto1(i) = auto1(i) / count1
            auto2(i) = auto2(i) / count2
            auto3(i) = auto3(i) / count3
         enddo

c normalize autocorrelation

         do i = 2, lags
            auto1(i) = auto1(i) / auto1(1)
            auto2(i) = auto2(i) / auto2(1)
            auto3(i) = auto3(i) / auto3(1)
         enddo
         auto1(1) = 1.0
         auto2(1) = 1.0
         auto3(1) = 1.0

         if ( .not. nopower ) then

c square autocorrelation only if user wants to use power

            do i = 1, lags
               auto1(i) = auto1(i)**2
               auto2(i) = auto2(i)**2
               auto3(i) = auto3(i)**2
            enddo
         endif

c calculate upper off-diagonal of covariance matrix

         call conv ( auto1, 1, auto2, 1, cross12, 1, 1, lags, 1 )
         call conv ( auto1, 1, auto3, 1, cross13, 1, 1, lags, 1 )
         call conv ( auto2, 1, auto3, 1, cross23, 1, 1, lags, 1 )

c determine if another source is present by checking magnitude of
c covariance elements.  If 
c
c  small large   for the array elements    12 13
c        small                                23

c then the central record in the zone of interest looks significantly
c different over the Fresnel zone of the central record that the
c surrounding records.  This has proven to autodetect at least another
c source [another boat shooting in the case of Trinidad - tringas survey].

         write(lerr,*) ' '
         write(lerr,*) ' RecNum = ',ShtWrd
         write (lerr,*) ' cross12 = ',cross12(1)
         write (lerr,*) ' cross13 = ',cross13(1)
         write (lerr,*) ' cross23 = ',cross23(1)

         if ( cross13(1) .gt. cross12(1) .and. 
     :        cross13(1) .gt. cross23(1) ) then
            test = (cross13(1) - cross12(1) + cross13(1) - cross23(1)) / 
     :           2.0
            write(LERR,*) ' ' 
            write(LERR,*) ' (13 - 12 + 13 - 23) / 2 = ',test

            nkicks = nkicks + 1
            if ( test .lt. min_threshold ) min_threshold = test
            if ( test .gt. max_threshold ) max_threshold = test
            thresholds(nkicks) = test
            detected(nkicks) = ShtWrd
            
            if (test .gt. threshold ) then
               write(lerr,*)' '
               write(lerr,*)' Anomalous Energy Detected on RecNum ', 
     :              ShtWrd
               present = .true.
            endif
         endif
      else
         write(LERR,*)' '
         write(LERR,*)'No Shave possible for shot ',ShtWrd
         write(LERR,*)' '
         write(LERR,*)'No live traces in autocorrelation summation '
         write(LERR,*)' count1 = ', count1
         write(LERR,*)' count2 = ', count2
         write(LERR,*)' count3 = ', count3
         write(LERR,*)' '
      endif

      return
      end
