C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine DoSurgMute ( array, N, nsi, VPick1, VPick2 )

c declare variables passed from calling routine

      integer N, nsi, VPick1, VPick2

      real array(N)

c declare local variables

      integer i

      logical found

c initialize variables

      found = .false.

c find the first zero on the trace below the current onset 
c mute and mute the trace from there to the end.  Return
c the muted trace and the VPick2 value in milliseconds
      
      i = VPick1 / nsi + 1

      do while ( i .lt. N .and. .not. found )
         if ( abs(array(i)) .lt. 1.e-32 ) then
            VPick2 = i 
            found = .true.
         endif
         i = i + 1
      enddo

      if ( .not. found ) then
         VPick2 = ( N + 1 ) * nsi
      else

         do i = VPick2, N
            array(i) = 0.0
         enddo
         
         VPick2 = ( VPick2 + 1 ) * nsi
      endif

      return
      end
