C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine roelof(uin,udenom,unum,
     1                  unumsum,udenomsum,
     1                  c,a2,rwork,cwork,nznew,lzsemb,nzsemb,
     2                  hbegin,nz,ntr,luin,luout,ialg)
c
      integer  hbegin
      real     uin(hbegin:nz,ntr)
      real     c(hbegin:nz)
      real     unum(nz),udenom(nz)
      real     unumsum(nz),udenomsum(nz)
      real     a2(nz)
      real     rwork(nznew)
c
      complex  cwork(nznew/2)

      parameter (eps2=1.e-20)
c__________________________________________________________________________
c     read in a seismic gather
c__________________________________________________________________________
      call rdsis(uin,nz,1,ntr,hbegin,luin,nbyptr)
c__________________________________________________________________________
c     initialize.               
c__________________________________________________________________________
      do 10000 iz=1,nz
       udenom(iz)=eps2
       unum(iz)=0.
10000 continue
c__________________________________________________________________________
c     accumulate.               
c     note that the numerator will be the conventional stack.
c__________________________________________________________________________
      do 30000 itr=1,ntr
       do 20000 iz=1,nz
        unum(iz)=unum(iz)+uin(iz,itr)
20000  continue
30000 continue
      if(ialg .le. 4) then                   
c__________________________________________________________________________
c        accumulate energy in udenominator.                
c__________________________________________________________________________
         do 30002 itr=1,ntr
          do 20002 iz=1,nz
           udenom(iz)=udenom(iz)+uin(iz,itr)**2
20002     continue
30002    continue
      else
c__________________________________________________________________________
c        accumulate envelope**2 in the udenominator        
c__________________________________________________________________________
         do 30004 itr=1,ntr
          call env2(uin(1,itr),a2,nz,nznew,cwork,rwork)
          do 20004 iz=1,nz
           udenom(iz)=udenom(iz)+a2(iz)           
20004     continue
30004    continue
         call env2(unum,a2,nz,nznew,cwork,rwork)
         call vmov(a2,1,unum,1,nz)
      endif
c__________________________________________________________________________
c     calculate the similarity index.  
c__________________________________________________________________________
      if(ialg .eq. 1) then
c__________________________________________________________________________
c        conventional semblance.
c        square the numerator.
c_______________________________________________________________________
         do 32000 iz=1,nz
          unum(iz)=unum(iz)**2
32000    continue
c_______________________________________________________________________
c        calculate running sum in depth.
c_______________________________________________________________________
         jz=lzsemb+1
         unumsum(jz)=0.
         udenomsum(jz)=0.
         do 34000 jzsemb=-lzsemb,+lzsemb
          unumsum(jz)=unumsum(jz)+unum(jz+jzsemb)
          udenomsum(jz)=udenomsum(jz)+udenom(jz+jzsemb)
34000    continue
         do 34100 iz=lzsemb+2,nz-lzsemb
          unumsum(iz)=unumsum(iz-1)+(unum(iz+lzsemb)-unum(iz-lzsemb-1))
          udenomsum(iz)=udenomsum(iz-1)
     1               +(udenom(iz+lzsemb)-udenom(iz-lzsemb-1))
          udenomsum(iz)=max(udenomsum(iz),eps2)
          unumsum(iz)=max(unumsum(iz),0.)
          c(iz)=unumsum(iz)/(nzsemb*udenomsum(iz))
34100    continue
         do 35000 iz=lzsemb+1,nz-lzsemb
          c(iz)=unumsum(iz)/(nzsemb*udenomsum(iz))
35000    continue
         do 35100 iz=1,lzsemb
          c(iz)=c(lzsemb+1)
35100    continue
         do 35200 iz=nz-lzsemb+1,nz
          c(iz)=c(nzsemb-lzsemb)
35200    continue
      elseif(ialg .eq. 2) then
c__________________________________________________________________________
c        unnormalized energy.    
c__________________________________________________________________________
         do 42000 iz=1,nz
          c(iz)=unum(iz)**2
42000    continue
      elseif(ialg .eq. 3) then
c__________________________________________________________________________
c        semblance times rms stack energy.
c__________________________________________________________________________
         do 43000 iz=1,nz
          c(iz)=unum(iz)**2/(ntr*sqrt(udenom(iz)))
43000    continue
      elseif(ialg .eq. 4) then
c__________________________________________________________________________
c        signed semblance time rms stack energy.
c__________________________________________________________________________
         do 44000 iz=1,nz
          c(iz)=sign(unum(iz)**2/(ntr*sqrt(udenom(iz))),unum(iz))
44000    continue
      elseif(ialg .eq. 5) then
c__________________________________________________________________________
c        envelop of sum squared over sum of envelopes squared.
c__________________________________________________________________________
         do 45000 iz=1,nz
          c(iz)=unum(iz)/(ntr*udenom(iz))
45000    continue
      elseif(ialg .eq. 6) then
c__________________________________________________________________________
c        envelop of sum squared over sqrt(sum of envelopes squared)       
c__________________________________________________________________________
         do 46000 iz=1,nz
          c(iz)=unum(iz)/sqrt(ntr*udenom(iz))
46000    continue
      endif
c__________________________________________________________________________
c     write out similarity index.  
c__________________________________________________________________________
      call wrtape(luout,c,nbyptr)
c
      return 
      end
