C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c Program Sinterp
c Amplitude Editting 
c
c**********************************************************************c
c
c     declare variables
c
#include     <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c declare standard USP variables
 
      integer     itr ( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs, ire, ns, ne
      integer     argis

      real        tri ( SZLNHD )

      character   ntap * 512, otap * 512, name*7

      logical     verbos
c declare program specific variables

      integer     Adjacent, Lastig, Lastih
      integer     recnum, trcnum

      logical     minSearch

c initialize variables
 
      data lbytes / 0 /
      data nbytes / 0 /
      data name/'SINTERP'/
      data minSearch/.false./
 
c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout files

#include <f77/open.h>

c parse  command line
 
      call gcmdln(ntap,otap,lus,ns,ne,irs,ire,
     1     amax,amin,minterp,verbos,
     2     tbegin, tend, dbegin, dend,
     3     vel	)

c get logical unit numbers for input and output

      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c read line header of input save certain parameters

      call rtape   ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'STORE: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      
      call hlhprt (itr, lbytes, name, 5, LERR)

c ensure that command line values are compatible with data set

      call cmdchk(ns,ne,irs,ire,ntrc,nrec)
c modify line header to reflect actual number of traces output

      nrecc=ire - irs+1
      call savew(itr, 'NumRec', nrecc, LINHED)
      jtr=ne-ns+1
      call savew(itr, 'NumTrc', jtr  , LINHED)
      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout )

c compute start and end samples for application

      if ( tend .eq. 0.) tend = float( (nsamp -1) * nsi )
      istart = 1 + int( 0.5 + (tbegin / float( nsi ) ) )
      iend =   1 + int( 0.5 + (tend / float( nsi ) ) )
      if ( istart .lt. 1) istart = 1
      if ( iend .gt. nsamp) iend = nsamp

	itime_begin = istart

      if ( istart .ge. iend ) then
         write(lerr,*) 'Fatal Error -- Abort'
         write(lerr,*) 'Start time must be greater than end time'
         stop
      endif

      if ( dbegin .ge. dend ) then
         write(lerr,*) 'Fatal Error -- Abort'
         write(lerr,*)
     1        'Start distance must be greater than end distance'
         stop
      endif
	

	
c output of all pertinent information before processing begins

      call verbal(nsamp, nsi, ntrc, nrec, iform,
     1     ntap,otap,amax,amin,minterp,
     2     tbegin, tend, dbegin, dend,
     3     vel)

c figure out design window times

      dt = float(nsi)/1000.

      if ( amin .ne. -1.e-30 ) minSearch = .true.

c process records

      do 1000 jj = 1, nrec

c process traces

         do 1001 kk = 1, ntrc

            nbytes = 0
            call rtape( luin, itr, nbytes)
            if(nbytes .eq. 0) then
               write(LERR,*)'End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               go to 999
            endif
            call vmov (itr(ITHWP1), 1, tri, 1, nsamp)

            call saver2(itr,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                  recnum , TRACEHEADER)
            call saver2(itr,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                  trcnum , TRACEHEADER)
            call saver2(itr,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                  idist  , TRACEHEADER)
            dist = idist
            call saver2(itr,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                  istatic, TRACEHEADER)

        
            IF ( istatic .ne. 30000 ) THEN

               IF ( (dist .gt. dbegin) .and. (dist .le. dend) ) THEN

                  if ( minSearch ) then
                     if ( abs ( tri(1) ) .le. abs(amin) ) tri(1) = 0.
                  else
                     if ( abs ( tri(1) ) .ge. abs(amax) ) tri(1) = 0.
                  endif

                  igsamp = istart
                  igflag = 1
                  Lastig = istart + 1
                  ncnt = 0   

                  ihsamp = istart
                  ihflag = 1

c loop over samples
c set the consecutive bad sample variables

c change the start time if vel not equal 999999

	if (vel .ne. 999999.) then
	istart = itime_begin + (((abs(dist)/int(vel))*1000)/nsi)
	endif
               
                  Adjacent = 0
                  Lastih = istart + 1

                  do 150 il = istart + 1, iend

                     if ( abs( tri(il) ) .ge. abs( amax ) ) then 
                        if ( ( il - Lastig ) .eq. 1 ) then 
                           ncnt = ncnt + 1
                        endif
                        Lastig = il
                        igflag = 0
                     else
                     if (igflag .eq. 0) then
                       if (ncnt .lt. minterp) then
                        sl=(tri(il)-tri(igsamp))/(float(il-igsamp))
                        do 250 jl = igsamp, il
                           tri(jl) = sl * (jl - igsamp) + tri(igsamp)
 250                    continue
                       endif
                       ncnt = 0
                       igsamp = il
                       igflag = 1
                     else
                        igsamp = il
                     endif

                     endif
                        

                     if ( minSearch ) then
                        if ( abs(tri(il) ) .le. abs(amin) ) then
                           if ( ( il - Lastih ) .eq. 1 ) then 
                              Adjacent = Adjacent + 1
                           endif
                           Lastih = il
                           ihflag = 0
                        else
                        if (ihflag .eq. 0) then
                          if (Adjacent .lt. minterp) then
                           sl=(tri(il)-tri(ihsamp))/(float(il-ihsamp))
                           do 300 jl = ihsamp, il
                              tri(jl) = sl * (jl - ihsamp) + tri(ihsamp)
 300                       continue
                          endif
                          Adjacent = 0
                          ihsamp = il
                          ihflag = 1
                        else
                           ihsamp = il
                        endif

                        endif
                        
                     endif

 150              continue

c interpolate last sample if necessary

                  if ( igflag .eq. 0) then
                    if (ncnt .lt. minterp) then
                     sl = ( 0. - tri(igsamp) )/(float(iend-igsamp))
                     do 350 jl = igsamp, iend
                        tri(jl) = sl * (jl - igsamp) + tri(igsamp)
 350                 continue
                    endif
                  endif

                  if ( ihflag .eq. 0) then
                    if (Adjacent .lt. minterp) then
                     sl = ( 0. - tri(ihsamp) )/(float(iend-ihsamp))
                     do 425 jl = ihsamp, iend
                        tri(jl) = sl * (jl - ihsamp) + tri(ihsamp)
 425                 continue
                    endif
                  endif

 400              if( (verbos) .and. (ncnt .ne. 0 .or. 
     :                 Adjacent .ne. 0 ) ) then
                     write(LERR,*)'ri ',recnum,' trace ',trcnum,
     :                    ' # Bad -amp samples ',ncnt,
     :                    ' # Bad -min samples', Adjacent,
     :                    ' minumum number of bad samples', minterp
                  endif


501         CONTINUE


               ENDIF
            ENDIF

502         CONTINUE

            call vmov (tri, 1, itr(ITHWP1), 1, nsamp)
            call wrtape( luout, itr, nbytes)
 1001    continue
 
 1000 continue

c-----
c     close data files
c-----

 999  continue

      call lbclos ( luin )
      call lbclos ( luout )

      write(LERR,*)'end of prgm, processed',nrec,' record(s)',
     :     ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
      WRITE(LER,*)
     :'***************************************************************'
      WRITE(LER,*)
     :'PROGRAM MODULE SINTERP  --  AMPLITUDE EDITTING'
      WRITE(LER,*)
      WRITE(LER,*)
     :'Program SINTERP removes low/high amplitude values from ',
     :'seismic data.'
      WRITE(LER,*)
     :'Absolute value amplitudes, less/greater than a user ',
     :'input threshold'
      WRITE(LER,*)
     :'within a time and offset designated application window'
      WRITE(LER,*)
     :'are replaced with with a new amplitude, linearly interpolated'
      WRITE(LER,*)
     :'from the nearest acceptable sample amplitudes.'
      WRITE(LER,*)
     :'If the number of unacceptable samples is greater than a user'
      WRITE(LER,*)
     :'input tolerance, the trace is skipped.'
      WRITE(LER,*)
      WRITE(LER,*)
     :'Execute SINTERP  by typing "sinterp" followed by program ',
     :'parameters.'
      WRITE(LER,*)
     :'Note that each parameter is proceeded by -A where "A" is '
      WRITE(LER,*)
     :'a character(s) corresponding to some parameter.'	
      WRITE(LER,*)
     :'..............................................................'
      WRITE(LER,*)
      WRITE(LER,*)
     :'INPUT PARAMETERS and (DEFAULT VALUES)'
      WRITE(LER,*)
      WRITE(LER,*)
     :' -N [ntap]      (no default) : input data file name'
        WRITE(LER,*)
     :' -O [otap]      (no default) : output data file name'
        WRITE(LER,*) 
     :' -max [amax]    (1.e30)          : max. amplitude threshhold'
        WRITE(LER,*) 
     :' -min [amax]    (-1.e-30)          : min amplitude threshhold'
      WRITE(LER,*)
     :' -interp [iinterp] (0)          : max. number of bad samples'
      WRITE(LER,*)
     :'                               per trace. '
        WRITE(LER,*) 
     :' -ts [tbegin]   (0)          : application start time'
        WRITE(LER,*) 
     :' -te [tend]     (last samp)  : application end time'
        WRITE(LER,*) 
     :' -v0 [vel]      (999999.)    : start velocity '
        WRITE(LER,*) 
     :' -ds [dstart]   (min dist    : minimum distance for application'
        WRITE(LER,*) 
     :' -de [dstart]   (max dist)   : maximum distance for application'
      WRITE(LER,*)
      WRITE(LER,*)
     :' -V [verbos]    ( no )       : print additional info'
      WRITE(LER,*)
      WRITE(LER,*)
     :' EXAMPLE'
      WRITE(LER,*)
     :' sinterp -N/home/data/ntap -O/home/data/otap -min10. -interp95'
      WRITE(LER,*)
      WRITE(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,lus,ns,ne,irs,ire,
     1                  amax,amin,minterp,verbos,
     2                  tbegin, tend, dbegin, dend,
     3			vel)
c-----
c     get command arguments
c
c     ntap  - c*100     input file name
c     otap  - c*100     output file name
c     vel   - r*4  design velocity
c     ns    - i*4 starting trace index
c     ne    - i*4 ending trace index
c     irs   - i*4 starting record index
c     ire   - i*4 ending record index
c     verbos      - l   verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      integer     ns, ne, irs, ire
      real        amax, amin, vel
      logical     verbos
      integer     argis
 
            call argr4( '-max', amax, 1.e30, 1.e30 )
            call argr4( '-de', dend, 1000000., 1000000. )
            call argr4( '-ds', dbegin, -1000000., -1000000. )
            call argr4 ( '-interp', ainterp ,  0  , 0    )
            call argr4( '-min', amin, -1.e-30, -1.e-30 )
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argr4( '-te', tend, 0., 0. )
            call argr4( '-ts', tbegin, 0., 0. )
            call argr4( '-v0', vel, 999999., 999999. )
            verbos = (argis('-V') .gt. 0)
            minterp = int( ainterp )
c
      lus=LUN
      return
      end
c
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  ntap,otap,amax,amin,minterp,
     2                  tbegin, tend, dbegin, dend,
     3                  vel)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     vel   - r*4  design velocity
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     ntap  - C*120     input file name
c     otap  - C*120     output file name
c-----
#include <f77/iounit.h>
      integer * 4 nsamp, nsi, ntrc, nrec
      character ntap*(*), otap*(*)
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace    =  ', nsamp
            write(LERR,*) ' sample interval       =  ', nsi
            write(LERR,*) ' traces per record     =  ', ntrc
            write(LERR,*) ' records per line      =  ', nrec
            write(LERR,*) ' format of data        =  ', iform
            write(LERR,*) 
            write(LERR,*) ' input data set name   =  ', ntap
            write(LERR,*) ' output data set name  =  ', otap
  
            write(LERR,*)' program control parameters '
            write(LERR,*) ' Min. Application Time =  ', tbegin
            write(LERR,*) ' Max. Application Time =  ', tend
            write(LERR,*) ' Min. Appl. Distance   =  ', dbegin
            write(LERR,*) ' Max. Appl. Distance   =  ', dend
            write(LERR,*) ' Max. Amp. Threshold   =  ', amax
            write(LERR,*) ' Min. Amp. Threshold   =  ', amin
            write(LERR,*) ' Velocity              =  ', vel
            write(LERR,*) ' Sample count Threshold  =  ', minterp
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
