C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine statapp(x,nx,y,shft)
************************************************************************
*                                                                      *
*    SUBROUTINE TO PERFORM STATIC SHIFT USING PARABOLIC                *
*    INTERPOLATION.                                                    *
*                                                                      *
*      ARGUMENTS ARE:                                                  *
*         X  - [R ()] - DATA TO BE SHIFTED                             *
*        NX  - [I   ] - Length of x                                    *
*         Y  - [R ()] - Shifted data (Returned)                        *
*      SHFT  - [R   ] - Shift (in fractions of a sample)               *
*                                                                      *
************************************************************************
c#ifdef hpux
c      implicit none
c#else
c      implicit none (a-z)
c#endif
      real X(*),Y(*)
      real shft,rshft,f,fs,c1,c2,c3
      integer i,nx,m,lmv,lmv1,j,k,nb

      rshft = abs(shft)
      do i=1,nx
        y(i)=0.0
      end do
      if(shft.eq.0)then
        call vmov(x,1,y,1,nx)
        return
      endif
      if(rshft.gt.nx-2)then
         return
      endif
C +=========================================================+
C | In context of this program, the shft value coming is    |
C | the sample position we are looking for.  To get to the  |
C | position, first interpolate to the fractional portion   |
C | of a sample, then move to the integer output position.  |
C +=========================================================+
      m = int(rshft)+1
      if(m.eq.0)m=1
      f = rshft - aint(rshft)
      if(shft.lt.0)f = 1.0 - f
      lmv = nx-m+1
      lmv1 = lmv+1
      if(lmv1.gt.nx)lmv1=nx
      if(f.eq.0)then
        if(shft.gt.0)then
          call vmov(x(m),1,y(1),1,lmv)
        else
          call vmov(x,1,y(m),1,lmv)
        endif
        return
      endif
      fs = f*f
      c1=fs-f
      c2 =2.0 - 2.0*fs
      c3 = fs+f
      c1 = c1 * 0.5
      c2 = c2 * 0.5
      c3 = c3 * 0.5
*  Here add code as created by Bill Kamps, CONVEX
      if(m.eq.1.and.shft.gt.0)then
         y(1)=x(1)*c2 + x(2)*c3 
         do i=2,nx-3,3
           y(i) =       (
     :             x(i-1)*c1 + x(i)*c2 + x(i+1)*c3)
           y(i+1) =       (
     :             x(i)*c1 + x(i+1)*c2 + x(i+2)*c3)
           y(i+2) =       (
     :             x(i+1)*c1 + x(i+2)*c2 + x(i+3)*c3)
         end do
         do k=i, nx-1
           y(k) =       (
     :             x(k-1)*c1 + x(k)*c2 + x(k+1)*c3)
         end do
         y(nx) =       (x(nx-1)*c1 + x(nx)*c2)
      elseif (shft.gt.0)then
         j=1
         do i=m,nx-3,3
           y(j) =       (
     :           x(i-1)*c1 + x(i)*c2 + x(i+1)*c3)
           y(j+1) =       (
     :           x(i)*c1 + x(i+1)*c2 + x(i+2)*c3)
           y(j+2) =       (
     :           x(i+1)*c1 + x(i+2)*c2 + x(i+3)*c3)
           j = j + 3
         end do
           j = j-2
         do k=i,nx-1
            y(j) =       (
     :             x(k-1)*c1 + x(k)*c2 + x(k+1)*c3)
            j = j+1
         end do
         y(lmv) =       (x(nx-1)*c1 + x(nx)*c2)
         return
      else
        j = m+1
        y(m)=x(1)*f
        y(j)=x(1)*c2+x(2)*c3
        j = j+1
        do i=2,nx-3,3
          y(j) =       (
     :           x(i-1)*c1 + x(i)*c2 + x(i+1)*c3)
          y(j+1) =     (
     :             x(i)*c1 + x(i+1)*c2 + x(i+2)*c3)
          y(j+2) =     (
     :             x(i+1)*c1 + x(i+2)*c2 + x(i+3)*c3)
          j = j+3
        end do
        nb = nx-1
        if(nb.lt.i)nb = i
        if(i.le.nx-1)then
        do k=i,nb
           y(k) =       (
     :            x(k-1)*c1 + x(k)*c2 + x(k+1)*c3)
        end do
        endif
        y(nx) =       (x(nx-1)*c1 + x(nx)*c2)
        return
      endif
      RETURN
      END
