C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE MUTEAA ( NSAMP,  tm,   vm, DIST,  SAMP, hyp, Y,
     1                    iwin, minsamp, maxsamp, wts)

      implicit none

      INTEGER   ITM, ITMi, minsamp, maxsamp, iwin, NSAMP
      REAL      Y(nsamp) , wts (iwin), tm, vm, SAMP, DIST
      logical   hyp

c declare local variables

      integer i

      real v2, x2, t2, tmute

C**********************************************************************C
C
C  SUBROUTINE ARGUMENTS
C
C  NSAMP = NUMBER OF SAMPLES IN TRACE
C  TO    = MUTE TIME IN SEC AT ZERO OFFSET
C  vm    = MUTE VELOCITY
C  DIST  = OFFSET FROM SOURCE TO TRACE
C  SAMP  = SAMPLE INTERVAL IN SECONDS
C  NRAMP = LENGTH OF RAMP IN SAMPLES
C  Y     = TRACE VECTOR
C
C**********************************************************************C
C
C  ZERO OUT FIRST PART OF TRACE
C
C**********************************************************************C

      IF (hyp) THEN

         v2 = vm * vm
         x2 = dist * dist
         t2 = tm * tm
         TMUTE = sqrt ( t2 + x2 / v2)
         ITM   =  ( TMUTE / SAMP ) + 0.5

      ELSE

         TMUTE  =  ( tm + ( DIST / vm ) )
         ITM    =  ( TMUTE / SAMP ) + 0.5

      ENDIF

      DO  i = 1, iwin

          ITMi = ITM + i - 1
          if (ITMi .ge. minsamp .AND. ITMi .le. maxsamp) then
             Y (ITMi) = Y (ITMi) * wts (i)
          endif

      ENDDO

      return
      END
