C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c-----------
c do spatial 
c interpolation

      subroutine untrp (ntrc, ntrco, ntrcm, nsamp, bigar1,
     1                   tabl1, tabl2, tablh1, tablh2, itrhdr,
     2                   zz, iz, zzh, izh,
     3                   icinit, sr, l_StaCor)

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      
      real       bigar1(nsamp,ntrcm)
      integer*2  itrhdr(LNTRHD,ntrcm)
      real       zz(*), tabl1(*), tabl2(*)
      real       zzh(*), tablh1(*), tablh2(*)
      integer    iz(*)
      integer    izh(*)
      real       work1 (SZLNHD)
      real       work2 (SZLNHD)

      ntrc1 = ntrc + 1
      ntrco1 = ntrco + 1
      nrat  = ntrco/ntrc
c----
c   interpolate record
c----


      DO  100  i = 1, nsamp

          do  1  j = 1, ntrc

              work1 (j) = bigar1(i,j)
1         continue

          call vclr (work2, 1, ntrco)
          call fcuint (tabl1, work1, ntrc, tabl2, work2, ntrco,
     1                            iz, zz, icinit)
          icinit = 1

          do  2  j = 1, ntrco

              bigar1(i,j) = work2(j)
2         continue

100   CONTINUE


c----
c   interpolate headers
c----
c     icinit = 1

      DO  200  i = 1, LNTRHD

          do  5  j = 1, ntrc

              wrk      = float( itrhdr(i,j))
              work1(j) = wrk + sign(.1, wrk)
5         continue

          call vclr (work2, 1, ntrco1)
          call fcuint (tablh1, work1, ntrc1 , tablh2, work2, ntrco1,
     1                               izh, zzh, 1)
          icinit = 1

          do  6  j = 2, ntrco1

              itrhdr(i,j-1) = work2(j-1)
6         continue

200   CONTINUE


      return
      end
