C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Decompose ( tri, nsamp, ist, iend, trbias, 
     :     nfreq, iwind, ihalf, Ctable, t, freq, radeg, 
     :     phase, ampmax, amprms )

c variables passed from calling routine

      integer nsamp, ist, iend, nfreq, iwind, ihalf

      real tri(nsamp)
      real t(iwind+1)
      real freq(nfreq)
      real ampmax(nfreq)
      real amprms(nfreq)
      real radeg

      complex Ctable(iwind, nfreq)

      logical trbias, phase

c local variables
      
      integer k

      real sumavg, xtmp, xr, xi, sumtmp

      complex cb, csum

c initialize variables


c do decomposition of this trace
      
      sumavg = 0.
                  
      if ( trbias ) then
         
         do i = ist, iend
            tri(i) = tri(i) * t(i-ist+1)
            sumavg = tri(i) + sumavg
         enddo
            
         sumavg=sumavg/(2*ihalf+1)

         do i=ist,iend
            tri(i) = tri(i) - sumavg
         enddo

      else

         do i=ist,iend
            tri(i) = tri(i) * t(i-ist+1)
         enddo

      endif
                  
      DO k = 1, nfreq

         cb = (0.,0.)
         csum=(0.,0.)
                     
         do i = ist, iend

            xtmp = tri(i)
            csum = Ctable(i-ist+1,k) * cmplx(xtmp,0.)
                        
            cb = csum + cb

         enddo
                  
c store spectral information in freq[frequency] array

         if (phase) then
            xr = real(cb)
            xi = aimag(cb)
            if(xr .eq. 0.) then
               freq(k)=0.
            else
               freq(k) = radeg*( atan2 (xi,xr))
            endif
         else
            call cvabs(cb,2,sumtmp,1,1)
            sumtmp = sumtmp / iwind
            freq(k) = sumtmp
            ampmax(k)=max(ampmax(k),freq(k))
            amprms(k)=amprms(k)+freq(k)**2  
            sumtmp=0.
         endif

      ENDDO

      return
      end
