C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Tables ( ctable, iwind, nfreq, opbias, gaus, t, itw, 
     :     ihalf, pie, fmin, fmax, fint, dt )

c variables passed from calling routine

      integer iwind, nfreq, itw, ihalf

      real pie, fmin, fmax, fint, dt
      real t(iwind)

      complex ctable(iwind,nfreq)

      logical opbias, gaus

c local variables

      integer k, i, nf2, ia, ijk, jkl

      real w, sumtmpc, sumtmps, a
      real sigma, sigma2, spi, val, termy


c initialize variables
      
      val = 0.0

c build transform tables

      DO k = 1, nfreq

         if (fmin .eq. fmax ) then
            w = fmin * 2.0 *pie * dt
         else
            w = ( fint * float(k-1) + fmin ) * 2.0 * pie * dt
         endif

         sumtmpc = 0.
         sumtmps = 0.
         
c     calculate the average to remove the opbias unless the user
c     has specifically asked not to

         if ( opbias ) then

            do i = 1, iwind
               a = w * (i-1)
               sumtmpc = cos(a) + sumtmpc
               sumtmps = -sin(a) + sumtmps
            enddo

            sumtmpc = sumtmpc / (iwind)
            sumtmps = sumtmps / (iwind)

         endif
         
         do i = 1, iwind

            a = w * (i-1)

            if ( opbias ) then

c     remove the average unless requested not to

               ctable(i,k) = cmplx(cos(a)-sumtmpc,-sin(a)-sumtmps)
            else
               ctable(i,k) = cmplx(cos(a),-sin(a))
            endif
         enddo

      ENDDO
      
      IF (gaus) then

c Precalculate Gaussian taper weights

         sigma = float (iwind)/(2.*3.)
         sigma2 = 2. * sigma**2
         nf2=ihalf +1
         spi=1./(sqrt(2.*pie)*sigma)

         do i = 1,iwind
            ia = i-nf2
            t(i) = spi * exp(-(float(ia))**2 / sigma2)
            val = max(val,t(i))
         enddo

         do i=1,iwind
            t(i)=t(i)/val
         enddo

      ENDIF

      IF (.not. gaus) then

c  Precalculate Cosine taper weights

         itw = 100 - itw
         itw = (int( (itw/100.) *iwind) ) / 2
         
         do ijk=1,iwind
            jkl=ijk-ihalf-1
            
            if (ijk .le. ihalf-itw ) then
               termy=(float(jkl+itw+1)/float(abs(itw-ihalf)))
               t(ijk)=((cos(pie*termy) +1.)/2.)
            elseif (ijk .gt. ihalf+itw+1) then 
               termy=abs(float(jkl-itw)/float(abs(itw-ihalf)))
               t(ijk)=((cos(pie*termy) +1.)/2.)
            else
               t(ijk)=1.0
            endif
            
         enddo

      ENDIF

      return
      end
