C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine memqpf(tri,lwin,work,freqs,ifmin,ifmax,ifdel,
     : c_amp_spec,sig,dt,ifc,qq,pf,thresh,nfreqo,mfreqo,
     : mstart,mlast,v_mem,vc_mem,s_mem,sc_mem,mdim,
     : a_mem,m_mem,ssq_mem,nfreq,fwork,pwr)
c +================================================================== +
c | Subroutine to do the grunt work of getting the Q (qq) and peak    |
c | frequency (pf) vectors for a given data trace (tri).              |
c | Input parameters are:                                             |
c |   tri        - R(*) - Data vector                                 |
c |   lwin       - I    - Length of  tri                              |
c |   lwin       - I    - Length of an analysis (DFT) window          |
c |   work       - R(*) - work vector                                 |
c |   c_amp_spec - R(*) - Amplitude spectrum work buffer              |
c |   ifc          R    - Highcut freq index for slope computations   |
c | Output :                                                          |
c |   qq           R(*) - Q vector                                    |
c |   pf           R(*) - Peak frequency vector                       |
c +================================================================== +

cprg---
c   for max entropy option we require the following working vectors
c   v_mem(*),vc_mem(*),s_mem(*),sc_mem(*),a_mem(*)

c   routine fabne below inputs a window of data then compute the
c   forward & backward max entropy autoregression and return the
c   AR coefficients in vector a_mem(*)
c   routine power then computes the amp spec: sqrt (1 / a_mem(z)
cprg---

      real tri(*),freqs(*)
      real c_amp_spec(*),sig(*),work(*)
      real v_mem(*),vc_mem(*),s_mem(*),sc_mem(*),a_mem(*)
      real fwork(*)
      integer akcode, rscode, icode, ocode

      icode =  0
      akcode = 0
      rscode = 1

      tiny = 2.23e-03
      do mm=1,lwin
       work(mm)=0.
      end do


      istrt=1
      do while(tri(istrt).eq.0.)
       istrt = istrt+1
      end do
      jstrt = istrt

      fmax = 0.
      jm = 0
      do  mm = istrt, lwin + istrt - 1
         jm=jm+1
         work(jm)=tri(mm)
      end do

      k=1
      ks = istrt
      kk = lwin+ks

         jm = 0
         do  mm = ks+1, kk
             jm = jm + 1
             work (jm) = tri (mm)
         end do
         sum = 0.
         liv = 0
         do  mm = 1, lwin
             sum = sum + work(mm)
             if (work(mm) .ne. 0.) liv = liv + 1
         end do

c----
c   check to see we have at least 2x the max entropy order nonzero samples
c   in current analysis window
c----
         if (liv .le. 2*mlast) then
             as = 0.
             go to 100
         endif

         avg = sum / float(lwin)
         if (avg .ne. 0) then
             do mm = 1, lwin
                  work(mm) = work(mm) - avg
             end do
         endif

         call fabne (work, lwin, mstart, mlast, icode,
     1               akcode, rscode, mdim, v_mem, vc_mem, s_mem, sc_mem,
     2               a_mem, m_mem, ssq_mem, pwr, ocode)
         call power (c_amp_spec, a_mem, m_mem, freqs, nfreq, dt, pwr)

 
       amax = 0.
       amin = 99999.
       do  mm = 1, nfreq
           x = c_amp_spec(mm)
           if(x.gt.amax)then
              amax = x
           endif
           if(x.lt.amin.and.x.ne.0.0)then
              amin = c_amp_spec(mm)
           endif
       end do

       if (amax .ne. 0) then
          do   mm = 1, nfreq
             x = c_amp_spec(mm)
             if(x.eq.0.)x=amin
             c_amp_spec(mm)=20.*alog10(x/amax)
          end do
       endif

       call SmoothFit (c_amp_spec, nfreq, 7)

       kmax = 1
       amax = -99999.
       do  mm = 1, nfreq
           if(c_amp_spec(mm).gt.amax)then
              amax = c_amp_spec(mm)
              kmax = mm
           endif
       end do

       fmax = freqs (kmax)
       kf2  = ifc
       if (kf2-kmax+1 .le. 3) then
          do  while(kf2-kmax+1 .le. 3)
                    kf2=kf2+kf2
          end do
       endif

       if (kf2 .gt. nfreq) kf2 = nfreq
       kf = 0

       do  mm = kmax, kf2
           xa = abs (c_amp_spec(mm) )
           if (xa .le. thresh) then
              kf = kf + 1
              work (kf) = c_amp_spec (mm)
              fwork (kf) = freqs (mm)
           endif
       end do

       if (kf .gt. 3) then
          call fit (fwork, work, kf, sig, 0, b, as, sa, sb, chi)
       else
          as=0.
       endif

       do  i = 1, mfreqo
           fwork (i) = 0.0
       enddo

       iif = 0
       do  if = ifmin, ifmax, ifdel
           iif = iif + 1
           ff = 0.
           lf = 0
           do  ii = 1, ifdel
               iii = if + ii - 1
               if (iii .le. nfreq) then
                   ff = ff + c_amp_spec (iii)
                   lf = lf + 1
               endif
           enddo
           if (lf .gt. 0) then
              fwork (iif) = ff / float(lf)
           else
              iif = iif -1
           endif
       enddo
       nfreqo = iif

100    continue

        if(abs(as) .gt. tiny .and. as .lt. 0.0) then
           qq = 27.3 / abs(as)
        else
           qq = 0.0
        endif
        pf = fmax

      return
      end
