C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine power (tri, a, m, f, nfreq, dt, p)

      real    a(*), tri(*), f(*)
      complex sum
      real    sumd

      pi2  = 2. * 3.14159265

      DO  100  i = 1, nfreq

          ff = f (i)
          sum = cmplx (0.,0.)

          do  50  j = 1, m

              temp = pi2 * ff * j * dt

              sum  =  sum + a(j) * cexp (cmplx(0., -temp))
50        continue

          sumd = cabs(1. - sum)

          if ( sumd .ne. 0.0 ) then
             trii = p / sumd
          else
             trii = 0.0
          endif

          tri (i) = sqrt ( trii )

100   CONTINUE

      return
      end


