/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <ctype.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/DialogS.h>
#include <Xm/ToggleBG.h>
#include <Xm/Scale.h>
#include <Xm/RowColumn.h>
#include <Xm/Text.h>
#include <Xm/TextF.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/LabelG.h>
#include <Xm/SeparatoG.h>
#include <Xm/BulletinB.h>
#include <Xm/SelectioB.h>
#include <Xm/MessageB.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>

#include "ColorEditor.h"
#include "ColorEditorP.h"
#include "ColorHelp.h"

static int type_code=0;

static float linlog_backup,boundary1_backup,boundary2_backup,boundary3_backup;
static float incr_linear_backup, incr_db_backup;
static int num_colors_backup, value_contrast_backup, value_brightness_backup;
static int using_defaults;
static XColor color_backup[MAX_COLORS];
static XColor color_save[MAX_COLORS];
static XColor current_color;
static Widget red_slider, blue_slider, green_slider;
static Widget dark_slider, light_slider;
static Widget contrast_slider, brightness_slider;
static Widget bb, bbe, colorcard_dialog, save_dialog;
static Widget button_loadpal, button_delpal;
static Widget file_button[2],file_label;
static Widget file_dialog;

static Widget action[7], palette_text;
static Widget savepalette_dialog, colorlist_dialog, deletecolorlist_dialog;

static Widget colhelp,helpText;

/* num_colors is the number of colors in current pallette.
   color_pixel is an array of pixel locations  */

static int ncolors = MAX_COLORS;
static unsigned long color_pixel[MAX_COLORS];
static Widget button[MAX_COLORS], limits[MAX_COLORS-2];
static int num_colors;
static float color_limits[MAX_COLORS-2];
static float incr_linear, incr_db;
static float boundary1, boundary2, boundary3;
static int linlog;
static Widget limit_text[5];
static char defaultb1[12], defaultb2[12];
static char *limitvalue_backup[5];
static char *limitvalue[5] = { "2047.", "0.", "-2047.", "2.0", "2047." };
static char opt1_str0[11],opt1_str1[11],opt1_str2[11],opt1_str3[11],
            opt1_str4[11];
static char *parm_temp[5];
static char *limitstring[5] = { "Maximum value    ", "Linear Increment ",
                                "Minimum value    ", "dB Increment     ",
                                "Value for zero dB" };
static int count_add_del;

static int interp_flag[40] = {  0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0
            };
static int value_contrast=0, value_brightness=0;
static int selected_item_index;
static char item[200][51];
static int num_items;
static char appl[11];
static char subclass[11];
static int apply=0;

static Display *display;
static int screen_num;
static Colormap default_cmap;
static char *red="red", *blue="blue", *green="green";
static char *dark="dark-\nness", *light="light-\nness";
static char *contrast="contrast  ", *brightness="brightness";
static char *cardfilename, *pltrfilename, *entry_name;
static double opt1_lin_int, opt1_lin_high, opt1_db_int, opt1_db_zero;
static int opt1_num, opt1_type;
static unsigned short clr_rr[40], clr_gg[40], clr_bl[40];
static int last_moved, last_pos4, last_pos5, pos_diff;
static int pos_col, pos_col1, pos_col2, pos_col3, pos_col4;
static unsigned short def_red[MAX_COLORS] = 
     { 0, 0, 0, 0, 0, 20224, 44800, 44800, 44800, 44800, 65280,
      65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
      65280, 65280, 65280, 65280, 65280, 65280, 65280, 44800,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65280 };
static unsigned short def_green[MAX_COLORS] = 
    { 0, 20224, 44800, 44800, 65280, 65280, 65280, 65280,
      65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280, 65280,
      65280, 44800, 44800, 44800, 44800, 44800, 20224, 20224, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65280 };
static unsigned short def_blue[MAX_COLORS] = 
    { 65280, 44800, 65280, 44800, 65280, 65280, 65280, 65280,
      44800, 44800, 44800, 44800, 65280, 65280, 65280, 65280,
      44800, 44800, 44800, 44800, 44800, 65280, 65280, 44800, 0, 0, 0, 0,
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65280 };
static Arg wargs[20];

static unsigned long pixel_black, pixel_white;
static int map_flag;

static FILE *luin,*tfp;

static struct pal_title titledata;
static struct pal_rgb rgbdata;
static struct pal_limits limitdata;
static struct pal_defaults defaultdata;


static int Float_Checks (char *int_string)
{
   char *ptr = NULL;
   (void)strtod(int_string,&ptr);
   if (ptr == int_string) return 1;
   if (*ptr == '\0' || isspace(*ptr)) return 0;
   return 1;
}      

static void DialogDestroyMessageCB(Widget w,XtPointer client_data,
                                   XtPointer call_data)
{
   XtDestroyWidget (w);
}

static Widget DisplayMsg(Widget parent,char *message,int kind_of_msg)
{
   Widget          mybutton;
   Widget          message_box;    /*  Message Dialog      */
   Arg             args[10];       /*  arg list            */
   register int    n;              /*  arg count           */
   XmString        message_string = NULL;
   char *tag = XmFONTLIST_DEFAULT_TAG;
 
 
   /*      Generate message to display.  */
   message_string = XmStringCreateLtoR (message, tag);
 
   /*      Create MessageBox dialog.  */
   n = 0;
   XtSetArg (args[n], XmNmessageString, message_string);  n++;

   if (kind_of_msg == 1) {
      XBell (XtDisplay(parent), 100);
      XtSetArg (args[n], XmNdialogTitle,
                XmStringCreateLocalized("ERROR"));  n++;
      message_box = XmCreateErrorDialog (parent, "errorbox", args, n);
      }
   else if (kind_of_msg == 2) {
      XtSetArg (args[n], XmNdialogTitle, 
                XmStringCreateLocalized ("INFORMATION"));  n++;
      message_box = XmCreateInformationDialog(parent,"informationbox",args,n);
      }
   else if (kind_of_msg == 3) {
      XtSetArg (args[n], XmNdialogTitle, 
                XmStringCreateLocalized ("MESSAGE"));  n++;
      message_box = XmCreateMessageDialog (parent, "messagebox", args, n);
      }
   else if (kind_of_msg == 4) {
      XtSetArg (args[n], XmNdialogTitle,
                XmStringCreateLocalized("QUESTION"));  n++;
      message_box = XmCreateQuestionDialog(parent,"questionbox",args,n);
      }
   else if (kind_of_msg == 5) {
      XtSetArg (args[n], XmNdialogTitle,
                XmStringCreateLocalized("WARNING"));  n++;
      message_box = XmCreateWarningDialog (parent, "warningbox", args, n);
      }
   else if (kind_of_msg == 6) {
      XtSetArg (args[n], XmNdialogTitle,
                XmStringCreateLocalized("WORKING"));  n++;
      message_box = XmCreateWorkingDialog (parent, "workingbox", args, n);
      }

   mybutton = XmMessageBoxGetChild (message_box, XmDIALOG_CANCEL_BUTTON);
   XtUnmanageChild (mybutton);

   mybutton = XmMessageBoxGetChild (message_box, XmDIALOG_HELP_BUTTON);
   XtUnmanageChild (mybutton);
 
   XtAddCallback(message_box, XmNokCallback, DialogDestroyMessageCB, NULL);
 
   /*      Free strings and return MessageBox.  */
   if (message_string) XmStringFree(message_string);
   return (message_box);
}

void Set_Color_Limit_Switch(int value)
{
   if (value == 0 || value == 1) type_code = value;
}

static char *getFileNameFromHome(char *filename)
{
   int flen = strlen(filename);
   char *home;
   char *name;

   if ((home = getenv("HOME")) == NULL) {
      fprintf(stderr,"Unable to get HOME environment variable\n");
      return NULL;
      }

   if ((name = (char *)malloc(flen+strlen(home)+2 * sizeof(char))) == NULL) {
      fprintf(stderr,"Unable to allocate memory for file name %s/%s\n",
              home,filename);
      return NULL;
      }

   sprintf(name,"%s/%s",home,filename);
   return name;
}

static int getdefaultid(void)
{
   FILE *fp;
   char *filename = ".colorpalette_defs";
   char datbuf[sizeof(defaultdata)];
   char *filedefaults;
   int l1, l2;
   int id = 0;

   if ((filedefaults = getFileNameFromHome(filename)) == NULL) return 0;

   fp = fopen(filedefaults,"r");
   if (fp != NULL) {
      l1 = strlen(appl);
      l2 = strlen(subclass);
      while(1) {
         fread(datbuf, sizeof(char), sizeof(defaultdata), fp);
         memcpy(&defaultdata, datbuf, sizeof(defaultdata));
         if (feof(fp) != 0) break;

         if (strncmp(appl, defaultdata.appl, l1) == 0 &&
             (l1 == 10 || defaultdata.appl[l1] == '\0' ||
              defaultdata.appl[l1] == ' ') &&
             strncmp(subclass, defaultdata.subclass, l2) == 0 &&
             (l2 == 10 || defaultdata.subclass[l2] == '\0' ||
              defaultdata.subclass[l2] == ' ')) {
            id = atoi(defaultdata.code);
            break;
            }
         }
      fclose(fp);
      }

   free(filedefaults);
   return id;
}

static void savedefaultid(int id)
{
   FILE *fp;
   char *filename = ".colorpalette_defs";
   char datbuf[sizeof(defaultdata)];
   char *filedefaults;
   int bytes, l1, l2;

   l1 = strlen(appl);
   if (l1 > 10) l1 = 10;
   l2 = strlen(subclass);
   if (l2 > 10) l2 = 10;

   if ((filedefaults = getFileNameFromHome(filename)) == NULL) return;

   fp = fopen(filedefaults,"r+");
   if (fp != NULL) {
      while(1) {
         bytes = fread(datbuf, sizeof(char), sizeof(defaultdata), fp);
         memcpy(&defaultdata, datbuf, sizeof(defaultdata));
         if (feof(fp) != 0) {
            memset (defaultdata.appl, ' ', sizeof(defaultdata));
            memcpy (defaultdata.appl, appl, l1);
            memcpy (defaultdata.subclass, subclass, l2);
            sprintf(defaultdata.code, "%-4d", id);
            defaultdata.newline = '\n';
            memcpy(datbuf, &defaultdata, sizeof(defaultdata));
            fseek (fp, 0L, SEEK_END);
            bytes = fwrite(datbuf, sizeof(char), sizeof(defaultdata), fp);
            break;
            }
         if (strncmp(appl, defaultdata.appl, l1) == 0 &&
             (l1 == 10 ||
              defaultdata.appl[l1] == '\0' ||
              defaultdata.appl[l1] == ' ') &&
             strncmp(subclass, defaultdata.subclass, l2) == 0 &&
             (l2 == 10 ||
              defaultdata.subclass[l2] == '\0' ||
              defaultdata.subclass[l2] ==  ' ')) {
            sprintf(defaultdata.code, "%-4d", id);
            fseek (fp, -bytes, SEEK_CUR);
            defaultdata.newline = '\n';
            memcpy(datbuf, &defaultdata, sizeof(defaultdata));
            fwrite(datbuf, sizeof(char), sizeof(defaultdata), fp);
            break;
            }
         }
      fclose(fp);
      }
   else  {
      fp = fopen(filedefaults,"w");
      if (fp != NULL) {
         memset (&defaultdata, 0x20, sizeof(defaultdata));
         memcpy (defaultdata.appl, appl, l1);
         memcpy (defaultdata.subclass, subclass, l2);
         sprintf(defaultdata.code, "%-4d", id);
         defaultdata.newline = '\n';
         memcpy(datbuf, &defaultdata, sizeof(defaultdata));
         fwrite(datbuf, sizeof(char), sizeof(defaultdata), fp);
         fclose(fp);
         }
      }

   free(filedefaults);
}

static void reset_default_id(int id)
{
   FILE *fp;
   char datbuf[sizeof(defaultdata)];
   char *filedefaults;
   int i, l1, l2;
   static int zero=0;
   int notdone;
   char *palettename = ".colorpalette_defs";

   l1 = strlen(appl);
   if (l1 > 10) l1 = 10;
   l2 = strlen(subclass);
   if (l2 > 10) l2 = 10;

   if ((filedefaults = getFileNameFromHome(palettename)) == NULL) return;

   notdone = 1;
   while (notdone) {
      fp = fopen(filedefaults,"r+");
      notdone = 0;
      if (fp != NULL) {
         while(1) {
            fread(datbuf, sizeof(char), sizeof(defaultdata), fp);
            memcpy(&defaultdata, datbuf, sizeof(defaultdata));
            if (feof(fp) != 0) break;
            if (atoi(defaultdata.code) == id) {
               sprintf(defaultdata.code, "%-4d", zero);
               fseek (fp, -i, SEEK_CUR);
               defaultdata.newline = '\n';
               memcpy(datbuf, &defaultdata, sizeof(defaultdata));
               fwrite(datbuf, sizeof(char), sizeof(defaultdata), fp);
               notdone = 1;
               break;
               }
            }
         fclose(fp);
         }
      }

   free(filedefaults);
}

static void setnewlimits(void)
{
   static long int zero=0;
   register int i;
   char temp[22];

   linlog = (long)limitdata.limtyp;
   boundary2 = limitdata.bound2;
   incr_linear = limitdata.incr_lin;
   boundary1 = limitdata.bound1;
   incr_db = limitdata.incr_db;
   boundary3 = limitdata.bound3;
   sprintf(temp, "%-20.10f", boundary2);
   for (i=9; i>=0; i--) {
      if (temp[i] != '0') {
         temp[i+1] = '\0';
         break;
         }
      }
   strncpy(opt1_str0, temp, 10);
   opt1_str0[10] = '\0';
   sprintf(temp, "%-20.10f", incr_linear);
   for (i=9; i>=0; i--) {
      if (temp[i] != '0') {
         temp[i+1] = '\0';
         break;
         }
      }
   strncpy(opt1_str1, temp, 10);
   opt1_str1[10] = '\0';
   sprintf(temp, "%-20.10f", boundary1);
   for (i=9; i>=0; i--) {
      if (temp[i] != '0') {
         temp[i+1] = '\0';
         break;
         }
      }
   strncpy(opt1_str2, temp, 10);
   opt1_str2[10] = '\0';
   sprintf(temp, "%-20.4f", incr_db);
   for (i=4; i>=0; i--) {
      if (temp[i] != '0') {
         temp[i+1] = '\0';
         break;
         }
      }
   strncpy(opt1_str3, temp, 10);
   opt1_str3[10] = '\0';
   sprintf(temp, "%-20.10f", boundary3);
   for (i=9; i>=0; i--) {
      if (temp[i] != '0') {
         temp[i+1] = '\0';
         break;
         }
      }
   strncpy(opt1_str4, temp, 10);
   opt1_str4[10] = '\0';
   parm_temp[0] = opt1_str0;
   parm_temp[1] = opt1_str1;
   parm_temp[2] = opt1_str2;
   parm_temp[3] = opt1_str3;
   parm_temp[4] = opt1_str4;

   for (i=0; i<5; i++) limitvalue[i] = parm_temp[i];
}

static void retrievepalette(int myitem)
{
   /* rgbdata is by far the largest of titledata rgbdata and limitdata */
   char datbuf[sizeof(rgbdata)];
   int num_save;
   int bytes, i, j;

   for (j=1; j<myitem; j++) {
      fread(datbuf, sizeof(char), sizeof(titledata), luin);
      fread(datbuf, sizeof(char), sizeof(rgbdata), luin);
      fread(datbuf, sizeof(char), sizeof(limitdata), luin);
      }

   bytes = fread(datbuf, sizeof(char), sizeof(titledata), luin);
   memcpy(&titledata, datbuf, sizeof(titledata));

   if (titledata.entry_num > 0 && bytes > 0) {
      fread(datbuf, sizeof(char), sizeof(rgbdata), luin);
      memcpy(&rgbdata, datbuf, sizeof(rgbdata));

      fread(datbuf, sizeof(char), sizeof(limitdata), luin);
      memcpy(&limitdata, datbuf, sizeof(limitdata));

      if (limitdata.limtyp != 0) setnewlimits();

      num_save = num_colors;
      num_colors = rgbdata.num_colors;
      value_contrast = rgbdata.contrast;
      value_brightness = rgbdata.brightness;

      for (i=0; i<num_colors; i++) {
         current_color.red = rgbdata.colors[i][0];
         current_color.green = rgbdata.colors[i][1];
         current_color.blue = rgbdata.colors[i][2];
         current_color.pixel = color_pixel[i];
         color_save[i] = current_color;
         }

      XmScaleSetValue(contrast_slider, value_contrast);
      XmScaleSetValue(brightness_slider, value_brightness);
      update_color();

      current_color.pixel = color_pixel[ncolors-1];
      XQueryColor(display, default_cmap, &current_color);

      if (num_save > num_colors) {
         for (i=num_colors; i<num_save; i++)
            XtUnmanageChild(button[i]);
         }
      else if (num_save < num_colors) {
         for (i=num_save; i<num_colors; i++)
            XtManageChild(button[i]);
         }
      UpdateLimits();

      using_defaults = 0;
      }

   fclose(luin);
}

static int openpalette(char *mode)
{
   char *palettename = ".colorpalette";
   char *nntap;

   Widget message_box;
   char msgbuf[256];

   if ((nntap = getFileNameFromHome(palettename)) == NULL) return 1;

   luin = fopen(nntap, mode);
   if (luin == NULL) {
      luin = fopen(nntap, "ab+");
      fclose(luin);
      luin = fopen(nntap, mode);
      if (luin == NULL) {
         strcpy(msgbuf,"Unable to open file\n");
         strncat(msgbuf,nntap,sizeof(msgbuf)-strlen(msgbuf)-1);
         msgbuf[sizeof(msgbuf)-1] = '\0';
         message_box = DisplayMsg(bb,msgbuf,5);
         XtManageChild (message_box);
         return 1;
         }
      }

   free(nntap);

   return luin == NULL;
}

static void getpalette(void)
{
   char datbuf[sizeof(rgbdata)];

   num_items = 0;

   while (1) {
      if (fread(datbuf, sizeof(char), sizeof(titledata), luin) <= 0) break;
      memcpy(&titledata, datbuf, sizeof(titledata));
      if (titledata.entry_num > 0 ) {
         strcpy(item[num_items],titledata.desc);
         num_items++;
         if (num_items >= 200) break;
         }

      if (fread(datbuf, sizeof(char), sizeof(rgbdata), luin) <= 0) break;

      if (fread(datbuf, sizeof(char), sizeof(limitdata), luin) <= 0) break;
      }

   fclose(luin);
}

static void setpalette(void)
{
   int num_save;
   int id;
   int i;
   char datbuf[sizeof(rgbdata)];

   num_items = 0;

   id = 0;

   while (1) {
      id++;
      if (fread(datbuf, sizeof(char), sizeof(titledata), luin) <= 0) break;
      memcpy(&titledata, datbuf, sizeof(titledata));
      if (titledata.entry_num > 0) {
         num_items++;
         if (num_items == selected_item_index) {
            savedefaultid(id);

            fread(datbuf, sizeof(char), sizeof(rgbdata), luin);
            memcpy(&rgbdata, datbuf, sizeof(rgbdata));

            fread(datbuf, sizeof(char), sizeof(limitdata), luin);
            memcpy(&limitdata, datbuf, sizeof(limitdata));
            if (limitdata.limtyp != 0) setnewlimits();
            break;
            }
         else {
            fread(datbuf, sizeof(char), sizeof(rgbdata), luin);
            fread(datbuf, sizeof(char), sizeof(limitdata), luin);
            }
         }
      else {
         fread(datbuf, sizeof(char), sizeof(rgbdata), luin);
         fread(datbuf, sizeof(char), sizeof(limitdata), luin);
         }
      }

   fclose(luin);

   num_save = num_colors;
   num_colors = rgbdata.num_colors;
   value_contrast = rgbdata.contrast;
   value_brightness = rgbdata.brightness;

   for (i=0; i<num_colors; i++) {
      current_color.red = rgbdata.colors[i][0];
      current_color.green = rgbdata.colors[i][1];
      current_color.blue = rgbdata.colors[i][2];
      current_color.pixel = color_pixel[i];
      color_save[i] = current_color;
      }

   XmScaleSetValue(contrast_slider, value_contrast);
   XmScaleSetValue(brightness_slider, value_brightness);
   update_color();

   current_color.pixel = color_pixel[ncolors-1];
   XQueryColor(display, default_cmap, &current_color);

   if (num_save > num_colors) {
      for (i=num_colors; i<num_save; i++)
         XtUnmanageChild(button[i]);
      }
   else if (num_save < num_colors) {
      for (i=num_save; i<num_colors; i++)
         XtManageChild(button[i]);
      }

   UpdateLimits();
}

static void deletepalette(void)
{
   int bytes;
   int id;
   int leng;
   char datbuf[sizeof(rgbdata)];

   num_items = 0;

   id = 0;

   while (1) {
      if ((bytes = fread(datbuf, sizeof(char), sizeof(titledata), luin) <= 0))
         break;
      memcpy(&titledata, datbuf, sizeof(titledata));
      id++;
      if (titledata.entry_num > 0) {
         num_items++;
         if (num_items == selected_item_index) {
            if (fseek(luin, -bytes, SEEK_CUR) == 0) {
               titledata.entry_num = 0;
               leng = sizeof(titledata)-4;
               memcpy(titledata.length, &leng, 4);
               fwrite(&titledata,sizeof(char),sizeof(titledata),luin);
               reset_default_id(id);
               }
            break;
            }
         }

      bytes = fread(datbuf, sizeof(char), sizeof(rgbdata), luin);
      bytes = fread(datbuf, sizeof(char), sizeof(limitdata), luin);
      }
   fclose(luin);
}

static int appendpalette(void)
{
   int nrecs, id, i, ok;
   char *description;
   Widget message_box;
   int leng;
   char datbuf[sizeof(rgbdata)];

   ok = 0;
   description = XmTextGetString (palette_text);
   for (i=0; i<strlen(description); i++) {
      if (description[i] != ' ') {
         ok = 1;
         break;
         }
      }
   if (ok == 0) {
      message_box = DisplayMsg(bb,"Description cannot be blank",1);
      XtManageChild (message_box);
      return 1;
      }

   nrecs = 0;
   id = 0;

   while (1) {
      if (fread(datbuf, sizeof(char), sizeof(titledata), luin) <= 0) break;

      memcpy(&titledata, datbuf, sizeof(titledata));
      if (titledata.entry_num == 0) {
         id = nrecs + 1;
         if (fseek(luin, -i, SEEK_CUR) != 0) return 1;
         break;
         }
      fread(datbuf, sizeof(char), sizeof(rgbdata), luin);
      fread(datbuf, sizeof(char), sizeof(limitdata), luin);
      nrecs++;
      }

   if (id == 0) {
      id = nrecs + 1;
      if (fseek(luin, 0L, SEEK_END) != 0) return 1;
      }

   savedefaultid(id);

   rgbdata.num_colors = num_colors;
   rgbdata.contrast = value_contrast;
   rgbdata.brightness = value_brightness;

   for (i=0; i<num_colors; i++) {
      rgbdata.colors[i][0] = color_save[i].red;
      rgbdata.colors[i][1] = color_save[i].green;
      rgbdata.colors[i][2] = color_save[i].blue;
      }

   titledata.entry_num = 1;
   memset(titledata.desc, 0x20, sizeof(titledata.desc));
   strcpy(titledata.desc,description);
   XtFree(description);

   limitdata.limtyp = (short)linlog;
   limitdata.bound2 = boundary2;
   limitdata.incr_lin = incr_linear;
   limitdata.bound1 = boundary1;
   limitdata.incr_db = incr_db;
   limitdata.bound3 = boundary3;


   leng = sizeof(titledata)-4;
   memcpy(titledata.length, &leng, 4);
   memcpy(datbuf, &titledata, sizeof(titledata));
   fwrite(datbuf, sizeof(char), sizeof(titledata), luin);

   leng = sizeof(rgbdata)-4;
   memcpy(rgbdata.length, &leng, 4);
   memcpy(datbuf, &rgbdata, sizeof(rgbdata));
   fwrite(datbuf, sizeof(char), sizeof(rgbdata), luin);

   leng = sizeof(limitdata)-4;
   memcpy(limitdata.length, &leng, 4);
   memcpy(datbuf, &limitdata, sizeof(limitdata));
   fwrite(datbuf, sizeof(char), sizeof(limitdata), luin);

   fclose(luin);

   current_color.pixel = color_pixel[ncolors-1];
   XQueryColor(display, default_cmap, &current_color);

   return 0;
}

static Widget CreateSavePaletteMenu(Widget parent)
{
   Widget toplevel,rc01,rc2,label,seper,push1,push2;
   char *tag = XmFONTLIST_DEFAULT_TAG;

   XmString string;

   Arg args[10];
   int argcnt;

   argcnt = 0;
   toplevel = XmCreateBulletinBoardDialog(parent, "save", args, argcnt);

   argcnt = 0;
   rc01 = XmCreateRowColumn(toplevel, "workarea", args, argcnt);
   XtManageChild(rc01);

   argcnt = 0;
   XtSetArg(args[argcnt], XmNlabelString,
   XmStringCreateLtoR("SAVE PALETTE MENU\n\n", tag)); argcnt++;
   label = XmCreateLabelGadget(rc01, "label", args, argcnt);
   XtManageChild(label);

   XtSetArg(args[argcnt], XmNlabelString,
   XmStringCreateLocalized("Enter a description of this palette:"));argcnt++;
   label = XmCreateLabelGadget(rc01, "label", args, argcnt);
   XtManageChild(label);

   argcnt = 0;
   XtSetArg(args[argcnt], XmNcolumns, 50 ); argcnt++;
   XtSetArg(args[argcnt], XmNmaxLength, 50); argcnt++;
   palette_text = XmCreateText(rc01, "text", args, argcnt);
   XtManageChild(palette_text);

   argcnt = 0;
   seper = XmCreateSeparatorGadget(rc01, "sepe", args, argcnt);
   XtManageChild(seper);
 
   argcnt = 0;
   XtSetArg(args[argcnt], XmNorientation, XmHORIZONTAL); argcnt++;
   XtSetArg(args[argcnt], XmNentryAlignment, XmALIGNMENT_CENTER); argcnt++;
   XtSetArg(args[argcnt], XmNspacing, 40); argcnt++;
   XtSetArg(args[argcnt], XmNpacking, XmPACK_COLUMN); argcnt++;
   XtSetArg(args[argcnt], XmNmarginHeight,10); argcnt++;
   XtSetArg(args[argcnt], XmNmarginWidth, 40); argcnt++;
   rc2 = XmCreateRowColumn(rc01, "rc2", args, argcnt);
   XtManageChild (rc2);
 
   string = XmStringCreateLocalized("OK");
   argcnt = 0;
   XtSetArg(args[argcnt], XmNlabelString, string); argcnt++;
   XtSetArg(args[argcnt], XmNshowAsDefault, 1); argcnt++;
   push1 = XmCreatePushButtonGadget(rc2, "push1", args, argcnt);
   XtManageChild(push1);

   string = XmStringCreateLocalized("Cancel");
   argcnt = 0;
   XtSetArg(args[argcnt], XmNlabelString, string); argcnt++;
   XtSetArg(args[argcnt], XmNshowAsDefault, 1); argcnt++;
   push2 = XmCreatePushButtonGadget(rc2, "push1", args, argcnt);
   XtManageChild(push2);
  
   XtAddCallback(push1,XmNactivateCallback,color_cb,
                 (XtPointer)DIALOG_SAVEPALETTE_ACCEPT);
   XtAddCallback(push2,XmNactivateCallback,color_cb,
                 (XtPointer)DIALOG_SAVEPALETTE_CANCEL);
 
   argcnt = 0;
   XtSetArg(args[argcnt], XmNdefaultButton, push1); argcnt++;
   XtSetArg(args[argcnt], XmNcancelButton, push2); argcnt++;
   XtSetValues(toplevel,args,argcnt);

   return(toplevel);
}

Widget CreateColorEditor(Widget topwidget,char *applx,char *subclassx)
{
   int default_depth;
   Visual *default_visual;
   unsigned long int plane_masks[1];
   int n, i;
   int id;

   last_moved = 0;
   using_defaults = 1;

   display = (Display *)XtDisplay(topwidget);

   pixel_black = BlackPixel(display, screen_num);
   pixel_white = WhitePixel(display, screen_num);

   strcpy(appl,applx);
   strcpy(subclass,subclassx);

   default_depth = DefaultDepth(display, screen_num);
   default_visual = DefaultVisual(display, screen_num);
   default_cmap = DefaultColormap(display, screen_num);
   if (default_depth == 1) {
      /* Must be StaticGray, use black and white */
      color_pixel[0] = pixel_white;
      color_pixel[1] = pixel_black;
      num_colors = 2;
      ncolors = 2;
      return(0);
      }

   /* if not PseudoColor or DirectColor visual need to
      run in black and white mode only */
   if (default_visual->class != PseudoColor &&
       default_visual->class != DirectColor) {
      color_pixel[0] = pixel_white;
      color_pixel[1] = pixel_black;
      num_colors = 2;
      ncolors = 2;
      return(0);
      }

   num_colors = 28;

   /* Got PseudoColor or DirectColor visual at default_depth */

   ncolors = MAX_COLORS;

   if (!XAllocColorCells (display, default_cmap, False,
                          plane_masks, 0, color_pixel, ncolors)) {
      fprintf(stderr, "Coloredit: Couldn't allocate read/write colors\n"
                      "Color editor will be inactive.");
      color_pixel[0] = pixel_white;
      color_pixel[1] = pixel_black;
      ncolors = 2;
      num_colors = 2;
      }

   for (i=0; i< ncolors; i++) { 
      /* Set pixel value in struct to the allocated one */
      color_save[i].red = def_red[i];
      color_save[i].green = def_green[i];
      color_save[i].blue = def_blue[i];
      color_save[i].pixel = color_pixel[i];
      color_save[i].flags = DoRed | DoGreen | DoBlue;
      }

   if (ncolors <= 2) return(0);

   /* This sets the color of read/write cell */
   XStoreColors (display, default_cmap, color_save, ncolors);

   linlog = 1;
   boundary1 = -2047.;
   boundary2 = 2047.;
   boundary3 = 2047.;
   incr_linear = 0.;
   incr_db = 2.;
   setzlm();


   n = 0;
   XtSetArg (wargs[n], XmNdialogTitle, 
             XmStringCreateLocalized("Color Editor")); n++;
   bb = XmCreateBulletinBoardDialog(topwidget, "coloredit", wargs, n);

   Create_Color_Barx(bb);

   create_option_menu(bb);

   create_colhelp(bb);

   savepalette_dialog = CreateSavePaletteMenu(bb);
      
   n = 0;
   XtSetArg(wargs[n], XmNlistVisibleItemCount, 20); n++;
   colorcard_dialog = XmCreateFileSelectionDialog(bb,"Open Card File",wargs,n);
   XtAddCallback(colorcard_dialog,XmNokCallback,color_cb,
                 (XtPointer)DIALOG_CARD_ACCEPT);
   XtAddCallback(colorcard_dialog,XmNcancelCallback,color_cb,
                 (XtPointer)DIALOG_CARD_CANCEL);

   n = 0;
   XtSetArg(wargs[n], XmNselectionLabelString, 
            XmStringCreateLocalized("Save As...")); n++;
   save_dialog = XmCreatePromptDialog(bb, "save dialog", wargs, n);
   XtAddCallback (save_dialog, XmNokCallback,color_cb, 
                  (XtPointer)DIALOG_SAVE_ACCEPT);

   set_limit_menu();

   /* get the default color palette from default file */
   if ((id = getdefaultid()) > 0) {
      if (!openpalette("rb")) retrievepalette(id);
      }
   return(bb);
}

void SetDefaultColorLimits(double b1, double b2)
{
   if (using_defaults) {
      using_defaults = 0;
      boundary1 = b1;
      boundary2 = b2;
      boundary3 = b2;
      incr_linear = 0.;
      linlog = 1;
      sprintf(defaultb1,"%.3f",b1);
      sprintf(defaultb2,"%.3f",b2);
      limitvalue[2] = defaultb1;
      limitvalue[0] = defaultb2;
      limitvalue[4] = defaultb2;
      UpdateLimits();
   }
}

Widget DisplayColorEditor(void)
{
   register int i;

   if (ncolors <= 2) return NULL;

   for (i=0; i< ncolors; i++) {
      color_backup[i] = color_save[i];
      }
   num_colors_backup = num_colors;
   value_contrast_backup = value_contrast;
   value_brightness_backup = value_brightness;

   for (i=0; i<5; i++) limitvalue_backup[i] = limitvalue[i];

   linlog_backup = linlog;
   boundary1_backup = boundary1;
   boundary2_backup = boundary2;
   boundary3_backup = boundary3;
   incr_linear_backup = incr_linear;
   incr_db_backup = incr_db;

   XtManageChild (bb);
}

static void Create_Color_Barx(Widget parent)
{
   int n;
   int yy, i;
   char nm[10];
   Widget panel;
   XColor colorcell_def, colorcell_def2;
   XColor rgb_db_def;

   /* Create a row of buttons, one for each color to be edited */

   n = 0;
   XtSetArg(wargs[n], XmNx, 10); n++;
   XtSetArg(wargs[n], XmNy, 10); n++;
   XtSetArg(wargs[n], XmNorientation, XmVERTICAL); n++;
   XtSetArg(wargs[n], XmNpacking, XmPACK_NONE); n++;
   panel = XtCreateManagedWidget("colorpanel",xmRowColumnWidgetClass,
                                 parent, wargs, n);
   XAllocNamedColor(display,default_cmap,"white",&colorcell_def,&rgb_db_def);
   XAllocNamedColor(display,default_cmap,"black",&colorcell_def2,&rgb_db_def);
   yy = 2;

   for (i=ncolors-2; i>=0; i--) {
      n = 0;
      XtSetArg(wargs[n], XmNmarginHeight, 0); n++;
      XtSetArg(wargs[n], XmNmarginTop, 0); n++;
      XtSetArg(wargs[n], XmNx, 10); n++;
      XtSetArg(wargs[n], XmNy, yy); n++;
      XtSetArg(wargs[n], XmNheight, 14); n++;
      if (def_red[i] < 48960 && def_green[i] < 48960 ||
          def_green[i] < 48960 && def_blue[i] < 48960) {
         XtSetArg(wargs[n], XmNforeground, pixel_white); n++;
         }
      else {
         XtSetArg(wargs[n], XmNforeground, pixel_black); n++;
         }

      sprintf(nm, "%6d",i+1);
      XtSetArg(wargs[n], XmNbackground, color_pixel[i]); n++;
      XtSetArg(wargs[n], XmNtopShadowColor, colorcell_def.pixel); n++;
      button[i] = XtCreateManagedWidget(nm, xmPushButtonWidgetClass,
                                        panel, wargs, n);
      XtAddCallback(button[i],XmNactivateCallback,copy_current_pixel,
                    (XtPointer)i);
      if (i > num_colors-1) XtUnmanageChild(button[i]);

      if (i < ncolors-2) {
         char str[30];
         sprintf(str, "%-14.7g", color_limits[i]);
         if (i > num_colors-2) strcpy(str," ");
         n = 0;
         XtSetArg(wargs[n], XmNx, 80); n++;
         XtSetArg(wargs[n], XmNy, yy-5); n++;
         if (type_code == 0)
            limits[i] = XtCreateManagedWidget(str, xmLabelGadgetClass,
                                              panel, wargs, n);
         else
            limits[i] = XtCreateWidget(str, xmLabelGadgetClass,
                                       panel, wargs, n);
         }
      yy += 17;
      }
}

static Widget make_slider(char *name,Widget parent,int size,int start,int dir)
{
   Widget w;
   int n;
   XColor colorcell_def;
   XColor rgb_db_def;

   /* Create a Valuator widget */
   n = 0;
   if (strcmp(name, dark) == 0) {
      colorcell_def.pixel = BlackPixel(display, screen_num);
      XtSetArg(wargs[n], XmNshowValue, False); n++;
      }
   else if (strcmp(name, light) == 0) {
      colorcell_def.pixel = WhitePixel(display, screen_num);
      XtSetArg(wargs[n], XmNshowValue, False); n++;
      }
   else if (strcmp(name, brightness) != 0 && strcmp(name, contrast) != 0) {
      XAllocNamedColor(display,default_cmap,name,&colorcell_def,&rgb_db_def);
      XtSetArg(wargs[n], XmNshowValue, True); n++;
      }
   else {
      XtSetArg(wargs[n], XmNshowValue, True); n++;
      }
   if (strcmp(name, brightness) != 0 && strcmp(name, contrast) != 0) {
      XtSetArg(wargs[n], XmNtopShadowColor, colorcell_def.pixel); n++;
      }
   XtSetArg(wargs[n], XmNmaximum, start+size); n++;
   XtSetArg(wargs[n], XmNminimum, start); n++;
   XtSetArg(wargs[n], XmNscaleMultiple, 1); n++;

   if (dir == 0) {
      XtSetArg(wargs[n], XmNprocessingDirection, XmMAX_ON_BOTTOM); n++;
      XtSetArg(wargs[n], XmNorientation, XmVERTICAL); n++;
      XtSetArg(wargs[n], XmNheight, size); n++;
      XtSetArg(wargs[n], XmNscaleHeight, size); n++;
      }
   else {
      XtSetArg(wargs[n], XmNprocessingDirection, XmMAX_ON_RIGHT); n++;
      XtSetArg(wargs[n], XmNorientation, XmHORIZONTAL ); n++;
      XtSetArg(wargs[n], XmNwidth, size); n++;
      XtSetArg(wargs[n], XmNscaleWidth, size); n++;
      }

   XtSetArg(wargs[n], XmNtitleString,
            XmStringCreateLocalized(name)); n++;
   w = XtCreateManagedWidget(name, xmScaleWidgetClass, parent, wargs, n);
   XtAddCallback(w, XmNvalueChangedCallback, slider_moved, (XtPointer)name);
   XtAddCallback(w, XmNdragCallback, slider_moved, (XtPointer)name);
   return(w);
}

static void slider_moved(Widget w,XtPointer client_data,XtPointer call_data)
{
   XmScaleCallbackStruct *scbs = (XmScaleCallbackStruct *)call_data;
   char *which_slider = (char *)client_data;
   /* Set the appropriate color components of the global
      current_color structure, depending on which color slider has moved. */

   int sliderpos, k1, k2, k3, k6, k7, mult, max_col, div;

   mult = 256;
   div = mult;
   sliderpos = scbs->value;
   k1 = strcmp(which_slider, red);
   k2 = strcmp(which_slider, green);
   k3 = strcmp(which_slider, blue);
   k6 = strcmp(which_slider, contrast);
   k7 = strcmp(which_slider, brightness);

   if (!k1) {
      current_color.red   = sliderpos * mult;
      last_moved = 1;
      }
   else if (!k2) {
      current_color.green = sliderpos * mult;
      last_moved = 2;
      }
   else if(!k3) {
      current_color.blue  = sliderpos * mult;
      last_moved = 3;
      }
   else if(!strcmp(which_slider, light)) {
      pos_diff = sliderpos - last_pos4;
      last_pos4 = sliderpos;
      if (last_moved != 4) {
         XmScaleGetValue(red_slider, &pos_col);
         pos_col1 = pos_col + pos_diff;
         XmScaleGetValue(green_slider, &pos_col);
         pos_col2 = pos_col + pos_diff;
         XmScaleGetValue(blue_slider, &pos_col);
         pos_col3 = pos_col + pos_diff;
         XmScaleGetValue(dark_slider, &pos_col);
         pos_col4 = pos_col + pos_diff;
         }
      else {
         pos_col1 += pos_diff;
         pos_col2 += pos_diff;
         pos_col3 += pos_diff;
         pos_col4 += pos_diff;
         }

      pos_col = pos_col1;
      if (pos_col > 255) pos_col = 255;
      if (pos_col < 0) pos_col = 0;
      current_color.red = pos_col;

      pos_col = pos_col2;
      if (pos_col > 255) pos_col = 255;
      if (pos_col < 0) pos_col = 0;
      current_color.green = pos_col;

      pos_col = pos_col3;
      if (pos_col > 255) pos_col = 255;
      if (pos_col < 0) pos_col = 0;
      current_color.blue = pos_col;

      pos_col = pos_col4;
      if (pos_col > 255) pos_col = 255;
      if (pos_col < 0) pos_col = 0;

      XmScaleSetValue(red_slider, current_color.red);
      XmScaleSetValue(green_slider, current_color.green);
      XmScaleSetValue(blue_slider, current_color.blue);
      XmScaleSetValue(dark_slider, pos_col);
      last_pos5 = pos_col;
      current_color.red *= mult;
      current_color.green *= mult;
      current_color.blue *= mult;
      last_moved = 4;
      }
   else if (!strcmp(which_slider, dark)) {
      pos_diff = sliderpos - last_pos5;
      last_pos5 = sliderpos;
      if (last_moved != 5) {
         XmScaleGetValue(red_slider, &pos_col);
         pos_col1 = pos_col + pos_diff;
         XmScaleGetValue(green_slider, &pos_col);
         pos_col2 = pos_col + pos_diff;
         XmScaleGetValue(blue_slider, &pos_col);
         pos_col3 = pos_col + pos_diff;
         XmScaleGetValue(light_slider, &pos_col);
         pos_col4 = pos_col + pos_diff; 
         }
      else {
         pos_col1 += pos_diff;
         pos_col2 += pos_diff;
         pos_col3 += pos_diff;
         pos_col4 += pos_diff;
         }

      pos_col = pos_col1;
      if (pos_col > 255) pos_col = 255;
      if (pos_col < 0) pos_col = 0;
      current_color.red = pos_col;

      pos_col = pos_col2;
      if (pos_col > 255) pos_col = 255;
      if (pos_col < 0) pos_col = 0;
      current_color.green = pos_col;

      pos_col = pos_col3;
      if (pos_col > 255) pos_col = 255;
      if (pos_col < 0) pos_col = 0;
      current_color.blue = pos_col;

      pos_col = pos_col4;
      if (pos_col > 255) pos_col = 255;
      if (pos_col < 0) pos_col = 0;

      XmScaleSetValue(red_slider, current_color.red);
      XmScaleSetValue(green_slider, current_color.green);
      XmScaleSetValue(blue_slider, current_color.blue);
      XmScaleSetValue(light_slider, pos_col);
      last_pos4 = pos_col;
      current_color.red *= mult;
      current_color.green *= mult;
      current_color.blue *= mult;
      last_moved = 5;
      }
   else if (!k6) {
        XmScaleGetValue(contrast_slider, &value_contrast);
      }
   else if (!k7) {
      XmScaleGetValue(brightness_slider, &value_brightness);
      }

   current_color.pixel = color_pixel[ncolors-1];

   /* Update the color button. */
   if (k6 || k7) color_save[ncolors-1] = current_color;
   update_color();

   if (!k1 || !k2 || !k3) {
     max_col = current_color.red;
     if ((int)current_color.green > max_col) max_col = (int)current_color.green;
     if ((int)current_color.blue > max_col) max_col = (int)current_color.blue;
     XmScaleSetValue(dark_slider, max_col / div);
     last_pos5 = max_col/div;

     max_col = current_color.red;
     if ((int)current_color.green < max_col) max_col = (int)current_color.green;
     if ((int)current_color.blue < max_col) max_col = (int)current_color.blue;
     XmScaleSetValue(light_slider, max_col / div);
     last_pos4 = max_col/div;
     }
}

static void update_color()
{   
   /* Update the current color button */

   XColor color_temp[MAX_COLORS];
   unsigned char rs[MAX_COLORS];
   unsigned char gs[MAX_COLORS];
   unsigned char bs[MAX_COLORS];
   unsigned char r1[MAX_COLORS];
   unsigned char g1[MAX_COLORS];
   unsigned char b1[MAX_COLORS];

   register int i;
   int value;
   int half, edge;
   float x, xinc;

   for (i=0; i<num_colors; i++) {
      r1[i] = (unsigned char)(color_save[i].red / 256);
      g1[i] = (unsigned char)(color_save[i].green / 256);
      b1[i] = (unsigned char)(color_save[i].blue / 256);
      }

   half = num_colors / 2;         /* distance to center */
   if (value_contrast > 0) {      /* increase contrast */
      edge = half * value_contrast / 50;
      xinc = (float)(num_colors-1) / (float)(num_colors-1-2*edge);
      for (i=edge, x=0; i<num_colors-edge; i++, x+=xinc) {
         rs[i] = r1[(int)x];
         gs[i] = g1[(int)x];
         bs[i] = b1[(int)x];
         }
      memset((char *)rs, (int)r1[0], edge);
      memset((char *)gs, (int)g1[0], edge);
      memset((char *)bs, (int)b1[0], edge);

      memset((char *)&rs[num_colors-edge], (int)r1[num_colors-1], edge);
      memset((char *)&gs[num_colors-edge], (int)g1[num_colors-1], edge);
      memset((char *)&bs[num_colors-edge], (int)b1[num_colors-1], edge);
      }
   else {               /* decrease contrast */
      edge = -half * value_contrast / 50;
      xinc = (float)(num_colors-1-2*edge) / (float)(num_colors-1);
      if (xinc < 0.) xinc = 0.;
      for (i=0, x=edge; i<num_colors; i++, x+=xinc) {
         rs[i] = r1[(int)x];
         gs[i] = g1[(int)x];
         bs[i] = b1[(int)x];
         }
      }

   value = value_brightness * 255 / 50;
   if (value_brightness > 0) {      /* increase brightness */
      for (i=0; i<num_colors; i++) {
         register t;
         r1[i] = ((t=(int)rs[i]+value) >= 256) ? 255 : t;
         g1[i] = ((t=(int)gs[i]+value) >= 256) ? 255 : t;
         b1[i] = ((t=(int)bs[i]+value) >= 256) ? 255 : t;
         }
      }
   else {               /* decrease brightness */
      for (i=0; i<num_colors; i++) {
         register int t;
         r1[i] = ((t=(int)rs[i]+value) < 0) ? 0 : t;
         g1[i] = ((t=(int)gs[i]+value) < 0) ? 0 : t;
         b1[i] = ((t=(int)bs[i]+value) < 0) ? 0 : t;
         }
      }

   for (i=0; i<num_colors; i++) {
      color_temp[i] = color_save[i];
      color_temp[i].red = r1[i] * 256;
      color_temp[i].green = g1[i] * 256;
      color_temp[i].blue = b1[i] * 256;
      if (color_temp[i].red < 48960 && color_temp[i].green < 48960 ||
         color_temp[i].green < 48960 && color_temp[i].blue < 48960)
         XtSetArg(wargs[0], XmNforeground, pixel_white);
      else
         XtSetArg(wargs[0], XmNforeground, pixel_black);
      XtSetValues (button[i], wargs, 1);
      }

   XStoreColors(display, default_cmap, color_temp, num_colors);

   if (color_save[ncolors-1].red < 48960 && 
       color_save[ncolors-1].green < 48960 ||
       color_save[ncolors-1].green < 48960 && 
       color_save[ncolors-1].blue < 48960)
      XtSetArg(wargs[0], XmNforeground, pixel_white);
   else
      XtSetArg(wargs[0], XmNforeground, pixel_black);
   XtSetValues (button[ncolors-1], wargs, 1);

   XStoreColor(display, default_cmap, &color_save[ncolors-1]);
}

static void set_current_pixel(unsigned long pixel)
{
   int div;
   int max_col,min_col;

   div = 256;
   current_color.flags = DoRed | DoGreen | DoBlue;

   /* Get the current color components of the selected button */

   current_color.pixel = pixel;
   XQueryColor(display, default_cmap, &current_color);

   /* Set the slider values to the respective RGB positions */

   XmScaleSetValue(red_slider, (int)current_color.red / div);
   XmScaleSetValue(green_slider, (int)current_color.green / div);
   XmScaleSetValue(blue_slider, (int)current_color.blue / div);

   max_col = (int)current_color.red;
   if ((int)current_color.green > max_col) max_col = (int)current_color.green;
   if ((int)current_color.blue > max_col) max_col = (int)current_color.blue;
   XmScaleSetValue(dark_slider, max_col / div);
   last_pos5 = max_col/div;

   min_col = (int)current_color.red;
   if ((int)current_color.green < min_col) min_col = (int)current_color.green;
   if ((int)current_color.blue < min_col) min_col = (int)current_color.blue;
   XmScaleSetValue(light_slider, min_col / div);
   last_pos4 = min_col/div;
   last_moved = 0;
}

static void copy_current_pixel(Widget w, XtPointer client_data, 
                               XtPointer call_data)
{
   int i, n;
   int div;
   int max_col,min_col;
   char msgbuf[256];
   char str[30];
   Widget message_box;
   int number = (int)client_data;
                   
   if (XmToggleButtonGadgetGetState(action[3]) == True) {
      /* copy color to working color */
      div = 256;
      current_color.flags = DoRed | DoGreen | DoBlue;

      /* Get the current color components of the selected button */

      current_color.pixel = color_pixel[number];
      XQueryColor(display, default_cmap, &current_color);

      /* Set the slider values to the respective RGB positions */

      XmScaleSetValue(red_slider, (int)current_color.red / div);
      XmScaleSetValue(green_slider, (int)current_color.green / div);
      XmScaleSetValue(blue_slider, (int)current_color.blue / div);

      max_col = (int)current_color.red;
      if ((int)current_color.green > max_col) 
         max_col = (int)current_color.green;
      if ((int)current_color.blue > max_col) max_col = (int)current_color.blue;
      XmScaleSetValue(dark_slider, max_col / div);
      last_pos5 = max_col/div;

      min_col = current_color.red;
      if ((int)current_color.green < min_col) 
         min_col = (int)current_color.green;
      if ((int)current_color.blue < min_col) min_col = (int)current_color.blue;
      XmScaleSetValue(light_slider, min_col / div);
      last_pos4 = min_col/div;
      last_moved = 0;

      current_color.pixel = color_pixel[ncolors-1];
      color_save[ncolors-1] = current_color;
      update_color();
      }
   else if (XmToggleButtonGadgetGetState(action[2]) == True) {
      /* replace a color */
      if (value_contrast != 0) {
         strcpy(msgbuf,
                "Contrast must be set to zero before replacing a color.");
         message_box = DisplayMsg(bb,msgbuf,1);
         XtManageChild (message_box);
         }
      else {
         current_color.flags = DoRed | DoGreen | DoBlue;

         /* Get the current color components of the working color */
         current_color.pixel = color_pixel[ncolors-1];
         XQueryColor(display, default_cmap, &current_color);

         current_color.pixel = color_pixel[number];
         color_save[number] = current_color;
         update_color();
         }
      }
   else if (XmToggleButtonGadgetGetState(action[1]) == True) {
      /* delete a color */
      if (num_colors > 2) {
         for (i=number; i<num_colors-1; i++) {
            current_color.pixel = color_pixel[i+1];
            XQueryColor(display, default_cmap, &current_color);
            current_color.pixel = color_pixel[i];
            color_save[i] = current_color;
            }
         num_colors--;
         update_color();
         XtUnmanageChild(button[num_colors]);

         /* Reset current_color to the working color */
         current_color.pixel = color_pixel[ncolors-1];
         XQueryColor(display, default_cmap, &current_color);

         count_add_del--;
         UpdateLimits();
         }
      }
   else if (XmToggleButtonGadgetGetState(action[0]) == True) {
      /* insert a color */
      if (num_colors < 40) {
         for (i=num_colors; i>number+1; i--) {
            current_color.pixel = color_pixel[i-1];
            XQueryColor(display, default_cmap, &current_color);
            current_color.pixel = color_pixel[i];
            color_save[i] = current_color;
            }
         current_color.pixel = color_pixel[ncolors-1];
         XQueryColor(display, default_cmap, &current_color);
         current_color.pixel = color_pixel[number+1];
         color_save[number+1] = current_color;

         XtManageChild(button[num_colors]);
         num_colors++;
         update_color();

         count_add_del++;
         UpdateLimits();
         }
      }
   else if (XmToggleButtonGadgetGetState(action[4]) == True) {
      /* set breakpoint for interpolation */
      if (interp_flag[number] == 0) {
         interp_flag[number] = 1;
         sprintf(str,"*%5d", number+1);
         }
      else {
         interp_flag[number] = 0;
         sprintf(str,"%6d", number+1);
         }
      n = 0;
      XtSetArg(wargs[n], XmNlabelString,
               XmStringCreateLocalized(str)); n++;
      XtSetValues (button[number],wargs,n);
      }
}

static void create_option_menu(Widget parent)
{
   int n;
   Widget push1, push1a, push2, push3;
   Widget w, rc, rca, rc0, rcok;
   Widget action_text,toggle_action;
   Widget controls;
   char *tag = XmFONTLIST_DEFAULT_TAG;

   n = 0;

   if (type_code == 0) { XtSetArg(wargs[n], XmNx, 200); n++; }
   else { XtSetArg(wargs[n], XmNx, 100); n++; }

   XtSetArg(wargs[n], XmNy, 0); n++;
   XtSetArg(wargs[n], XmNmarginHeight, 0); n++;
   XtSetArg(wargs[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
   rca = XtCreateManagedWidget("coloroptions", xmRowColumnWidgetClass,
                  parent, wargs, n);

   n = 0;
   XtSetArg(wargs[n], XmNorientation, XmHORIZONTAL ); n++;
   XtSetArg(wargs[n], XmNpacking, XmPACK_COLUMN); n++;
   XtSetArg(wargs[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
   rc = XtCreateManagedWidget("rc", xmRowColumnWidgetClass,rca, wargs, n);
   n = 0;
   XtSetArg(wargs[n], XmNspacing, 1); n++;
   XtSetArg(wargs[n], XmNpacking, XmPACK_COLUMN); n++;
   XtSetArg(wargs[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
   rc0 = XtCreateManagedWidget("rc", xmRowColumnWidgetClass, rc, wargs, n);

   n = 0;
   XtSetArg(wargs[n], XmNlabelString, 
            XmStringCreateLtoR("\nPLTR Cards",tag)); n++;
   w = XtCreateManagedWidget("Cards", xmLabelGadgetClass,rc0, wargs, n);


   n = 0;
   XtSetArg(wargs[n], XmNheight, 50); n++;
   w = XtCreateManagedWidget("Load", xmPushButtonGadgetClass, rc0,wargs, n);
   XtAddCallback(w, XmNactivateCallback, color_cb, (XtPointer)LOAD_PLTR);
   XmAddTabGroup(w);

   n = 0;
   w = XtCreateManagedWidget("Save", xmPushButtonGadgetClass, rc0, wargs, n);
   XtAddCallback(w, XmNactivateCallback, color_cb, (XtPointer)SAVE_PLTR);
   XmAddTabGroup(w);

   n = 0;
   XtSetArg(wargs[n], XmNspacing, 1); n++;
   XtSetArg(wargs[n], XmNpacking, XmPACK_COLUMN); n++;
   XtSetArg(wargs[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
   rc0 = XtCreateManagedWidget("rc", xmRowColumnWidgetClass, rc, wargs, n);

   n = 0;
   XtSetArg(wargs[n], XmNlabelString, 
            XmStringCreateLtoR("\nPalettes",tag)); n++;
   w = XtCreateManagedWidget("\nPalettes", xmLabelGadgetClass, rc0, wargs, n);

   n = 0;
   w = XtCreateManagedWidget("Load", xmPushButtonGadgetClass, rc0, wargs, n);
   XtAddCallback(w, XmNactivateCallback, color_cb, (XtPointer)LOAD_PAL);
   button_loadpal = w;
   XmAddTabGroup(w);

   n = 0;
   w = XtCreateManagedWidget("Save", xmPushButtonGadgetClass, rc0, wargs, n);
   XtAddCallback(w, XmNactivateCallback, color_cb, (XtPointer)SAVE_PAL);
   XmAddTabGroup(w);

   n = 0;
   w = XtCreateManagedWidget("Delete", xmPushButtonGadgetClass, rc0, wargs, n);
   XtAddCallback(w, XmNactivateCallback, color_cb, (XtPointer)DELETE_PAL);
   button_delpal = w;
   XmAddTabGroup(w);

   n = 0;
   XtSetArg(wargs[n], XmNspacing, 1); n++;
   XtSetArg(wargs[n], XmNpacking, XmPACK_COLUMN); n++;
   XtSetArg(wargs[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
   rc0 = XtCreateManagedWidget("rc", xmRowColumnWidgetClass, rc, wargs, n);

   n = 0;
   XtSetArg(wargs[n], XmNheight, 30); n++;
   w = XtCreateManagedWidget("Gray Scale",xmPushButtonGadgetClass,rc0,wargs,n);
   XtAddCallback(w, XmNactivateCallback, color_cb, (XtPointer)GRAY_SCALE);
   XmAddTabGroup(w);

   n = 0;
   XtSetArg(wargs[n], XmNheight, 30); n++;
   XtSetArg(wargs[n], XmNlabelString, 
      XmStringCreateLtoR("Interpolate\nColors",tag)); n++;
   w = XtCreateManagedWidget("Interpolate\nColors", xmPushButtonGadgetClass,
                             rc0, wargs, n);
   XtAddCallback(w, XmNactivateCallback, color_cb,(XtPointer) COLOR_INTERP);
   XmAddTabGroup(w);

   if (type_code == 0) {
      n = 0;
      w = XtCreateManagedWidget("Change Limits", xmPushButtonGadgetClass, rc0,
                                wargs, n);
      XtAddCallback(w, XmNactivateCallback, color_cb, (XtPointer)CHANGE_LIMITS);
      XmAddTabGroup(w);
      }

   n = 0;
   XtSetArg(wargs[n], XmNspacing, 1); n++;
   XtSetArg(wargs[n], XmNpacking, XmPACK_TIGHT); n++;
   XtSetArg(wargs[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
   rc0 = XtCreateManagedWidget("rc", xmRowColumnWidgetClass,rc, wargs, n);

   contrast_slider = make_slider(contrast, rc0, 100, -50, 1);

   brightness_slider = make_slider(brightness, rc0, 100, -50, 1);

   n = 0;
   XtSetArg(wargs[n], XmNmarginWidth, 0); n++;
   XtSetArg(wargs[n], XmNheight, 20); n++;
   w = XtCreateManagedWidget("Reset Slider",xmPushButtonGadgetClass,rc0,
                             wargs,n);
   XtAddCallback(w, XmNactivateCallback, color_cb, (XtPointer)RESET_SLIDER);
   XmAddTabGroup(w);

   n = 0;
   w = XmCreateSeparatorGadget(rca, "sepe", wargs, n);
   XtManageChild(w);

   /* allow user to set option to determine what will happen when
      a color button is clicked */

   n = 0;
   XtSetArg(wargs[n], XmNlabelString, 
   XmStringCreateLtoR(" \nAction when palette color is picked:",tag)); n++;
   action_text = XtCreateManagedWidget("action_text", xmLabelGadgetClass,
                                       rca, wargs, n);

   n = 0;
   XtSetArg(wargs[n], XmNmarginHeight, 0); n++;
   XtSetArg(wargs[n], XmNnumColumns, 2 ); n++;
   XtSetArg(wargs[n], XmNpacking, XmPACK_COLUMN); n++;
   XtSetArg(wargs[n], XmNorientation, XmVERTICAL ); n++;
   XtSetArg(wargs[n], XmNspacing, 4); n++;
   XtSetArg(wargs[n], XmNradioBehavior, True); n++;
   XtSetArg(wargs[n], XmNradioAlwaysOne, True); n++;
   toggle_action = XtCreateWidget("toggle_action", xmRowColumnWidgetClass, rca,
                                  wargs, n);
   XtManageChild(toggle_action);

   n = 0;
   XtSetArg(wargs[n], XmNlabelString, 
            XmStringCreateLocalized("Insert Working Color above")); n++;
   XtSetArg(wargs[n], XmNset, True); n++;
   action[0] = XtCreateWidget("button0",xmToggleButtonGadgetClass,
                               toggle_action, wargs, n);
   XtManageChild(action[0]);

   n = 0;
   XtSetArg(wargs[n], XmNlabelString, 
            XmStringCreateLocalized("Delete")); n++;
   XtSetArg(wargs[n], XmNset, True); n++;
   action[1] = XtCreateWidget("button1",xmToggleButtonGadgetClass,
                              toggle_action, wargs, n);
   XtManageChild(action[1]);

   n = 0;
   XtSetArg(wargs[n], XmNlabelString,
            XmStringCreateLocalized("Replace with Working Color")); n++;
   XtSetArg(wargs[n], XmNset, True); n++;
   action[2] = XtCreateWidget("button2",xmToggleButtonGadgetClass,
                              toggle_action,wargs,n);
   XtManageChild(action[2]);

   n = 0;
   XtSetArg(wargs[n], XmNlabelString,
            XmStringCreateLocalized("Copy to Working Color")); n++;
   XtSetArg(wargs[n], XmNset, True); n++;
   action[3] = XtCreateWidget("button3",xmToggleButtonGadgetClass,
                              toggle_action, wargs, n);
   XtManageChild(action[3]);

   n = 0;
   XtSetArg(wargs[n], XmNlabelString, 
            XmStringCreateLtoR("Set Interpolation\nBreakpoints",tag)); n++;
   XtSetArg(wargs[n], XmNset, True); n++;
   action[4] = XtCreateWidget("button4",xmToggleButtonGadgetClass,
                              toggle_action, wargs, n);
   XtManageChild(action[4]);

   XmToggleButtonGadgetSetState(action[0], False, False);
   XmToggleButtonGadgetSetState(action[1], False, False);
   XmToggleButtonGadgetSetState(action[2], False, False);
   XmToggleButtonGadgetSetState(action[3], True, False);
   XmToggleButtonGadgetSetState(action[4], False, False);

   n = 0;
   w = XmCreateSeparatorGadget(rca, "sepe", wargs, n);
   XtManageChild(w);

   /* Create a row column widget containing three sliders,
      one for each color component. */
   n = 0;
   XtSetArg(wargs[n], XmNmarginHeight, 20); n++;
   XtSetArg(wargs[n], XmNpacking, XmPACK_TIGHT); n++;
   XtSetArg(wargs[n], XmNorientation, XmHORIZONTAL ); n++;
   XtSetArg(wargs[n], XmNspacing, 5); n++;
   controls = XtCreateManagedWidget("sliderpanel", xmRowColumnWidgetClass,
                                    rca, wargs, n);

   /* Create working color button */
   n = 0;
   XtSetArg(wargs[n], XmNheight, 255); n++;
   XtSetArg(wargs[n], XmNbackground, color_pixel[ncolors-1]); n++;
   XtSetArg(wargs[n], XmNmarginHeight, 15); n++;
   XtSetArg(wargs[n], XmNlabelString, 
      XmStringCreateLtoR(
         " w \n o \n r \n k \n i \n n \n g \n  \n c \n o \n l \n o \n r ",
         tag)); n++;
   button[ncolors-1] = XtCreateManagedWidget(" ", xmPushButtonWidgetClass,
                                             controls, wargs, n);

   red_slider = make_slider(red, controls, 255, 0, 0);
   green_slider = make_slider(green, controls, 255, 0, 0);
   blue_slider = make_slider(blue, controls, 255, 0, 0);
   light_slider = make_slider(light, controls, 255, 0, 0);
   dark_slider = make_slider(dark, controls, 255, 0, 0);

   set_current_pixel(color_pixel[ncolors-1]);

   n = 0;
   XtSetArg(wargs[n], XmNborderWidth, 20); n++;
   XtSetArg(wargs[n], XmNheight, 20); n++;
   w = XmCreateSeparatorGadget(rca, "sepe", wargs, n);
   XtManageChild(w);

   /* quit button */
   n = 0;
   XtSetArg(wargs[n], XmNorientation, XmHORIZONTAL); n++;
   XtSetArg(wargs[n], XmNpacking, XmPACK_COLUMN); n++;
   XtSetArg(wargs[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
   XtSetArg(wargs[n], XmNspacing,50); n++;
   XtSetArg(wargs[n], XmNmarginHeight,0); n++;
   XtSetArg(wargs[n], XmNmarginWidth, 30); n++;
   rcok = XmCreateRowColumn(rca, "rcok", wargs, n);
   XtManageChild (rcok);
 
   n = 0;
   XtSetArg(wargs[n], XmNshowAsDefault, 1); n++;
   push1 = XtCreateManagedWidget("OK", xmPushButtonGadgetClass,rcok,wargs,n);
   XtAddCallback(push1, XmNactivateCallback, color_cb, (XtPointer)COLOR_EXIT);
   XmAddTabGroup(push1);

   n = 0;
   push1a = XtCreateManagedWidget("Apply",xmPushButtonGadgetClass,rcok,wargs,n);
   XtAddCallback(push1a, XmNactivateCallback, color_cb, (XtPointer)COLOR_APPLY);
   XmAddTabGroup(push1a);

   n = 0;
   push2 = XtCreateManagedWidget("Cancel",xmPushButtonGadgetClass,rcok,wargs,n);
   XtAddCallback(push2, XmNactivateCallback, color_cb,(XtPointer) COLOR_CANCEL);
   XtAddCallback(bb, XmNunmapCallback, color_cb,(XtPointer) COLOR_UNMAP);

   n = 0;
   push3 = XtCreateManagedWidget("Help",xmPushButtonGadgetClass,rcok,wargs,n);
   XtAddCallback(push3,XmNactivateCallback,color_cb,(XtPointer)COLOR_HELP);

   n = 0;
   XtSetArg(wargs[n], XmNdefaultButton, push1); n++;
   XtSetArg(wargs[n], XmNcancelButton, push2); n++;
   XtSetValues(parent,wargs,n);
}

static void UpdateScreen()
{
   int i;
   unsigned short mult = 256;

   for (i=0; i<opt1_num; i++) {
      current_color.red   = clr_rr[opt1_num-i-1] * mult;
      current_color.green = clr_gg[opt1_num-i-1] * mult;
      current_color.blue  = clr_bl[opt1_num-i-1] * mult;

      current_color.pixel = color_pixel[i];

      color_save[i] = current_color;
      }

   value_contrast = 0;
   value_brightness = 0;
   XmScaleSetValue(contrast_slider, value_contrast);
   XmScaleSetValue(brightness_slider, value_brightness);

   /* Update the color button. */
   update_color();

   linlog = opt1_type;
   boundary1 = 0.;
   boundary2 = opt1_lin_high;
   incr_linear = opt1_lin_int;
   boundary3 = opt1_db_zero;
   incr_db = opt1_db_int;

   strcpy(opt1_str2,"0.");
   parm_temp[0] = &opt1_str0[0];
   parm_temp[1] = &opt1_str1[0];
   parm_temp[2] = &opt1_str2[0];
   parm_temp[3] = &opt1_str3[0];
   parm_temp[4] = &opt1_str4[0];

   for (i=0; i<5; i++) limitvalue[i] = parm_temp[i];

   if (num_colors < opt1_num) {
      for (i=num_colors; i<opt1_num; i++)
         XtManageChild(button[i]);
      num_colors = opt1_num;
      }
   else if (num_colors > opt1_num) {
      for (i=num_colors-1; i>opt1_num-1; i--)
         XtUnmanageChild(button[i]);
      num_colors = opt1_num;
      }
   count_add_del = 0;
   UpdateLimits();
}

static void UpdateLimits()
{
   int i;
   char str[30];
   setzlm();

   for (i=ncolors-3; i>=0; i--) {
      sprintf(str, "%-14.7g", color_limits[i]);
      if (i > num_colors-2) strcpy(str," ");
      XtSetArg(wargs[0], XmNlabelString,XmStringCreateLocalized(str));
      XtSetValues(limits[i], wargs, 1);
      }

   /* Reset current_color to the working color */
   current_color.pixel = color_pixel[ncolors-1];
   XQueryColor(display, default_cmap, &current_color);
}

static void OpenCardFile()
{
   struct colr1rec colr1data;
   struct colr2rec colr2data;
   struct color_code color_data;
   FILE *fp;
   char msgbuf[256];
   Widget message_box;
   char line[82], *buffer;
   char temp[11];
   int i;
   int clr_bb[40], clr_yy[40], clr_mm[40], clr_cc[40];
   int color_count;
   int sum1, sum2;


   opt1_num = 0;
   if ((fp = fopen(cardfilename, "r")) == NULL) {
      strcpy(msgbuf,"Unable to open parameter file\n");
      strncat(msgbuf,cardfilename,sizeof(msgbuf)-strlen(msgbuf)-1);
      msgbuf[sizeof(msgbuf)-1] = '\0';
      message_box = DisplayMsg(bb,msgbuf,5);
      XtManageChild (message_box);
      return;
      }

   /* read first record */
   buffer = &line[0];
   if (fgets(buffer, sizeof(line), fp) == NULL) {
      strcpy(msgbuf,"Unable to read data from file\n");
      strncat(msgbuf,cardfilename,sizeof(msgbuf)-strlen(msgbuf)-1);
      msgbuf[sizeof(msgbuf)-1] = '\0';
      message_box = DisplayMsg(bb,msgbuf,5);
      XtManageChild (message_box);
      fclose(fp);
      return;
      }

   for (i=0; i<40; i++) {
      clr_bb[i] = 0;
      clr_yy[i] = 0;
      clr_mm[i] = 0;
      clr_cc[i] = 0;
      }
   color_count = 0;
   sum1 = 0;
   sum2 = 0;

   while(1) {
      if (strncmp(buffer,"1COLR",5) == 0) {
         sum1++;
         memcpy(colr1data.colr1, line, 80);

         memcpy(temp, colr1data.interval_lin, 10);
         temp[10] = '\0';
         for (i=9; i>=0; i--) {
            if (temp[i] == ' ') temp[i] = '0';
            else break;
            }
         opt1_lin_int = atof(temp);
         if (opt1_lin_int == 0.) {
            opt1_lin_int = 409.4;
            strcpy(temp,"409.4");
            }
         strcpy(opt1_str1,temp);

         memcpy(temp, colr1data.level_high, 10);
         temp[10] = '\0';
         for (i=9; i>=0; i--) {
            if (temp[i] == ' ') temp[i] = '0';
            else break;
            }
         opt1_lin_high = atof(temp);
         if (opt1_lin_high == 0.) {
            opt1_lin_high = 1.;
            strcpy(temp,"1.");
            }
         strcpy(opt1_str0,temp);

         memcpy(temp, colr1data.interval_db, 5);
         temp[5] = '\0';
         for (i=4; i>=0; i--) {
            if (temp[i] == ' ') temp[i] = '0';
            else break;
            }
         opt1_db_int = atof(temp);
         if (opt1_db_int == 0.) {
            opt1_db_int = 2.;
            strcpy(temp,"2.");
            }
         strcpy(opt1_str3,temp);

         memcpy(temp, colr1data.zero_db_value, 10);
         temp[10] = '\0';
         for (i=9; i>=0; i--) {
            if (temp[i] == ' ') temp[i] = '0';
            else break;
            }
         opt1_db_zero = atof(temp);
         if (opt1_db_zero == 0.) {
            opt1_db_zero = 1.;
            strcpy(temp,"1.");
            }
         strcpy(opt1_str4,temp);

         memcpy(temp, colr1data.numclr, 2);
         temp[2] = '\0';
         for (i=1; i>=0; i--) {
            if (temp[i] == ' ') temp[i] = '0';
            else break;
            }
         opt1_num = atoi(temp);
         if (opt1_num > 40) opt1_num = 40;

         if (strncmp(colr1data.incr,"db ",3) == 0 ||
             strncmp(colr1data.incr,"DB ",3) == 0 ||
             strncmp(colr1data.incr," db",3) == 0 ||
             strncmp(colr1data.incr," DB",3) == 0 ||
             strncmp(colr1data.incr," dB",3) == 0 ||
             strncmp(colr1data.incr," Db",3) == 0 ||
             strncmp(colr1data.incr,"dB ",3) == 0 ||
             strncmp(colr1data.incr,"Db ",3) == 0 )
            opt1_type = 2;
         else 
            opt1_type = 1;
         }
      else if (strncmp(buffer,"2COLR",5) == 0 && color_count < 40) {
         sum2++;
         memcpy(colr2data.colr2, line, 80);
         memcpy(color_data.color_bb  , colr2data.color_code1, 8);
         memcpy(temp, color_data.color_bb, 2);
         temp[2] = '\0';
         clr_bb[color_count] = atoi(temp);
         memcpy(temp, color_data.color_yy, 2);
         temp[2] = '\0';
         clr_yy[color_count] = atoi(temp);
         memcpy(temp, color_data.color_mm, 2);
         temp[2] = '\0';
         clr_mm[color_count] = atoi(temp);
         memcpy(temp, color_data.color_cc, 2);
         temp[2] = '\0';
         clr_cc[color_count] = atoi(temp);
         ymcrgb (clr_cc[color_count], clr_mm[color_count],
                 clr_yy[color_count], clr_bb[color_count],
                 &clr_rr[color_count], &clr_gg[color_count],
                 &clr_bl[color_count]);
         color_count++;

         memcpy(color_data.color_bb  , colr2data.color_code2, 8);
         memcpy(temp, color_data.color_bb, 2);
         temp[2] = '\0';
         clr_bb[color_count] = atoi(temp);
         memcpy(temp, color_data.color_yy, 2);
         temp[2] = '\0';
         clr_yy[color_count] = atoi(temp);
         memcpy(temp, color_data.color_mm, 2);
         temp[2] = '\0';
         clr_mm[color_count] = atoi(temp);
         memcpy(temp, color_data.color_cc, 2);
         temp[2] = '\0';
         clr_cc[color_count] = atoi(temp);
         ymcrgb (clr_cc[color_count], clr_mm[color_count],
                 clr_yy[color_count], clr_bb[color_count],
                 &clr_rr[color_count], &clr_gg[color_count],
                 &clr_bl[color_count]);
         color_count++;

         memcpy(color_data.color_bb  , colr2data.color_code3, 8);
         memcpy(temp, color_data.color_bb, 2);
         temp[2] = '\0';
         clr_bb[color_count] = atoi(temp);
         memcpy(temp, color_data.color_yy, 2);
         temp[2] = '\0';
         clr_yy[color_count] = atoi(temp);
         memcpy(temp, color_data.color_mm, 2);
         temp[2] = '\0';
         clr_mm[color_count] = atoi(temp);
         memcpy(temp, color_data.color_cc, 2);
         temp[2] = '\0';
         clr_cc[color_count] = atoi(temp);
         ymcrgb (clr_cc[color_count], clr_mm[color_count],
                 clr_yy[color_count], clr_bb[color_count],
                 &clr_rr[color_count], &clr_gg[color_count],
                 &clr_bl[color_count]);
         color_count++;

         memcpy(color_data.color_bb  , colr2data.color_code4, 8);
         memcpy(temp, color_data.color_bb, 2);
         temp[2] = '\0';
         clr_bb[color_count] = atoi(temp);
         memcpy(temp, color_data.color_yy, 2);
         temp[2] = '\0';
         clr_yy[color_count] = atoi(temp);
         memcpy(temp, color_data.color_mm, 2);
         temp[2] = '\0';
         clr_mm[color_count] = atoi(temp);
         memcpy(temp, color_data.color_cc, 2);
         temp[2] = '\0';
         clr_cc[color_count] = atoi(temp);
         ymcrgb (clr_cc[color_count], clr_mm[color_count],
                 clr_yy[color_count], clr_bb[color_count],
                 &clr_rr[color_count], &clr_gg[color_count],
                 &clr_bl[color_count]);
         color_count++;

         memcpy(color_data.color_bb  , colr2data.color_code5, 8);
         memcpy(temp, color_data.color_bb, 2);
         temp[2] = '\0';
         clr_bb[color_count] = atoi(temp);
         memcpy(temp, color_data.color_yy, 2);
         temp[2] = '\0';
         clr_yy[color_count] = atoi(temp);
         memcpy(temp, color_data.color_mm, 2);
         temp[2] = '\0';
         clr_mm[color_count] = atoi(temp);
         memcpy(temp, color_data.color_cc, 2);
         temp[2] = '\0';
         clr_cc[color_count] = atoi(temp);
         ymcrgb (clr_cc[color_count], clr_mm[color_count],
                 clr_yy[color_count], clr_bb[color_count],
                 &clr_rr[color_count], &clr_gg[color_count],
                 &clr_bl[color_count]);
         color_count++;
         }
      if (fgets(buffer, sizeof(line), fp) == NULL) break;
      }
   fclose(fp);

   if (sum1 == 0 && sum2 == 0) {
      strcpy(msgbuf,"File does not contain any 1PLTR or 2PLTR cards\n");
      strncat(msgbuf,cardfilename,sizeof(msgbuf)-strlen(msgbuf)-1);
      msgbuf[sizeof(msgbuf)-1] = '\0';
      message_box = DisplayMsg(bb,msgbuf,5);
      XtManageChild (message_box);
      return;
      }

   if (sum1 == 0) {
      strcpy(msgbuf,"File does not contain any 1PLTR\n"
                    "Both 1PLTR and 2PLTR cards are required.\n");
      strncat(msgbuf,cardfilename,sizeof(msgbuf)-strlen(msgbuf)-1);
      msgbuf[sizeof(msgbuf)-1] = '\0';
      message_box = DisplayMsg(bb,msgbuf,5);
      XtManageChild (message_box);
      return;
      }

   if (sum2 == 0) {
      strcpy(msgbuf,"File does not contain any 2PLTR\n"
                    "Both 1PLTR and 2PLTR cards are required.\n");
      strncat(msgbuf,cardfilename,sizeof(msgbuf)-strlen(msgbuf)-1);
      msgbuf[sizeof(msgbuf)-1] = '\0';
      message_box = DisplayMsg(bb,msgbuf,5);
      XtManageChild (message_box);
      opt1_num = 0;
      return;
      }
}

static int SavePLTRFile()
{
   struct colr1rec colr1data;
   struct colr2rec colr2data;
   struct color_code color_data;
   Widget message_box;
   double incr_actual;
   int i, j, md;
   int y,m,c;
   int div;
   char temp[11], temp2[11];
   char msgbuf[80];


   if ((tfp = fopen(pltrfilename, "w")) == NULL) {
      sprintf(msgbuf,"Unable to open file for write access");
      message_box = DisplayMsg(bb,msgbuf,1);
      XtManageChild (message_box);
      return False;
      }
   memset(colr1data.colr1,' ',80);

   memcpy(colr1data.colr1, "1COLR", 5);

   if (linlog == 2)
      memcpy(colr1data.incr," DB",3);
   else
      memcpy(colr1data.incr, "LIN", 3);

   sprintf(temp,"%10s",limitvalue[0]);
   for (i=9; i>=0; i--) {
      if (temp[i] != ' ') {
         temp[i+1] = '\0';
         sprintf(temp2,"%10s", temp);
         strcpy(temp,temp2);
         break;
         }
      }
   memcpy(colr1data.level_high, temp, 10);

   if (incr_linear == 0.) {
      incr_actual = (boundary2 - boundary1) / (num_colors-2);
      sprintf(temp,"%10.9g",incr_actual);
      }
   else {
      sprintf(temp,"%10s",limitvalue[1]);
      for (i=9; i>=0; i--) {
         if (temp[i] != ' ') {
            temp[i+1] = '\0';
            sprintf(temp2,"%10s", temp);
            strcpy(temp,temp2);
            break;
            }
         }
      }
   memcpy(colr1data.interval_lin, temp, 10);

   sprintf(temp,"%10s",limitvalue[3]);
   for (i=9; i>=0; i--) {
      if (temp[i] != ' ') {
         temp[i+1] = '\0';
         sprintf(temp2,"%10s", temp);
         strcpy(temp,temp2);
         break;
         }
      }
   memcpy(colr1data.interval_db, temp, 10);

   sprintf(temp,"%10s",limitvalue[4]);
   for (i=9; i>=0; i--) {
      if (temp[i] != ' ') {
         temp[i+1] = '\0';
         sprintf(temp2,"%10s", temp);
         strcpy(temp,temp2);
         break;
         }
      }
   memcpy(colr1data.zero_db_value, temp, 10);

   sprintf(temp,"%2d",num_colors);
   memcpy(colr1data.numclr, temp, 2);

   /* write to a temp file */
   fwrite(&colr1data, sizeof(char), sizeof(colr1data), tfp);
   fputs("\n",tfp);

   div = 256;
   sprintf(temp,"2COLR");
   memcpy(colr2data.colr2, temp, 5);
   memset(colr2data.blank6,' ',75);
   j = 0;

   for (i=num_colors-1; i>=0; i--) {
      md = j % 5;
      if (md == 0) memset(colr2data.blank6,' ',75);

      current_color.pixel = color_pixel[i];
      XQueryColor(display, default_cmap, &current_color);
      rgbymc((int)current_color.red/div,(int)current_color.green/div,
             (int)current_color.blue/div,&y, &m, &c);

      sprintf (temp, " 0%2d%2d%2d", y,m,c);
      memcpy(color_data.color_bb, temp, 8);

      if (md == 0) memcpy(colr2data.color_code1, color_data.color_bb, 8);
      else if (md == 1) memcpy(colr2data.color_code2, color_data.color_bb, 8);
      else if (md == 2) memcpy(colr2data.color_code3, color_data.color_bb, 8);
      else if (md == 3) memcpy(colr2data.color_code4, color_data.color_bb, 8);
      else if (md == 4) memcpy(colr2data.color_code5, color_data.color_bb, 8);

      if (md == 4 || i == 0) {
         fwrite(&colr2data, sizeof(char), sizeof(colr2data), tfp);
         fputs("\n",tfp);
         }
      j++;
      }
 
   /* flush and close the temp file */
   if (fflush(tfp) != (int)NULL) fprintf(stderr,"Warning: unable to flush file.\n");
   if (fclose(tfp) != (int)NULL) fprintf(stderr,"Warning: unable to close file.\n");

   return True;
}

static void OpenOutputPLTR()
{
   if ((tfp = fopen(pltrfilename, "r")) != NULL) {
      fclose(tfp);
      /* file already exists - pop up menu to see what user wants to do */
      if( file_dialog == NULL ) create_pltrfile_menu();

      XtSetArg(wargs[0],XmNlabelString,XmStringCreateLocalized(pltrfilename));
      XtSetValues(file_label, wargs, 1);
      XmToggleButtonGadgetSetState(file_button[0], False, False);
      XmToggleButtonGadgetSetState(file_button[1], True, False);

      XtManageChild (file_dialog);
      return;
      }

   SavePLTRFile();
}

static void create_pltrfile_menu()
{
   Widget rc01,rc02,rc2,label,seper,push1;
   char* tag = XmFONTLIST_DEFAULT_TAG;
   int n;

   /* this is for saving a pltr file */
   if ( file_dialog != NULL) return;

   file_dialog = XmCreateFormDialog(bb, "save", NULL, 0 );

   n = 0;
   rc01 = XmCreateRowColumn(file_dialog, "workarea", NULL, 0 );
   XtManageChild(rc01);

   n = 0;
   XtSetArg(wargs[n], XmNlabelString,
            XmStringCreateLtoR("Output PLTR File Status Menu\n\n",tag)); n++;
   label = XmCreateLabelGadget(rc01, "label", wargs, n);
   XtManageChild(label);

   n=0;
   XtSetArg(wargs[n], XmNlabelString,
            XmStringCreateLocalized("Output PLTR file already exists:")); n++;
   label = XmCreateLabelGadget(rc01, "label", wargs, n);
   XtManageChild(label);

   /* dataset name will be put in this one */
   n=0;
   XtSetArg(wargs[n], XmNlabelString,XmStringCreateLocalized(" ")); n++;
   file_label = XmCreateLabelGadget(rc01, "label", wargs, n);
   XtManageChild(file_label);

   n=0;
   XtSetArg(wargs[n], XmNlabelString,XmStringCreateLocalized(" ")); n++;
   label = XmCreateLabelGadget(rc01, "label", wargs, n);
   XtManageChild(label);

   n = 0;
   XtSetArg(wargs[n], XmNorientation, XmHORIZONTAL); n++;
   XtSetArg(wargs[n], XmNradioAlwaysOne, True); n++;
   XtSetArg(wargs[n], XmNradioBehavior, True); n++;
   XtSetArg(wargs[n], XmNpacking, XmPACK_COLUMN); n++;
   XtSetArg(wargs[n], XmNnumColumns, 15); n++;
   XtSetArg(wargs[n], XmNspacing, 15); n++;
   rc02 = XmCreateRowColumn(rc01, "file", wargs, n);
   XtManageChild(rc02);

   n = 0;
   XtSetArg(wargs[n], XmNlabelString, 
            XmStringCreateLocalized("Replace Existing File")); n++;
   file_button[0] = XtCreateManagedWidget("button",xmToggleButtonGadgetClass,
                                          rc02,wargs,n);
   XmToggleButtonGadgetSetState(file_button[0], False, True);

   n = 0;
   XtSetArg(wargs[n],XmNlabelString,
            XmStringCreateLocalized("Cancel Save")); n++;
   file_button[1] = XtCreateManagedWidget("button",xmToggleButtonGadgetClass,
                                          rc02,wargs,n);
   XmToggleButtonGadgetSetState(file_button[0], False, True);
   XmToggleButtonGadgetSetState(file_button[1], True, False);

   n = 0;
   seper = XmCreateSeparatorGadget(rc01, "sepe", wargs, n);
   XtManageChild(seper);

   n = 0;
   XtSetArg(wargs[n], XmNorientation, XmHORIZONTAL); n++;
   XtSetArg(wargs[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
   XtSetArg(wargs[n], XmNspacing, 40); n++;
   XtSetArg(wargs[n], XmNpacking, XmPACK_COLUMN); n++;
   XtSetArg(wargs[n], XmNmarginHeight,10); n++;
   XtSetArg(wargs[n], XmNmarginWidth, 40); n++;
   rc2 = XmCreateRowColumn(rc01, "rc2", wargs, n);
   XtManageChild (rc2);

   n = 0;
   XtSetArg(wargs[n], XmNshowAsDefault, 1); n++;
   push1 = XmCreatePushButtonGadget(rc2, "OK", wargs, n);
   XtManageChild(push1);
   XtAddCallback(push1,XmNactivateCallback,color_cb,
                 (XtPointer)DIALOG_FILE_ACCEPT);

   n = 0;
   XtSetArg(wargs[n], XmNdefaultButton, push1); n++;
   XtSetValues(file_dialog,wargs,n);
}

static Widget CreateColorListMenu(Widget parent)
{
   XmString        list_item[200];
   static Widget   selection_box;
   Widget      wid;
   Arg al[10];
   int ac;
   int i;
   char *tag = XmFONTLIST_DEFAULT_TAG;
   
   static int first=1;

   for ( i = 0;  i < num_items;  i++ )
      list_item[i] = XmStringCreateLtoR (item[i], tag);

   if (first) {
      first = 0;
      ac = 0;
      XtSetArg (al[ac], XmNshadowThickness, 1);  ac++;
      XtSetArg (al[ac], XmNshadowType, XmSHADOW_OUT);  ac++;
      XtSetArg (al[ac], XmNtextString, list_item[0]);  ac++;
      XtSetArg (al[ac], XmNlistItems, list_item);  ac++;
      XtSetArg (al[ac], XmNlistItemCount, num_items);  ac++;
      XtSetArg (al[ac], XmNlistLabelString,
                XmStringCreateLocalized("Palettes Available for Loading:"));
               ac++;
      XtSetArg (al[ac], XmNselectionLabelString,
                XmStringCreateLocalized ("Active Dialog"));  ac++;
      selection_box = XmCreateSelectionBox (parent, "selection_box",al, ac);
      XtAddCallback (selection_box, XmNcancelCallback, color_cb,
                     (XtPointer)DIALOG_LOAD_CANCEL);
      XtAddCallback (selection_box,XmNokCallback, color_cb,
                     (XtPointer) DIALOG_LOAD_ACCEPT);

      wid = XmSelectionBoxGetChild (selection_box, XmDIALOG_HELP_BUTTON);
      XtUnmanageChild(wid);

      wid = XmSelectionBoxGetChild (selection_box, XmDIALOG_APPLY_BUTTON);
      XtUnmanageChild(wid);

      wid = XmSelectionBoxGetChild (selection_box, XmDIALOG_TEXT);
      if (XmIsTextField(wid))
         XmTextFieldSetEditable(wid,False);
      else
         XmTextSetEditable(wid,False);
      }
   else {
      ac = 0;
      XtSetArg (al[ac], XmNtextString, list_item[0]);  ac++;
      XtSetArg (al[ac], XmNlistItems, list_item);  ac++;
      XtSetArg (al[ac], XmNlistItemCount, num_items);  ac++;
      XtSetValues (selection_box, al, ac);
      }

   selected_item_index = 1;
   return(selection_box);
}

static Widget CreateDeleteColorListMenu(Widget parent)
{
   XmString        list_item[200];
   static Widget   selection_box;
   Widget      wid;
   Arg al[10];
   int ac;
   int i;
   char *tag = XmFONTLIST_DEFAULT_TAG;
   
   static int first=1;

   for ( i = 0;  i < num_items;  i++ )
      list_item[i] = XmStringCreateLtoR (item[i], tag);

   if (first) {
      first = 0;
      ac = 0;
      XtSetArg (al[ac], XmNshadowThickness, 1);  ac++;
      XtSetArg (al[ac], XmNshadowType, XmSHADOW_OUT);  ac++;
      XtSetArg (al[ac], XmNtextString, list_item[0]);  ac++;
      XtSetArg (al[ac], XmNlistItems, list_item);  ac++;
      XtSetArg (al[ac], XmNlistItemCount, num_items);  ac++;
      XtSetArg (al[ac], XmNlistLabelString,
                XmStringCreateLocalized("Palettes Available for Deletion:"));
               ac++;
      XtSetArg (al[ac], XmNselectionLabelString,
                XmStringCreateLocalized("Active Dialog"));  ac++;
      selection_box = XmCreateSelectionBox (parent, "selection_box", al, ac);

      XtAddCallback (selection_box,XmNcancelCallback,color_cb,
                     (XtPointer)DIALOG_DELETE_CANCEL);
      XtAddCallback (selection_box, XmNokCallback, color_cb,
                     (XtPointer)DIALOG_DELETE_ACCEPT);

      wid = XmSelectionBoxGetChild (selection_box, XmDIALOG_HELP_BUTTON);
      XtUnmanageChild(wid);

      wid = XmSelectionBoxGetChild (selection_box, XmDIALOG_APPLY_BUTTON);
      XtUnmanageChild(wid);

      wid = XmSelectionBoxGetChild (selection_box, XmDIALOG_TEXT);
      if (XmIsTextField(wid))
         XmTextFieldSetEditable(wid,False);
      else
         XmTextSetEditable(wid,False);
      }
   else {
      ac = 0;
      XtSetArg (al[ac], XmNtextString, list_item[0]);  ac++;
      XtSetArg (al[ac], XmNlistItems, list_item);  ac++;
      XtSetArg (al[ac], XmNlistItemCount, num_items);  ac++;
      XtSetValues (selection_box, al, ac);
      }

   selected_item_index = 1;
   return(selection_box);
}

static void color_cb(Widget w,XtPointer client_data, XtPointer call_data)
{
   int low, high;
   int red_low, green_low, blue_low;
   int red_high,green_high,blue_high;
   double red_incr, green_incr, blue_incr;
   int n, i, j;
   char *limitstr;
   Widget message_box;
   char msgbuf[256];
   char *tag = XmFONTLIST_DEFAULT_TAG;

   switch ((int)client_data) {
      case CHANGE_LIMITS:
         if (linlog == 1) {
            XmToggleButtonGadgetSetState(action[5], True, False);
            XmToggleButtonGadgetSetState(action[6], False, False);
            }
         else {
            XmToggleButtonGadgetSetState(action[6], True, False);
            XmToggleButtonGadgetSetState(action[5], False, False);
            }
        for (i=0; i<5; i++) {
           XmTextSetString (limit_text[i], limitvalue[i]);
           }
        XtManageChild(bbe);
        break;

      case DELETE_PAL:
         if (!openpalette("rb")) {
            getpalette();
            if (num_items > 0) {
               XtSetSensitive(button_delpal,False);
               XtSetSensitive(button_loadpal,False);
               deletecolorlist_dialog = CreateDeleteColorListMenu(bb);
               XtManageChild(deletecolorlist_dialog);
               selected_item_index = -1;
               }
            else {
               strcpy(msgbuf,"No palettes are available for deletion.");
               message_box = DisplayMsg(bb,msgbuf,5);
               XtManageChild (message_box);
               }
            }
         break;

      case LOAD_PAL:
         if (!openpalette("rb")) {
            getpalette();
            if (num_items > 0) {
               XtSetSensitive(button_delpal,False);
               XtSetSensitive(button_loadpal,False);
               colorlist_dialog = CreateColorListMenu(bb);
               XtManageChild(colorlist_dialog);
               selected_item_index = -1;
               }
            else {
               strcpy(msgbuf,"No palettes are available for loading.");
               message_box = DisplayMsg(bb,msgbuf,5);
               XtManageChild (message_box);
               }
            }
         break;

      case SAVE_PAL:
         XtManageChild(savepalette_dialog);
         break;

      case LOAD_PLTR:
         XtManageChild(colorcard_dialog);
         break;

      case SAVE_PLTR:
         n = 0;
         XtSetArg(wargs[n], XmNtextString,
                  XmStringCreateLocalized(pltrfilename));  n++;
         XtSetValues(save_dialog, wargs, n);
         XtManageChild (save_dialog);
         break;

      case GRAY_SCALE:
         if (num_colors > 1) {
            for (i=0; i<num_colors; i++) {
               current_color.red = (int)((float)(num_colors - i - 1) /
                                        (float)(num_colors - 1) * 255.) * 256;
               current_color.green = current_color.red;
               current_color.blue = current_color.red;
               current_color.pixel = color_pixel[i];
               color_save[i] = current_color;
               }

            current_color.pixel = color_pixel[ncolors-1];
            XQueryColor(display, default_cmap, &current_color);
            value_contrast = 0;
            value_brightness = 0;
            XmScaleSetValue(contrast_slider, value_contrast);
            XmScaleSetValue(brightness_slider, value_brightness);
            update_color();
            }
         break;

      case RESET_SLIDER:
         value_contrast = 0;
         value_brightness = 0;
         XmScaleSetValue(contrast_slider, value_contrast);
         XmScaleSetValue(brightness_slider, value_brightness);
         update_color();
         break;

      case COLOR_INTERP:
         low = -1;
         for (i=0; i<num_colors; i++) {
            if (interp_flag[i] == 1) {
               low = i;
               break;
               }
            }
         if (low < 0) break;
         for (i=low+1; i<num_colors; i++) {
            if (interp_flag[i] == 1) {
               high = i;

               current_color.pixel = color_pixel[low];
               XQueryColor(display, default_cmap, &current_color);

               red_low = current_color.red;
               green_low = current_color.green;
               blue_low = current_color.blue;

               current_color.pixel = color_pixel[high];
               XQueryColor(display, default_cmap, &current_color);

               red_high = current_color.red;
               green_high = current_color.green;
               blue_high = current_color.blue;

               red_incr = (double)(red_high - red_low) / (double)(high - low);
               green_incr = (double)(green_high - green_low) /
                            (double)(high - low);
               blue_incr = (double)(blue_high - blue_low) /
                           (double)(high - low);

               for (i=low+1,j=1; i<high; ++i,++j) {
                  current_color.red = red_low + (int)(j * red_incr);
                  if (current_color.red > 64408)
                     current_color.red = current_color.red / 256 * 256;
                  else
                     current_color.red = ((int)current_color.red + 128) /
                                         256 * 256;

                  current_color.green = green_low + (int)(j * green_incr);
                  if (current_color.green > 64408)
                     current_color.green = (int)current_color.green / 256 * 256;
                  else
                     current_color.green = ((int)current_color.green + 128) /
                                           256 * 256;

                  current_color.blue = blue_low + (int)(j * blue_incr);
                  if (current_color.blue > 64408)
                     current_color.blue = (int)current_color.blue / 256 * 256;
                  else
                     current_color.blue = ((int)current_color.blue + 128) /
                                          256 * 256;

                  current_color.pixel = color_pixel[i];
                  color_save[i] = current_color;
                  }
               update_color();
               low = high;
               }
            }

         current_color.pixel = color_pixel[ncolors-1];
         XQueryColor(display, default_cmap, &current_color);

         break;

      case COLOR_EXIT:
         map_flag = 1;
         if (count_add_del != 0) limits_change(default_cmap);
         count_add_del = 0;
         XtUnmanageChild(bb);
         apply = 0;
         break;

      case COLOR_HELP:
         XmTextSetString(helpText,help_text[0]);
         for (i = 1; i < sizeof(help_text)/sizeof(help_text[0]); i++) {
            XmTextPosition position;
            position = XmTextGetLastPosition(helpText);
            XmTextInsert(helpText,position,help_text[i]);
            }
         XtManageChild(colhelp);
         break;

      case COLOR_APPLY:
         limits_change(default_cmap);
         count_add_del = 0;
         apply = 1;
         break;

      case COLOR_UNMAP:
         if (map_flag == 0) color_cb(w, (XtPointer)COLOR_CANCEL, call_data);
         map_flag = 0;
         XtUnmanageChild(bb);
         break;

      case COLOR_CANCEL:
         map_flag = 2;
         XtUnmanageChild(bb);

         if (num_colors < num_colors_backup) {
            for (i=num_colors; i<num_colors_backup; i++)
               XtManageChild(button[i]);
            }
         else if (num_colors > num_colors_backup) {
            for (i=num_colors-1; i>num_colors_backup-1; i--)
               XtUnmanageChild(button[i]);
            }

         for (i=0; i< ncolors; i++) {
            color_save[i] = color_backup[i];
            }

         for (i=0; i<5; i++) limitvalue[i] = limitvalue_backup[i];

         count_add_del = 0;
         if ((num_colors != num_colors_backup ||
            linlog != linlog_backup ||
            linlog == 1 && (boundary1 != boundary1_backup ||
                            boundary2 != boundary2_backup ||
                            incr_linear != incr_linear_backup) ||
                            linlog == 2 && (boundary3 != boundary3_backup ||
                            incr_db != incr_db_backup) ) && apply == 1 )
            count_add_del = 1;

         num_colors = num_colors_backup;
         value_contrast = value_contrast_backup;
         value_brightness = value_brightness_backup;

         XmScaleSetValue(contrast_slider, value_contrast);
         XmScaleSetValue(brightness_slider, value_brightness);

         linlog = linlog_backup;
         boundary1 = boundary1_backup;
         boundary2 = boundary2_backup;
         boundary3 = boundary3_backup;
         incr_linear = incr_linear_backup;
         incr_db = incr_db_backup;
         UpdateLimits();
         if (count_add_del != 0) {
            count_add_del = 0;
            limits_change(default_cmap);
            }
         update_color();
         apply = 0;

         break;

      case DIALOG_CARD_CANCEL:
         XtUnmanageChild (colorcard_dialog);
         break;

      case DIALOG_CARD_ACCEPT:
         {
            XmFileSelectionBoxCallbackStruct *fcb =
               (XmFileSelectionBoxCallbackStruct *) call_data;

            /* get the filename from the file selection box */
            XmStringGetLtoR(fcb->value, tag, &cardfilename);
   
            XtUnmanageChild (colorcard_dialog);

            OpenCardFile();
            if (opt1_num > 0) UpdateScreen();
            XtFree(cardfilename);
         }
         break;

      case DIALOG_LIMIT_HELP:
         i = sizeof(help_text)/sizeof(help_text[0]) - 1;
         XmTextSetString(helpText,help_text[i]);
         XtManageChild(colhelp);
         break;

      case DIALOG_LIMIT_CANCEL:
         XtUnmanageChild (bbe);
         break;

      case DIALOG_LIMIT_ACCEPT:
         for (i=0; i < 5; i++) {
            limitstr = XmTextGetString (limit_text[i]);
            if (Float_Checks(limitstr)) {
               sprintf(msgbuf,"Value is not a valid number for %s",
                       limitstring[i]);
               message_box = DisplayMsg(bb,msgbuf,1);
               XtManageChild (message_box);
               XtFree(limitstr);
               break;
               }
            XtFree(limitstr);
            }

         if (atof(XmTextGetString (limit_text[0])) <= 
             atof(XmTextGetString (limit_text[2]))) {
            strcpy(msgbuf,"Maximum value must be greater than minimum value");
            message_box = DisplayMsg(bb,msgbuf,1);
            XtManageChild (message_box);
            break;
            }

         if (atof(XmTextGetString (limit_text[1])) < 0) {
            strcpy(msgbuf,"Linear increment cannot be negative");
            message_box = DisplayMsg(bb,msgbuf,1);
            XtManageChild (message_box);
            break;
            }

         if (atof(XmTextGetString (limit_text[3])) < 0.1 ||
             atof(XmTextGetString (limit_text[3])) > 50.) {
            strcpy(msgbuf,"dB increment is out of range");
            message_box = DisplayMsg(bb,msgbuf,1);
            XtManageChild (message_box);
            break;
            }

         if (XmToggleButtonGadgetGetState(action[6]) == True) 
            linlog = 2;
         else 
            linlog = 1;

         for (i=0; i < 5; i++) limitvalue[i] = XmTextGetString (limit_text[i]);
         boundary2 = atof(limitvalue[0]);
         incr_linear = atof(limitvalue[1]);
         boundary1 = atof(limitvalue[2]);
         incr_db = atof(limitvalue[3]);
         boundary3 = atof(limitvalue[4]);
         XtUnmanageChild (bbe);
         count_add_del = 999999;
         UpdateLimits();
         break;

      case DIALOG_SAVE_ACCEPT:
         {
            XmSelectionBoxCallbackStruct *scb =
                         (XmSelectionBoxCallbackStruct *) call_data;

            /* get the filename string from the file selection box */
            XmStringGetLtoR(scb->value, tag, &pltrfilename);
            OpenOutputPLTR();
            XtUnmanageChild (save_dialog);
         }
         break;

      case DIALOG_SAVE_CANCEL:
         break;

      case DIALOG_FILE_ACCEPT:
         if (XmToggleButtonGadgetGetState(file_button[0])) SavePLTRFile();
         XtUnmanageChild(file_dialog);
         break;

      case DIALOG_SAVEPALETTE_ACCEPT:
         if (!openpalette("r+b")) {
            if (appendpalette()) break;
            }
         XtUnmanageChild(savepalette_dialog);
         break;

      case DIALOG_SAVEPALETTE_CANCEL:
         XtUnmanageChild(savepalette_dialog);
         break;

      case DIALOG_LOAD_CANCEL:
         XtUnmanageChild(colorlist_dialog);
         XtSetSensitive(button_loadpal,True);
         XtSetSensitive(button_delpal,True);
         break;

      case DIALOG_LOAD_ACCEPT:
         {
            XmSelectionBoxCallbackStruct *scb =
                   (XmSelectionBoxCallbackStruct *) call_data;

            /* get the item string from the selection box */
            XmStringGetLtoR(scb->value, tag, &entry_name);
            for (i=0; i<num_items; i++) {
               if (strcmp(entry_name,item[i]) == 0) {
                  selected_item_index = i + 1;
                  break;
                  }
               }
            XtUnmanageChild(colorlist_dialog);
            if (!openpalette("rb")) setpalette();
            XtSetSensitive(button_loadpal,True);
            XtSetSensitive(button_delpal,True);
         }
         break;

      case DIALOG_DELETE_CANCEL:
         XtUnmanageChild(deletecolorlist_dialog);
         XtSetSensitive(button_loadpal,True);
         XtSetSensitive(button_delpal,True);
         break;

      case DIALOG_DELETE_ACCEPT:
         {
            XmSelectionBoxCallbackStruct *scb =
                   (XmSelectionBoxCallbackStruct *) call_data;

            /* get the item string from the selection box */
            XmStringGetLtoR(scb->value, tag, &entry_name);
            for (i=0; i<num_items; i++) {
               if (strcmp(entry_name,item[i]) == 0) {
                  selected_item_index = i + 1;
                  break;
                  }
               }
            XtUnmanageChild(deletecolorlist_dialog);
            if (!openpalette("r+b")) deletepalette();
            XtSetSensitive(button_loadpal,True);
            XtSetSensitive(button_delpal,True);
         }
         break;

      default:
         fprintf(stderr,"Warning: in color_cb\n");
         break;
      }
}

static void ymcrgb(int c,int  m,int  y,int  bk,unsigned short *r,
                   unsigned short *g,unsigned short *b)
{
   int cc,mm,yy;
   float rr, gg, bb;

   if (bk > 0) {
      cc = c + bk;
      mm = m + bk;
      yy = y + bk;
      if (cc > 16) cc = 16;
      if (mm > 16) mm = 16;
      if (yy > 16) yy = 16;
      }
   else {
      cc = c;
      mm = m;
      yy = y;
      }

   rr = 16 - cc;
   gg = 16 - mm;
   bb = 16 - yy;
     
   rr = (rr/16.) * 255.;
   gg = (gg/16.) * 255.;
   bb = (bb/16.) * 255.;

   *r = (unsigned short)rr;
   *g = (unsigned short)gg;
   *b = (unsigned short)bb;
}

static void rgbymc(int r,int g,int b,int *y,int *m,int *c)
{
   int im, ic, iy;
   float C, M, Y;

   C = 255. - r;
   M = 255. - g;
   Y = 255. - b;

   C = (C/255.)*16. + 0.5;
   M = (M/255.)*16. + 0.5;
   Y = (Y/255.)*16. + 0.5;

   ic = (int)C;
   im = (int)M;
   iy = (int)Y;

   *c = ic;
   *m = im;
   *y = iy;
}

static void setzlm()
{
   double aainc;
   int ncs, i;

   if (abs(linlog) == 1) {
      aainc = incr_linear;
      if (incr_linear == 0 && num_colors > 2)
         aainc = (boundary2 - boundary1) / (num_colors - 2);
      for (i=0; i<num_colors-1; i++)
         color_limits[i] = boundary2 - aainc * ((num_colors-2)-i);
      if (incr_linear == 0 && num_colors > 2) {
         if (num_colors % 2 == 0 && boundary1 == -boundary2) 
            color_limits[num_colors/2-1] = 0.;
         color_limits[num_colors-2] = boundary2;
         }
      }
   else if (abs(linlog) == 2) {
      aainc = fabs(incr_db);
      if (aainc < 0.01) aainc = 0.01;
      ncs = num_colors / 2;
      if (ncs*2 == num_colors) {
         color_limits[ncs-1] = 0.;
         ncs = ncs - 1;
         }
      for (i=0; i<ncs; i++) {
         color_limits[i] = -fabs(boundary3) * pow(10., (aainc*(i)/(-20.)));
         color_limits[num_colors-2-i] = -color_limits[i];
         }
      }
}

float get_limit(int num)
{
   if (num > num_colors-2 && num_colors > 2)
      return color_limits[num_colors-2];
   else
      return color_limits[num];
}

unsigned long get_color(double amp)
{
   unsigned long pixel;

   /* find upperbound limit in color limits 
      check for boundary conditions first */
   if (amp <= color_limits[0])
      pixel = color_pixel[0];
   else if (amp > color_limits[num_colors-2])
      pixel = color_pixel[num_colors-1];
   else {
      int k,klo = 0,khi = num_colors - 2;
      /* use bisection to find correct location in table */
      while (khi - klo > 1) {
         k = (khi + klo) >> 1;
         if (color_limits[k] > amp) khi = k;
         else klo = k;
         }
      pixel = color_pixel[khi];
      }
 
   return pixel;
}

int get_num_colors()
{
   return(num_colors);
}

unsigned long get_pixel(int num)
{
   if (num < 0 || num >= num_colors) return(-1);
   return color_pixel[num];
}

static void set_limit_menu()
{
   Widget action_text, push1, push2, push3, rc1, rc2, rc3, rc4, rc5, rc3a;
   Widget seper, label0,labels_widget,toggle_action;
   int n, i, fldlen;
   XmString string;
   char *tag = XmFONTLIST_DEFAULT_TAG;

   bbe = XmCreateBulletinBoardDialog(bb, "limitedit", NULL, 0);

   n = 0;
   rc1 = XmCreateRowColumn(bbe, "workarea", wargs, n);
   XtManageChild(rc1);

   n = 0;
   XtSetArg(wargs[n], XmNlabelString,
   XmStringCreateLtoR("              COLOR CONTOUR SPECIFICATION MENU\n\n",
                      tag)); n++;
   label0 = XmCreateLabelGadget(rc1, "label1", wargs, n);
   XtManageChild(label0);

   n = 0;
   XtSetArg(wargs[n], XmNpacking, XmPACK_TIGHT ); n++;
   XtSetArg(wargs[n], XmNspacing, 30 ); n++;
   XtSetArg(wargs[n], XmNorientation, XmHORIZONTAL ); n++;
   rc3 = XmCreateRowColumn(rc1, "workarea", wargs, n);
   XtManageChild(rc3);

   n = 0;
   XtSetArg(wargs[n], XmNpacking, XmPACK_TIGHT ); n++;
   rc3a = XmCreateRowColumn(rc3, "workarea", wargs, n);
   XtManageChild(rc3a);

   n = 0;
   XtSetArg(wargs[n], XmNlabelString, 
            XmStringCreateLtoR("Increment\nType",tag)); n++;
   action_text = XtCreateManagedWidget("action_text", xmLabelGadgetClass,
                                       rc3a, wargs, n);

   n = 0;
   XtSetArg(wargs[n], XmNx, 250); n++;
   XtSetArg(wargs[n], XmNy, 150); n++;
   XtSetArg(wargs[n], XmNorientation, XmVERTICAL ); n++;
   XtSetArg(wargs[n], XmNspacing, 50); n++;
   XtSetArg(wargs[n], XmNradioBehavior, True); n++;
   XtSetArg(wargs[n], XmNradioAlwaysOne, True); n++;
   toggle_action = XtCreateWidget("toggle_action",xmRowColumnWidgetClass,
                                  rc3a, wargs, n);
   XtManageChild(toggle_action);

   n = 0;
   XtSetArg(wargs[n], XmNlabelString, 
            XmStringCreateLocalized("Linear")); n++;
   XtSetArg(wargs[n], XmNset, True); n++;
   action[5] = XtCreateWidget("button4",xmToggleButtonGadgetClass,
                              toggle_action,wargs,n);
   XtManageChild(action[5]);

   n = 0;
   XtSetArg(wargs[n], XmNlabelString,
            XmStringCreateLocalized("dB")); n++;
   XtSetArg(wargs[n], XmNset, True); n++;
   action[6] = XtCreateWidget("button5",xmToggleButtonGadgetClass,
                              toggle_action,wargs,n);
   XtManageChild(action[6]);

   XmToggleButtonGadgetSetState(action[6], False, False);
   XmToggleButtonGadgetSetState(action[5], True, False);

   n = 0;
   XtSetArg(wargs[n], XmNorientation, XmVERTICAL ); n++;
   seper = XmCreateSeparatorGadget(rc3, "sepe", wargs, n);
   XtManageChild(seper);

   n = 0;
   XtSetArg(wargs[n], XmNorientation, XmVERTICAL ); n++;
   XtSetArg(wargs[n], XmNpacking, XmPACK_COLUMN ); n++;
   rc4 = XmCreateRowColumn(rc3, "workarea", wargs, n);
   XtManageChild(rc4);

   /* build the text entry boxes */
   n = 0;
   XtSetArg(wargs[n], XmNlabelString,XmStringCreateLocalized("Linear:")); n++;
   labels_widget = XmCreateLabelGadget(rc4, "label", wargs, n);
   XtManageChild(labels_widget);
   for (i=0; i<5; i++) {
      n = 0;
      XtSetArg(wargs[n], XmNorientation, XmHORIZONTAL ); n++;
      XtSetArg(wargs[n], XmNpacking, XmPACK_TIGHT ); n++;
      XtSetArg(wargs[n], XmNspacing, 10 ); n++;
      rc5 = XmCreateRowColumn(rc4, "workarea", wargs, n);
      XtManageChild(rc5);;
      XmAddTabGroup(rc5);

      n = 0;
      XtSetArg(wargs[n], XmNlabelString,
      XmStringCreateLtoR(limitstring[i], tag)); n++;
      labels_widget = XmCreateLabelGadget(rc5, "label", wargs, n);
      XtManageChild(labels_widget);

      fldlen = 10;
      if (i == 3) fldlen = 5;
      n = 0;
      XtSetArg(wargs[n], XmNcolumns, fldlen ); n++;
      XtSetArg(wargs[n], XmNmaxLength, fldlen ); n++;
      limit_text[i] = XmCreateText(rc5, "text", wargs, n);
      XtManageChild(limit_text[i]);

      if (i == 2) {
         n = 0;
         XtSetArg(wargs[n], XmNlabelString,
         XmStringCreateLtoR("Note:  If increment is zero,\n"
                            "it will be calculated.",tag)); n++;
         labels_widget = XmCreateLabelGadget(rc4, "label", wargs, n);
         XtManageChild(labels_widget);

         n = 0;
         XtSetArg(wargs[n], XmNlabelString,
         XmStringCreateLtoR("If increment is not zero,\n"
                            "minimum value will be calculated.",tag)); n++;
         labels_widget = XmCreateLabelGadget(rc4, "label", wargs, n);
         XtManageChild(labels_widget);

         n = 0;
         XtSetArg(wargs[n], XmNlabelString,
         XmStringCreateLtoR("Values greater than maximum value\n"
                            "will use highest color.",tag)); n++;
         labels_widget = XmCreateLabelGadget(rc4, "label", wargs, n);
         XtManageChild(labels_widget);

         n = 0;
         XtSetArg(wargs[n], XmNlabelString,
         XmStringCreateLtoR("Values less than minimum value\n"
                            "will use lowest color.",tag)); n++;
         labels_widget = XmCreateLabelGadget(rc4, "label", wargs, n);
         XtManageChild(labels_widget);

         n = 0;
         seper = XmCreateSeparatorGadget(rc4, "sepe", wargs, n);
         XtManageChild(seper);

         n = 0;
         XtSetArg(wargs[n], XmNlabelString,
         XmStringCreateLocalized("dB:")); n++;
         labels_widget = XmCreateLabelGadget(rc4, "label", wargs, n);
         XtManageChild(labels_widget);
         }
      }

   n = 0;
   seper = XmCreateSeparatorGadget(rc1, "sepe", wargs, n);
   XtManageChild(seper);
 
   n = 0;
   XtSetArg(wargs[n], XmNorientation, XmHORIZONTAL); n++;
   XtSetArg(wargs[n], XmNentryAlignment, XmALIGNMENT_CENTER); n++;
   XtSetArg(wargs[n], XmNspacing, 50); n++;
   XtSetArg(wargs[n], XmNpacking, XmPACK_COLUMN); n++;
   XtSetArg(wargs[n], XmNmarginHeight,10); n++;
   XtSetArg(wargs[n], XmNmarginWidth, 100); n++;
   rc2 = XmCreateRowColumn(rc1, "rc2", wargs, n);
   XtManageChild (rc2);
 
   string = XmStringCreateLocalized("OK");
   n = 0;
   XtSetArg(wargs[n], XmNlabelString, string); n++;
   XtSetArg(wargs[n], XmNshowAsDefault, 1); n++;
   push1 = XmCreatePushButtonGadget(rc2, "push1", wargs, n);
   XtManageChild(push1);
 
   string = XmStringCreateLocalized("Cancel");
   n = 0;
   XtSetArg(wargs[n], XmNlabelString, string); n++;
   push2 = XmCreatePushButtonGadget(rc2, "push2", wargs, n);
   XtManageChild(push2);
 
   string = XmStringCreateLocalized("Help");
   n = 0;
   XtSetArg(wargs[n], XmNlabelString, string); n++;
   push3 = XmCreatePushButtonGadget(rc2, "push3", wargs, n);
   XtManageChild(push3);
 
   XtAddCallback(push1, XmNactivateCallback, color_cb, 
                 (XtPointer)DIALOG_LIMIT_ACCEPT);
   XtAddCallback(push2, XmNactivateCallback, color_cb, 
                 (XtPointer)DIALOG_LIMIT_CANCEL);
   XtAddCallback(push3, XmNactivateCallback, color_cb, 
                 (XtPointer)DIALOG_LIMIT_HELP);
 
   n = 0;
   XtSetArg(wargs[n], XmNdefaultButton, push1); n++;
   XtSetArg(wargs[n], XmNcancelButton, push2); n++;
   XtSetValues(bbe,wargs,n);
}

void create_colhelp(Widget parent)
{
   Arg al[64];                    /* Arg List */
   register int ac = 0;           /* Arg Count */
   XmString xmstring; 
   Widget w = (Widget)NULL;

   xmstring = XmStringCreateLocalized("Dismiss");
   XtSetArg(al[ac],XmNallowShellResize,True); ac++;
   XtSetArg(al[ac],XmNtitle,"Color Editor Help"); ac++;
   XtSetArg(al[ac],XmNautoUnmanage,True); ac++;
   XtSetArg(al[ac],XmNokLabelString,xmstring); ac++;
   colhelp = XmCreateMessageDialog(parent,"colhelp",al,ac);
   XmStringFree(xmstring);
   w = XmMessageBoxGetChild(colhelp,XmDIALOG_CANCEL_BUTTON);
   XtUnmanageChild(w);
   w = XmMessageBoxGetChild(colhelp,XmDIALOG_HELP_BUTTON);
   XtUnmanageChild(w);

   ac = 0;
   XtSetArg(al[ac],XmNcolumns,60); ac++;
   XtSetArg(al[ac],XmNeditable,FALSE); ac++;
   XtSetArg(al[ac],XmNeditMode,XmMULTI_LINE_EDIT); ac++;
   XtSetArg(al[ac],XmNrows,20); ac++;
   XtSetArg(al[ac],XmNwordWrap,True); ac++;
   XtSetArg(al[ac],XmNscrollHorizontal,False); ac++;
   XtSetArg(al[ac],XmNcursorPositionVisible,False); ac++;
   helpText = XmCreateScrolledText(colhelp,"helpText",al,ac);
   XtManageChild(helpText);
}
