/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#define CHANGE_LIMITS                9901
#define LOAD_PLTR                    9902
#define SAVE_PLTR                    9903
#define DELETE_PAL                   9904
#define LOAD_PAL                     9905
#define SAVE_PAL                     9906
#define COLOR_INTERP                 9907
#define GRAY_SCALE                   9908
#define RESET_SLIDER                 9909
#define CANCEL_ACTION                9910
#define COLOR_EXIT                   9911
#define COLOR_APPLY                  9912
#define COLOR_CANCEL                 9913
#define COLOR_UNMAP                  9914
#define COLOR_HELP                   9915

#define DIALOG_CARD_CANCEL           9921
#define DIALOG_CARD_ACCEPT           9922
#define DIALOG_LIMIT_CANCEL          9923
#define DIALOG_LIMIT_ACCEPT          9924
#define DIALOG_LIMIT_HELP            9925
#define DIALOG_SAVE_CANCEL           9926
#define DIALOG_SAVE_ACCEPT           9927
#define DIALOG_FILE_ACCEPT           9928
#define DIALOG_SAVEPALETTE_ACCEPT    9929
#define DIALOG_SAVEPALETTE_CANCEL    9930
#define DIALOG_LOAD_ACCEPT           9931
#define DIALOG_LOAD_CANCEL           9932
#define DIALOG_DELETE_ACCEPT         9933
#define DIALOG_DELETE_CANCEL         9934

#define MAX_COLORS 41

/* the length member is anachronistic and no longer used but is
   maintained for backwards capatibility */

struct pal_title {
   char length[4];
   short int entry_num;
   char desc[52];
   };

struct pal_rgb {
   char length[4];
   short int num_colors;
   short int contrast;
   short int brightness;
   unsigned short int colors[256][3];
   };

struct pal_limits {
   char length[4];
   short int limtyp;
   float bound2;
   float incr_lin;
   float bound1;
   float incr_db;
   float bound3;
   };

struct pal_defaults {
   char appl[10];
   char subclass[10];
   char code[4];
   char newline;
   };

struct colr1rec {
   char colr1[5];
   char blank1[2];
   char incr[3];
   char interval_lin[10];
   char level_high[10];
   char blank2[3];
   char display_opt[2];
   char interval_db[5];
   char zero_db_value[10];
   char blank3[3];
   char numclr[2];
   char blank4[1];
   char trace_fill[4];
   char blank5[20];
   };

struct colr2rec {
   char colr2[5];
   char blank6[2];
   char color_code1[8];
   char blank7[2];
   char color_code2[8];
   char blank8[2];
   char color_code3[8];
   char blank9[2];
   char color_code4[8];
   char blank10[2];
   char color_code5[8];
   char blank11[25];
   };

struct color_code {
   char color_bb[2];
   char color_yy[2];
   char color_mm[2];
   char color_cc[2];
   };

static void Create_Color_Barx(Widget parent);
static int Float_Checks (char *int_string);
static char *getFileNameFromHome(char *filename);
static void DialogDestroyMessageCB(Widget w,XtPointer client_data,
                                   XtPointer call_data);
static Widget DisplayMsg(Widget parent,char *message,int kind_of_msg);
static int getdefaultid(void);
static void savedefaultid(int id);
static void reset_default_id(int id);
static void setnewlimits(void);
static void retrievepalette(int myitem);
static int openpalette(char *mode);
static void getpalette(void);
static void setpalette(void);
static void deletepalette(void);
static int appendpalette(void);
static Widget CreateSavePaletteMenu(Widget parent);
static Widget make_slider(char *name,Widget parent,int size,int start,int dir);
static void slider_moved(Widget w,XtPointer client_data,XtPointer call_data);
static void update_color(void);
static void set_current_pixel(unsigned long pixel);
static void copy_current_pixel(Widget w,XtPointer client_data,
                               XtPointer call_data);
static void create_option_menu(Widget parent);
static void create_colhelp(Widget parent);
static void UpdateScreen(void);
static void UpdateLimits(void);
static Widget CreateColorListMenu(Widget parent);
static Widget CreateDeleteColorListMenu(Widget parent);
static void color_cb(Widget w,XtPointer client_data, XtPointer call_data);
static void setzlm(void);
static void set_limit_menu(void);
static void OpenCardFile(void);
static void ymcrgb(int c,int  m,int  y,int  bk,unsigned short *r,
                   unsigned short *g,unsigned short *b);
static void rgbymc(int r,int g,int b,int *y,int *m,int *c);
static int SavePLTRFile(void);
static void OpenOutputPLTR(void);
static void create_pltrfile_menu(void);
