C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------------spike3d----------------------------------------
c
c Author P.G.A. Garossino:Amoco Production Research:August,94
c
c spike3d generates a 3D surface based on parameters input on the 
c command line.  The x dimension is inline [i.e. traces] while the
c y dimension is crossline [i.e. records]
c
c<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>

c get machine dependent parameters 

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c dimension standard USP variables 

      integer     itr(2 * SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luout, lbytes, nbytes, obytes, luin
      integer     argis, ist, iend, irs, ire, ns, ne, JJ, KK
      integer     lutty, ludsk

      real        tri(2 * SZLNHD)

      character   name*7, otap*255, ntap*255

      logical     verbos

c program variables defined with static memory allocation

      integer     StaCor, fmt_StaCor, l_StaCor, ln_StaCor
      integer     DstSgn, fmt_DstSgn, l_DstSgn, ln_DstSgn
      integer     DstUsg, fmt_DstUsg, l_DstUsg, ln_DstUsg
      integer     RecNum, fmt_RecNum, l_RecNum, ln_RecNum
      integer     TrcNum, fmt_TrcNum, l_TrcNum, ln_TrcNum
      integer     LinInd, fmt_LinInd, l_LinInd, ln_LinInd
      integer     DphInd, fmt_DphInd, l_DphInd, ln_DphInd
      integer     CDPBCX, fmt_CDPBCX, l_CDPBCX, ln_CDPBCX
      integer     CDPBCY, fmt_CDPBCY, l_CDPBCY, ln_CDPBCY
      integer     SrPtXC, fmt_SrPtXC, l_SrPtXC, ln_SrPtXC
      integer     SrPtYC, fmt_SrPtYC, l_SrPtYC, ln_SrPtYC
      integer     dT, Tmax 
      integer     it1, it2

      real    dX, dY, Xmax, Xmin, Ymax, Ymin, X0, Y0, T0
      real    Azimuth, Dip, MaxModelRadius, velocity, Amplitude
      real    tr, tt, dt1, dt2, Pi

      logical Plane, Cone, Hyperboloid, pipe

c initialize variables 

      data name/'SPIKE3D'/
      data lbytes/0/
      data iform/3/
      data Plane/.false./
      data Cone/.false./
      data Hyperboloid/.false./
      Pi = 4. * atan(1.0)

c get online help if necessary 

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 ) then
           call help ()
           stop
      endif

c open printout files 

#include <f77/open.h>

c get command line parameters 

      call cmdln ( ntap, dX, dY, dT, Xmax, Xmin, Ymax, Ymin, Tmax,   
     :     X0, Y0, T0, Azimuth, Dip, MaxModelRadius, otap, Velocity, 
     :     Amplitude, Plane, Cone, Hyperboloid, verbos )

c open input 

      call getln ( luin, ntap, 'r', 0 )

c ludsk and lutty below are from lib ut.

      if ( ludsk ( luin ) .eq. 0 ) then

c check to see if input is a pipe

         if ( lutty ( luin ) .eq. 1 ) then

c check to see if pipe is connected to the terminal.  If it is not
c then this is the initial model run

            pipe = .false.
         else

c otherwise pipe is connected to stdin and am expecting data

            pipe = .true.
         endif
      else

c input is not a pipe therefore must be a disk file 

         pipe = .false.
      endif

c open output 

      call getln ( luout, otap, 'w', 1 )

c define USP volume descriptors in terms of input parameters

c records

      irs = 1 
      ire = nint( ( Ymax - Ymin ) / dY ) + 1
      nrec = ire - irs + 1

c traces

      ns = 1
      ne = nint( ( Xmax - Xmin ) / dX ) + 1
      ntrc = ne - ns + 1

c samples : [first sample is time zero]

      ist = 1
      iend = nint( float(Tmax) / float(dT) ) + 1
      nsi = dT
      nsamp = iend - ist + 1

      if ( nsamp .gt. ( 2 * SZLNHD ) ) nsamp = ( 2 * SZLNHD ) - ITRWRD

c check model parameters against above volume parameters

      if ( .not. Plane .and. .not. Cone .and. .not. Hyperboloid ) then
         write(LERR,*)' '
         write(LERR,*)' SPIKE3D: must specify type of surface to '
         write(LERR,*)'          generate.  Use one of -P -H -C '
         write(LERR,*)'          on the command line and resubmit'
         write(LERR,*)' FATAL'       
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)' SPIKE3D: must specify type of surface to '
         write(LER,*)'          generate.  Use one of -P -H -C '
         write(LER,*)'          on the command line and resubmit'
         write(LER,*)' FATAL'       
         write(LER,*)' '
         write(LER,*)' FATAL'       
         write(LER,*)' '
      endif

      if ( X0 .lt. Xmin .or. X0 .gt. Xmax ) then 
         write(LERR,*)' '
         write(LERR,*)' SPIKE3D: X origin ',X0,' is outside volume'
         write(LERR,*)'          Check -x0 parameter and resubmit'
         write(LERR,*)' '
         write(LERR,*)' FATAL'       
         write(LERR,*)' '
         write(LER,*)' SPIKE3D: X origin ',X0,' is outside volume'
         write(LER,*)'          Check -x0 parameter and resubmit'
         write(LER,*)' '
         write(LER,*)' FATAL'       
         write(LER,*)' '
      endif

      if ( Y0 .lt. Ymin .or. Y0 .gt. Ymax ) then 
         write(LERR,*)' '
         write(LERR,*)' SPIKE3D: Y origin ',Y0,' is outside volume'
         write(LERR,*)'          Check -y0 parameter and resubmit'
         write(LERR,*)' '
         write(LERR,*)' FATAL'       
         write(LERR,*)' '
         write(LER,*)' SPIKE3D: Y origin ',Y0,' is outside volume'
         write(LER,*)'          Check -y0 parameter and resubmit'
         write(LER,*)' '
         write(LER,*)' FATAL'       
         write(LER,*)' '
      endif

      if ( T0 .lt. 0.0 .or. T0 .gt. float(Tmax) ) then 
         write(LERR,*)' '
         write(LERR,*)' SPIKE3D: T origin ',T0,' is outside volume'
         write(LERR,*)'          Check -t0 parameter and resubmit'
         write(LERR,*)' '
         write(LERR,*)' FATAL'       
         write(LERR,*)' '
         write(LER,*)' SPIKE3D: T origin ',T0,' is outside volume'
         write(LER,*)'          Check -t0 parameter and resubmit'
         write(LER,*)' '
         write(LER,*)' FATAL'       
         write(LER,*)' '
      endif

      if ( abs ( Dip ) .gt. 90.0 ) then
         write(LERR,*)' '
         write(LERR,*)' SPIKE3D: Dip greater than 90.0 degrees.'
         write(LERR,*)'          Check -dip parameter and resubmit'
         write(LERR,*)' '
         write(LERR,*)' FATAL'       
         write(LERR,*)' '
         write(LER,*)' SPIKE3D:  Dip greater than 90.0 degrees.'
         write(LERR,*)'          Check -dip parameter and resubmit'
         write(LER,*)' '
         write(LER,*)' FATAL'       
         write(LER,*)' '
      endif

      if ( Dip .lt. 0.0 ) Dip = abs(Dip)

      if ( Azimuth .lt. 0.0 .or. Azimuth .gt. 360 ) then
         write(LERR,*)' '
         write(LERR,*)' SPIKE3D: Azimuth chosen is outside range'
         write(LERR,*)'          of zero to 360 degrees.  Check '
         write(LERR,*)'          -azim parameter and resubmit'
         write(LERR,*)' FATAL'
         write(LERR,*)' '
      endif

      call verbal (dX, dY, dT, Xmax, Xmin, Ymax, Ymin, Tmax,   
     :     X0, Y0, T0, Azimuth, Dip, MaxModelRadius, otap, Velocity, 
     :     Amplitude, Plane, Cone, Hyperboloid, nrec, ntrc, 
     :     nsamp, pipe, ntap )

c read the input line header if required.

      if ( ntap .ne. ' ' .or. pipe ) then
         call rtape ( luin, itr, lbytes )
         if(lbytes .eq. 0) then
            write(LERR,*)'SPIKE3D: no header read on unit ',ntap
            write(LERR,*)'FATAL'
            write(LERR,*)'Check existence of file & rerun'
            stop
         endif
      
         call hlhprt ( itr , lbytes, name, 7, LERR )

c recover global parameters which will override command line parameters
c for ntrc, nsamp etc. to keep dataset square

#include <f77/saveh.h>

         if ( nint( ( Xmax - Xmin ) / dX ) .ne. ntrc  .or.
     :        nint( ( Ymax - Ymin ) / dY ) .ne. nrec .or.
     :        (nint( float(Tmax) / float(dT) ) + 1) .ne. nsamp ) then

            write(LERR,*)' '
            write(LERR,*)'SPIKE3D: ntrc, nrec or nsamp of input '
            write(LERR,*)'         dataset not compatible with  '
            write(LERR,*)'         command line entries'
            write(LERR,*)' FATAL'
            stop
         endif
         
      endif

c handle velocity units for milliseconds or microseconds

      if ( nsi .le. 32 ) then
         Velocity = Velocity / 1000.
      else
         Velocity = Velocity / 1000000.
      endif

c convert Azimuth and Dip to radians

      Azimuth = Azimuth * Pi / 180.0
      Dip = Dip * Pi / 180. 

c define number of output bytes

      obytes = SZTRHD + SZSMPD * nsamp

c create an output line header if creating a new volume

       if ( ntap .eq. ' ' .and. .not. pipe ) then
          call savew( itr, 'NumTrc', ntrc  , LINHED)
          call savew( itr, 'NumRec', nrec  , LINHED)
          call savew( itr, 'SmpInt',  nsi  , LINHED)
          call savew( itr, 'NumSmp', nsamp , LINHED)
          call savew( itr, 'Format', iform , LINHED)

          lbytes = HSTOFF
          nbytes = 2 * SZHFWD

          call savew( itr, 'HlhEnt',  0   , LINHED)
          call savew( itr, 'HlhByt', nbytes , LINHED)
       endif

c save current command line stuff in hlh

       call savhlh( itr, lbytes, lbyout )

c write output line header

       call wrtape ( luout, itr, lbyout )

c get pointers to required trace header mnemonics

      call savelu('TrcNum',fmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',fmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('LinInd',fmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('DphInd',fmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',fmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',fmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',fmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('CDPBCX',fmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TRACEHEADER)
      call savelu('CDPBCY',fmt_CDPBCY,l_CDPBCY,ln_CDPBCY,TRACEHEADER)
      call savelu('SrPtXC',fmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',fmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
       
c build this model volume

      SrPtXC = nint(X0)
      call savew2( itr, fmt_SrPtXC, l_SrPtXC, ln_SrPtXC, SrPtXC, 
     :     TRACEHEADER )
      SrPtYC = nint(Y0)
      call savew2( itr, fmt_SrPtYC, l_SrPtYC, ln_SrPtYC, SrPtYC, 
     :     TRACEHEADER )

      DO JJ = irs, ire

         Y = Ymin + float(JJ - 1) * dY

         if ( ntap .eq. ' ' .and. .not. pipe ) then
            CDPBCY = nint(Y)
            RecNum = JJ
            LinInd = JJ
            call savew2( itr, fmt_LinInd, l_LinInd, ln_LinInd, LinInd, 
     :           TRACEHEADER )
            call savew2( itr, fmt_RecNum, l_RecNum, ln_RecNum, RecNum, 
     :           TRACEHEADER )
            call savew2( itr, fmt_CDPBCY, l_CDPBCY, ln_CDPBCY, CDPBCY, 
     :           TRACEHEADER )
         endif

         DO KK = ns, ne

            if ( ntap .ne. ' ' .or. pipe ) then
               nbytes = 0
               call rtape ( luin, itr, nbytes )
               if(nbytes .eq. 0) then
                  write(LERR,*)'Premature EOF on input:'
                  write(LERR,*)'  rec= ',JJ,'  trace= ',KK
                  go to 999
               endif
               call vmov ( itr(ITHWP1), 1, tri(1), 1, nsamp )
            else

c this is a new model clear the trace

               call vclr(tri,1,nsamp)

            endif

            X =  Xmin + float(KK - 1) * dX
            R = sqrt( (X - X0)**2 + (Y - Y0)**2 )

c flush out trace header entries

            if ( ntap .eq. ' ' .or. .not. pipe ) then
               CDPBCX = nint(X)
               DstSgn = nint(R)
               DstUsg = iabs(DstSgn)
               DphInd = KK
               TrcNum = KK
               StaCor = 0
              call savew2( itr, fmt_CDPBCX, l_CDPBCX, ln_CDPBCX, CDPBCX, 
     :              TRACEHEADER )
              call savew2( itr, fmt_DstSgn, l_DstSgn, ln_DstSgn, DstSgn, 
     :              TRACEHEADER )
              call savew2( itr, fmt_DstUsg, l_DstUsg, ln_DstUsg, DstUsg, 
     :              TRACEHEADER )
              call savew2( itr, fmt_DphInd, l_DphInd, ln_DphInd, DphInd, 
     :              TRACEHEADER )
              call savew2( itr, fmt_TrcNum, l_TrcNum, ln_TrcNum, TrcNum, 
     :              TRACEHEADER )
              call savew2( itr, fmt_StaCor, l_StaCor, ln_StaCor, StaCor, 
     :              TRACEHEADER )
            endif

            IF ( R .le. MaxModelRadius ) then

               if ( Plane ) then
                  
                  tr = T0  + 
     :                 ( (X - X0) * cos(Azimuth) + 
     :                 (Y - Y0) * sin(Azimuth) ) * 
     :                 tan(Dip) / Velocity

               elseif ( Cone ) then

                  tr = T0 + R * tan(Dip) / Velocity

               elseif ( Hyperboloid ) then

                  tr = sqrt( T0**2 + R**2 /Velocity**2 )

               endif

c interpolate spike across samples: ripped off from spike.F

               if ( abs(tr) .ge. 0.0 .and. abs(tr) .lt. Tmax ) then

                  tt = tr / float(nsi) + 1.000000001
                  it1 = tt
                  it2 = it1 + 1
                  dt1 = tt - it1
                  dt2 = it2 - tt
               
                  if ( it1 .lt. 1 ) then
                     it1 = 1
                     dt2 = dt1
                  endif

                  if ( it2 .gt. nsamp ) then
                     it2 = nsamp
                     dt1 = dt2
                  endif

                  tri(it1) = Amplitude * dt2
                  tri(it2) = Amplitude * dt1

               elseif ( ntap .eq. ' ' .and. .not. pipe ) then
                  StaCor = 30000
                  call savew2( itr, fmt_StaCor, l_StaCor, ln_StaCor,  
     :                 StaCor, TRACEHEADER )
               endif

            ELSEIF ( ntap .eq. ' ' .and. .not. pipe ) then

               call vclr(tri,1,nsamp)
               StaCor = 30000
               call savew2( itr, fmt_StaCor, l_StaCor, ln_StaCor,  
     :              StaCor, TRACEHEADER )

           ENDIF

c write out trace 

            call vmov ( tri, 1, itr(ITHWP1),1, nsamp)
            call wrtape( luout, itr, obytes )

         ENDDO

      ENDDO

 999  continue

      call lbclos(luout)

      write(LERR,*)'processed ',nrec,' record(s) with ',ntrc,' traces'
      write(LER,*)'SPIKE3D: Normal Termination'

      stop
      end

