C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c
c Subroutine for calculating rock properties when calculating dgamma/gamma
c
c
      subroutine calc2(min1,max1,min2,max2,c,f)

	 real min1,max1,min2,max2
	 real c(9),f(9)
	 real c11,c12,c21,c22
	 real ci11,ci12,ci21,ci22
	 real f11,f12,f21,f22

	 c11= 1.0
	 c12= ((tan(max1)-tan(min1))/(max1-min1)) - 1.0

	 c21= 1.0
	 c22= ((tan(max2)-tan(min2))/(max2-min2)) - 1.0

	 ci11 = c22 /(c11*c22 - c12*c21) 
	 ci12 = c12 /(c12*c21 - c11*c22) 
	 ci21 = c21 /(c12*c21 - c11*c22) 
	 ci22 = c11 /(c11*c22 - c12*c22) 

	 f11 = 2*ci11
         f12 = 2*ci12
         f21 = ci11+ci21
         f22 = ci12+ci22

	 c(1) = ci11
	 c(2) = ci12
	 c(3) = ci21
	 c(4) = ci22

	 f(1) = f11
	 f(2) = f12
	 f(3) = f21
	 f(4) = f22

	 return
	 end

