C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c*********************************************************************c
c square reads data a trace at a time, finds zero crossings, and 
c outputs square waves consisting of the max amplitude or rms avg
c amplitude between the zero crossings.
c*********************************************************************c
c
c     declare variables
c
c-----
c    get machine dependent parameters

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/pid.h>
#include <f77/sisdef.h>
#include <save_defs.h>
c-----
 
c------
c  dynamic memory allocation for big arrays, eg whole records
c------
      real        work(1)
      real        itr (1),vtr(1)
      character   ntap * 100, otap * 100, name*6,vtap*100
      logical     query, rms,area,stretch,ikp
      integer     trlen,lhed(SZLNHD),argis
      integer     nsamp, nsi, ntrc, nrec, iform, obytes,abort
      integer     luin , luout, lbytes, nbytes, lbyout,lvt
      integer     irs,ire,pipe,in_ikp
      pointer     (wkadr1, work),(pitr,itr),(pvtr,vtr)
 
      data lbytes / 0 /, nbytes / 0 /, name/'SQUARE'/
      data abort / 0 /,pipe/3/
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 ).or.(argis('-h').gt.0)
      if ( query )then
            call help(ler)
            stop
      endif
      ikp=.false.
      if(in_ikp().eq.1)ikp=.true.
 
c-----
c     open printout files
c     this consists of a 2-character identifier, the process id number,
c     and the child process id number:
c     XY.nnnnn.mmmmm
c     this should be unique even for multiple occurences of the same
c     process in a pipeline
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,irs,ire,rms,area,stretch,vtap)

c-----
c     get logical unit numbers for input and output of seismic data
c     0 = default stdin
c     1 = default stdout
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
      if(stretch)then
      if(ikp)then
       call sisfdfit(lvt,pipe)
      else
       call getln(lvt, vtap, 'r', -1)
      endif
      lbytes=0
      call rtape(lvt,lhed,lbytes)
      if(lbytes.eq.0)then
        write(LER, *)'EOF on input velocity file. No header! Fatal!'
        stop
      endif
      endif

c-----
c     read line header of input
c     save certain parameters
c-----
      lbytes = 0
      call rtape  ( luin, lhed, lbytes)
      if(lbytes .eq. 0) then
         write(LER,*)'SQUARE: no header read from unit ',luin
         write(LER,*)'Fatal!'
         stop
      endif

c------
c     to get and/or put LINE header values please use saver/savew
c     since that way code will always be portable to whatever machine
c     we maintain usp on
c     saver/w refer to header words using mnemonics rather than position
c
c     see saver/w manual pages
c------
      call saver(lhed, 'NumSmp', nsamp, LINHED)
      call saver(lhed, 'SmpInt', nsi  , LINHED)
      call saver(lhed, 'NumTrc', ntrc , LINHED)
      call saver(lhed, 'NumRec', nrec , LINHED)
      call saver(lhed, 'Format', iform, LINHED)
    
      if(nsi.gt.32)then
       si = float(nsi)/1000000.
      else
       si = float(nsi)/1000.
      endif


      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      lname = 6
      call hlhprt (lhed, lbytes, name, lname, LERR)

c-----
c     ensure that command line values are compatible with data set
c     (i.e. start/end traces; start/end records)
c-----
      ns = 1
      ne = ntrc

      call verbal(nsamp, nsi, ntrc, nrec, iform,
     :  irs, ire, rms,ntap,otap,area,stretch,vtap)

c------------------------------------
c  malloc space we are going to use
c  note also ISZBYT is the 
c  size of an item in bytes
c-----------------------------------


      trlen = nsamp + ITRWRD
      iget = trlen * ISZBYT
      ier = 0
      ner = 0
      memsum = 0
      abort = 0
      call galloc (wkadr1, iget, ier, abort)
      memsum=memsum+iget
      if (ier.ne.0)ner=ner+1
      call galloc (pitr, iget, ier, abort)
      memsum=memsum+iget
      if (ier.ne.0)ner=ner+1
      call galloc (pvtr, iget, ier, abort)
      memsum=memsum+iget
      if (ier.ne.0)ner=ner+1

      if (ner.ne.0) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) memsum,'  bytes'
         write(LERR,*)' '
         call lbclos(luin)
         call lbclos(luout)
         stop    
      endif
c---------------------------------------------------


c-----
c     modify line header to reflect actual number of traces output
c-----
      nrecc = nrec
      if(ire.ne.0)then
       nrecc=ire - irs+1
      endif
      jtr = ntrc
      call savew(lhed, 'NumRec', nrecc, LINHED)
      call savew(lhed, 'NumTrc', jtr , LINHED)
      if(ire.eq.0)ire = 999999

c----------------------
c  number output bytes
      obytes = (ITRWRD  + nsamp) * ISZBYT
c----------------------
      call savhlh(lhed,lbytes,lbyout)
      call wrtape ( luout, lhed, lbyout)
c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c-----
c-----
c     skip unwanted records
c-----
      if(irs.gt.1)then
       iget=(irs-1)*ntrc+1
       call sisseek(luin,iget)
       if(stretch)call sisseek(lvt,irs)
      end if


c-----
c     process desired trace records
c-----
      do jj = irs, ire
 
       if(stretch)then
        nvbytes=0
        call rtape(lvt,vtr,nvbytes)
        if(nvbytes.eq.0)Then
         call lbclos(luin)
         call lbclos(luout)
         call lbclos(lvt)
         stop
        endif
       endif
       idst=0
       jdst=0
       iset=0
       jset=1
       do kk = 1,ntrc
        nbytes = 0
        call rtape( luin, itr, nbytes)
c------
c     if end of data encountered (nbytes=0) then bail out
c------
        if(nbytes .eq. 0) then
         write(LERR,*)'End of file on input:'
         write(LERR,*)'  rec= ',jj,'  trace= ',kk
         call lbclos(luin)
         call lbclos(luout)
         if(stretch)call lbclos(lvt)
         stop
        endif
        call saver2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,istat,
     :    TRACEHEADER)
        call saver2(itr,ifmt_DstSgn,l_DstSgn,ln_DstSgn,ioff,
     :    TRACEHEADER)
        off = ioff
        if(istat.lt.30000)then
         call squarewave(itr(ITHWP1),nsamp,work,rms,area,stretch,
     :    vtr(ITHWP1),off,si,ier)
         call vmov(work,1,itr(ITHWP1),1,nsamp)
        endif
        call wrtape(luout,itr,obytes)
       end do    
      end do

c-----
c     close data files
c-----
      call lbclos ( luin )
      call lbclos ( luout )
      if(stretch)call lbclos(lvt)

      write(LERR,*)'end of bsquare, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      stop
      end
 
C***********************************************************************
      subroutine help(ler)
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'square reads traces of data, finds zero crossings, optionally'
        write(LER,*)
     :'corrects the traces for amplitude distortions due to NMO '
        write(LER,*)
     :'stretch, and replaces the data between zero crossings with the'
        write(LER,*)
     :'maximum (absolute) or rms average value, or with the area under'
        write(LER,*)
     :'each lobe.  The modified traces are output.'
       write(LER,*)
     :'See manual pages for details ( online by typing uman prg )'
        write(LER,*)' '
        write(LER,*)
     :'execute square by typing square and the program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (stdin)              : input data file name'
        write(LER,*)
     :' -O [otap]    (stdout)             : output data file name'
        write(LER,*)
     :' -v [vtap]    (none if stretch)    : input nmo function'
        write(LER,*)
     :' -rs[irs]     (default = first)    : start sequential record'
        write(LER,*)
     :' -re[ire]     (default = last)     : end sequential record'
        write(LER,*)
     :' -rms         (default = no)       : If present, find the rms'
        write(LER,*)
     :'                                     average amplitude rather'
        write(LER,*)
     :'                                     than maximum amplitude'
        write(LER,*)
     :' -area        (default = no)       : If present, find the area'
        write(LER,*)
     :'                                     under each lobe rather'
        write(LER,*)
     :'                                     than maximum amplitude'
        write(LER,*)
     :'                                     between zero crossings.' 
        write(LER,*)
     :' -stretch     (default = no)       : If present, correct each'
        write(LER,*)
     :'                                     trace for amplitude   '
        write(LER,*)
     :'                                     distortion due to NMO'
        write(LER,*)
     :'                                     stretch.'
        write(LER,*) ' '
        write(LER,*)
     :'usage:   square -N[] -O[] -v[] -rs[] -re[] -rms -area -stretch'
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,irs,ire,rms,area,stretch,vtap)
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     vel   - R*4      design velocity
c     irs   - I*4      starting record index
c     ire   - I*4      ending record index
c     ntrs  - I*4      Number of traces to mirror
c     mode  - I*4      0=front and back, 1=front only
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*), vtap*(*)
      integer     irs, ire,argis
      logical     rms,area,stretch
 
c-------
c     see manual pages on the argument handler routines
c     for the meanings of these functions
c-------
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            rms = ( argis ( '-rms' ) .gt. 0 )
            area = (argis('-area').gt.0)
            stretch=(argis('-stretch').gt.0)
            if(stretch)call argstr('-v',vtap,' ',' ')
 
      return
      end
 
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     :                  irs, ire, rms,ntap,otap,area,stretch,vtap)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     vel   - R*4     design velocity
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*100   input file name
c     otap  - C*100   output file name
c-----
#include <f77/iounit.h>

      integer     nsamp, nsi, ntrc, nrec
      integer     irs,ire
      logical     rms,area,stretch
      character   ntap*(*), otap*(*),vtap*(*)
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' input data set name  =  ', ntap(1:30)
            write(LERR,*) ' # of samples/trace   =  ', nsamp
            write(LERR,*) ' sample interval      =  ', nsi
            write(LERR,*) ' traces per record    =  ', ntrc
            write(LERR,*) ' records per line     =  ', nrec
            write(LERR,*) ' format of data       =  ', iform
            write(LERR,*) ' output data set name =  ', otap(1:30)
            write(LERR,*) ' Start processing rec =  ', irs
            write(LERR,*) ' End processing rec.  =  ', ire
            if(stretch)then
            write(LERR,*) ' Correct for NMO stretch'
            write(LERR,*) ' velocity data set name =  ', vtap(1:30)
            endif
            if(rms)then
            write(LERR,*) ' Find rms avg amp     = T '
            elseif(area)then
            write(LERR,*) ' Find area under lobe = T'
            else
            write(LERR,*) ' Find maximum amp     = T'
            endif
 
      return
      end
      subroutine vmov(x,ix,y,iy,n)
      real x(*),y(*)
      integer ix,iy,n
      nx=1
      ny=1
      do i=1,n
       y(ny)=x(nx)
       nx=nx+ix
       ny=ny+iy
      end do
      return
      end
