C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C
      program STACK
c__________________________________________________________________________
c     STACK -- Stack/Add seismic traces using various weights.
c                                                            
c     Original Version by K. B. Taylor and R. B. Herrmann.
c
c     Additional options (Blackman, Hamming and Linear offset weights)
c     vectorization, restructuring and cleanup by K. J. Marfurt (11/2/92)
c
c     Mary Ann Thornton     August 28, 1995   
c     I changed stacksub.F to move DptInt into SrcPnt trace header for
c     plotting purposes.
C
c     Garossino    May 27, 1999
c      I removed reference to InTrCn in preparation for using that slot
c      for ProMax trace identifier.  This entry was not used for anything
c      but was written to indicating fold for that stacked trace.  Since
c      sample wise fold is ultimately more important better to use pstack -F
c__________________________________________________________________________
#include <localsys.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>
#include <f77/pid.h>
c
      parameter (maxs=0 000 002)
      dimension s(maxs)
      pointer   (pntrs,s)
C
      integer   hbegin
c     parameter (i2fact=8/szsmpd,lenhed=lntrhd/i2fact,hbegin=1-lenhed)


      integer     sheader (SZLNHD)
      integer     holdi (SZLNHD)
      integer     holdo (SZLNHD)
      integer     bufin(SZLNHD)
      integer     bufout(SZLNHD)
      integer     ARGIS
      real        power
 
      character   name * 5, ntap * 256, otap * 256
 
      logical     verbos, query, semb, semwt, renum
      logical     dwgt,blackman,hamming,snorm,tnorm,threed
      logical     BC
 
      data  name/'STACK'/, nbytes/0/, lbytes/0/
c-------------------------------------------------------------------
c     If '-?' flag is used in command line, execute query
c     loop and end program.
c-------------------------------------------------------------------
      query = (argis('-?').gt.0 .or. argis('-h').gt.0)
      if ( query ) then
         call help()
         stop
      end if
c-------------------------------------------------------------------
c     open printout file
c-------------------------------------------------------------------
#include <f77/open.h>
      call argstr('-N',ntap,' ',' ')
      call argstr('-O',otap,' ',' ' )
c-------------------------------------------
c     Open input and output files
c-------------------------------------------
      call getln(luin,ntap,'r',0)
      call getln(luout,otap,'w',1)
c----------------------------------------------------
c     Read line header and save parameters
c----------------------------------------------------
      lbytes=0
      call rtape(luin,sheader,lbytes)
      if(lbytes .eq. 0) then
         write(LERR,*)'STACK: no header read on unit ',luin
         write(LERR,*)'FATAL'
         stop
      endif
      call hlhprt(sheader,lbytes,name,5,lerr)
      call saver(sheader,'NumSmp',nsamp,LINEHEADER)
      call saver(sheader,'SmpInt',nsi,LINEHEADER)
      call saver(sheader,'NumTrc',ntr,LINEHEADER)
      call saver(sheader,'NumRec',nrec,LINEHEADER)
      call saver(sheader,'Format',iform,LINEHEADER)

      lenhed=ITRWRD
      hbegin=1-lenhed

c---------------------------------------------------------------------------
c     Read program input parameters from command line argument flags
c---------------------------------------------------------------------------
      call cmdln(d1pos,d2pos,d1neg,d2neg,ngath,ntpr,ntr,nrec,
     1           power,ns,ne,irs,ire,semb,semwt,verbos,renum,
     2           tnorm,snorm,dwgt,blackman,hamming,threed,BC)
c---------------------------------------------------------------------------
c     print out parameters
c---------------------------------------------------------------------------
      write(LERR,*) ' Values read from command line'
      write(LERR,*) ' First record to process =  ', irs
      write(LERR,*) ' Last record to process  =  ', ire
      write(LERR,*) ' Starting trace number   =  ', ns
      write(LERR,*) ' Ending trace number     =  ', ne
      write(LERR,*) ' Output traces/rec       =  ', ntpr
      write(LERR,*) ' Force stacking gather   =  ', ngath
      write(LERR,*) ' Nth root power          =  ', power
      write(LERR,*) ' Positive spread: near dist = ',d1pos
      write(LERR,*) ' Positive spread: far  dist = ',d2pos
      write(LERR,*) ' Negative spread: near dist = ',d1neg
      write(LERR,*) ' Negative spread: far  dist = ',d2neg
      write(LERR,*) ' Change single trace records  '      
      write(LERR,*) '   single record multi trace=     ',renum    
      write(LERR,*) ' weight traces by distance?       ',dwgt     
      write(LERR,*) ' Apply Hamming weights?           ',hamming  
      write(LERR,*) ' Apply Blackman weights?          ',blackman 
      write(LERR,*) ' Apply equal, normalized weights? ',tnorm
      write(LERR,*) ' Normalize by nonzero samps?      ',snorm
      write(LERR,*) ' Apply semblance weights?         ',semwt
      write(LERR,*) ' Output semblance?                ',semb
      write(LERR,*) ' Input data 3D                    ', threed
      if (threed)
     1write(LERR,*) ' Compute bin center XYs from src/rcvr XYs',BC
      write(LERR,*) ' Verbose output?                  ',verbos
c----------------------------------------------------
c     print out header parameters
c----------------------------------------------------
      if(ngath .eq. 0) ngath = ntr
      write(LERR,*) ' Values read from input data set lineheader'
      write(LERR,*) ' Number of Samples/Trace =  ', nsamp
      write(LERR,*) ' Sample Interval         =  ', nsi
      write(LERR,*) ' Traces per Record       =  ', ntr
      write(LERR,*) ' Records per Line        =  ', nrec
      write(LERR,*) ' Format of Data          =  ', iform
      write(LERR,*) ' Traces/gather           =  ', ngath
c---------------------------------------------------------------------------
c     Check bounds of input parameters and set values to defaults
c---------------------------------------------------------------------------
      call cmdchk(ns,ne,irs,ire,ntr,nrec)
c-------------------------------------------------------------
c     reorganize output traces/rec based on new ngath
c     and ntpr (number traces/rec output) entry
c-------------------------------------------------------------
      if(ngath .ne. ntr) then
         if(irs.ne.1 .and. ire.ne. nrec .and. 
     &         ns.ne.1 .and. ne.ne.ntr) then
            write(LERR,*)'If ngath not = input gather size, start/end'
            write(LERR,*)'records & traces must be left to default'
            write(LERR,*)'Rerun with these defaults'
            stop
         endif
         itot = ntr*nrec
         xre = float(itot)/float(ngath)
         ire = xre
         meft = itot - ngath*ire
         ire = xre + .99
         write(LERR,*)'xre= ',xre,' ire= ',ire,' meft= ',meft
         irs = 1
         ns = 1
         ne = ngath
      endif
      ntrout = ire - irs + 1
      nreout = ne - ns + 1
      if(ntpr .gt. ntrout) ntpr = ntrout
c   number output records
      xreco = float(ntrout)/float(ntpr)
      nreco = xreco + 0.99
      ireco = xreco 
      left = ntrout - ireco*ntpr
      ipad = ntpr - left
      write(LERR,*)'left= ',left,' ntrout= ',ntrout,' ntpr= ',ntpr

c-------------------------------------------------------------
c        save key parameters in line header; save command
c        line in historical line header
c-------------------------------------------------------------
      call saver(sheader, 'MnDpIn', nd1 , LINHED)
      call saver(sheader, 'MxDpIn', nd2 , LINHED)
      call saver(sheader, 'MnLnIn', nl1 , LINHED)
      call saver(sheader, 'MxLnIn', nl2 , LINHED)

      if(renum) then
         if(ntpr .ne. 1) then
            write(LERR,*) 'ntpr = ',ntpr,' .ne. 1 !'
            write(LERR,*) 'cannot do a simple renumbering using -R'
     1               //' option'
            stop 666
         endif 
         call savew( sheader, 'NumTrc', nreco, LINHED)
         call savew( sheader, 'NumRec', ntpr , LINHED)
      else
         call savew( sheader, 'NumTrc', ntpr , LINHED)
         call savew( sheader, 'NumRec', nreco, LINHED)
         if (threed) then
            nd = nd2 - nd1 + 1
            nl = nl2 - nl1 + 1
            call savew( sheader, 'NumTrc', nl , LINHED)
            call savew( sheader, 'NumRec', nd , LINHED)
         endif

      endif

      call savhlh( sheader, lbytes, lbyout)
      call WRTAPE (luout, sheader, lbyout)

      call savelu('TrcNum',ifmt_TrcNum,l_trcnum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_recnum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_srcloc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_recind,ln_RecInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_dstsgn,ln_DstSgn,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_stacor,ln_StaCor,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)
      call savelu('FlReFN',ifmt_FlReFN,l_FlReFN,ln_FlReFN,TRACEHEADER)
      call savelu('ToStUn',ifmt_ToStUn,l_ToStUn,ln_ToStUn,TRACEHEADER)
      call savelu('ToTmAU',ifmt_ToTmAU,l_ToTmAU,ln_ToTmAU,TRACEHEADER)
      call savelu('SrcPnt',ifmt_SrcPnt,l_SrcPnt,ln_SrcPnt,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)
      call savelu('FoldNm',ifmt_FoldNm,l_FoldNm,ln_FoldNm,TRACEHEADER)
      call savelu('SrRcMX',ifmt_SrRcMX,l_SrRcMX,ln_SrRcMX,TRACEHEADER)
      call savelu('SrRcMY',ifmt_SrRcMY,l_SrRcMY,ln_SrRcMY,TRACEHEADER)
      call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TRACEHEADER)
      call savelu('CDPBCY',ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,TRACEHEADER)
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)
      call savelu('FoldNm',ifmt_FoldNm,l_FoldNm,ln_FoldNm,TRACEHEADER)
c______________________________________________________________________
c     calculate memory requirements
c______________________________________________________________________
      write(lerr,'(///,80a1)') ('_',i=1,80)
      write(lerr,'(A)')'storage map of major arrays'
      write(lerr,'(80a1)') ('_',i=1,80)
C
      l_free=1
      write(lerr,'(a20,3a10)')'variable name','begin','end','length'
      call mapmem('ugather',l_ugather,l_free,nsamp*ngath,lerr)
      call mapmem('weight',l_weight,l_free,nsamp*ngath,lerr)
      call mapmem('usum',l_usum,l_free,nsamp,lerr)
      call mapmem('udenom',l_udenom,l_free,nsamp,lerr)
      call mapmem('icount',l_icount,l_free,nsamp,lerr)
      call mapmem('taper',l_taper,l_free,ngath**2,lerr)
      call mapmem('xoff',l_xoff,l_free,ngath,lerr)
      call mapmem('theta',l_theta,l_free,ngath,lerr)
C_______________________________________________________________________
C     allocate dynamic memory.
C_______________________________________________________________________
      lens=l_free-1
      write(lerr,'(a20,10x,i10)') 'total vector length',lens
      write(lerr,'(//,a)') 'allocate dynamic memory for STACK: '
      write(lerr,*) 1.e-6*lens,' Mwords'
      write(lerr,*) 1.e-6*lens*szsmpd,' Mbytes'
      write(ler,'(//,a)') 'allocate dynamic memory for STACK: '
      write(ler,*) 1.e-6*lens,' Mwords'
      write(ler,*) 1.e-6*lens*szsmpd,' Mbytes'
      call galloc(pntrs,lens*szsmpd,ierrcd,0)
      if(ierrcd .ne. 0 ) then
         write(lerr,*)'galloc memory allocation error from main'
         write(lerr,*)'ierrcd = ',ierrcd
         write(lerr,*)
         write(lerr,*)'probable cause: too much memory requested!'
         write(lerr,*)
         write(lerr,*)'program STACK aborted'
         call exitfu(101)
      endif
c---------------------------------------------------------------------
c     get weights for all possible combination of live samples.
c     for non unitary weights, the traces should be sorted by distance,
c     be equally spaced, and have dead traces interpolated.
c---------------------------------------------------------------------
      call getwgt(s(l_taper),s(l_theta),s(l_xoff),ngath,
     1            lerr,hamming,blackman,tnorm,snorm,verbos)
c---------------------------------------------------------------------
c     Skip unwanted records if necessary.  Skipping is done
c     in groups of ntr traces per record.
c---------------------------------------------------------------------
      call recskp(1,irs-1,luin,ntr,bufin)    
c
      ic=1
      icc = 0
      irec = 1
      do 10000 i=irs,ire
c-----------------------------------------------------------------------------
c      if no. traces in gather is not input no. traces/gath we may have some 
c      traces in input left over, i.e. partial gather
c-----------------------------------------------------------------------------
       if(ngath .ne. ntr .and. i .eq. ire .and. meft.ne.0)ngath = meft
       call stacksub(bufin,bufin,bufout,bufout,lntrhd,threed,BC,
     1               nsamp,nbytes,holdi,holdo,renum,
     2               s(l_ugather),s(l_usum),s(l_udenom),ITRWRD,
     3               s(l_weight),s(l_xoff),s(l_taper),s(l_icount),
     4               power,ic,icc,irs,ire,irec,ngath,ntpr,ifmt_CDPBCY,
     5               hbegin,luin,luout,lerr,verbos,ns,ne,ifmt_CDPBCX,
     6               semb,semwt,snorm,dwgt,l_CDPBCX,ln_CDPBCX,ln_CDPBCY,
     7               d1neg,d2neg,d1pos,d2pos,l_SrRcMX,l_SrRcMY,l_CDPBCY,
     8               l_FlReFN,l_ToStUn,l_ToTmAU,l_RecNum,l_TrcNum,
     9               l_RecInd,l_DphInd,l_SrcLoc,l_SrcPnt,
     a               l_StaCor,l_DstSgn,l_LinInd,l_SoPtNm,ln_SrRcMX,
     8               ln_FlReFN,ln_ToStUn,ln_ToTmAU,ln_RecNum,ln_TrcNum,
     9               ln_RecInd,ln_DphInd,ln_SrcLoc,ln_SrcPnt,
     a               ln_StaCor,ln_DstSgn,ln_LinInd,ln_SoPtNm,ln_SrRcMY,
     8               ifmt_FlReFN,ifmt_ToStUn,ifmt_ToTmAU,ifmt_RecNum,
     9               ifmt_TrcNum,ifmt_RecInd,ifmt_DphInd,ifmt_SrcLoc,
     a               ifmt_SrcPnt,ifmt_StaCor,ifmt_DstSgn,
     b               ifmt_LinInd,ifmt_SoPtNm,ifmt_SrRcMX,ifmt_SrRcMY,
     c  ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,
     d  ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,
     e  ifmt_FoldNm,l_FoldNm,ln_FoldNm)

c 
c *** check if nbytes is zero, i.e., end of file reached on input
c *** if so, jump out of do loop
c *** message was written out in stacksub
c

      if (nbytes .eq. 0) go to 11000

10000 continue
11000 if(left .ne. 0) then
c_______________________________________________________________________
c        pad the last record.               
c_______________________________________________________________________
         do 20000 l = 1, ipad
          icc = icc + 1
c         bufout(l_recnum)=irec
c         bufout(l_trcnum)=icc
c         bufout(l_stacor)=30000
          call savew2(bufout,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                irec  , TRACEHEADER)
          call savew2(bufout,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                icc   , TRACEHEADER)
          call savew2(bufout,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                30000 , TRACEHEADER)
          call wrtape(luout,bufout,nbytes)
20000    continue
      endif
c-------------------------------------------
c     Close files and end program
c-------------------------------------------
      call lbclos(luin)
      call lbclos(luout)
      write(lerr,*)'Normal completion of routine STACK'
      close(lerr)  
      write(ler,*)'Normal completion of routine STACK'
c
      call exitfu(0)
      end


c-------------------------------------------
c        online help
c-------------------------------------------
      subroutine help
#include <f77/iounit.h>

         write(LER,*)
     1 '***************************************************************'
         write(LER,*)
     1 'Run this program by typing: stack and the following arguments'
         write(LER,*)
     1 ' -N[ntap]    (no default)      : Input data file name'
         write(LER,*)
     1 ' -O[otap]    (no default)      : Output data file name'
         write(LER,*)
     1 ' -d2neg[d2neg] far distance  - negative side of spread (-ve #)'
         write(LER,*)
     1 ' -d1neg[d1neg] near distance - negative side of spread (-ve #)'
         write(LER,*)
     1 ' -d1pos[d1pos] near distance - positive side of spread'
         write(LER,*)
     1 ' -d2pos[d2pos] far distance  - positive side of spread'
         write(LER,*)
     1 ' -rs[irs] starting record (default = 1)'
         write(LER,*)
     1 ' -re[ire] ending record   (default = all)'
         write(LER,*)
     1 ' -ns[ns] starting trace   (default = 1)'
         write(LER,*)
     1 ' -ne[ne] ending trace     (default = all)'
         write(LER,*)
     1 ' -tr[ntpr] output number traces/rec (default = 1)'
         write(LER,*)
     1 ' -gath[ngath] force number of input traces/gather'
         write(LER,*)
     1 ' -pw[power] nth root power (default = 1.0)'
         write(LER,*)
     1 ' -H        if present, weight stack with hamming taper'         
         write(LER,*)
     1 ' -B        if present, weight stack with blackman taper'         
         write(LER,*)
     1 ' -D        if present, weight stack with receiver offset'        
         write(LER,*)
     1 ' -swt      if present, weight stack with semblance'      
         write(LER,*)
     1 ' -sem      if present, output semblance'
         write(LER,*)
     1 ' -S        if present, gen weights to reflect live traces' 
     2             //' in the gather (same for all times)'
         write(LER,*)
     1 ' -L        if present, gen weights to reflect live samples'
     2             //' at each time'
         write(LER,*)
     1 ' -R        if present, change line header to be one record,'
     2       //' multiple traces (for MBS model building)'
         write(LER,*)
     1 ' -threed   if present, output is assumed to be 3D from sr3d2'
     2       //' # trcs/rec set to be # of DIs, # recs will be # LIs'
         write(LER,*)
     1 ' -BC       if present, compute CDP XYs from S/R XYs'
         write(LER,*)
     1 ' -V  Verbose mode.  All command line and lineheader parameters'
         write(LER,*)
     1 '                    printed to standard error output'
         write(LER,*)
     : 'USAGE:  ' 
         write(LER,*)
     : 'stack -N[ntap] -O[otap] -d2neg[] -d1neg[] -d1pos[] -d2pos[]'
         write(LER,*)
     : '       -ns[] -ne[] -rs[] -re[] -ngath[] -ntpr[] -pw[]'
         write(LER,*)
     : '       [-H -B -D -sem -swt -L  -R -threed -BC -V]'
         write(LER,*)
     1 '***************************************************************'

      return
      end

      subroutine cmdln(d1pos,d2pos,d1neg,d2neg,ngath,ntpr,ntr,nrec,
     1                 power,ns,ne,irs,ire,semb,semwt,verbos,renum,
     2                 tnorm,snorm,dwgt,blackman,hamming,threed,BC)
c-----
c     get command arguments
c
c      ns   - I      start trace
c      ne   - I      stop end trace
c     irs   - I      start record
c     ire   - I      stop end record
c    d1pos  - R      min distance to stack (positive side of spread)
c    d2pos  - R      max distance to stack (negative side of spread)
c    d1neg  - R      min distance to stack (positive side of spread)
c    d2neg  - R      max distance to stack (negative side of spread)
c    ntpr   - I      number traces per rec on output
c    ngath  - I      force number traces in gather to stack
c     ntpr  - I      output number traces/record
c     power  - R      take nth nth root, stack, then nth power
c   snorm   - L      normalize stacked trace by # live samples
c    semb   - L      output semblance
c    semwt  - L      output semblance weghted stack
c    verbos - L      verbose output or not
c-----
#include <f77/iounit.h>
      integer   ns,ne,irs,ire,ngath,ntpr, argis
      real      d1pos,d2pos,d1neg,d2neg,power
      logical   semb,semwt,verbos,renum
      logical   dwgt,blackman,hamming,snorm,tnorm,threed,BC
c----------------------------------------------------------------------------
c        ARGXXX has parameters
c             ( flag, variable name, default value, format error value )
c-----------------------------------------------------------------------------
      call ARGR4  ('-d2neg', d2neg, -99999., -99999.)
      call ARGR4  ('-d1neg', d1neg, -00000., -00000.)
      call ARGR4  ('-d1pos', d1pos,  00000.,  00000.)
      call ARGR4  ('-d2pos', d2pos,  99999.,  99999.)
      call ARGI4  ('-ns', ns, 0, 0)
      call ARGI4  ('-ne', ne, 0, 0)
      call ARGI4  ('-rs', irs, 0, 0)
      call ARGI4  ('-re', ire, 0, 0)
      call ARGI4  ('-tr', ntpr, 1, 1)
      call ARGR4  ('-pw', power, 1.0, 1.0)
      call ARGI4  ('-gath', ngath, 0, 0)
 
      tnorm = ( argis ('-S') .gt. 0 )
      snorm = ( argis ('-L') .gt. 0 )
      semb  = ( argis ('-sem') .gt. 0 )
      semwt = ( argis ('-swt') .gt. 0 )
      renum = ( argis ('-R') .gt. 0 )
      dwgt  = ( argis ('-D') .gt. 0 )
      blackman =( argis ('-B') .gt. 0 )
      hamming  =( argis ('-H') .gt. 0 )
      threed   =( argis ('-threed') .gt. 0 )
      BC       =( argis ('-BC') .gt. 0 )

      ierror=0
C
      if(ns .eq. 0) ns=1
      if(ne .eq. 0) ne=ntr
      ne=min(ne,ntr)
c
      if(irs .eq. 0) irs=1 
      if(ire .eq. 0) ire=nrec
      ire=min(ire,nrec)
c
      if (power .eq. 0.0) power = 1.0
c
      noption=0
      if(semb) noption=noption+1
      if(semwt) noption=noption+1
      if(power .ne. 1.) noption=noption+1
      if(blackman) noption=noption+1
      if(hamming) noption=noption+1
c
      if(noption .gt. 1) then
         write(lerr,*) 'command line error in routine STACK!'
         write(lerr,*) 'can only invoke one of the following options:'
         write(lerr,'(a10,l10)') '-sem',semb,'-swt',semwt,
     1                     '-B',blackman,'-H',hamming
         write(lerr,'(a10,f10.1)') '-pw',power           
         write(lerr,*) 'number of options chosen = ',noption
         ierror=ierror+1
      endif
 
      verbos = ( argis ('-V') .gt. 0 )
c---------------------------------------------
c     check range limiting parameters
c---------------------------------------------
      if(d1neg .lt. d2neg) then
        write(LERR,*)'d1neg should be near range negative side of spread
     1(a -ve number)'
        write(LERR,*)'d2neg should be far range negative side of spread
     1(a -ve number)'
        write(LERR,*)'Check command line arguments & rerun'
        ierror=ierror+1
      endif
      if(d1pos .gt. d2pos) then
        write(LERR,*)'d1pos should be near range '
     1                //'positive side of spread'
        write(LERR,*)'d2pos should be far range '                       
     1                //'positive side of spread'
        write(LERR,*)'Check command line arguments & rerun'
        ierror=ierror+1
      endif
c
      if(ierror .ne. 0) then
         write(lerr,*) 'routine STACK aborted due to ',ierror,
     1                 ' command line errors!'
         call exitfu(666)
      endif

      return
      end
