C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine stacksub(uin,bufin,uout,bufout,lntrhd,threed,BC,
     1               nsamp,nbytes,holdi,holdo,renum,
     2               ugather,usum,udenom,ITRWRD,
     3               weight,xtemp,taper,icount,
     4               power,ic,icc,irs,ire,irec,ngath,ntpr,ifmt_CDPBCY,
     5               hbegin,luin,luout,lerr,verbos,ns,ne,ifmt_CDPBCX,
     6               semb,semwt,snorm,dwgt,l_CDPBCX,ln_CDPBCX,ln_CDPBCY,
     7               d1neg,d2neg,d1pos,d2pos,l_SrRcMX,l_SrRcMY,l_CDPBCY,
     8               l_FlReFN,l_ToStUn,l_ToTmAU,l_RecNum,l_TrcNum,
     9               l_RecInd,l_DphInd,l_SrcLoc,l_SrcPnt,
     a               l_StaCor,l_DstSgn,l_LinInd,l_SoPtNm,ln_SrRcMX,
     8               ln_FlReFN,ln_ToStUn,ln_ToTmAU,ln_RecNum,ln_TrcNum,
     9               ln_RecInd,ln_DphInd,ln_SrcLoc,ln_SrcPnt,
     a               ln_StaCor,ln_DstSgn,ln_LinInd,ln_SoPtNm,ln_SrRcMY,
     8               ifmt_FlReFN,ifmt_ToStUn,ifmt_ToTmAU,ifmt_RecNum,
     9               ifmt_TrcNum,ifmt_RecInd,ifmt_DphInd,ifmt_SrcLoc,
     a               ifmt_SrcPnt,ifmt_StaCor,ifmt_DstSgn,
     b               ifmt_LinInd,ifmt_SoPtNm,ifmt_SrRcMX,ifmt_SrRcMY,
     c  ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,
     d  ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,
     e  ifmt_FoldNm,l_FoldNm,ln_FoldNm)
c
      parameter  (pi=3.14159265,twopi=2.*pi)
      parameter  (eps=1.e-20)
      integer    hbegin
c
      integer    bufin(*)
      integer    bufout(*)
      integer    holdi(*)
      integer    holdo(*)
c
      real       uin(hbegin:nsamp)
      real       uout(hbegin:nsamp)
      real       ugather(nsamp,ngath)
      real       usum(nsamp)
      real       udenom(nsamp)
      real       taper(ngath,ngath)     
      real       weight(nsamp,ngath) 
      real       xtemp(ngath)
      integer    icount(nsamp)
      logical    semb,semwt,verbos,snorm,dwgt,threed,BC
      logical    renum
c
      powerinv=1./power
c_______________________________________________________________________
c     zero out output data array and trace header
c_______________________________________________________________________

c     do 10000 j=1,lntrhd
c      bufout(j)=0
c0000 continue
      call vclr(uout(1),1,nsamp)           
      call vclr(usum,1,nsamp)
      do 12000 isamp=1,nsamp
       udenom(isamp)=eps
       icount(isamp)=0
12000 continue

      noffset = 0
      cdpxsum = 0.
      cdpysum = 0.

      if(verbos) then
         write(lerr,'(7a10)')
     1            'ioffset','RecNum','TrcNum','SrcLoc',
     2            'DphInd','SrcPnt','LinInd'
      endif

      do 20000 k=1,ngath
       nbytes=0
c      call rtape(luin,uin(hbegin),nbytes)
       call rtape(luin,holdi,nbytes)
       call move (1, uin(hbegin), holdi(1), nbytes)
       if(nbytes .eq. 0) then
          write(lerr,*)'End of file on input:'
          write(lerr,*)'  rec= ',irec,'  trace= ',k
          return      
       endif

       if(k .ge. ns .and. k .le. ne) then
c_____________________________________________________________________
c         trace falls within trace window.         
c_____________________________________________________________________
          call saver2(bufin,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                istatic  , 1)
          am = 0.
          do  ii = 1, nsamp
              am = am + abs(uin(ii))
          enddo

          if(istatic .ne. 30000 .AND. am .ne. 0.0) then
c_____________________________________________________________________
c            live trace.                           
c_____________________________________________________________________
             call saver2(bufin,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                   idist    , 1)
             dist = float( idist )
             if(dist .ge. d2neg .and. dist .le. d1neg .OR.
     1          dist .ge. d1pos .and. dist .le. d2pos) then
c_____________________________________________________________________
c               trace falls within distance window.
c_____________________________________________________________________
                noffset=noffset+1
                if (noffset .eq. 1)
     1          call move (1, holdo(1), holdi(1), nbytes)
                xtemp(noffset)=dist
                call vmov(uin(1),1,ugather(1,noffset),1,nsamp)
                call vfill(dist,weight(1,noffset),1,nsamp)
c_____________________________________________________________________
c               capture important trace header information
c_____________________________________________________________________
                   call saver2(bufin,ifmt_FlReFN,l_FlReFN, ln_FlReFN,
     1                         i_FlReFN , 1)
                   call saver2(bufin,ifmt_ToStUn,l_ToStUn, ln_ToStUn,
     1                         i_ToStUn , 1)
                   call saver2(bufin,ifmt_ToTmAU,l_ToTmAU, ln_ToTmAU,
     1                         i_ToTmAU , 1)
                   call saver2(bufin,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                         i_RecNum , 1)
                   call saver2(bufin,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                         i_TrcNum , 1)
                   call saver2(bufin,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                         i_RecInd , 1)
                   call saver2(bufin,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1                         i_SrcLoc , 1)
                   call saver2(bufin,ifmt_SrcPnt,l_SrcPnt, ln_SrcPnt,
     1                         i_SrcPnt , 1)
                   call saver2(bufin,ifmt_SoPtNm,l_SoPtNm, ln_SoPtNm,
     1                         i_SoPtNm , 1)
                   call saver2(bufin,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                         i_LinInd , 1)
                   call saver2(bufin,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                         i_DphInd , 1)
                   call saver2(bufin,ifmt_SrRcMX,l_SrRcMX, ln_SrRcMX,
     1                         i_SrRcMX , 1)
                   call saver2(bufin,ifmt_SrRcMY,l_SrRcMY, ln_SrRcMY,
     1                         i_SrRcMY , 1)
                   if ( BC ) then
                      call saver2(bufin,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1                            i_SrPtXC , 1)
                      call saver2(bufin,ifmt_SrPtYC,l_SrPtYC, ln_SrPtYC,
     1                            i_SrPtYC , 1)
                      call saver2(bufin,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1                            i_RcPtXC , 1)
                      call saver2(bufin,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,
     1                            i_RcPtYC , 1)
                      cdpx = 0.5 * float (i_SrPtXC + i_RcPtXC) + 0.5
                      cdpy = 0.5 * float (i_SrPtYC + i_RcPtYC) + 0.5
                      cdpxsum = cdpxsum + cdpx
                      cdpysum = cdpysum + cdpy
                   else
                      call saver2(bufin,ifmt_CDPBCX,l_CDPBCX, ln_CDPBCX,
     1                            i_CDPBCX , 1)
                      call saver2(bufin,ifmt_CDPBCY,l_CDPBCY, ln_CDPBCY,
     1                            i_CDPBCY , 1)
                   endif

c
                if(verbos) then
                   write(lerr,'(7i10)')
     1                   noffset,i_recnum,i_trcnum,i_srcloc,
     2                   i_dphind,i_srcpnt,i_linind
                endif
             endif
          endif
       endif
20000 continue

      if (noffset .eq. 0) then
          do 20001  ii = 1,ITRWRD+nsamp
              bufout (ii) = 0
20001     continue
          call savew2(bufout,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                30000 , 1)
          go to 76000
      endif
c
      if(snorm) then
c_____________________________________________________________________
c        count how many non zero samples there are in each gather.
c        shift nonzero samples to the left.
c_____________________________________________________________________
         do 25000 k=1,noffset
          do 22000 isamp=1,nsamp
           if(ugather(isamp,k) .ne. 0.) then
              icount(isamp)=icount(isamp)+1
              ugather(isamp,icount(isamp))=ugather(isamp,k)
              weight(isamp,icount(isamp))=weight(isamp,k)       
           endif
22000     continue
25000    continue
         if(dwgt) then
c_____________________________________________________________________
c           calculate and normalize weights proportional to distance.
c_____________________________________________________________________
            do 30000 isamp=1,nsamp
             sum=0.
             do 26000 k=1,icount(isamp)
              xtemp(k)=weight(isamp,k)*taper(k,icount(isamp))
              sum=sum+xtemp(k)               
26000        continue
             if(sum .ne. 0.) then
                do 28000 k=1,icount(isamp)
                 weight(isamp,k)=xtemp(k)/sum
28000           continue
             else
                do 29000 k=1,icount(isamp)
                  weight(isamp,k)=0.
29000           continue
             endif
30000       continue
         else
c_____________________________________________________________________
c           weights invariant with distance. copy taper into weight.       
c_____________________________________________________________________
            do 30050 isamp=1,nsamp
             do 26050 k=1,icount(isamp)
              weight(isamp,k)=taper(k,icount(isamp))
26050        continue
30050       continue
         endif
      else
c_____________________________________________________________________
c        simple normalization by the number of live traces in the 
c        window.
c_____________________________________________________________________
         if(dwgt) then
c_____________________________________________________________________
c           calculate and normalize weights proportional to distance.
c_____________________________________________________________________
            sum=0.
            do 26100 k=1,noffset             
             xtemp(k)=weight(1,k)*taper(k,noffset)             
             sum=sum+xtemp(k)               
26100       continue
            if(sum .ne. 0.) then
               do 28100 k=1,noffset        
                do 28050 isamp=1,nsamp
                 weight(isamp,k)=xtemp(k)/sum
28050           continue
28100          continue
            else
               call vclr(weight,1,nsamp*noffset)
               write(lerr,*) 'possible error in routine stacksub'
               write(lerr,*) 'distance weights are all zero!'
               write(lerr,*) 'noffset = ',noffset
               write(lerr,*) 'xtemp ',(xtemp(k),k=1,noffset)
            endif
         else
c_____________________________________________________________________
c           weights invariant with distance. taper into weight.           
c_____________________________________________________________________
            do 30150 k=1,noffset  
             do 26150 isamp=1,nsamp         
              weight(isamp,k)=taper(k,noffset)             
26150        continue
30150       continue
         endif
      endif
c
      if(power .ne. 1.) then
c_____________________________________________________________________
c        do power-th root stack of the input data.
c_____________________________________________________________________
         do 35000 k=1,noffset
          do 31000 isamp=1,nsamp
           ampl=sign(abs(ugather(isamp,k))**powerinv,
     1                                       ugather(isamp,k))
           usum(isamp)=ampl+usum(isamp)
31000     continue
c_____________________________________________________________________
c         raise stacked trace to the power 'power'
c_____________________________________________________________________
          do 32000 isamp=1,nsamp
           usum(isamp)=sign(abs(usum(isamp))**power,usum(isamp))
32000     continue
35000    continue
      elseif(semb .or. semwt) then
         do 50000 k=1,noffset
c_____________________________________________________________________
c         do power-th root stack of the input data.
c_____________________________________________________________________
          do 40000 isamp=1,nsamp
           usum(isamp)=usum(isamp)+ugather(isamp,k)
           udenom(isamp)=udenom(isamp)+ugather(isamp,k)**2
40000     continue
50000    continue
      elseif(snorm) then
c_____________________________________________________________________
c        weighted stack honoring mute zones (zero valued samples).
c_____________________________________________________________________
         do 55000 isamp=1,nsamp
          do 52000 k=1,icount(isamp)
           usum(isamp)=usum(isamp)
     1                  +ugather(isamp,k)*weight(isamp,k)           
52000     continue
55000    continue
      else
c_____________________________________________________________________
c        simple weighting (with or without normalization).        
c_____________________________________________________________________
         do 70000 k=1,noffset
          do 60000 isamp=1,nsamp
           usum(isamp)=usum(isamp)+ugather(isamp,k)*weight(isamp,k)
60000     continue
70000    continue
      endif
      if(noffset .eq. 0) noffset = 1
      if(semb) then
c_____________________________________________________________________
c        output the semblance.             
c_____________________________________________________________________
         do 72000  isamp=1,nsamp
          uout(isamp)=(usum(isamp)**2)/udenom(isamp)
72000    continue
      elseif(semwt) then
c_____________________________________________________________________
c        output the semblance weighted stack
c_____________________________________________________________________
         do  74000  isamp=1,nsamp
          uout(isamp)=(usum(isamp)**3)/(udenom(isamp)*noffset)
74000    continue
      else
c_____________________________________________________________________
c        output non semblance weighted stack
c_____________________________________________________________________
         do 75000 isamp=1,nsamp
          uout(isamp)=usum(isamp)
75000    continue
      endif
76000 continue
      icc = icc + 1

c     call move (1, bufout(1), holdo(1), SZTRHD)
      call vmov (holdo(1), 1, bufout(1), 1, ITRWRD)
c----
c   deal with completely dead gather
c----
      if (noffset .eq. 0) then
         do  ii = 1, ITRWRD+nsamp
             bufout (ii) = 0
         enddo
         call savew2(bufout,ifmt_StaCor,l_StaCor, ln_StaCor,
     1               30000 , 1)
         i_ToStUn = 0
         i_ToTmAU = 0
c        i_DphInd = 0
c        i_LinInd = 0
         i_SrcLoc = 0
         i_SrcPnt = 0
         i_SoPtNm = 0
         i_CDPBCX = 0
         i_CDPBCY = 0
      else
        if ( BC ) then
           cdpxsum = cdpxsum / noffset
           cdpysum = cdpysum / noffset
           i_CDPBCX = cdpxsum
           i_CDPBCY = cdpysum
        endif
      endif
c----
c   put proper indexing into stacked trace
c----
 
                   call savew2(bufout,ifmt_ToStUn,l_ToStUn, ln_ToStUn,
     1                         i_ToStUn , 1)
                   call savew2(bufout,ifmt_ToTmAU,l_ToTmAU, ln_ToTmAU,
     1                         i_ToTmAU , 1)
c 
c  Changed to switch output RecNum and TrcNum if renum flag is set - jev
c
                   if (renum) then
                     call savew2(bufout,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                           icc       , 1)
                     call savew2(bufout,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                           irec      , 1)
                   else
                     call savew2(bufout,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                           irec     , 1)
                     call savew2(bufout,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                           icc      , 1)
                   endif

                   call savew2(bufout,ifmt_RecInd,l_RecInd, ln_RecInd,
     1                         i_RecInd , 1)
                   call savew2(bufout,ifmt_DphInd,l_DphInd, ln_DphInd,
     1                         i_DphInd , 1)
                   call savew2(bufout,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1                         i_SrcLoc , 1)
                   call savew2(bufout,ifmt_SrcPnt,l_SrcPnt, ln_SrcPnt,
     1                         i_SrcPnt , 1)
                   call savew2(bufout,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                         i_LinInd , 1)
                   call savew2(bufout,ifmt_SoPtNm,l_SoPtNm, ln_SoPtNm,
     1                         i_SoPtNm , 1)
                   call savew2(bufout,ifmt_SrRcMX,l_SrRcMX, ln_SrRcMX,
     1                         i_SrRcMX , 1)
                   call savew2(bufout,ifmt_SrRcMY,l_SrRcMY, ln_SrRcMY,
     1                         i_SrRcMY , 1)
                   call savew2(bufout,ifmt_CDPBCX,l_CDPBCX, ln_CDPBCX,
     1                         i_CDPBCX , 1)
                   call savew2(bufout,ifmt_CDPBCY,l_CDPBCY, ln_CDPBCY,
     1                         i_CDPBCY , 1)
                   call savew2(bufout,ifmt_FoldNm,l_FoldNm, ln_FoldNm,
     1                         noffset , 1)

      if(mod(icc,ntpr) .eq. 0) then
        irec=irec+1                 
        icc = 0
      endif
      ic=ic+1
      call wrtape(luout,bufout,nbytes)
c
      return
      end
