C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Multiple ( JJ, index, traces, times, velocities,  
     :     depths, indexOut, tracesOut, timesOut, Simple, Flat,
     :     MultOrder, pickOutndx, nsegOut, nsi, TraceSpacing )

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      integer JJ, index(2*SZSMPM,2), indexOut(2*SZSMPM,2)
      integer MultOrder, pickndx, pickOutndx, nsegOut, nsi

      real traces(*), times(*), velocities(*), depths(*)
      real tracesOut(*), timesOut(*), TraceSpacing

      real dips(SZLNHD)

      logical Simple, Flat

c initialize variables

      call vclr ( dips, 1, SZLNHD )
      pickndx = 0

c determine pickndx of this segment start

      if ( JJ .eq. 1 ) then
         pickndx = 0
      else
         do i = 1, JJ-1
            pickndx = pickndx + index(i,1)
         enddo
      endif

c determine nsegOut for this segment

      nsegOut = nsegOut + 1

c load primary to output arrays

      indexOut(nsegOut,1) = index(JJ,1)
      indexOut(nsegOut,2) = index(JJ,2)

      do i = 1, index(JJ,1)
         pickOutndx = pickOutndx + 1
         tracesOut(pickOutndx) = traces(pickndx+i)
         timesOut(pickOutndx) = times(pickndx+i) * float(nsi)
      enddo

c calculate dips at each input pick

      call GetDips (JJ, pickndx, index, traces, times, velocities, 
     :     depths, dips, TraceSpacing )
 
c calculate and load to output all required multiples of this segment

      IF (Simple) then

c do only the order requested


         do k = 1, index(JJ,1)

c choose flat or dipping algorithm
          if (Flat)then
           factor=float(MultOrder+1)
          else
           if(dips(pickndx+k) .gt. .01)then
            factor=sin((MultOrder+1)*dips(pickndx+k))
     &            /sin(dips(pickndx+k))
           else
            factor=float(MultOrder+1)
           endif
           if((MultOrder+1)*dips(pickndx+k) .gt. 1.56)then
            factor=0.
            write(LERR,*)'excess dip for pick',k,', segment',JJ,
     &     ', order',MultOrder
           endif
          endif
            pickOutndx = pickOutndx + 1
            tracesOut(pickOutndx) = traces(pickndx+k)
            timesOut(pickOutndx) = times(pickndx+k) * factor *float(nsi)

         enddo

c determine nsegOut for this segment

         nsegOut = nsegOut + 1

c load primary to output arrays

         indexOut(nsegOut,1) = index(JJ,1)
         indexOut(nsegOut,2) = index(JJ,2)

      ELSE

c do up to and including the order requested ( MultOrder segments)

         do j = 1, MultOrder

            do k = 1,index(JJ,1)

               pickOutndx = pickOutndx + 1

c choose flat or dipping algorithm
         if (Flat)then
          factor=float(j+1)
         else
          if(dips(pickndx+k) .gt. .01)then
           factor=sin((j+1)*dips(pickndx+k))/sin(dips(pickndx+k))
          else
          factor=float(j+1)
          endif
          if((j+1)*dips(pickndx+k) .gt. 1.56)then
           factor=0.
           write(LERR,*)'excess dip for pick',k,', segment',JJ,
     &     ', order',j
          endif
         endif
         tracesOut(pickOutndx) = traces(pickndx+k)
         timesOut(pickOutndx) = 
     :   times(pickndx+k) * factor * float(nsi)
            enddo

c determine nsegOut for this segment

            nsegOut = nsegOut + 1

c load multiple to output arrays

            indexOut(nsegOut,1) = index(JJ,1)
            indexOut(nsegOut,2) = index(JJ,2)

         enddo

      ENDIF

      return
      end

