C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine WritePick(lupick, index, traces, times, Simple, 
     :     MultOrder, nseg, ntrc )

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      integer lupick, index(2*SZSMPM,2), MultOrder, nseg, ntrc
      integer pickndx

      real traces(*), times(*)

      logical Simple

c initialize variables

      pickndx = 0

      do i=1, nseg

c write segment header

         IF ( Simple )then
            
c output primaries and selected order of multiples

            if ( mod(i,2) .eq. 0 ) then

c in multiple mode

               write(lupick,401) i, index(i,2), index(i,1)
 401           format('Segment = ',i5,' Name             MULTIPLE',
     :              '  color = ',i5,' picks = ',i5)
            else
c this is a primary

               write(lupick,402) i, index(i,2), index(i,1)
 402           format('Segment = ',i5,' Name              PRIMARY',
     :              '  color = ',i5,' picks = ',i5)
            endif
         ELSE

c output primaries and all orders of multiples

            if ( mod((i-1),(MultOrder+1)) .ne. 0 ) then

c in multiple mode

               write(lupick,401) i, index(i,2), index(i,1)
            else

c this is a primary
            
               write(lupick,402) i, index(i,2), index(i,1)
            endif
         ENDIF

c write out picks for this segment

         if ( ntrc .eq. 1 ) then

c write traces to records column [we have single trace records]

            do  j=1, index(i,1)
               pickndx = pickndx + 1
               write(lupick,403)traces(pickndx), 1.0, times(pickndx)
 403           format(f12.6,1x,f12.6,1x,f12.6)
            enddo
         else

c write traces to trace column [we have on record of many traces]

            do  j=1, index(i,1)
               pickndx = pickndx + 1
               write(lupick,403) 1.0, traces(pickndx), times(pickndx)
            enddo
         endif
      enddo
      return
      end
