C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine reciprocals(recip, livesum, isamp, NumTrc, im, kk, jj,
     1                       i_mult_num, i_mult_asg, 
     2                       livesum_num, livesum_asg)
      implicit none

c-----------------------------------------------------------------------
c Bertram Kaufhold	05/01/98
c
c For the i-direction (down trace) there is really nothing changing
c i.e., the traces are either filled with ones or zeros. Therefore
c instead of doing time consuming summation we can multiply the
c outcome of the j-k-plane summation by the actual window length in
c i-direction for every focal point to find N(i,j,k), the focal point
c divisor. The situation simplifies even more because only three
c different cases have to be considered which will lead to a set
c of multipliers which can be used for the whole plane.
c Let us look at the following example:
c let iap=2, i.e. im=3 and the overall window length is ii=5
c
c   ---  compute partial      compute partial       compute full
c  | * | sum for i=1     ---  sum for 1<i<im        sum for i>=im
c  | * |                | * |                 ---
c -| * |----------------| * |----------------| * |------------
c  | * |                | * |                | * |
c  | * |                | * |                | * |
c   ---                 | * |                | * |
c                        ---                 | * |
c                                             ---
c From this it follows that there are only im different multipliers
c that have to be used! This multipliers are calculated in the 
c beginning of subroutine process
c 
c i=1          => im  		<=This multipliers are the only 
c i=2          => im + 1	<=ones that are actually of
c  :           :  :		<=importance for us
c i=im         => im + iap	
c  :           => im + iap
c i=NumTrc-im  => im + iap
c  :           :  :
c i=NumTrc-iap => im + 1
c i=NumTrc     => im
c-----------------------------------------------------------------------

      integer isamp, NumTrc, im, kk, jj
      real recip(im, kk*jj)
      integer livesum(NumTrc), i_mult_asg(isamp), livesum_asg(NumTrc)
      integer i_mult_num(im), livesum_num(NumTrc) 

      integer i, j, m, n
      logical jfinder 

c-----------------------------------------------------------------------
c The x-y-plane summation multipliers stored in livesum only contain a
c reduced set of numbers (number of multipliers <= kk*jj). To reduce 
c outer product processing time we will find the set of numbers that 
c are contained in livesum and store them in livesum_num
 
      livesum_num(1) = livesum(1)
      livesum_asg(1) = 1
      m = 2
      do j = 2, NumTrc         
         n = 1
10       if (n .le. m-1) then                  
            if (livesum(j) .ne. livesum_num(n)) then
               jfinder = .true.
               n = n + 1
            else
               jfinder = .false.
               livesum_asg(j) = n
               n = m  
            endif 
            go to 10        
         endif
         if  (jfinder) then   
         livesum_num(m) = livesum(j)  
         livesum_asg(j) = m
         m = m + 1
         endif
      enddo      
 
c-----------------------------------------------------------------------
c Create a table look up for all possible focal point multipliers
c Using this table in connection with the assignment vectors i_mult_asg
c and livesum_asg we are able to obtain values for each focal point
c divisor (see subroutine write_avg_record)

      do j = 1, m-1
         do i = 1, im
            recip(i,j) = i_mult_num(i) * livesum_num(j)
            if (recip(i,j) .ne. 0.0) then
               recip(i,j) = 1.0 / recip(i,j)
            else
               recip(i,j) =1.0
            endif	
         enddo
      enddo
      
      end             



