C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine copy_record(uout, tsum, isamp, NumTrc)
      implicit none

c-----------------------------------------------------------------------
c Kelly D. Crawford - 04/14/97
c
c This routine copies the record tsum into the record uout.
c
c-----------------------------------------------------------------------

      integer isamp, NumTrc
      real uout(isamp, NumTrc)
      double precision tsum(isamp, NumTrc)

      integer i, j

      do j = 1, NumTrc
         do i = 1, isamp
            uout(i,j) = tsum(i,j)
         enddo
      enddo

      end

      subroutine add_record(uout, tsum, isamp, NumTrc)
      implicit none

c-----------------------------------------------------------------------
c Kelly D. Crawford - 04/14/97
c
c This routine adds the record tsum to the record uout.
c
c-----------------------------------------------------------------------

      integer isamp, NumTrc
      real uout(isamp, NumTrc)
      double precision tsum(isamp, NumTrc)

      integer i, j

      do j = 1, NumTrc
         do i = 1, isamp
            uout(i,j) = uout(i,j) + tsum(i,j)
         enddo
      enddo

      end

      subroutine drop_record(uout, tsum, isamp, NumTrc)
      implicit none

c-----------------------------------------------------------------------
c Kelly D. Crawford - 04/14/97
c
c This routine subtracts the record tsum from the record uout.
c
c-----------------------------------------------------------------------

      integer isamp, NumTrc
      real uout(isamp, NumTrc)
      double precision tsum(isamp, NumTrc)

      integer i, j

      do j = 1, NumTrc
         do i = 1, isamp
            uout(i,j) = uout(i,j) - tsum(i,j)
         enddo
      enddo

      end

      subroutine add_drop_record(uout, addsum, dropsum, isamp, NumTrc)
      implicit none

c-----------------------------------------------------------------------
c Kelly D. Crawford - 04/14/97
c
c This routine adds the record addsum and subtracts the record dropsum
c to and from the record uout.
c
c-----------------------------------------------------------------------

      integer isamp, NumTrc
      real uout(isamp, NumTrc)
      double precision addsum(isamp, NumTrc), dropsum(isamp, NumTrc)

      integer i, j

      do j = 1, NumTrc
         do i = 1, isamp
            uout(i,j) = uout(i,j) + (addsum(i,j) - dropsum(i,j))
         enddo
      enddo

      end
