C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine write_avg_record(u, uhdr, live, uout, recip,
     1                            i_mult_asg, livesum_asg, isamp,
     2                            NumTrc, Nx_Pad, luout, lerr, lbyout,
     3                            lenhed, im, kk, jj, fdead)
      implicit none

c-----------------------------------------------------------------------
c Kelly D. Crawford	04/14/97
c
c Bertram Kaufhold	05/01/98	Modification
c
c This routine multiplies the sums stored in uout by the reciprocals
c stored in recip and writes out the result. Each sum in uout 
c corresponds to the total sum over the window for all samples in a
c record.  The reciprocals correspond to the number of samples summed at
c each point.The result is the arithmetic mean over the window (whether
c a full window or a partial window at the edges of the dataset) at each
c point.
c-----------------------------------------------------------------------

      integer isamp, NumTrc, Nx_Pad, luout, lerr, lbyout, lenhed
      integer im, kk, jj
      integer i_mult_asg(isamp), livesum_asg(NumTrc), live(NumTrc)
      real u(-lenhed+1:isamp), uhdr(lenhed, NumTrc)
      real uout(isamp, NumTrc), recip(im, kk*jj)
      logical fdead
      integer i, j

c Do not output the means of the padded traces

      do j = Nx_Pad+1, NumTrc-Nx_Pad

c Copy the trace header

         call vmov(uhdr(1,j), 1, u(-lenhed+1), 1, lenhed)

c Copy the trace data

         call vmov(uout(1,j), 1, u(1), 1, isamp)

c-----------------------------------------------------------------------
c Convert the sum into an average. If the fill dead traces flag (fdead)
c is not set, i.e. if fdead = .false. fill the dead traces with zeros.
c Otherwise fill the dead traces with the mean values we calculated for
c them if the number of live traces is greater than 0.5*jj*kk.
c This might be useful if you want to interpolate between data points.
c Note: The consequence of this is that the dead traces along the 
c       outside border of the x-y plane will have a higher likelihood
c       to be assigned to zero than the ones in the middle.

         if (.not.fdead) then
            if (live(j) .eq. 1) then 
               do i = 1, isamp               
                  u(i) = u(i) * recip(i_mult_asg(i),livesum_asg(j))    
               enddo                          
            else
               call vclr(u(1), 1, isamp)
            endif
         else
            if (live(j).eq.1 .or. livesum_asg(j).gt.0.5*(jj*kk)) then 
               do i = 1, isamp               
                  u(i) = u(i) * recip(i_mult_asg(i),livesum_asg(j))    
               enddo                          
            else
               call vclr(u(1), 1, isamp)
            endif 
         endif

c Write the trace

         call wrtape(luout, u(-lenhed+1), lbyout)

      enddo

      end
