C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C
C**********************************************************************C
C
C PROGRAM MODULE stel
C Program reduces difference in amplitude spectra of traces compared
C  to a reference trace without changing phase spectrum.
C d. bjerstedt Jan 21, 1992
C Added additional restore of zero pad below sample number nsamp.
C Mar 10, 1992
C Added target temporal window and taper arguments, restore mute and
C  taper argument, iteration option and pass options.
C Mar 18, 1992 d.r.b
C
C**********************************************************************C
C
C From USP manual by Don Wagoner, 10-31-90, pages 1 and 2.
C SZDTHD bytes in trace header on disk   (256 SUN, 1024 CRAY)
C SZTRHD bytes in trace header in pipes  (256 SUN)
C LNTRHD size of trace header in samples (128 SUN )
C SZSAMP bytes in floating pt sample     (4 0n SUN, 8 on CRAY)
C SZSMPM max number of trace samples     (8000)
C SZSMPD number of bytes in a sample     (8 for 64 bit data)
C SZLNHD line file size = (SZTRHD + SZSAMP*MAXSMP)/2    (8320)
C SZSPRD size of spread in channels      (500)
C HSTOFF count of byte at which hlh starts              (1004)
C
C USP SUBROUTINE CALLS:  HLHprt, WRTAPE, SAVE, SAVEW, SAVEHLH
C                            RTAPE4, recskp
C User routine calls:
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
                                                                         
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
                                                                         
C
cdyn  dimension record(512 ,SZSMPM), trstel(512 ,SZSMPM)
C
C New dynamic memory allocation.
      real record, trstel
      real flenwm1
      pointer (wkr, record(1))
      pointer (wkt, trstel(1))
C
C
      INTEGER     itr ( SZLNHD )
      INTEGER     kmute(SZLNHD)
c     INTEGER     itrtemp(2048 ,LNTRHD)
      integer     itrtemp
      pointer     (wkitr, itrtemp(1))
C Two lines above assume there are 2048 or fewer traces per record.
      INTEGER     luin,luout,nsamp,ntrc,nbytes
      INTEGER     lbytes,lbyted,lbytnew,lbytout,nrec
      INTEGER     nf,nl,nsf,nsl,ktm,jtapt,jtapw
      INTEGER     argis
      integer     targunit, targlin
C
      REAL        tri( SZLNHD ), target( SZLNHD )
C
      CHARACTER   NAME * 4, ntap * 256, ntarg * 256, otap * 256
      LOGICAL     verbos, query, res, pass, didst, heap1, heap2,heapi
      logical     tusp
C
c     EQUIVALENCE ( itr(129), tri (1) )
      data NAME / 'STEL' /
      data targunit/32/, targlin/8/
C
#include <f77/pid.h>
#include <f77/open.h>
C
C Open report files.
cmam......................  open(LERR,file='st.rep.file',form='formatted')
      open(35,file='st.trc.file',form='formatted')
C Unit 35 is for X,Y graph sets of target trace.
C
      write(LERR,50)
   50 format('STEL program begins:')
      write(LERR,*) 'SZSMPM ',  SZSMPM, ' SZSMPD ', SZSMPD
      write(LERR,*) 'SZDTHD ',  SZDTHD, ' SZTRHD ', SZTRHD
      write(LERR,*) 'LNTRHD ',  LNTRHD
C
C**********************************************************************C
C     Get online help if necessary
C**********************************************************************C
      query = ((argis('-?').gt.0).or.( argis('-h').gt.0))
      if( query ) then
          call help()
cmam      close(LERR)
          close(35)
          stop
      endif
C**********************************************************************C
C     Read command line parameters
C**********************************************************************C
C
      call cmdln(ntap,ntarg,otap,iopt,nf,nl,irs,ire,ibeta,
     : nsf,nsl,ktm,jtapt,jtapw,res,pass,tusp,verbos)
C
C Check restore mute taper length.
      if(jtapt.lt.1) jtapt=1
      lentaper=jtapt
      lenm1=lentaper-1
      flenm1=float(lenm1)
C Check target window taper length.
      if(jtapw.lt.1) jtapw=1
      lenwtapr=jtapw
      lenwm1=lenwtapr-1
      flenwm1=float(lenwm1)
      write(LERR,*) 'Mute taper is ', jtapt, ' Window taper is ', jtapw
C
      if(ktm.lt.1) ktm=1
      if(ktm.gt.7) write(LERR,*) 'NOTICE: Doing more than 7 kaskades.'
C
      if(ire.lt.0) ire = 0
      if(irs.lt.1) irs = 1
      if(ibeta.lt.1) ibeta=1
      if(ibeta.gt.100) ibeta=100
      beta=float(ibeta)/100.0
      if (verbos) write(LERR,9000) irs,ire,iopt,ibeta,ktm
 9000 format(' After cmdln, irs,ire,iopt,ibeta,ktm: ',/,5i8)
      if(res) write(LERR,*) 'Traces will be amplitude restored.'
      if(pass) write(LERR,*) 'All records passed to output.'
C
C**********************************************************************C
C     Verbos printout
C**********************************************************************C
c        if ( verbos ) then
             write(LERR,*) 'stel: Values read from command line.'
             write(LERR,*) 'Input  data  =  ', ntap
             write(LERR,*) 'Output data  =  ', otap
             write(LERR,*) 'Start record =  ', irs
             write(LERR,*) 'End record   =  ', ire
             write(LERR,*) 'Option number=  ', iopt
	     if(iopt.eq.2) then
              write(LERR,*)'Target Input File = ', ntarg
              if(tusp)
     :         write(LERR,*)'Target Input File is usp format'
             endif
             if(res) write(LERR,*) 'Traces will be amplitude restored.'
C
	if(verbos) write(LERR,*)'opening ntap=',ntap
      call getln( luin, ntap, 'r', 0 )
	if(verbos) write(LERR,*)'opening otap=',otap
      call getln( luout, otap, 'w', 1 )
      if(verbos) write(LERR,*) 'Input is   ',  ntap,'  unit= ',luin
      if(verbos) write(LERR,*) 'Output is  ',  otap,'  unit= ',luout
cmam  if(iopt.eq.2) then
cmam	write(LERR,*) 'Target input file is  ', ntarg
cmam	if(tusp) then
cmam	  write(LERR,*)'Target input file is usp formatted'
cmam  endif
C
C Read line header.
      lbytes = 0
	if (verbos) write(LERR,*)'reading ntap line header'
      CALL RTAPE ( luin, itr, lbytes )
C lbytes is number of bytes read in first record of tape image (header size).
C lbyted is number of bytes header takes on disk in computer being used.
C
      if(lbytes .eq. 0) then
         write(LERR,*)'stel: Zero bytes in header on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif
      if (verbos) write(LERR,*)'Input Header read: lbytes=',lbytes
C
C
C#include <f77/saveh.h>
C Start of file usually included in f77/saveh.h
	write(LERR,*)'saving header values'
      call saver(itr, 'NumSmp', nsamp , LINHED)
      call saver(itr, 'SmpInt', nsi   , LINHED)
      call saver(itr, 'NumTrc', ntrc  , LINHED)
      call saver(itr, 'NumRec', nrec  , LINHED)
      call saver(itr, 'Format', iform , LINHED)
      call saver(itr, 'GrpInt', dx    , LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
C End of file usually included in f77/saveh.h

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)

      if (verbos) write(LERR,9076)
 9076 format('Done saver.')
C
             write(LERR,*)
             write(LERR,*) 'stel: Values from input Lineheader'
             write(LERR,*) 'No. of Records           =',nrec
             write(LERR,*) 'No. of Traces per Record =',ntrc
             write(LERR,*) 'No. of Samples per Trace =',nsamp
             write(LERR,*) 'Sample interval          =',nsi
             write(LERR,*) 'Format                   =',iform
C
C Take care of last record to use (default 0 changes to last rec)
      if(ire.le.0) ire=nrec
C Handle default cases for first and last traces in stack.
      if(nf.le.0) nf=1
      if(nl.gt.ntrc) nl=ntrc
      if(nl.le.0) nl=ntrc
C Handle default cases for first and last samples in target.
      if(nsf.le.0) nsf=1
      if(nsl.le.0) nsl=nsamp
      if(nsl.gt.nsamp) nsl=nsamp
      if (verbos) then
	 write(LERR,*) 'nsf ', nsf, ' nsl ', nsl
         if(iopt.eq.1) write(LERR,*) 'nf ', nf, ' nl ', nl
      endif
      mrec = ire - irs + 1
C
      if((iopt.lt.1).or.(nl.lt.nf)) then
        write(LERR,*) 'WARNING bad iopt or stack range. Aborting.'
        write(LERR,*) 'WARNING bad iopt or stack range. Aborting.'
cmam    close(LERR)
        close(35)
        call lbclos ( luin )
        call lbclos ( luout )
        stop
      endif
C
      if(nsl.le.nsf) then
        write(LERR,*) 'WARNING bad set of -sf, -sl selected. Aborting.'
        write(LERR,*) 'WARNING bad set of -sf, -sl. Aborting.'
cmam    close(LERR)
        close(35)
        call lbclos ( luin )
        call lbclos ( luout )
        stop
      endif
C
      if((ntrc.le.1).and.(iopt.ne.2)) then
        write(LERR,*) 'WARNING: Must be more than 1 trace/rec. Aborting'
        write(LERR,*) 'WARNING: Must be more than 1 trace/rec. Aborting'
cmam    close(LERR)
        close(35)
        call lbclos ( luin )
        call lbclos ( luout )
        stop
      endif
C
      if (verbos) write(LERR,*) 'ntrc= ',ntrc, ' nsamp= ',nsamp,
     :	' nrec= ',nrec
C
C Dynamic memory allocation:
c---------------------------------------------------
c  malloc only space we're going to use
      heapi = .true.
      heap1 = .true.
      heap2 = .true.

c--------------------------
c  note: these don't
c  have to be the same size

      itemi = ntrc * ITRWRD * SZSMPD
cmam.....  item1 = ntrc * ITRWRD * SZSMPD
      item1 = ntrc * nsamp * SZSMPD
      item2 = ntrc * nsamp * SZSMPD

c  note also SZSMPD is the native
c  size of a float or int in bytes
c--------------------------

c--------
c  galloc - general allocation (machine independent since it uses C
c  malloc internally
c  inputs to galloc are pointer, number of bytes to allocate
c  outputs are error codes:
c     errcod = 1  (allocation succeeded)
c     errcod = 0  (allocation failed)
c--------

cmam	print *,'allocating work space:itemi,item1,item2=',
cmam :			itemi,item1,item2
      call galloc (wkitr, itemi, errcdi, aborti)
      call galloc (wkr, item1, errcd1, abort1)
      call galloc (wkt, item2, errcd2, abort2)

      if (errcdi .ne. 0.) heapi = .false.
      if (errcd1 .ne. 0.) heap1 = .false.
      if (errcd2 .ne. 0.) heap2 = .false.

      if (.not. heap1 .or. .not. heap2) then
         write(LERR,*)' '
         write(LERR,*) 'Unable to allocate workspace: Aborting'
         write(LER ,*) 'Unable to allocate workspace: Aborting'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item2,'  bytes'
         write(LERR,*)' '
         write(LER ,*) itemi,'  bytes'
         write(LER ,*) item1,'  bytes'
         write(LER ,*) item2,'  bytes'
         write(LER ,*)' '
         go to 999
      else
         write(LERR,*)' '
         write(LERR,*)'Allocated workspace:'
         write(LERR,*) itemi,'  bytes'
         write(LERR,*) item1,'  bytes'
         write(LERR,*) item2,'  bytes'
         write(LERR,*)' '
         write(LER  ,*)'Allocated workspace:'
         write(LER ,*) itemi,'  bytes'
         write(LER  ,*) item1,'  bytes'
         write(LER  ,*) item2,'  bytes'
         write(LER  ,*)' '
      endif
c---------------------------------------------------
C
C Update historical line header for output. HLPprt, savew, savhlh etc.
C Put proper number of output records line header buffer.
      if(mrec.ne.nrec) then
       if(.not.pass) call savew( itr, 'NumRec', mrec, LINHED )
      endif
C Put name stel in header.
      call HLHprt( itr, lbytes, NAME, 4, LERR )
C Put argument string in historical part of line header.
      call savhlh( itr, lbytes, lbytnew )
C
C Write output line header.
C
      Call WRTAPE( luout, itr, lbytnew )
C
      if (verbos) write(LERR,*)'Wrote Line Header ',lbytnew,
     :		' bytes, unit ',luout
C
C Calc number of bytes in output trace.
      lbytout = SZTRHD + nsamp * SZSMPD
      if (verbos) write(LERR,3358) lbytes,lbytnew,lbytout
 3358 format('After Line Header write lbytes,lbytnew,lbytout ',3i8 )
C
      if(iopt.eq.2) then
	if(tusp) then
cmam target trace input file is usp formatted
         write(LERR,*)'reading in usp formatted file target trace'
         call getln( targunit, ntarg, 'r', 32 )
cmam Read line header of target input file
         labyts = 0
         call rtape ( targunit, kmute, labyts )
cmam read target trace
         call rtape(targunit, kmute, labyts)
          if(labyts.eq.0) then
            write(LERR,*)'stel: Zero bytes read on Target Input File'
            write(LERR,*)'      usp formatted dataset name =',ntarg
            write(LERR,*)'FATAL'
            write(LERR,*)'Check existence of file & rerun'
            write(LER ,*)'stel: Zero bytes read on Target Input File'
            write(LER ,*)'      usp formatted dataset name =',ntarg
            write(LER ,*)'FATAL'
            write(LER ,*)'Check existence of file & rerun'
            stop
          endif
cmam move this trace into target array
	call vmov (kmute(ITHWP1), 1, target, 1, nsamp)
cmam	call maxmgv(target,1,xtarmx,itarmx,nsamp)
cmam	print *,'xtarmx,itarmx=',xtarmx,itarmx
        call lbclos (targunit)
cmam////////  endif

	else
C Open target trace input file.
          open(targunit,file=ntarg,form='formatted')
C Read in target trace from a file.
          if (verbos) write(LERR,*) 'Reading in target trace (iopt=2).'
          call targin80(target,nsamp,targlin,targunit)
	endif
C Handle time windowing (with taper) if any.
        if((nsf.gt.1).or.(nsl.lt.nsamp)) then
          if (verbos) write(LERR,*)'windowing/tapering target trace'
          call targtapr(target,nsamp,nsf,nsl,lenwm1,flenwm1)
        endif
C
      endif
C
      if (verbos) write(LERR,*) 'nrec ', nrec, ' mrec ', mrec
      if(pass) goto 2299
C---------------------------------------
C  Skip to start record
C---------------------------------------
        if((nrec.gt.mrec).and.(irs.ne.1)) then
          if (verbos) write(LERR,*) 
     :		'Skipping records not wanted in output.'
          call recskp(1,irs-1,luin,ntrc,itr)
        endif
C
      nrec = mrec
 2299 continue
C
C**********************************************************************C
C
C     Read record, do filter and output.
C
C**********************************************************************C
C
C jjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjj
C
C Loop over records.
        DO 200 JJ = 1, nrec, 1
      jjrec=jj+irs-1
      if(pass) jjrec=jj
      if (verbos) write(LERR,3350) jjrec
 3350 format(' Working input data set record number ',i5)
C
C kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk
C Loop over traces of record.
            DO 198 KK = 1, ntrc, 1
C
C Zero this trace of input record.
               istrc=(KK-1)*nsamp
cmam	print *,'at do777:kk,istrc,nsamp=',kk,istrc,nsamp
             do 777 izt=1,nsamp,1
               record(istrc+izt)=0.0
  777        continue
cmam	print *,'trace zeroed for input:',kk
C
               nbytes = 0
               CALL RTAPE  ( luin, itr, nbytes )
cmam	print *,'read trace from luin:',kk
               if(nbytes .eq. 0) then
                  write(LERR,*)'End of file on input: Aborting.'
                  write(LER ,*)'End of file on input: Aborting.'
                  write(LERR,*)'  rec is ',jjrec,'  trace is ',kk
                  write(LER ,*)'  rec is ',jjrec,'  trace is ',kk
                  go to 999
               endif
C
               if(nbytes .ne. lbytout) then
                write(LERR,*)'Wrong number of bytes in trace: Aborting.'
                write(LER ,*)'Wrong number of bytes in trace: Aborting.'
                write(LERR,*)'  rec is ',jjrec,'  trace is ',kk
                write(LER ,*)'  rec is ',jjrec,'  trace is ',kk
                go to 999
               endif
C
C Put current trace into record array.
C qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq
C Recall tri is offset WRT itr thru equiv statement.
C Build record
      istrc=(KK-1)*nsamp
cmam	print *,'building record:istrc,nsamp=', istrc,nsamp
      call vmov (itr(ITHWP1), 1, record(istrc+1), 1, nsamp)
C qqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqqq
C
C Store header for use later.
C pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp
      ishdr = (KK-1) * ITRWRD
cmam	print *,'storing header for later:ishdr,ITRWRD=',ishdr,ITRWRD
      call vmov (itr, 1, itrtemp(ishdr+1), 1, ITRWRD)
cmam	print *,'return from vmov'
C pppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppppp
C
  198       CONTINUE
C End read loop over traces of record.
C kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk
C
      if (verbos) write(LERR,*) 'Done record read stage.'
C
      if((jjrec.ge.irs).and.(jjrec.le.ire)) then
      if (verbos) write(LERR,*) 'Filtering rec ', jjrec
C This record will be filtered.
C
C Find the mute zone and store.
      do 1555 lmt=1,ntrc,1
      kmute(lmt)=0
      kmcount=1
      istrc=(lmt-1)*nsamp
 1444 if((kmcount.le.nsamp).and.(record(istrc+kmcount).eq.0.0)) then
      kmute(lmt)=kmcount
      kmcount=kmcount+1
      goto 1444
      endif
 1555 continue
C
C
C Form stack trace or read target trace.
C
      if(iopt.gt.100) then
C Option is use trace number iopt-100 as target.
      knum=iopt-100
C Make sure only an existing trace used as a target.
      if(knum.gt.ntrc) then
        write(LERR,*) 'WARNING: Reference trace number adjusted to max.'
        write(LER ,*) 'WARNING: Reference trace number adjusted to max.'
        knum=ntrc
      endif
C
      do 410 ksamp=1,nsamp,1
C Handle time windowing.
      target(ksamp)=0.0
      if((ksamp.ge.(nsf-lenwtapr)).and.(ksamp.le.(nsl+lenwtapr))) then
       istrc=(knum-1)*nsamp
       target(ksamp)=record(istrc+ksamp)
      endif
  410 continue
C
C Handle taper.
      if((nsf.gt.1).or.(nsl.lt.nsamp)) then
       call targtapr(target,nsamp,nsf,nsl,lenwm1,flenwm1)
      endif
C
      if (verbos) write(LERR,*) 
     :		'Formed target with trace selected via argument.'
      endif
C
C Prevent kaskading unless stack option is specified.
      if(iopt.ne.1) ktm=1
C
C Start kaskade loop.
      didst=.true.
      do 3999 kas=1,ktm,1
C
      if(iopt.eq.1) then
C Option is stacked target trace.
      sumnum=float(1+nl-nf)
      do 550 jmsp=1,nsamp,1
      sum=0.0
      do 540 itrace=nf,nl,1
C Sum only samples in live time window.
      if((jmsp.ge.(nsf-lenwtapr)).and.(jmsp.le.(nsl+lenwtapr))) then
       istrc=(itrace-1)*nsamp
       sum=sum+record(istrc+jmsp)
      endif
  540 continue
      target(jmsp)=sum/sumnum
C Write extended windowed target trace to graph file.
      if((jj.eq.1).and.(kas.eq.1)) write(35,*) jmsp, target(jmsp)
  550 continue
C Write separator.
      if((jj.eq.1).and.(kas.eq.1)) write(35,*) '   '
C
C Handle taper.
      if((nsf.gt.1).or.(nsl.lt.nsamp)) then
       call targtapr(target,nsamp,nsf,nsl,lenwm1,flenwm1)
      endif
C
C Printout a sample graphical file of first windowed trace.
      if((jj.eq.1).and.(kas.eq.1)) then
       do 3331 ig=1,nsamp,1
C Write windowed and tapered target trace to graph file.
       write(35,*) ig, target(ig)
 3331  continue
       write(35,*)  '   '
       if (verbos) write(LERR,*)
     :		'Wrote sample windowed target trace to file.'
      endif
C
      if (verbos) write(LERR,*) 
     :		'Formed stacked target trace, for kaskade ', kas
      endif
C
C Zero the result array in case of bad target or record traces.
      do 710 jnit=1,ntrc,1
      do 700 knit=1,nsamp,1
      istrc=(jnit-1)*nsamp
      trstel(istrc+knit)=0.0
  700 continue
  710 continue
C
C Filter the record.
      if(didst) then
       call stelfilt(target,record,trstel,ntrc,nsamp,beta,res,didst)
       if (verbos) write(LERR,*) 'Did stelfilt.'
C
C Restore mute to output record
      do 2444 ktmu=1,ntrc,1
      if(kmute(ktmu).ne.0) then
       do 2333 ksmu=1,kmute(ktmu),1
       kdiff=kmute(ktmu)-ksmu
       fkdiff=float(kdiff)
       istrc=(ktmu-1)*nsamp
       if(kdiff.gt.0) then
        if(kdiff.ge.lenm1) trstel(istrc+ksmu)=0.0
        trstel(istrc+ksmu)=trstel(istrc+ksmu)*(1.0-fkdiff/flenm1)
C Statement above is (0.0 * something) before the taper zone interior.
       endif
 2333  continue
      endif
 2444 continue
C
C If kaskading, reset record to output to get ready for next kaskade.
      if((ktm.gt.1).and.(kas.lt.ktm)) then
      do 5999 kast=1,ntrc,1
      do 4999 kass=1,nsamp,1
      istrc=(kast-1)*nsamp
      record(istrc+kass)=0.0
C
      if(didst) record(istrc+kass)=trstel(istrc+kass)
 4999 continue
 5999 continue
C End test for replace input with output.
      endif
C End test for didst (did a good stelfilt).
      endif
C End kaskade loop.
 3999 continue
C
C End filter part that applies for record jj from irs to ire.
      endif
C Write out seismic record.
C
C UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU
      do 2612 kku=1,ntrc,1
C
C Build header for output trace.
C hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhh
C Copy the header.
      ishdr = (kku-1) * ITRWRD
      call vmov (itrtemp(ishdr+1), 1, itr, 1, ITRWRD)
C hhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhhh
C
C uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuu
      if((jjrec.ge.irs).and.(jjrec.le.ire)) then
      if(kku.eq.1. and. verbos) write(LERR,*)
     :		'Copying filtered traces.'
C Copy the filtered trace array for output.
      do 2610 iksu=1,nsamp,1
      istrc=(kku-1)*nsamp
      tri(iksu) = record(istrc+iksu)
C Output is input if stelfilt not done.
      if(didst) tri(iksu) = trstel(istrc+iksu)
 2610 continue
      endif
      if(((jjrec.lt.irs).or.(jjrec.gt.ire)).and.(pass)) then
      if(kku.eq.1 .and. verbos) write(LERR,*)
     :		'Copying unfiltered traces.'
C Copy the trace input array for output.
      do 2611 iksu=1,nsamp,1
      istrc=(kku-1)*nsamp
      tri(iksu) = record(istrc+iksu)
 2611 continue
      endif
C uuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuuu
C
C Write trace
      call vmov  (tri, 1, itr(ITHWP1), 1, nsamp)
      Call WRTAPE( luout, itr, lbytout )
      if (verbos) write(LERR,*) 'Wrote trace ', kku,' with ',lbytout,
     :	' bytes',' to unit ',luout
C
C End loop over traces.
 2612 continue
C UUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUUU
C
  200   continue
C End loop over records of data set.
C jjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjjj
      if (verbos) write(LERR,*) 'DONE ALL RECORDS'
C
  999 continue
C
cmam  close(LERR)
      close(35)
      if(iopt.eq.2 .and. .not.tusp ) close(32)
      call lbclos ( luin )
      call lbclos ( luout )
C
      stop
      end
C
C-------------------------------------------
C  Online help section
C-------------------------------------------
      subroutine help
C
#include <f77/iounit.h>
C
         write(LER,*)
         write(LER,*)
     :'Program stel reduces difference in amplitude spectra of traces'
         write(LER,*)
     :' compared to a reference trace (or stack). Phase is not changed.'
         write(LER,*)
     :'***************************************************************'
         write(LER,*)
         write(LER,*)
     :'Run this program by typing: stel and the following arguments'
         write(LER,*)
         write(LER,*)
     :' -N[ntap]  (default stdin)       : Input data set name'
         write(LER,*)
     :' -T[ntarg] (default target.in): Input target trace file name'
         write(LER,*)
     :'                                 Used only if option = 2 .'
         write(LER,*)
     :' -O[otap]  (default stdout) : Output data set name'
         write(LER,*)
     :' -K[ktm]   (default = 1  )    : Number of times to iterate stel'
         write(LER,*)
     :' -rs[irs]  (default = 1  )    : First record to filter'
         write(LER,*)
     :' -re[ire]  (default = last)   : Last record to filter'
         write(LER,*)
     :' -op[iopt] (default =  1 )    : Option number. 1 for stack,'
         write(LER,*)
     :'                                2 for ref trace from a file,'
         write(LER,*)
     :'                                100+n means use trace n as ref.'
         write(LER,*)
     :' -usp       (flag)            : for option 2 only: the -T input'
         write(LER,*)
     :'                                trace file is a usp formatted'
         write(LER,*)
     :'                                dataset of a single trace'
         write(LER,*)
     :' -B[ibeta] (default = 90 )    : Percent reduction in amp spec'
         write(LER,*)
     :'                                difference (1 to 100 allowed).'
         write(LER,*)
         write(LER,*)
     :' -nf[nf]   (default =  1 )    : First trace in stack (iopt=1).'
         write(LER,*)
     :' -nl[nl]   (default =  last ) : Last trace in stack (iopt=1).'
         write(LER,*)
     :' -tt[jtapt] (default =  10 )  : Samples in mute restore taper.'
         write(LER,*)
     :' -P         (flag         )   : Pass (output) all records both'
         write(LER,*)
     :'                                filtered and unfiltered.'
         write(LER,*)
     :' -R         (flag         )   : Restore average trace amplitude.'
         write(LER,*)
     :' -V         (flag         )   : Verbos report printing flag on.'
         write(LER,*)
         write(LER,*)
     :'Usage: stel -N[ntap] -O[otap] -op[option_number] -P -R -V'
         write(LER,*)
     :'            -T[target_trace_input_file_name] -K[kaskade_number]'
         write(LER,*)
     :'              -B[percent_reduction_amp_spectra_difference]'
         write(LER,*)
     :'              -nf[first_trace_to_stack] -nl[last_trace_in_stack]'
         write(LER,*)
     :'              -tt[mute_restore_taper_samps] '
         write(LER,*)
         write(LER,*)
     :'Note: To use trace 5 as reference, use -op105 as an argument.'
         write(LER,*)
     :'      Arguments -ns and -nl only used when iopt=1 (ref = stack).'
         write(LER,*)
     :'      Argument  -T only used when iopt=2 (ref from input file).'
         write(LER,*)
     :'      Only filtered records are ouput unless -P argument used.'
         write(LER,*)
         write(LER,*)
     :'***************************************************************'
C
      return
      end
C
C-----
C     Get command arguments
C
C     ntap  - C*100  input  file name
C     ntarg - C*100  input  reference trace file name
C     otap  - C*100  output file name
C     irs   - I      start record
C     ire   - I      stop end record
C     iopt  - I      reference trace option number
C     ktm   - I      number of times to kaskade stel process
C     nf    - I      first trace in stack
C  jtapt    - I      number samples in trace mute restore taper
C  jtapw    - I      number of samples in target window end tapers
C     nl    - I      last trace in stack
C     ibeta - I      percent reduction of difference in amp spec
C    verbos - L      verbos output or not
C       res - L      restore average trace amplitude or not
C      pass - L      pass (output) all records or not
C-----
      subroutine cmdln(ntap,ntarg,otap,iopt,nf,nl,irs,ire,ibeta,
     :  nsf,nsl,ktm,jtapt,jtapw,res,pass,tusp,verbos )
C
#include <f77/iounit.h>
C
      character   ntap*(*), otap*(*), ntarg*(*)
      integer     argis,irs,ire
      integer     iopt,nf,nl,nsf,nsl,ibeta,ktm,jtapt,jtapw
      logical     verbos,res,pass
      logical     tusp
C
         call argstr ( '-N', ntap,  ' ', ' ' )
         call argstr ( '-O', otap,  ' ', ' ' )
         call argstr ( '-T', ntarg, 'target.in','target.in' )
         call argi4  ( '-rs', irs  , 1, 1 )
C Note: program must convert ire=0 to ire=last record number.
         call argi4  ( '-re', ire    , 0,  0 )
         call argi4  ( '-op', iopt   , 1,  1 )
         tusp = ( argis ( '-usp' ) .gt. 0 )
         call argi4  ( '-K',  ktm    , 1,  1 )
         call argi4  ( '-nf', nf     , 1,  1 )
         call argi4  ( '-sf', nsf    , 1,  1 )
         call argi4  ( '-sl', nsl    , 0,  0 )
         call argi4  ( '-tt', jtapt  ,10, 10 )
         call argi4  ( '-tw', jtapw  ,10, 10 )
C Note: program must convert nsl=0 to nsl=last sample number.
         call argi4  ( '-nl', nl     , 0,  0 )
C Note: program must convert nl=0 to nl=last trace number.
         call argi4  ( '-B' , ibeta  ,90, 90 )
         verbos = ( argis ( '-V' ) .gt. 0 )
         res    = ( argis ( '-R' ) .gt. 0 )
         pass   = ( argis ( '-P' ) .gt. 0 )
C
      return
      end
C ------------------------------------------------------------------
