C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine forward_stft( tri, Workspace, nsamp, ist, iend, nf,  
     :     nwin, stft_Record, ntrco, nsampo, w, ctr, verbos )

c variables passed from calling routine

      integer nsamp, ist, iend, nf, nwin, ntrco, nsampo

      real tri(nsamp+nwin), Workspace(nsampo)
      real stft_Record( nsampo, nf) 
      real w(nwin)

      complex ctr(nf)

      logical verbos

c local variables

      integer start, finish

c make certain data is zero for half window length beyond last sample
c and before first sample

      call vclr( tri, 1, nf )
      call vclr( tri(nsamp+1), 1, nf )

c process data

      nft = 2 * nf 

c set up loop parameters so that half window of zero 
c pad is taken into consideration

      start = ist + nf
      finish = iend + nf - 1
      
      DO i = start, finish

         call vclr ( Workspace , 1, nsampo )

         do j = 1, nf
            ctr(j) = cmplx(0.0, 0.0)
         enddo

         sum = 0.
         
c load up window worth of data into workspace so that samples
c are centered at i

         do k = i, i + nwin -1
            Workspace(k - i + 1) =  tri(k - nf)  * w(k - i + 1)
            sum = sum + abs (Workspace(k - i + 1))
         enddo

         if (sum .ne. 0.) then
 
c if something in the window do fft

            call rfftb( Workspace, ctr , nft , 1)
            call rfftsc ( ctr, nft , 2, 1)

c need to put amp and phase into output trace amp first then phase
c need counters for this activity.  In the main need a 2D array for the output
c for clarity as will build a 2D record for each trace input.  take the 
c effect of the half window pad out when loading the output data.  We want the
c first real samples to land on the first real data position.  This means 
c subtract the half window size [nf] from the index
            
            do k = 1, nf
               stft_record( i - nf + 1, k ) = cabs ( ctr ( k ) )
               stft_record( i - nf + 1 + nsamp, k ) = 
     :              atan2 ( aimag( ctr(k) ), real( ctr(k) ) )
            enddo

         else

            do k = 1, nf
               stft_record( i - nf, k ) = 0.0
               stft_record( i - nf + nsamp, k ) = 0.0
            enddo

         endif
         
      enddo

      return
      end
