C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine fhoriz( uin, uout, twgt, w, ndiv, adiv,
     1     luin, luout, lbyout, hwd, uw, lw, ttaper,
     2     ler, lerr, nsamp_in, nsamp_out, nfft, tdatum,
     3     dtmsec, ITRWRD, verbose, ntrace, nbytes_out,
     4     startrec, endrec, starttrace, endtrace,
     5     thoriz, tstart_orig, wrxsd, luxsd, znull,
     6     nhtLive, nhtVal, deadVal)

      implicit none

c declare variables passed from calling routine

      integer ndiv, luin, luout, lbyout, ler, lerr, nsamp_in, nsamp_out
      integer nfft, ITRWRD, ntrace, nbytes_out, luxsd
      integer startrec, endrec, starttrace, endtrace

      real  adiv, uw, lw, tstart_orig, znull
      real  nhtVal, deadVal, ttaper, tdatum, dtmsec

      real uin(-ITRWRD:nsamp_in+2)
      real uout(-ITRWRD:nsamp_out-1)
      real twgt(0:nsamp_out-1)
      real w(-2:+3,0:ndiv)
      real thoriz(starttrace:endtrace)

      character*(*) hwd

      logical wrxsd, nhtLive, useableTrace, verbose

c declare local variables

      integer ifmt_hwd, l_hwd, ln_hwd
      integer ifmt_StaCor, l_StaCor, ln_StaCor
      integer jt, jrec, jtr, nbytes_in, iseg, jtrace, npicks, istatic
      integer jshift, jdiv, jleft

      real t1, t2, t3, t4
      real trel, tshift, traceno, recno, sampno

      logical     live

#include <save_defs.h>
c__________________________________________________________________
c     thoriz(jtrace)......horizon pick time in ms.
c     tstart_orig.........time of first seismic input sample in ms.
c     trel................horizon pick time relative to the first
c                         sample.
c     tdatum..............horizon output datum time in ms.
c     dtmsec..............trace sample increment in ms.
c     tshift..............data shift time in samples.
c     jshift..............data shift time in integer samples.
c     jdiv................fine data shift time. 
c__________________________________________________________________
c__________________________________________________________________
c     get addresses of trace header words.
c__________________________________________________________________
      call savelu(hwd,ifmt_hwd,l_hwd,ln_hwd,TRACEHEADER)
      call savelu('StaCor',ifmt_stacor,l_stacor,ln_stacor,
     1             TRACEHEADER)
c__________________________________________________________________
c     calculate the window weights that will be applied to the 
c     OUTPUT data.
c__________________________________________________________________
c     thalf=(lw-uw)/2.
c     tavg=(lw+uw)/2.
      t1=tdatum+uw    
      t2=tdatum+uw+ttaper
      t3=tdatum+lw-ttaper
      t4=tdatum+lw    
c     call gttapr(twgt,t1,t2,t3,t4,dtmsec,0,nsamp_out-1)         
      call gttapr(twgt,t1,t2,t3,t4,dtmsec,nint(t1/dtmsec),
     1    nint(t4/dtmsec))         
      write(lerr,*) 't1,t2,t3,t4,lw,uw,ttaper ' 
      write(lerr,*) t1,t2,t3,t4,lw,uw,ttaper  
      write(lerr,'(3a12)') 'jt','time','taper'                   
      write(lerr,'(i12,2f12.3)') (jt,jt*dtmsec,twgt(jt),
     1                               jt=0,nsamp_out-1)
c__________________________________________________________________
c     skip startrec-1                                                 
c__________________________________________________________________
      do 20000 jrec=1,startrec-1
       do 10000 jtr=1,ntrace 
        nbytes_in=0
        call rtape(luin,uin(-ITRWRD),nbytes_in)
10000  continue
20000 continue
c__________________________________________________________________
c     read in traces, flatten to a datum, window, and write out.
c__________________________________________________________________
      iseg=0
      do 90000 jrec=startrec,endrec
       if(verbose) then
          write(lerr,'(8a8)') 'jrec','jtrace','tdatum','thoriz',
     1              'tstart','tshift','jshift','jdiv'
       endif
c__________________________________________________________________
c      skip to starttrace
c__________________________________________________________________
       do 30000 jtrace=1,starttrace-1
        nbytes_in=0
        call rtape(luin,uin(-ITRWRD),nbytes_in)
30000  continue
       npicks=0
       do 80000 jtrace=starttrace,endtrace
        nbytes_in=0
        call rtape(luin,uin(-ITRWRD),nbytes_in)
        if(nbytes_in .eq. 0) then
           write(LERR,*)'Unexpected end of input file detected!'
           write(LERR,*)'rec(rec) = ',jrec,' trace = ',jtrace
           write(LERR,*)'luin =', luin
           call exit(666)
        endif
c__________________________________________________________________
c       check for dead trace flag.
c__________________________________________________________________
        call saver2(uin(-ITRWRD),ifmt_StaCor,l_StaCor,ln_StaCor,
     1               istatic,TRACEHEADER)

        call getfp2(uin(-ITRWRD),ifmt_hwd,l_hwd,ln_hwd,
     1              thoriz(jtrace),TRACEHEADER)


        if(  istatic .eq. 30000 ) then

cc         cc Mark it deadlread marked dead
           live = .false.
           useableTrace = .false.
        elseif( thoriz(jtrace) .eq. znull ) then

cc         cc live non-horizontrace is not usable either
           useableTrace = .false.
           if( nhtLive ) then
           
cc            cc Leave it live even though not in horz
              live = .true.
           else
cc            cc Mark it dead, not in horz
              live = .false.
              istatic = 30000
              call savew2(uin(-ITRWRD),ifmt_StaCor,l_StaCor,ln_StaCor,
     1                   istatic,TRACEHEADER)
           endif
        else
           live = .true.
           useableTrace = .true.
        endif

        if( useableTrace ) then
           npicks=npicks+1
           trel=thoriz(jtrace)-tstart_orig
           tshift=(trel-tdatum)/dtmsec
           jshift=tshift   
           jdiv=nint(adiv*(tshift-jshift))     
        endif
        if(verbose) then
           if(useableTrace) then
              write(LERR,'(2i8,4f8.1,2i8)') 
     1        jrec,jtrace,tdatum,thoriz(jtrace),tstart_orig,
     2        tshift,jshift,jdiv
           else
              write(LERR,'(2i8,a)')jrec,jtrace,' dead'
           endif
        endif
c____________________________________________________________________
c       copy trace header.
c____________________________________________________________________
        call vmov(uin(-ITRWRD),1,uout(-ITRWRD),1,ITRWRD)
        if(useableTrace) then                       
c____________________________________________________________________
c          pad with necessary zeroes.
c____________________________________________________________________
           uin(-2)=0.
           uin(-1)=0.
           uin(nsamp_in)=0.
           uin(nsamp_in+1)=0.
           uin(nsamp_in+2)=0.
c____________________________________________________________________
c          shift and apply window weights
c____________________________________________________________________
           do 54000 jt=0,nsamp_out-1
            if(twgt(jt) .ne. 0.) then
               jleft=jt+jshift
               if(jleft .lt. 0) then
                  uout(jt)=0.
               elseif(jleft .gt. nsamp_in-1) then
                  uout(jt)=0.
               else
                  uout(jt)=twgt(jt)*(w(-2,jdiv)*uin(jleft-2)
     1                           +w(-1,jdiv)*uin(jleft-1)
     2                           +w( 0,jdiv)*uin(jleft  )
     3                           +w(+1,jdiv)*uin(jleft+1)
     4                           +w(+2,jdiv)*uin(jleft+2)
     5                           +w(+3,jdiv)*uin(jleft+3))
               endif
            else
               uout(jt)=0.
            endif
54000      continue
        else
c____________________________________________________________________
c          Not useable trace, make up some sample values
c____________________________________________________________________
           do 70000 jt=0,nsamp_out-1
              if(live) then
cc               cc not in horz, give it non horz trace val
                 uout(jt) = nhtval
              else
cc               cc dead, give it dead val
                 uout(jt) = deadVal
              endif
70000      continue
        endif
        call wrtape(luout,uout(-ITRWRD),nbytes_out)
80000  continue
c____________________________________________________________________
c      skip to end of current record.
c____________________________________________________________________
       do 85000 jtrace=endtrace+1,ntrace
        nbytes_in=0
        call rtape(luin,uin(-ITRWRD),nbytes_in)
85000  continue
c
       if(wrxsd) then
          if(npicks .gt. 0) then
c_______________________________________________________________________
c            write out the modeled picks for this shot gather.
c_______________________________________________________________________
             iseg=iseg+1
             write(luxsd,201)'Segment = ',iseg,
     1                    ' Name ','stratslab_pick',
     2                    ' color = ',1,
     3                    ' picks = ',npicks
201          format(a10,i5,a6,a20,a10,i5,a9,i5)
             do 86000  jtrace=starttrace,endtrace
              traceno=jtrace
              recno=jrec
              if(thoriz(jtrace) .lt. 0.) then
                 sampno=-1.
              else
                 sampno=thoriz(jtrace)
              endif
              write(luxsd,102) recno,traceno,sampno
102           format(f12.6,1x,f12.6,1x,f12.6)
86000        continue
          endif
       endif
c
90000 continue
c
      return         
      end
