C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine fslab(uin,uout,twgt,w,ndiv,adiv,
     1                 luin,luout,lbyout,uhwd,lhwd,uw,lw,ttaper,
     2                 ler,lerr,nsamp_in,nsamp_out,nfft,tdatum,
     3                 dtmsec,ITRWRD,verbose,ntrace,nbytes_out,
     4                 startrec,endrec,starttrace,endtrace,
     5                 nttaper,uflat,lflat,impatient,
     5                  thoriz,tstart_orig,wrxsd,luxsd,znull,
     6                  nhtLive,nhtVal,deadVal)


      implicit none

c declare variables passed from calling routine

      integer ndiv, luin, luout, lbyout, ler, lerr
      integer nsamp_in, nsamp_out, nfft, ITRWRD, ntrace
      integer startrec, endrec, starttrace, endtrace
      integer nbytes_out, nttaper, luxsd

      real  ttaper, tdatum, dtmsec, tstart_orig, znull
      real  nhtVal, deadVal, adiv, uw, lw

      real uin(-ITRWRD:nsamp_in+2)
      real uout(-ITRWRD:nsamp_out-1)
      real twgt(0:nttaper)       
      real w(-2:+3,0:ndiv)
      real thoriz(starttrace:endtrace,2)

      character*(*) uhwd, lhwd

      logical uflat, lflat, nhtLive, useableTrace, verbose, wrxsd
      logical impatient

c declare local variables

      integer ifmt_uhwd, l_uhwd, ln_uhwd
      integer ifmt_lhwd, l_lhwd, ln_lhwd
      integer ifmt_StaCor, l_StaCor, ln_StaCor
      integer jt, jrec, jtr, nbytes_in, npicks, jtrace, istatic
      integer jshift, jdiv, ibegin, iend, jleft, iseg

      real t1, t2, t3, t4
      real tupper, tlower, tmid, tshift, tbegin, tend
      real traceno, recno, sampno

      logical     live

#include <save_defs.h>
c__________________________________________________________________
c     thoriz(jtrace)......horizon pick time in ms.
c     tstart_orig.........time of first seismic input sample in ms.
c     tdatum..............horizon output datum time in ms.
c     dtmsec..............trace sample increment in ms.
c     tshift..............data shift time in samples.
c     jshift..............data shift time in integer samples.
c     jdiv................fine data shift time.
c__________________________________________________________________
c     get addresses of trace header words.
c__________________________________________________________________

      call savelu(uhwd,ifmt_uhwd,l_uhwd,ln_uhwd,TRACEHEADER)
      call savelu(lhwd,ifmt_lhwd,l_lhwd,ln_lhwd,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,
     1             TRACEHEADER)
c__________________________________________________________________
c     calculate the window weights.
c__________________________________________________________________
      t1=0.           
      t2=ttaper              
      t3=1.1*ttaper         
      t4=1.1*ttaper

      call gttapr(twgt,t1,t2,t3,t4,dtmsec,0,nttaper) 
        
      write(lerr,*) 't1,t2,t3,t4,lw,uw,ttaper ' 
      write(lerr,*) t1,t2,t3,t4,lw,uw,ttaper  
      write(lerr,'(3a12)') 'jt','time','taper'                   
      write(lerr,'(i12,2f12.3)') (jt,jt*dtmsec,twgt(jt),
     1                               jt=0,nttaper)
       
c__________________________________________________________________
c     skip startrec-1
c__________________________________________________________________

      do jrec=1,startrec-1
         do jtr=1,ntrace
            nbytes_in=0
            call rtape(luin,uin(-ITRWRD),nbytes_in)
         enddo
      enddo

c__________________________________________________________________
c     read in traces, flatten to a datum, window, and write out.
c__________________________________________________________________

      DO jrec=startrec,endrec

c echo progress to impatient user

         if (impatient )
     :        write(ler,*) 'start, current, end ',startrec,jrec,endrec
         npicks=0

c__________________________________________________________________
c      skip to starttrace
c__________________________________________________________________

         if(verbose) then
            write(LERR,'(8a10)') 'jrec','jtrace','tupper','tlower',
     1           'tmid','tstart','tdatum','tshift'
         endif

         do jtrace=1,starttrace-1
            nbytes_in=0 
            call rtape(luin,uin(-ITRWRD),nbytes_in)
         enddo

         DO jtrace = starttrace, endtrace

            nbytes_in=0
            call rtape(luin,uin(-ITRWRD),nbytes_in)
            if(nbytes_in .eq. 0) then
               write(LERR,*)'Unexpected end of input file detected!'
               write(LERR,*)'rec(rec) = ',jrec,' trace = ',jtrace
               call exit(666)
            endif

c__________________________________________________________________
c       check for dead trace flag.
c__________________________________________________________________

            call saver2(uin(-ITRWRD),ifmt_StaCor,l_StaCor,ln_StaCor,
     1           istatic,TRACEHEADER)

c read in upper and lower horizon values
          
            call saver2(uin(-ITRWRD),ifmt_uhwd,l_uhwd,ln_uhwd,
     1           tupper,TRACEHEADER)
            call saver2(uin(-ITRWRD),ifmt_lhwd,l_lhwd,ln_lhwd,
     1           tlower,TRACEHEADER)

c check for useable trace

            if( (istatic .ne. 30000) .and.
     1           (tupper .eq. znull .or. tlower .eq. znull) ) then

c Not used in both horizons, mark dead

               istatic = 30000
               call savew2(uin(-ITRWRD),ifmt_StaCor,l_StaCor,ln_StaCor,
     1              istatic,TRACEHEADER)
            endif


            if(  istatic .eq. 30000 ) then

c Mark it dead

               live = .false.
               useableTrace = .false.

            elseif ( tupper .eq. znull .or. tlower .eq. znull ) then

c     live non-horizon trace is not usable either

               useableTrace = .false.
               
               if( nhtLive ) then

c Leave it live even though not in horz

                  live = .true.

               else

c Mark it dead, not in horz

                  live = .false.
                  istatic = 30000
                  call savew2(uin(-ITRWRD),ifmt_StaCor,l_StaCor,
     1                 ln_StaCor,istatic,TRACEHEADER)

               endif
            else
               live = .true.
               useableTrace = .true.
            endif

            IF ( useableTrace ) THEN
               
               npicks=npicks+1

               thoriz(jtrace,1)=tupper-tstart_orig
               thoriz(jtrace,2)=tlower-tstart_orig

               tupper = tupper + uw
               tlower = tlower + lw
               tmid=.5*(tupper+tlower)-tstart_orig

               if(uflat) then

c flatten on upper horizon and shift it to tdatum.

c                  tshift=(tupper-tdatum)/dtmsec
                  tshift=(tupper-tstart_orig-tdatum)/dtmsec

               elseif(lflat) then

c flatten on lower horizon and shift it to tdatum.

c                  tshift=(tlower-tdatum)/dtmsec
                  tshift=(tlower-tstart_orig-tdatum)/dtmsec

               else

c flatten on middle of the formation and shift it to tdatum.

                  tshift=(tmid-tdatum)/dtmsec
               endif

               jshift=tshift   
               jdiv=nint(adiv*(tshift-jshift))     
c               tbegin=(tupper+uw)/dtmsec
               tbegin = ( tdatum - .5*(tlower-tupper))/dtmsec
c               tend=(tlower+lw)/dtmsec
               tend = ( tdatum + .5*(tlower-tupper))/dtmsec
c               ibegin=max(0,nint(tbegin-tshift))
               ibegin=max(0.0,tbegin)
c               iend=min(nsamp_out-1,nint(tend-tshift))
               iend=min(nsamp_out-1.0,tend)

            endif

            if(verbose) then
               if(useableTrace) then
                  write(LERR,'(2i10,5f10.1)') 
     1                 jrec,jtrace,tupper,tlower,tmid,tstart_orig,
     2                 tdatum,tshift
               else
                  write(LERR,'(2i8,a)')jrec,jtrace,' dead'
               endif
            endif
c____________________________________________________________________
c       copy trace header.
c____________________________________________________________________

            call vmov(uin(-ITRWRD),1,uout(-ITRWRD),1,ITRWRD)

            if( useableTrace ) then                       

c____________________________________________________________________
c          pad with necessary zeroes.
c____________________________________________________________________

               uin(-2)=0.
               uin(-1)=0.
               uin(nsamp_in)=0.
               uin(nsamp_in+1)=0.
               uin(nsamp_in+2)=0.

c____________________________________________________________________
c          shift and apply window weights
c____________________________________________________________________

               do jt=0,ibegin-1
                  uout(jt)=0.
               enddo

               do  jt=iend+1,nsamp_out-1
                  uout(jt)=0.
               enddo

               do jt=ibegin,iend  
                  jleft=jt+jshift
                  if(jleft .lt. 0) then
                     uout(jt)=0.
                  elseif(jleft .gt. nsamp_in-1) then
                     uout(jt)=0.
                  else
                     uout(jt)=w(-2,jdiv)*uin(jleft-2)
     1                    +w(-1,jdiv)*uin(jleft-1)
     2                    +w( 0,jdiv)*uin(jleft  )
     3                    +w(+1,jdiv)*uin(jleft+1)
     4                    +w(+2,jdiv)*uin(jleft+2)
     5                    +w(+3,jdiv)*uin(jleft+3)
                  endif
               enddo

c____________________________________________________________________
c          taper                                 
c____________________________________________________________________

               do jt=0,nttaper
                  uout(ibegin+jt)=twgt(jt)*uout(ibegin+jt)
                  uout(iend-jt)=twgt(jt)*uout(iend-jt)
               enddo

            ELSE

c____________________________________________________________________
c          Not useable trace, make up some sample values
c____________________________________________________________________

               do  jt=0,nsamp_out-1
                  if(live) then
c not in horz, give it non horz trace val
                     uout(jt) = nhtval
                  else
c dead, give it dead val
                     uout(jt) = deadVal
                  endif
               enddo

            ENDIF

c write out slab

            call wrtape(luout,uout(-ITRWRD),nbytes_out)

         ENDDO

c____________________________________________________________________
c      skip to end of current record.
c____________________________________________________________________

         do  jtrace=endtrace+1,ntrace
            nbytes_in=0
            call rtape(luin,uin(-ITRWRD),nbytes_in)
         enddo

         if (wrxsd) then
            write(ler,*) 'enter 111'
            if(npicks .gt. 0) then

c_______________________________________________________________________
c            write out the modeled XSD picks for this shot gather.
c_______________________________________________________________________

               iseg=iseg+1
               write(luxsd,201)'Segment = ',iseg,
     1              ' Name ','stratslab_pick',
     2              ' color = ',1,
     3              ' picks = ',npicks
 201           format(a10,i5,a6,a20,a10,i5,a9,i5)

               do jtrace=starttrace,endtrace

                  traceno=jtrace
                  recno=jrec
                  if(thoriz(jtrace,1) .lt. 0.) then
                     sampno=-1.
                  else
                     sampno=thoriz(jtrace,1)
                  endif

                  write(luxsd,102) recno,traceno,sampno
 102              format(f12.6,1x,f12.6,1x,f12.6)
               enddo
               
            endif
         endif

      ENDDO

      return         
      end
