C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getw6(w,ndiv)
c
      real      w(-2:+3,0:ndiv)
c_____________________________________________________________________
c     calculate 6 point lagrange interpolation for equally spaced     
c     input data for a table of divisions.
c
c     from Abramawitz and Stegun
c        formula 25.2.17
c_____________________________________________________________________
      dp=1./ndiv
      do 20000 idiv=0,ndiv
       p=idiv*dp
       p2=p**2
       w(-2,idiv)=(-p*(p2-1)*(p -2)*(p-3))/120.
       w(-1,idiv)=(+p*(p -1)*(p2-4)*(p-3))/24.
       w(0,idiv) =(-  (p2-1)*(p2-4)*(p-3))/12. 
       w(+1,idiv)=(+p*(p +1)*(p2-4)*(p-3))/12.
       w(+2,idiv)=(-p*(p2-1)*(p +2)*(p-3))/24.  
       w(+3,idiv)=(+p*(p2-1)*(p2-4)      )/120.
20000 continue
C
      return   
      end
