C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine wrwavlet(tracebuf,wgt,tabledexp,
     1                    istart,iend,ifl,ifh,dfp,dt,
     2                    lenw_outer,ITRWRD,
     3                    luw,lerr,nbytes_in,verbose,
     4                    ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     5                    ifmt_RecNum,l_RecNum,ln_RecNum,
     6                    ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
c___________________________________________________________________
c     trace buffer.
c___________________________________________________________________
      real     tracebuf(-ITRWRD:2*lenw_outer)
c___________________________________________________________________
c     tabled arrays and tapers.
c___________________________________________________________________
      complex  tabledexp(istart-lenw_outer:iend+lenw_outer,ifl:ifh)
      complex  wavelet
      real     wgt(-lenw_outer:lenw_outer)
c___________________________________________________________________
c     control variables.
c___________________________________________________________________
      logical  verbose
      integer  TRACEHEADER
c___________________________________________________________________
c     calculate the cosine wavelet.
c___________________________________________________________________
      jrec=1
      jtr=0
      do 30000 jf=ifl,ifh
       call savew2(tracebuf,ifmt_RecNum,l_RecNum,ln_RecNum,
     1             jrec,TRACEHEADER)
       jtr=jtr+1
       call savew2(tracebuf,ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1             jrec,TRACEHEADER)
       jval=nint(jf*dfp)
       call savew2(tracebuf,ifmt_RecInd,l_RecInd,ln_RecInd,
     1             jval,TRACEHEADER)
       kt=0
       do 20000 jt=-lenw_outer,+lenw_outer
        wavelet=conjg((tabledexp(istart,jf)))
     1                *tabledexp(istart+jt,jf)*wgt(jt)
        tracebuf(kt)=real(wavelet)
        kt=kt+1
20000  continue
       call wrtape(luw,tracebuf,nbytes_in)
       if(verbose) then
          write(lerr,*) 'jf= ',jf,' jf*dfp = ',jf*dfp
          write(lerr,'(3a12)') 'jt','t','wavelet'
          write(lerr,'(i12,2f12.4)') 
     1       (jt,jt*dt,tracebuf(jt),jt=0,2*lenw_outer+1)
       endif
30000 continue
c___________________________________________________________________
c     calculate the sine wavelet.
c___________________________________________________________________
      jrec=2
      jtr=0
      do 50000 jf=ifl,ifh
       call savew2(tracebuf,ifmt_RecNum,l_RecNum,ln_RecNum,
     1             jrec,TRACEHEADER)
       jtr=jtr+1
       call savew2(tracebuf,ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     1             jrec,TRACEHEADER)
       jval=nint(jf*dfp)
       call savew2(tracebuf,ifmt_RecInd,l_RecInd,ln_RecInd,
     1             jval,TRACEHEADER)

       kt=0
       do 40000 jt=-lenw_outer,+lenw_outer
        wavelet=conjg((tabledexp(istart,jf)))
     1                 *tabledexp(istart+jt,jf)*wgt(jt)
        tracebuf(kt)=aimag(wavelet)
        kt=kt+1 
40000  continue
       call wrtape(luw,tracebuf,nbytes_in)
50000 continue
c
      return
      end


