C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      Subroutine getgrid(p,q,x,y,locate,mx,my,nangs,maxangs,
     1                   dx,dy,dp,dq,np,nq,jcenter,lerr,fref,
     2                   npoint,rad,pmin,pmax,qmin,qmax,pref,qref,
     3                   ptheta,phi,xazim,yazim,clockwise)
c
      real       p(*),q(*)                 
      real       ptheta(maxangs),phi(maxangs)
      real       x(-mx:+mx),y(-my:+my)               
      integer    locate(2,*)                         
      parameter (pi=3.1415926,radpdeg=pi/180.,degprad=180./pi)
      logical    clockwise
c_____________________________________________________________________
c     calculate the rectangular trace grid (x,y) locations.
c_____________________________________________________________________
      do 11000 jx=-mx,+mx
       x(jx)=jx*dx
11000 continue
c
      do 12000 jy=-my,+my
       y(jy)=jy*dy
12000 continue
      write(lerr,'(3a10,2a12)') 'point','jx','jy','x','y'
      kount=0
c____________________________________________________________
c     let every trace on the rectangular grid be part of
c     the computational star.
c____________________________________________________________
      do 60000 jy=-my,+my
       do 50000 jx=-mx,+mx
        kount=kount+1
        locate(1,kount)=jx
        locate(2,kount)=jy
        if(jx .eq. 0 .and. jy .eq. 0) then
           jcenter=kount
        endif
        write(lerr,'(3i10,2f12.3)') kount,jx,jy,x(jx),y(jy)
50000  continue
60000 continue
      npoint=kount
c_________________________________________________________________
c
c     2d apparent dip or solid angle discretization
c
c     if yazim=0 then
c        phi=0 corresponds to the +p axis (North)
c        phi=90 corresponds to the +q axis (East)
c     otherwise
c        subtract off xazim from phi to correct it.
c_________________________________________________________________
      if(nint(yazim-xazim) .eq. -90 .or.
     1   nint(yazim-xazim+360.) .eq. -90 .or.
     2   nint(yazim-xazim-360.) .eq. -90) then
c
         clockwise=.false.
      elseif(nint(yazim-xazim) .eq. +90 .or.
     1   nint(yazim-xazim+360.) .eq. +90 .or.
     2   nint(yazim-xazim-360.) .eq. +90) then
c
         clockwise=.true.
      else
         write(lerr,*) 'error ! '
         write(lerr,*) 'x and y axis azimuths are not 90 degrees '
     1                 // ' apart !'
         write(lerr,*) 'xazim = ',xazim
         write(lerr,*) 'yazim = ',yazim
         call exit(1666)
      endif
c_____________________________________________________________________
c     calculate the p and q that critically sample the moveout.
c     fref needs to be in cycles/msec, cycles/m, cycles/ft to
c     correspond to the units of p.
c_____________________________________________________________________
      periodmin=1./(fref*.001)
c_____________________________________________________________________
c        tesselate the solid angle space with rectangular facets
c        of size dp by dq.
c_____________________________________________________________________
         if(mx .eq.  0) then
            dp=0.
            pmin=0.
            np=1
         else
            dp=periodmin/(2*mx*dx)
            np=nint((pmax-pmin)/dp)+1
            if(np .gt. 1) then
               dp=(pmax-pmin)/(np-1)
            else
               np=1
               dp=0.
            endif
         endif
         if(my .eq. 0) then
            dq=0.
            qmin=0.
            nq=1
         else
            dq=periodmin/(2*my*dy)
            nq=nint((qmax-qmin)/dq)+1
            if(nq .gt. 1) then
               dq=(qmax-qmin)/(nq-1)
            else
               dq=0.
            endif
         endif
         nangs=np*nq
         if(nangs .gt. maxangs) then
            write(lerr,*) 'insufficient memory dimensioned in routine'//
     1                    ' getgrid'
            write(lerr,*) 'maxangs = ',maxangs
            write(lerr,*) 'nangs   = ',nangs
            write(lerr,*) 'probable cause: too dense a sampling in '//
     1                    'either p or q directions'
            write(lerr,*) 'solution: decrease analysis window size '//
     1                    ' or dip range on command line and resubmit'
            write(lerr,*) ' or call marfurt in tulsa at 3268 and sign'//
     1                 ' up for the USP extended warantee program'
            write(lerr,*) 'np,nq,dp,dq ',np,nq,dp,dq
            call exitfu(1666)
         endif

         jang=0
c_____________________________________________________________________
c        first calculate apparent dips (p,q).
c        next calculate true dip and azimuth (ptheta,phi).
c_____________________________________________________________________
         do 20000 jp=1,np    
          p(jp)=pmin+(jp-1)*dp
          do 10000 jq=1,nq   
           jang=jang+1
           q(jq)=qmin+(jq-1)*dq  
           ptheta(jang)=sqrt(p(jp)**2+q(jq)**2)
           if(q(jq) .eq. 0. .and. p(jp) .eq. 0.) then
              phi(jang)=0.
           else
              if(clockwise) then
                 phi(jang)=atan2(q(jq),p(jp))*180./pi+xazim
              else
                 phi(jang)=atan2(-q(jq),p(jp))*180./pi+xazim
              endif
              if(phi(jang) .lt. 0.) phi(jang)=phi(jang)+360.
              if(phi(jang) .gt. 360.) phi(jang)=phi(jang)-360.
           endif
10000     continue
20000    continue
c
      write(lerr,*) 'clockwise = ',clockwise
      write(lerr,*) 'in line azim    = ',xazim 
      write(lerr,*) 'cross line azim = ',yazim 
      write(lerr,'(5a12)')'jang','p','q','ptheta','phi'
      jang=0
      do 92000 jp=1,np
       do 91000 jq=1,nq
        jang=jang+1
        write(lerr,'(i12,4f12.3)')jang,p(jp),q(jq),
     1                            ptheta(jang),phi(jang)
91000  continue
92000 continue
c
      return
      end
