C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getmute(wgtpq,jpqlive,p,q,swgt,awgt,ds,da,np,nq,
     1                   minswgt,maxswgt,minawgt,maxawgt,lerr,
     2                   xazim,yazim,clockwise,verbose,npqlive,
     3                   pwgt,qwgt,true_dip,jplive,jqlive)
c
      real    wgtpq(nq*np)
      real    p(np),q(nq)
      real    awgt(minawgt:maxawgt)         
      real    swgt(minswgt:maxswgt)
      real    pwgt(-maxswgt:maxswgt)
      real    qwgt(-maxswgt:maxswgt)
      integer jpqlive(nq*np)
      integer jplive(nq*np)
      integer jqlive(nq*np)
      logical verbose,clockwise,true_dip
      parameter  (pi=3.1415926)
       write(lerr,*) 'in getmute'
         write(lerr,'(a5,a12)') 'k','awgt(k)'
         write(lerr,'(i5,f12.6)') (k,awgt(k),k=-180,+180)

c_________________________________________________________________
c     check to see if acquisition axes are clockwise.
c
c     if yazim=0 then
c        phi=0 corresponds to the +p axis (North)
c        phi=90 corresponds to the +q axis (East)
c_________________________________________________________________
      if(nint(yazim-xazim) .eq. -90 .or.
     1   nint(yazim-xazim+360.) .eq. -90 .or.
     2   nint(yazim-xazim-360.) .eq. -90) then
c
         clockwise=.false.
      elseif(nint(yazim-xazim) .eq. +90 .or.
     1   nint(yazim-xazim+360.) .eq. +90 .or.
     2   nint(yazim-xazim-360.) .eq. +90) then
c
         clockwise=.true.
      else
         write(lerr,*) 'error ! '
         write(lerr,*) 'x and y axis azimuths are not 90 degrees '
     1                 // ' apart !'
         write(lerr,*) 'xazim = ',xazim
         write(lerr,*) 'yazim = ',yazim
         call exit(1666)
      endif

      write(lerr,'(3a8,7a8)') 'jpqlive','jq','jp',
     1         'q(jq),','p(jp)','s','phi','wgtpq'
c
      npqlive=0
      jang=0
      do 20000 jp=1,np
       do 10000 jq=1,nq
        jang=jang+1
        s=sqrt(p(jp)**2+q(jq)**2)
        if(p(jp) .eq. 0. .and. q(jq) .eq. 0.) then
           phi=0.
        else
           if(clockwise) then
              phi=atan2(q(jq),p(jp))*180./pi+xazim
           else
              phi=atan2(-q(jq),p(jp))*180./pi+xazim
           endif
           if(phi .lt. -180.) phi=phi+360.
           if(phi .gt. +180.) phi=phi-360.
        endif
        ks=nint(s/ds)
        ka=nint(phi/da)
        kp=nint(p(jp)/ds)
        kq=nint(q(jq)/ds)
        if(true_dip) then
           apass=awgt(ka)*swgt(ks)
        else
           apass=pwgt(kp)*qwgt(kq)
        endif
        if(apass .gt. 0.) then
           npqlive=npqlive+1
           jpqlive(npqlive)=jang
           jplive(npqlive)=jp
           jqlive(npqlive)=jq
           wgtpq(npqlive)=apass
           write(lerr,'(3i8,3f8.3,f8.1,f8.3)') 
     1             jpqlive(npqlive),jq,jp,
     2             q(jq),p(jp),s,phi,wgtpq(npqlive)
        else
           write(lerr,'(3i8,3f8.3,f8.1,f8.3)') 
     1             0,jq,jp,
     2             q(jq),p(jp),s,phi,0.
        endif
10000  continue
20000 continue
c
      return
      end
