C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getrho(rho,fwgt,df,ifl,ifh,npoint,nangs,
     1                  power,verbose,lerr)
c
      real      rho(ifl:ifh)
      real      fwgt(ifl:ifh)
      logical   verbose,twodim
c_____________________________________________________________________
c     calculate rho filter for (tau,p,q) transform.
c_______________________________________________________________________
      scalar=1./nangs
      fc=nf/2*df
      write(lerr,'(a12,3a12)') 'ifreq','f','fwgt','rho'
      do 5000 ifreq=ifl,ifh
       f=ifreq*df
       if(fwgt(ifreq) .eq. 0.) then
          rho(ifreq)=0.
       else 
          rho(ifreq)=scalar*fwgt(ifreq)*f**power
       endif
       write(lerr,'(i12,3f12.3)') ifreq,f,fwgt(ifreq),rho(ifreq)
5000  continue
c
      return
      end
