C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine mint6(ucoarse,ufine,w,nt_orig,ntfine,
     1                 nx,kstart,kend)
c
      real      ucoarse(-2:nt_orig+3,0:nx)        
      real      ufine(0:nt_orig,0:ntfine-1,0:nx)
      real      w(-2:+3,0:ntfine)  
c_____________________________________________________________________
c     convolve 6 point interpolation operator with data.
c     loop unrolling version.
c_____________________________________________________________________
c_____________________________________________________________________
c      pad to allow for interpolation operator edges.
c      warning: this will destroy other data in these edges  (such
c      as header words).
c_____________________________________________________________________
      idiv=0
      do 20000 jx=0,nx 
       ucoarse(-2,jx)=ucoarse(0,jx)
       ucoarse(-1,jx)=ucoarse(0,jx)
       ucoarse(nt_orig+1,jx)=ucoarse(nt_orig,jx)
       ucoarse(nt_orig+2,jx)=ucoarse(nt_orig,jx)
       ucoarse(nt_orig+3,jx)=ucoarse(nt_orig,jx)
20000 continue
c_____________________________________________________________________
c     copy original data to the uninterpolated position (jtfine=0).
c_____________________________________________________________________
      do 25000 jx=0,nx
       do 24000 jsamp=0,nt_orig
        ufine(jsamp,0,jx)=ucoarse(jsamp,jx)
24000  continue
25000 continue
c_____________________________________________________________________
c     interpolate intermediate (jtfine .ne. 0) fine sample points.
c_____________________________________________________________________
      do 40000 jsamp=kstart,kend       
       do 35000 jtfine=1,ntfine-1
        do 30000 jx=0,nx 
         ufine(jsamp,jtfine,jx)=ucoarse(jsamp-2,jx)*w(-2,jtfine) 
     1                         +ucoarse(jsamp-1,jx)*w(-1,jtfine) 
     2                         +ucoarse(jsamp  ,jx)*w( 0,jtfine) 
     3                         +ucoarse(jsamp+1,jx)*w(+1,jtfine) 
     4                         +ucoarse(jsamp+2,jx)*w(+2,jtfine) 
     5                         +ucoarse(jsamp+3,jx)*w(+3,jtfine) 
30000   continue  
35000  continue
40000 continue
c
      return   
      end
