C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdgather(tracebuf,ibuffer2,
     1                    trheader,uin,utxfine,
     2                    w,ntfine,live,luin,nx,
     3                    l_StaCor,eof,iy,my,mx,
     4                    lntrhd,lenhed,nt_orig,lerr,l_DphInd,
     5                    kstart,kend,scale,cputim,waltim,nxpad,
     8                    ifmt_DphInd,ln_DphInd,ifmt_StaCor,ln_StaCor)
c
      integer   trheader(lenhed,0:nx,-my:my)
      integer   ibuffer2(*)
      real      tracebuf(-lenhed:nt_orig)
      real      uin(-2:nt_orig+3,-mx:nx+mx)   
      real      w(-2:+3,0:ntfine)
      real      utxfine(0:(nt_orig+1)*ntfine-1,-mx:nx+mx,-my:+my)
      real      cputim(*),waltim(*)
c
      logical   live(-mx:nx+mx,-my:+my)
      logical   eof
c
      eof=.false.
      call timstr(v1,w1)
      if(nxpad .gt. 0) then
c_______________________________________________________________________
c        read in the first (-mx,-1) traces of the seismic record.
c_______________________________________________________________________
         do 13000 jx=-nxpad,-1
          nbytes_in=0
          call rtape(luin,tracebuf(-lenhed),nbytes_in)
          if(nbytes_in .le. 0) then
             eof=.true.
             return
          endif
          if(jx .ge. -mx) then
             call saver2(ibuffer2,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                   istat, 1)
             if(istat .eq. 30000) then
                live(jx,iy)=.false.
                call vclr(uin(0,jx),1,nt_orig+1)
             else
                live(jx,iy)=.true.
                do 12000 k=0,nt_orig
                 uin(k,jx)=tracebuf(k)
12000           continue
             endif
          endif
13000    continue
      else
c___________________________________________________________________
c        flag nonexistent traces as dead.
c__________________________________________________________________
         do 14000 jx=-mx,-1
          live(jx,iy)=.false. 
          call vclr(uin(0,jx),1,nt_orig+1)
14000    continue
      endif
c_______________________________________________________________________
c     read in the next (0,nx) traces of the seismic record.
c_______________________________________________________________________
      do 40000 jx=0,nx       
       nbytes_in=0
       call rtape(luin,tracebuf(-lenhed),nbytes_in)
       if(nbytes_in .le. 0) then
          eof=.true.
          return
       endif
c_______________________________________________________________________
c      copy trace headers into trheader array.
c      copy data into uin.                   
c_______________________________________________________________________
       do 35000 k=1,lenhed
        trheader(k,jx,iy)=ibuffer2(k)
35000  continue
       call saver2(trheader(1,jx,iy),ifmt_StaCor,l_StaCor, ln_StaCor,
     1             istat, 1)
       if(istat .eq. 30000) then
          live(jx,iy)=.false.
          call vclr(uin(0,jx),1,nt_orig+1)
       else
          live(jx,iy)=.true.    
          do 37000 k=0,nt_orig
           uin(k,jx)=tracebuf(k)
37000     continue
       endif
40000 continue
70000 continue
      if(nxpad .gt. 0) then
c_______________________________________________________________________
c        read in the last (nx+1,nx+mx) traces of the seismic record.
c_______________________________________________________________________
         do 83000 jx=nx+1,nx+nxpad
          nbytes_in=0
          call rtape(luin,tracebuf(-lenhed),nbytes_in)
          if(nbytes_in .le. 0) then
             eof=.true.
             return
          endif
          if(jx .le. nx+mx) then
             call saver2(ibuffer2,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                   istat, 1)
             if(istat .eq. 30000) then
                live(jx,iy)=.false.
                call vclr(uin(0,jx),1,nt_orig+1)
             else
                live(jx,iy)=.true.
                do 82000 k=0,nt_orig
                 uin(k,jx)=tracebuf(k)
82000           continue
             endif
          endif
83000    continue
      else
c___________________________________________________________________
c        flag nonexistent traces as dead.
c__________________________________________________________________
         do 84000 jx=nx+1,nx+mx
          live(jx,iy)=.false.
          call vclr(uin(0,jx),1,nt_orig+1)
84000    continue
      endif
      call timend(cputim(1),v1,v2,waltim(1),w1,w2)
      call timstr(v1,w1)
      if(scale .eq. 0.) then
c___________________________________________________________________
c        determine one scale for the entire cube of data from the
c        first line with data in it.
c___________________________________________________________________
         sum2=0.
         do 11400 jx=-mx,nx+mx
          if(live(jx,iy)) then
             do 11300 jsamp=0,nt_orig
              sum2=sum2+uin(jsamp,jx)**2
11300        continue
          endif
11400    continue
         if(sum2 .ne. 0.) then
            scale=1./sqrt(sum2)
         endif
      endif
c___________________________________________________________________
c     scale the data to avoid truncation errors when forming the
c     running sums using the efficient add/drop technique.
c___________________________________________________________________
      do 12400 jx=-mx,nx+mx
       if(live(jx,iy)) then
          do 12300 jsamp=0,nt_orig
           uin(jsamp,jx)=scale*uin(jsamp,jx)
12300     continue
       endif
12400 continue
      call timend(cputim(2),v1,v2,waltim(2),w1,w2)
c___________________________________________________________________
c     interpolate to a finer time/depth sample.  
c___________________________________________________________________
      call timstr(v1,w1)
      call mint6(uin,utxfine(0,-mx,iy),w,nt_orig,ntfine,
     1           nx+2*mx,kstart,kend)
      call timend(cputim(3),v1,v2,waltim(3),w1,w2)
c
      return
      end 
