C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine revdrt(utaupq,uomegapq,uout,uomegaxy,rr,rbuf,cbuf,
     1                  wsemb,kximin,kximax,kyimin,kyimax,npqlive,
     2                  anorm,nt,nfft,ifl,ifh,istart,iend,
     3                  jx,nx,nlive)
c__________________________________________________________________________
c     input (tau,p,q) gather.
c___________________________________________________________________
      real    utaupq(-2:nt+3,npqlive)
      real    wsemb(istart:iend,npqlive)
      complex uomegapq(ifl:ifh,npqlive)
c___________________________________________________________________
c     output (t,x,y) interpolated traces.                  
c___________________________________________________________________
      complex   uomegaxy(0:nfft/2-1)
      real      uout(istart:iend,0:nx,kximin:kximax,kyimin:kyimax)
c___________________________________________________________________
c     reverse   (omega,p,q) transform matrix
c___________________________________________________________________
      complex   rr(ifl:ifh,npqlive,kximin:kximax,kyimin:kyimax)
c__________________________________________________________________________
c     buffers for fft.
c__________________________________________________________________________
      real    rbuf(0:nfft-1)
      complex cbuf(0:nfft/2-1)
c
      if(nlive .eq. 0) then
c___________________________________________________________________
c        all input traces are dead. zero out output traces.
c___________________________________________________________________
         do 5000 kyi=kyimin,kyimax
          do 4000 kxi=kximin,kximax
           do 3000 jt=istart,iend
            uout(jt,jx,kxi,kyi)=0.
3000       continue
4000      continue
5000     continue
         return
      endif
c___________________________________________________________________
c     transform from (tau,p,q) to (omega,p,q) domain using an fft.
c___________________________________________________________________
      do 15000 jpq=1,npqlive
       do 11000 jt=0,istart-1
        rbuf(jt)=0.
11000  continue
       do 12000 jt=istart,iend
        rbuf(jt)=utaupq(jt,jpq)*wsemb(jt,jpq)
12000  continue
       do 13000 jt=iend+1,nfft-1
        rbuf(jt)=0.
13000  continue
       call rfftb(rbuf,cbuf,nfft,+1)
       call rfftsc(cbuf,nfft,+2,+1)
       do 14000 jf=ifl,ifh
        uomegapq(jf,jpq)=cbuf(jf)
14000  continue
15000 continue
c___________________________________________________________________
c     reverse drt to the interpolated trace locations. 
c___________________________________________________________________
      do 95000 kyi=kyimin,kyimax
       do 94000 kxi=kximin,kximax
c___________________________________________________________________
c       initialize
c___________________________________________________________________
        do 10000 jomega=ifl,ifh
         uomegaxy(jomega)=(0.,0.)
10000   continue
        do 30000 jpq=1,npqlive 
c___________________________________________________________________
c        transform from (omega,p,q) to (omega,x,y) domain using a drt.
c___________________________________________________________________
         do 22000 jomega=ifl,ifh
          uomegaxy(jomega)=uomegaxy(jomega)
     1                +rr(jomega,jpq,kxi,kyi)*uomegapq(jomega,jpq)
22000    continue
30000   continue
c___________________________________________________________________
c       transform from (omega,x,y) to (t,x,y) domain using an fft.
c___________________________________________________________________
        do 31000 jf=0,ifl-1
         uomegaxy(jf)=(0.,0.)
31000   continue
        do 32000 jf=ifh+1,nfft/2-1
         uomegaxy(jf)=(0.,0.)
32000   continue
        call rfftsc(uomegaxy,nfft,-2,0)
        call rfftb(uomegaxy,rbuf,nfft,-1)
        do 34000 jt=istart,iend
         uout(jt,jx,kxi,kyi)=rbuf(jt)
34000   continue
c
94000  continue
95000 continue
c
      return
      end
