C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c -----------------  Main Routine -----------------------
c

c     Program Description:
c     program to read tdfn and convert to xsd
c
c get machine dependent parameters
c	James M. Gridley
c 	USP Team
c	August 1996
 
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>
 
c dimension standard USP variables
 
      integer     luin , luout
      integer     Xsd_Color, Xsd_Num
      integer     argis
 
      real        Record( SZLNHD ),Velocity(SZLNHD)
      real        Unit(SZLNHD)
 
      character   ntap*255, otap*255, name*9
      character   Xsd_Name*255
      logical     EndFile
 
c Program Specific _ dynamic memory variables
 
c Initialize variables
 
      data abort/1/
      data name/"TDFN2XSD"/
 
c     give command line help if requested
 
      if ( argis ( '-?' ) .gt. 0 .or.
     :     argis ( '-h' ) .gt. 0 .or.
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif
 
c     open printout file
 
#include <f77/open.h>
 
c     get command line input parameters
 
      call cmdln ( ntap, otap)
 
c     open input and output files
 
      luin = 10
      luout = 11
      open(luin, file=ntap, status='unknown')
      open(luout, file=otap, status='unknown')
 
c     read input line header and save certain parameters
 
 
 
c     number output bytes
 
      do i = 1, 10000
         Velocity(i)=0.
         Record(i)=0.
         Unit(i)=0.
      enddo
      nfunc=0
      MaxNum=0
 5    call TdfnReadCards (luin, Record, Velocity, Unit, N,
     :     NumEntries, EndFile )
      nfunc=nfunc+1
      MaxNum=max(N,MaxNum)
 
      if(EndFile) goto 800
 
      go to 5
 
 800  rewind(unit=10)
      EndFile=.false.
 
c     verbose output of all pertinent information before processing begins
 
      call verbal( ntap, otap)
 
c     BEGIN PROCESSING
 
      icount = 0
 
 10   call TdfnReadCards (luin, Record, Velocity, Unit, N,
     :     NumEntries, EndFile )
      if(EndFile) goto 900
 
      icount = icount + 1
 
      if(icount .eq. 1) then
 
         write ( luout, 11) RecUnit, VelUnit, SmpUnit, nrec,
     :        ntrc, nsamp, RecOffset, VelOffset, SmpOffset,
     :        nfunc-1, MaxNum
 
 11      format('Units ',f12.6,1x,f12.6,1x,f12.6,1x,i5,1x,i5,1x,i5,
     :        ' Offset ',f12.6,1x,f12.6,1x,f12.6,' Count ',i5,1x,i5)
 
      endif
 
      Xsd_Name = '   NO_PICK_NAME_HERE'
      Xsd_Num=icount
      Xsd_Color = -43
 
      write(luout,12) Xsd_Num, Xsd_Name, Xsd_Color, N
 12   format('Segment = ',i5,' Name ',a20,
     :     '  color = ',i5,' picks = ',i5)
 
      do j = 1, N
         write(luout,'(f12.6,1x,f12.6,1x,f12.6)')
     :        Record(j), Velocity(j), Unit(j)
      enddo
 
      if (EndFile) then
         goto 900
      else
      go to 10
      endif
 
 900  continue
c     close data files
 
      close(unit=10)
      close(unit=11)
 
      write(LERR,*)'tdfn2xsd: Normal Termination'
      write(LER,*)'tdfn2xsd: Normal Termination'
      go to 777
 
 999  continue
 
      close(unit=10)
      close(unit=11)
      write(LERR,*)'tdfn2xsd: ABNORMAL Termination'
      write(LER,*)'tdfn2xsd: ABNORMAL Termination'
 777  stop
      end
 
c     -----------------  Subroutine -----------------------
 
      subroutine help()
 
c     provide terse online help [detailed help goes in man page]
 
#include <f77/iounit.h>
 
      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for PRGM: USP template'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'Input...................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[]   -- input data set                  (stdin)'
      write(LER,*)'-O[]   -- output data set                (stdout)'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'       tdfn2xsd -N[] -O[]'
      write(LER,*)' '
      write(LER,*)'===================================================='
 
      return
      end

c     -----------------  Subroutine -----------------------
 
c     pick up command line arguments
 
      subroutine cmdln ( ntap, otap)
 
#include <f77/iounit.h>
 
      character  ntap*(*), otap*(*)
 
      call argstr ( '-N', ntap, ' ', ' ' )
 
      call argstr ( '-O', otap, ' ', ' ' )
 
c     check for extraneous arguments and abort if found to
c     catch all manner of user typo's
 
      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )
 
 
      return
      end
 
c     -----------------  Subroutine -----------------------
 
c     verbal printout of pertinent program particulars
 
 
      subroutine verbal ( ntap, otap)
 
#include <f77/iounit.h>
 
 
      character  ntap*(*), otap*(*)
 
 
      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      write(LERR,*) ' input data set name   =  ', ntap
      write(LERR,*)' '
      write(LERR,*) ' output data set name  =  ', otap
      write(LERR,*)'========================================== '
      write(LERR,*)' '
 
      return
      end
