C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine GetThreshold (  MedSearch, Amplitude, nsamp, ntrc, nf, 
     :     ist, iend, ns, ne, min_sub_band, max_sub_band, StartSample, 
     :     threshold  )

      implicit none

#include <f77/lhdrsz.h>

c declare variables passed from calling routine

      integer nsamp, ntrc, nf, ist, iend, ns, ne
      integer min_sub_band, max_sub_band

      integer StartSample(ntrc)

      real Amplitude ( nsamp, nf+1, ntrc )
      real MedSearch(nsamp*ntrc)
      real threshold

c declare local variables

      integer i, j, k, count, num_sub_bands

      real Medians(SZLNHD)

c initialize variables

      num_sub_bands = max_sub_band - min_sub_band + 1

      do j = min_sub_band, max_sub_band

         count = 0

         do i = ist, iend

            do k = ns, ne

c only use contribution from within user defined zone of 
c traces and times
               
               if ( i .gt. StartSample(k) ) then
                  count = count + 1
                  MedSearch(count) = Amplitude(i,j,k)
               endif

            enddo
         enddo
         
         call mdian(count,MedSearch,Medians(j))
         
      enddo

      if ( num_sub_bands .eq. 2 ) then
         threshold = (Medians(min_sub_band)+Medians(max_sub_band)) / 2.0
      elseif ( num_sub_bands .eq. 1 ) then
         threshold = Medians(min_sub_band)
      else
         call mdian ( num_sub_bands, Medians, threshold )
      endif

      return
      end
