C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine TF_Filter( Amplitude, nsamp, ntrc, nf, out_Amplitude, 
     :     nwin_trace, threshold, ns, ne, ist, iend, min_sub_band, 
     :     max_sub_band, roll, workspace, wrksize, StartSample )

      implicit none

c declare variables passsed from calling routine

      integer nsamp, ntrc, nf, nwin_trace, ns, ne, ist, iend
      integer min_sub_band, max_sub_band, wrksize

      integer StartSample(ntrc)

      real Amplitude(nsamp, nf+1, ntrc)
      real out_Amplitude(nsamp, nf+1, ntrc)
      real workspace(wrksize)
      real threshold

      logical roll

c declare local variables

      integer KK, i, j, k, l, nwin_mid, nwin_end
      integer nf_unpack

      real med_value

c initialize variables

      nf_unpack = nf + 1
      nwin_mid = nwin_trace / 2 + 1
      nwin_end = ne - nwin_mid

      do 10 KK = ns, ne

         do 20 i = ist, iend

            if ( i .lt. StartSample(KK)) then

c if we are above the user specified start for this trace then
c just set output = intput for all frequency elements of this trace
c at this time.

               do k = 1, nf_unpack
                  out_Amplitude(i,k,KK) = Amplitude(i,k,KK)
               enddo

c go to next sample and try again

               goto 20

            endif

            do 30 j =1, nf_unpack

               if ( ( KK - ns + 1 ) .lt. nwin_mid ) then


                  if ( Amplitude(i,j,KK) .gt. threshold .and.
     :                 j .ge. min_sub_band .and.
     :                 j .le. max_sub_band ) then

                     if ( roll ) then

c at start of record so start the roll in off the median calculation
c to soften the edge effect of starting with the user defined nwin_trace
c In this logic the edge uses first 3 then 4 then 5 etc. values for the 
c median until the trace location gets to the midpoint of the user
c defined search window.  At this point it switches over to using the 
c full user defined number of traces. 

                        do l = 1, KK - ns + 3
                           workspace(l) = Amplitude(i,j,KK+l-1)
                        enddo

c must never have less than 3 samples for the median calculation

                        call mdian ( KK - ns + 3, workspace, med_value )
                     else

c this was the original option that held the median search window a constant
c size and just rolled the active trace through it.  It causes some odd edge
c effects at the sides of the records for large median search windows but on 
c the other hand does handle glitches and spike better that occur out in the
c first few traces.

                        do l = 1,nwin_trace
                           workspace(l) = Amplitude(i,j,KK+l-1)
                        enddo

                        call mdian ( nwin_trace, workspace, med_value )

                     endif

                     out_Amplitude(i,j,KK) = med_value

                  else

c no action required just copy the input to the output

                     out_Amplitude(i,j,KK) = Amplitude(i,j,KK)
                  endif

               elseif ( KK .gt. nwin_end ) then

                  if ( Amplitude(i,j,KK).gt. threshold .and.
     :                 j .ge. min_sub_band .and. 
     :                 j .le. max_sub_band) then

                     if ( roll ) then

c at end of record so now must roll off in the same fashion as we rolled in
c to soften any  edge effects of the median search using the same trace values
c for nwin_mid traces at the end of the record

                        do l = KK-2, ne
                           workspace(l) = Amplitude(i,j,l)
                        enddo

c  can never have less than 3 samples for the median calculation

                        call mdian ( ne-(KK-2)+1, workspace(KK-2),
     :                       med_value )

                     else

c do the original calculation freezing the median search window against the
c edge of the record and rolling the active trace through it

                        do l = 1,nwin_trace
                           workspace(l) = Amplitude(i,j,KK-nwin_trace+l)
                        enddo
                        call mdian ( nwin_trace, workspace, med_value )

                     endif

                     out_Amplitude(i,j,KK) = med_value
                  else
                     out_Amplitude(i,j,KK) = Amplitude(i,j,KK)
                  endif

               else

c in the body of the data so just roll along

                  if ( Amplitude(i,j,KK)
     :                 .gt. threshold .and.
     :                 j .ge. min_sub_band .and. 
     :                 j .le. max_sub_band ) then
                     do l = 1,nwin_trace
                        workspace(l) = Amplitude(i,j,KK-nwin_mid+l)
                     enddo
                     call mdian ( nwin_trace, workspace, med_value )
                     out_Amplitude(i,j,KK) = med_value
                  else
                     out_Amplitude(i,j,KK) = Amplitude(i,j,KK)
                  endif

               endif

 30         continue

 20      continue

 10   continue

      return
      end
