C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine inverse_stft ( out_Amplitude, Phase, nsamp, nf, ntrc, 
     :     ns, ne, ist, iend, nwin_samp, ctri, Headers, Record, tri, 
     :     Workspace, w, ifmt_StaCor, l_StaCor, ln_StaCor, verbos )

      implicit none

#include <f77/lhdrsz.h>
#include <save_defs.h> 

c variables passed from calling routine

      integer nsamp, nf, ntrc, ns, ne, ist, iend, nwin_samp
      integer ifmt_StaCor, l_StaCor, ln_StaCor
      integer Headers(ITRWRD,ntrc)

      real out_Amplitude(nsamp,nf+1,ntrc)
      real Phase(nsamp,nf+1,ntrc)
      real Record(nsamp,ntrc)
      real tri(nsamp)      
      real Workspace(nsamp)      
      real w(nwin_samp)

      complex ctri (nf+1)

      logical verbos

c declare local variables

      integer nwinh, nft, KK, i, j, nsampo
      integer StaCor, nf_unpack

      real sum

c initialize variables

      nf_unpack = nf + 1
      nwinh = nwin_samp / 2
      nft = 2 * nf 
      nsampo = iend - ist + 1

      DO KK = ns, ne

c check for dead trace

         call saver2 ( Headers(1,KK-ns+1), ifmt_StaCor, l_StaCor, 
     :        ln_StaCor, StaCor, TRACEHEADER )

         call vclr ( tri, 1, nsamp )

         IF ( StaCor .ne. 30000 ) THEN

c inverse transform only live traces

            do i = ist, iend

               call vclr ( Workspace , 1, nsampo )

               do j = 1, nf+1
                  ctri(j) = cmplx(0.0,0.0)
               enddo
         
c assign complex array from input phase and amplitude data.
c remember that to use rfftsc and rffti the data must be
c again packed so that the real part of estimate 1 and nf+1
c occupy the real and imaginary slot of complex value 1.

c we are going to extract for an output time sample at a time
c then extract from the inverse the center sample to output
c at the desired time.  Remember that the amplitude and phase
c arrays only have data transformed between ist and iend from
c the original dataset.
            

c               ctri(1) = cmplx(out_Amplitude(i,1,KK),
c     :              out_Amplitude(i,nf_unpack,KK))

               sum = 0.0
               do j = 1, nf+1
                  ctri(j) = out_Amplitude(i,j,KK) * 
     :                 cexp ( cmplx(0., Phase(i,j,KK) ) )
                  sum = sum + out_Amplitude(i,j,KK)
               enddo
 
c if no energy in sample then do not do the inverse fft, just output zeroes

               if ( sum .le. 1.e-32 ) then

                  tri(i) = 0.0
               else

c inverse FFT 

c               call rfftsc ( ctri, nft, -2 ,0)
                  call rfftsc ( ctri, nft, -3 ,0)
                  call rffti ( ctri, Workspace, nft)

c get the central sample only of the window

                  tri(i) = Workspace( nwinh + 1 ) / w( nwinh + 1 )

               endif
               
            enddo

         ENDIF

c load up filtered portion of Record in preparation for output

         call vmov ( tri(ist+1), 1, Record(ist+1,KK-ns+1), 1, nsampo-1 ) 

      ENDDO

      return
      end
