C***********************************************************************
C*****  RFFT    Real-to-Complex FFT (in-place)    MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL RFFT (C,N,IFLG)
C
C       where,
C
C       C       Real input/output vector.
C
C       N       Integer input real element count.
C
C       IFLG    Integer input processing option flag:
C                   = 1 for forward FFT
C                   =-1 for inverse FFT
C
C
C  DESCRIPTION
C
C       This routine performs either a real-to-complex
C       forward or complex-to-real inverse FFT on the data stored
C       in vector C, depending on the value of IFLG.
C
C       If IFLG = 1, the routine performs a real-to-complex forward
C       FFT.  The results are overlaid on vector C in a special packed
C       complex array format.  See RFFTSC for details on the packed
C       format.  These results are not properly scaled and may be
C       scaled using RFFTSC to multiply by 1/(2*N).
C
C       If IFLG = -1, the routine performs a complex-to-real inverse
C       FFT.  The results are overlaid on vector C and do not need
C       to be scaled.
C
C       N must be a power of two.
C
C       Refer to Appendix B for machine dependent notes.
C
C  REFERENCE
C
C       This code was taken from 'Programs for Digital Signal
C       Processing', by the IEEE Acoustics, Speech, and Signal
C       Processing Society.
C
C       J. W. Cooley and J. W. Tukey.  1965.  An algorithm for
C       the machine calculation of complex Fourier Series.
C       Math. Comp., Vol. 19,  pp. 297-301.
C
C       G. D. Bergland.  1969.  A radix-eight fast Fourier
C       transform subroutine for real-valued series.  IEEE
C       Trans. on Audio and Electroacoust., Vol. AU-17,  pp.
C       138-144.
C
C       E. O. Brigham.  1974.  The fast Fourier transform.
C       Englewood Cliffs NJ: Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL RFFT (C,16,1)
C
C       Input Operands:
C
C       C = -2.48126841
C            5.43857670
C            8.41856575
C            6.01869583
C            2.67843342
C            4.42139244
C           -1.46789265
C           -3.50454664
C            8.36031532
C            9.40397835
C           -8.71770477
C            3.50304222
C            0.80594349
C            1.62271309
C            5.97405338
C            1.68788052
C
C       Output Operands:
C
C       C = 84.32435608
C          -30.04257396
C           15.12630871
C          -20.26533321
C            1.19730169
C          -18.86721209
C          -54.97992660
C           11.02401025
C           10.31280422
C          -26.36317730
C          -57.90410269
C           30.95374087
C            8.38137832
C          -38.08841109
C           11.02505074
C           14.64431686
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
C
      SUBROUTINE RFFT(C,N,IFLG)
C
      INTEGER N,IFLG,DI
      REAL C(1)
      IF (N.LE.1 .OR. (IFLG.NE.-1 .AND. IFLG.NE.1)) GOTO 900
      DI = 1
      CALL QTC019(C,N,DI,IFLG)
900   RETURN
      END
